/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define _IBMC32                         /* Need to turn this on son that the */
                                        /*  proper prototype is used for the */
                                        /*  wcstod function.                 */

/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdlib.h>                     /* Needed for strtod function.       */

#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* XPG/4 library.                    */
#include <locale.h>                     /* Locale definitions.               */

/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

wchar_t *end;                           /* End wide string for conversions.  */
char *str_end;                          /* End string for strtod conversions.*/

/*****************************************************************************/
/***     Perform numeric conversion to long                                ***/
/*****************************************************************************/

void do_wcstol(wchar_t *in_val, int base)
{
  long    ret_val;                      /* Long integer returned from conv   */

                                        /* Do the conversion.                */
                                        /* Print results of conversion.      */
  ret_val = wcstol(in_val, &end, base);
  printf("Conversion of: '%S' is: '%ld' with end of: '%S'\n", in_val,
         ret_val, end);
}

void do_long_conv(void)
{
                                        /* Print a header.                   */
                                        /* Do conversions.  NOTE:  The base  */
                                        /*  of '0' tells the function to do  */
                                        /*  conversions in decimal.  The last*/
                                        /*  two conversions are done in base */
                                        /*  2.                               */
  printf("\nExamples of wcstol:\n");
  printf("-------------------\n");
  do_wcstol(L"1234.567", 0);
  do_wcstol(L".1234567", 0);
  do_wcstol(L" +1234567.", 0);
  do_wcstol(L"0777", 0);
  do_wcstol(L"-4.5e6ABC", 0);
  do_wcstol(L"0X19AF", 0);
  do_wcstol(L"0xffZAP", 0);
  do_wcstol(L"1234.567", 2);
  do_wcstol(L"10101.12", 2);
}

/*****************************************************************************/
/***     Perform numeric conversion to unsigned long                       ***/
/*****************************************************************************/

void do_wcstoul(wchar_t *in_val, int base)
{
  unsigned long ret_val;                /* Long (unsigned) int returned.     */

                                        /* Do the conversion.                */
                                        /* Print results of conversion.      */
  ret_val = wcstoul(in_val, &end, base);
  printf("Conversion of: '%S' is: '%lu' with end of: '%S'\n", in_val,
         ret_val, end);
}

void do_ulong_conv(void)
{
                                        /* Print a header.                   */
                                        /* Do conversions.  NOTE:  The base  */
                                        /*  of '0' tells the function to do  */
                                        /*  conversions in decimal.  The last*/
                                        /*  two conversions are done in base */
                                        /*  2.                               */
  printf("\nExamples of wcstoul:\n");
  printf("--------------------\n");
  do_wcstoul(L"1234.567", 0);
  do_wcstoul(L".1234567", 0);
  do_wcstoul(L" +1234567.", 0);
  do_wcstoul(L"0777", 0);
  do_wcstoul(L"-4.5e6ABC", 0);
  do_wcstoul(L"0X19AF", 0);
  do_wcstoul(L"0xffZAP", 0);
  do_wcstoul(L"1234.567", 2);
  do_wcstoul(L"10101.12", 2);
}

/*****************************************************************************/
/***     Perform numeric conversion to double from wide string             ***/
/*****************************************************************************/

void do_wcstod(wchar_t *in_val)
{
  double ret_val;                       /* Double that is returned.          */

                                        /* Do the conversion.                */
                                        /* Print results of conversion.      */
  ret_val = wcstod(in_val, &end);
  printf("Conversion of: '%S' is: '%lf' with end of: '%S'\n", in_val,
         ret_val, end);
}

void do_w_double_conv(void)
{
                                        /* Print a header.                   */
                                        /* Do conversions.                   */
  printf("\nExamples of wcstod:\n");
  printf("------------------\n");
  do_wcstod(L"123erg");
  do_wcstod(L"1234.567");
  do_wcstod(L".1234567");
  do_wcstod(L"+1234567.");
  do_wcstod(L"-1234.567");
  do_wcstod(L"-.1234567");
  do_wcstod(L" -1234567.");
  do_wcstod(L"0777");
  do_wcstod(L"-4.5e6ABC");
  do_wcstod(L"1.2e-3XYZ");
  do_wcstod(L"1.2ee3XYZ");
  do_wcstod(L"1.2E3eee");
}

/*****************************************************************************/
/***     Perform numeric conversion to double from string                  ***/
/*****************************************************************************/

void do_strtod(char *in_val)
{
  double ret_val;                       /* Double that is returned.          */

                                        /* Do the conversion.                */
                                        /* Print results of conversion.      */
  ret_val = strtod(in_val, &str_end);
  printf("Conversion of: '%s' is: '%lf' with end of: '%s'\n", in_val,
         ret_val, str_end);
}

void do_double_conv(void)
{
                                        /* Print a header.                   */
                                        /* Do conversions.                   */
  printf("\nExamples of strtod:\n");
  printf("------------------\n");
  do_strtod("123erg");
  do_strtod("1234.567");
  do_strtod(".1234567");
  do_strtod("+1234567.");
  do_strtod("-1234.567");
  do_strtod("-.1234567");
  do_strtod("-1234567.");
  do_strtod("0777");
  do_strtod("-4.5e6ABC");
  do_strtod("1.2e-3XYZ");
  do_strtod("1.2ee3XYZ");
  do_strtod("1.2E3eee");
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
                                        /* Print the locale values.          */
  setlocale(LC_ALL, "");
  printf("\nLocale settings: %s\n", setlocale(LC_NUMERIC, NULL));

                                        /* Set up fields for conversions.    */
  end = (wchar_t *) malloc(200);
  str_end = (char *) malloc(200);

                                        /* Perform numeric conversions.      */
  do_long_conv();
  do_ulong_conv();
  do_w_double_conv();
  do_double_conv();

                                        /* Free up memory.                   */
  free(str_end);
  free(end);
}
