/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* XPG/4 library.                    */
#include <locale.h>                     /* Locale definitions.               */

/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define UPPER_LIMIT    0xFF             /* Maximum character to check.       */

/*****************************************************************************/
/***     wctype functions                                                  ***/
/*****************************************************************************/

void do_wctype_functions()
{
  wctype_t lower_class;                 /* Character class var for lower.    */
  wint_t ch;                            /* Character to check.               */

                                        /* Print header line.                */
  printf("\n\nDemonstrating 'wctype' and 'iswctype'\n");
  printf("-------------------------------------\n");

                                        /* Get the character class for lower */
                                        /*  case characters.                 */
  lower_class = wctype("lower");

                                        /* Loop through some characters.     */
                                        /* For each character...             */
                                        /*  If it is in the lower case class,*/
                                        /*   Print out a message.            */
  for (ch = 0; ch <= UPPER_LIMIT; ch++)
      if (iswctype(ch, lower_class))
         printf("%c is a lowercase character\n", ch);
}

/*****************************************************************************/
/***     Is functions for wide characters                                  ***/
/*****************************************************************************/

void do_is_w_functions(void)
{
  wint_t ch;                            /* Character to check.               */

                                        /* Print out the current locale name.*/
  printf("The current locale is: %s\n\n", setlocale(LC_CTYPE, NULL));

                                        /* Print a header banner.            */
                                        /* For each character print the      */
                                        /*  following information:           */
                                        /*                                   */
                                        /*  1) The char number (integer).    */
                                        /*  2) The hex value of the number.  */
                                        /*  3) The character (if printable). */
                                        /*  4) Is it alphanumeric?           */
                                        /*  5) Is it alphabetic?             */
                                        /*  6) Is it a control character?    */
                                        /*  7) Is it a digit?                */
                                        /*  8) Is it a graph character?      */
                                        /*  9) Is it lowercase?              */
                                        /* 10) Is it a punctuation character?*/
                                        /* 11) Is it a space character?      */
                                        /* 12) Is it uppercase?              */
                                        /* 13) Is it a hex digit? (0-9, A-F) */
  printf("Char  Hex   Char  Alpha  Alpha  Cont  Dig  Graph Lower  ");
  printf("Punct  Space  Upper  Hex\n");
  printf("Num   Val         numer         Char                    ");
  printf("                     Dig\n");
  printf("--------------------------------------------------------");
  printf("------------------------");

                                        /* For each wide character...        */
                                        /* Print out the information using   */
                                        /*  the proper "w_is" function.      */
  for (ch = 0; ch <= UPPER_LIMIT; ++ch)
  {
    printf("\n%-5d ", ch);
    printf("%#04x ", ch);
    printf(" %c     ",  iswprint(ch)  ? ch   : ' ');
    printf("%-6s ", iswalnum(ch)  ? "YES" : "NO");
    printf("%-6s ", iswalpha(ch)  ? "YES"  : "NO");
    printf("%-6s",  iswcntrl(ch)  ? "YES"  : "NO");
    printf("%-5s",  iswdigit(ch)  ? "YES"  : "NO");
    printf("%-6s",  iswgraph(ch)  ? "YES"  : "NO");
    printf("%-7s",  iswlower(ch)  ? "YES"  : "NO");
    printf("%-7s",  iswpunct(ch)  ? "YES" : "NO");
    printf("%-8s",  iswspace(ch)  ? "YES"  : "NO");
    printf("%-6s",  iswupper(ch)  ? "YES"  : "NO");
    printf("%-6s",  iswxdigit(ch) ? "YES"  : "NO");
  }
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
  setlocale(LC_ALL, "");

                                        /* Print out the wide char table.    */
                                        /* Demonstrate the wctype functions. */
  do_is_w_functions();
  do_wctype_functions();
}
