/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* XPG/4 library.                    */
#include <locale.h>                     /* Locale definitions.               */

/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define UPPER_LIMIT    0xFF             /* Maximum character to check.       */

/*****************************************************************************/
/***     Is functions for characters                                       ***/
/*****************************************************************************/

void do_is_functions(void)
{
  int ch;                               /* Character to check.               */

                                        /* Print out the current locale.     */
  printf("The current locale is: %s\n\n", setlocale(LC_CTYPE, NULL));

                                        /* Print a header banner.            */
                                        /* For each character print the      */
                                        /*  following information:           */
                                        /*                                   */
                                        /*  1) The char number (integer).    */
                                        /*  2) The hex value of the number.  */
                                        /*  3) The character (if printable). */
                                        /*  4) Is it alphanumeric?           */
                                        /*  5) Is it alphabetic?             */
                                        /*  6) Is it a control character?    */
                                        /*  7) Is it a digit?                */
                                        /*  8) Is it a graph character?      */
                                        /*  9) Is it lowercase?              */
                                        /* 10) Is it a punctuation character?*/
                                        /* 11) Is it a space character?      */
                                        /* 12) Is it uppercase?              */
                                        /* 13) Is it a hex digit? (0-9, A-F) */
  printf("Char  Hex   Char  Alpha  Alpha  Cont  Dig  Graph Lower  ");
  printf("Punct  Space  Upper  Hex\n");
  printf("Num   Val         numer         Char                    ");
  printf("                     Dig\n");
  printf("--------------------------------------------------------");
  printf("------------------------");

                                        /* For each character...             */
                                        /* Print out the information using   */
                                        /*  the proper "is" function.        */
  for (ch = 0; ch <= UPPER_LIMIT; ++ch)
  {
    printf("\n%-5d ", ch);
    printf("%#04x ", ch);
    printf(" %c     ",  isprint(ch)  ? ch   : ' ');
    printf("%-6s ", isalnum(ch)  ? "YES" : "NO");
    printf("%-6s ", isalpha(ch)  ? "YES"  : "NO");
    printf("%-6s",  iscntrl(ch)  ? "YES"  : "NO");
    printf("%-5s",  isdigit(ch)  ? "YES"  : "NO");
    printf("%-6s",  isgraph(ch)  ? "YES"  : "NO");
    printf("%-7s",  islower(ch)  ? "YES"  : "NO");
    printf("%-7s",  ispunct(ch)  ? "YES" : "NO");
    printf("%-8s",  isspace(ch)  ? "YES"  : "NO");
    printf("%-6s",  isupper(ch)  ? "YES"  : "NO");
    printf("%-6s",  isxdigit(ch) ? "YES"  : "NO");
  }
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
  setlocale(LC_ALL, "");

                                        /* Print out the character table.    */
  do_is_functions();
}
