/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */
#include <locale.h>
#include <wchar.h>                      /* XPG/4 library.                    */

/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define NOT_END_OF_FILE 0

/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

FILE *test_file;                        /* File handle for input and output. */

/*****************************************************************************/
/***     Perform wchar_t IO tests.                                         ***/
/*****************************************************************************/

void do_w_io_tests(void)
{
  int count;
  wchar_t a_w_char;
  char    a_string[400];
  wchar_t a_w_string[200];

                                        /* Convert a string into a wchar_t   */
                                        /*  string.                          */
  mbstowcs(a_w_string, "A wchar_t string!\n", sizeof(a_w_string));

                                        /* Open up output file (for update). */
                                        /* Print a header.                   */
  test_file = fopen("OUTPUT", "w+");
  printf("\nDemonstrate the 'put' functions for wchar_t:\nString: ");

                                        /* This loop iterates through the    */
                                        /*  characters of a wchar_t string,  */
                                        /*  and puts each character out to   */
                                        /*  standard output, and to a file.  */
  for (count = 0; count < wcslen(a_w_string); count++)
  {
      a_w_char = a_w_string[count];
      putwchar(a_w_char);
      putwc(a_w_char, test_file);       /* Same as fputwc function.          */
  }

                                        /* Put a whole string of wchar_t to  */
                                        /*  the output file.                 */
  mbstowcs(a_w_string, 
       "Another wchar_t string to put in the file!\n", sizeof(a_w_string));
  fputws(a_w_string, test_file);

                                        /* Print a header.                   */
                                        /* Go back to start of test file.    */
                                        /* Print out the first wchar_t string*/
                                        /*  in the file.                     */
  printf("\nDemonstrate the 'get' functions for wchar_t:\n");
  rewind(test_file);
  printf("Reading the first line from the file: %S\n",
         fgetws(a_w_string, 100, test_file));

                                        /* Put a character back on the input */
                                        /*  stream (even though it wasn't    */
                                        /*  read from the stream.            */
                                        /* Print a header.                   */
                                        /* Loop 10 times...                  */
                                        /*  Get a wchar_t from the stream.   */
                                        /*  Put it out to std input.         */
  mbtowc(&a_w_char, "?", MB_CUR_MAX);
  ungetwc(a_w_char, test_file);
  printf("Next 10 wchar_t from file: ");
  for (count = 0; count < 10; count++)
  {
    a_w_char = getwc(test_file);        /* Same as fgetwc function.          */
    putwchar(a_w_char);
  }

                                        /* Print a header.                   */
                                        /* Get a wchar_t from std input.     */
                                        /* Print out results.                */
  printf("\n\nPlease enter a character, and then press <ENTER>:\n");
  a_w_char = getwchar();
  printf("The character entered was: %C\n", a_w_char);

                                        /* Close test output file.           */
  fclose(test_file);
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Demonstrate the wchar_t IO        */
                                        /*  functions.                       */
  setlocale(LC_ALL, "");
  do_w_io_tests();

}
