/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#define INCL_WIN                        /* Include the "win" OS2 calls.      */
#include <os2.h>                        /* Include the OS2 toolkit defs.     */

#include <stdlib.h>                     /* Include the standard library.     */
#include <io.h>                         /* Include standard input/output.    */
#include <stdio.h>                      /* Include standard input/output.    */
#include <string.h>                     /* Include standard string functions.*/
#include <ctype.h>                      /* Include standard C type functions.*/

/*****************************************************************************/
/***     Dialog defines                                                    ***/
/*****************************************************************************/

#define DRIVE_DIALOG             3000   /* Defines for controls in the       */
#define DRIVE_TITLE              3001   /*  dialog about which drive to      */
#define DRIVE_COMBOBOX           3002   /*  install I18N package on.         */
#define DRIVE_INSTALL_BUTTON     3003
#define DRIVE_CANCEL_BUTTON      3004

#define INSTALLING_DIALOG        3100   /* Defines for controls in the       */
#define INSTALLING_TITLE         3101   /*  dialog during installing.        */
#define INSTALLING_FROM_FILE     3102
#define INSTALLING_TO_FILE       3103
#define INSTALLING_CANCEL_BUTTON 3104
#define INSTALLING_OK_BUTTON     3105
#define INSTALLING_NEXT_ZIP      3106
#define INSTALLING_NEXT_FILE     3107

#define CONFIG_DIALOG            3200   /* Defines for controls in the       */
#define CONFIG_TITLE             3201   /*  dialog about whether to update   */
#define CONFIG_LINE1             3202   /*  the CONFIG.SYS file.             */
#define CONFIG_LINE2             3203
#define CONFIG_LINE3             3204
#define CONFIG_LINE4             3205
#define CONFIG_LANG_BUTTON       3206
#define CONFIG_UPDATE_BUTTON     3207
#define CONFIG_NO_UPDATE_BUTTON  3208

#define LANG_DIALOG              3300   /* Defines for controls in the       */
#define LANG_TITLE               3301   /*  dialog about which LANG value    */
#define LANG_COMBOBOX            3302   /*  to set in CONFIG.SYS file.       */
#define LANG_OK_BUTTON           3303
#define LANG_CANCEL_BUTTON       3304

/*****************************************************************************/
/***     Stringtable defines                                               ***/
/*****************************************************************************/

#define S_CONFIG_UPDATE_LINE1    3500   /* Defines for controls in the       */
#define S_CONFIG_UPDATE_LINE2    3501   /*  stringtable for misc. messages.  */
#define S_CONFIG_UPDATE_LINE3    3502
#define S_CONFIG_UPDATE_LINE4    3503

#define S_INSTALL_TITLE          3601
#define S_ERROR_TITLE            3602
#define S_ERROR_MISSING_DRIVE    3603
#define S_ERROR_MISSING_DIR      3604
#define S_ERROR_UNZIP_LIST_FAIL  3605
#define S_ERROR_UNZIP_FAIL       3606
#define S_ERROR_CONFIG_BACKUP    3607
#define S_NEXT_DISKETTE          3608



/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/


#define BUF_SIZE         256            /* Buffer size for general use       */
#define CONFIG_SIZE     4096            /* Buffer size for CONFIG.SYS use    */

#define EXIT_NORMAL    0                /* Exit the program with no errors.  */

#define CLS_CLIENT     "MyClass"        /* Default PM class to register.     */

#define DRIVE_WIN_WIDTH      400        /* Width and height of drive window. */
#define DRIVE_WIN_HEIGHT     190
#define CONFIG_WIN_WIDTH     450        /* Width and height of config window.*/
#define CONFIG_WIN_HEIGHT    220
#define LANG_WIN_WIDTH       400        /* Width and height of lang window.  */
#define LANG_WIN_HEIGHT      190

#define RC_NO_ERROR           0         /* Return: No error                  */
#define RC_CONFIG_FAILED      4         /* Return: CONFIG.SYS update failed  */
#define RC_USER_CANCEL        8         /* Return: User cancelled install    */
#define RC_FAILED            16         /* Return: Processing failed         */


/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

HWND hwndFrame;                         /* Frame window handle for main win. */
HWND hwndClient;                        /* Client window handle for main win.*/

LONG desktop_width, desktop_height;     /* Width and height of desktop.      */
SWP  screen_swp ;                       /* Information about current window. */

char    parm_command[BUF_SIZE];         /* Input parm: invocation command    */
char    parm_drive[3];                  /* Input parm: default install drive */
char    parm_force[3];                  /* Input parm: forced install drive  */
char    parm_lang[9];                   /* Input parm: default lang value    */
char    parm_userint[2];                /* Input parm: whether user interface*/
char    parm_askdrive[2];               /* Input parm: user confirm drive    */
char    parm_updateconfig[2];           /* Input parm: user confirm config.sys*/
char    boot_drive[3];                  /* Boot drive (OS/2 installed on).   */
char    install_from_drive[3];          /* Drive to install I18N from.       */
char    install_drive[3];               /* Drive on which to install I18N.   */
char    force_drive[3];                 /* Drive on which to force the       */
                                        /*  installation of I18N.            */
char    install_lang[9];                /* LANG variable value.              */
char    userint[2];                     /* "N" if no user interface wanted.  */
char    askdrive[2];                    /* "N" if do not ask user about drive*/
char    updateconfig[2];                /* "N" if do not update config.sys   */
                                        /* "Y" if update config.sys          */
                                        /* "A" if ask user about config.sys  */

int return_code;                        /* Return code                       */
int install_zip;                        /* ZIP file to install from diskette.*/
int install_file;                       /* I18N File to install from diskette*/

HAB            habAnchor;               /* Anchor block for program.         */
HMQ            hmqQueue;                /* Message queue for program.        */
QMSG           qmMsg;                   /* A message to pull from queue.     */

