/*


===============================================================================
      Internationalization (I18N) For OS/2                 March 31, 1995
===============================================================================

                   Copyright IBM Corporation -- 1993, 1995

DISCLAIMER: This I18N package has been made available solely to gauge OS/2
developer interest in the industry standard XPG4 internationalization
programming model. This does not mean that IBM will introduce a product based
on the contents of this package. This package is not a full implementation of
the X/Open XPG4 specification and does not make any claims of XPG4 branding.
It implements only the portions of the XPG4 specification which deal with
internationalization.

X/Open is a trademark of the X/Open Company Limited.

===============================================================================


===============================================================================
                           INSTALLATION PROGRAM
===============================================================================

Function:          This I18N install program can be used to control the
                   installation of the run-time required information.
                   Presentation Manager windows are shown to control the
                   installation process.

                   An application can modify this source for their specific
                   installation environment.  There are several #DEFINE
                   statements which should be reviewed and modified as needed:
                     1.  This defines the number of ZIP files which exist on
                         the diskettes which contain the I18N files.
                                #define INSTALL_ZIP_NUM   n
                     2.  This defines the name of the ZIP file which contains
                         the I18N run-time code (setloc.dll).  The name must
                         contain the letters "DLL".
                                #define INSTALL_ZIP1      "\\I18NDLL.ZIP"
                     3.  This defines the name of the ZIP file which contains
                         the 1st part of the I18N locale files.  There may
                         be several of these files if they exist on more than
                         one diskette.  The names must contain the letters "LOC".
                                #define INSTALL_ZIP2      "\\I18NLOC1.ZIP"
                                #define INSTALL_ZIP3      "\\I18NLOC2.ZIP"
                                #define INSTALL_ZIP4      "\\I18NLOC3.ZIP"

Parameters:        Parameters are optional.  When the program is invoked
                   without any parameters, the following default values are
                   used:
                              1st:   C       (Default drive C:)
                              2nd:   none    (Do not force to a specific drive)
                              3rd:   If LANG is currently set, use its value.
                                     Otherwise, use "enus437".
                              4th:   Y       (Show PM user interface)
                              5th:   Y       (Ask user if install drive is OK)
                              6th:   A       (Ask user if to update CONFIG.SYS)

                   When another install program is invoking this program,
                   the following parameters can be used to control the install
                   processing:

                   1st  -   The drive letter on which to install the I18N
                            package if the package is not already installed.
                            Must be an alphabetic letter, C-Z.  If "A", "B" or
                            non-alphabetic, will use the default value.

                   2nd  -   The drive letter on which to force the installation
                            of the I18N package, regardless whether the package
                            is already installed.  Could be used if installing
                            package on a server drive and already have package
                            installed on a local drive. Must be an alphabetic
                            letter, C-Z.  If "A", "B" or non-alphabetic, will
                            use the normal default value specified by 1st parm.

                   3rd  -   The default LANG variable value to use when updating
                            CONFIG.SYS. The first letter must be alphabetic,
                            else the normal default value will be used.

                   4th  -   Whether the PM user interface is to be shown.
                            "N"  Do not show any PM windows, except if error
                                 conditions are found.
                            Otherwise, the normal PM interface is shown.

                   5th  -   Whether to ask the user to select the drive on
                            which to install the I18N package.
                            "N"  Do not ask the user.  Use the default value
                                 defined by the 1st and 2nd parameters.
                            "U"  Ask the user only if the I18N package has
                                 never been installed.  If the I18N package
                                 exists, do not ask the user.
                            Otherwise, the user will be shown a PM window and
                            asked to select a drive.

                   6th  -   Whether to update the CONFIG.SYS file with I18N
                            information.
                            "A"  Ask the user whether to update CONFIG.SYS.
                            "Y"  Update CONFIG.SYS with I18N information.
                            Otherwise, CONFIG.SYS will not be updated.

===============================================================================
*/

/******************************************************************************
/***     Include files                                                     ***/
/*****************************************************************************/

#define INCL_DOS                        /* Use DOS function.                 */
#include "install.h"                    /* Include data for this application */

/*****************************************************************************/
/***     Predefined constants                                              ***/
/*****************************************************************************/

#include <version.h> 			/* Version of I18N we are installing */

#define INSTALL_ZIP_NUM 3                   /* Number of diskette files.     */
#define INSTALL_ZIP1    "\\I18NDLL.ZIP"     /* 1st diskette file.            */
#define INSTALL_ZIP2    "\\I18NLOC1.ZIP"    /* 2nd diskette file.            */
#define INSTALL_ZIP3    "\\I18NLOC2.ZIP"    /* 3rd diskette file.            */
#define INSTALL_ZIP4    ""                  /* 4th diskette file.            */

#define DEFAULT_DRIVE    "C:"           /* Default drive for installed I18N. */
#define DEFAULT_LANG     "enus437"      /* Default language for I18N.        */
#define DEFAULT_USERINT  "Y"            /* Default if user interface active. */
#define DEFAULT_ASKDRIVE "Y"            /* Default if ask user about drive.  */
#define DEFAULT_UPDATECONFIG "A"        /* Default if ask user about config. */

#define I18N_DIR         "\\I18N"       /* I18N directory.                   */
#define I18N_DLL_DIR     "\\DLL"        /* I18N DLL directory.               */
#define I18N_LOCALE_DIR  "\\LOCALE"     /* I18N locale file directory.       */
#define I18N_NLSPATH_DIR "\\MESSAGES"   /* I18N NLSPATH value.               */
#define I18N_NLSPATH_VARS "\\%L\\%N"    /* I18N NLSPATH variables.           */
#define I18N_LIBPATH_VAR "LIBPATH="     /* I18N LIBPATH variable.            */
#define I18N_LANG_VAR    "LANG="        /* I18N LANG    variable.            */
#define I18N_LOCPATH_VAR "LOCPATH="     /* I18N LOCPATH variable.            */
#define I18N_NLSPATH_VAR "NLSPATH="     /* I18N NLSPATH variable.            */

#define UNZIP_TEMP_FILEN       "\\I18NUZIP.TMP" /* Temp file for unzipping.  */
#define CONFIG_SYS_FILEN       "\\CONFIG.SYS"   /* Config file: CONFIG.SYS   */
#define CONFIG_SYS_BACKUP_FILEN "\\CONFIG.I18"  /* Backup file for CONFIG.SYS*/
#define CONFIG_SYS_WORK_FILEN  "\\CONFIG18.TMP" /* Work file for CONFIG.SYS  */

#define NO_ERROR         0              /* Useful return code.               */
#define STRC_PROC        "strcoll"      /* A function to search for in DLL.  */
#define VER_PROC         "get_i18n_version"  /* Func to get the version num. */

/*****************************************************************************/
/***     Global variables                                                 ***/
/*****************************************************************************/

  char        error_title[BUF_SIZE];    /* Text for error window title.      */
  char        error_text[BUF_SIZE];     /* Text for error window message.    */
  char        string_text[BUF_SIZE];    /* Text from STRINGTABLE entry.      */
  char        message_text[BUF_SIZE];   /* Text for general message.         */

  char        I18N_dll_dir[BUF_SIZE];       /* DLL directory.                */
  char        I18N_locale_dir[BUF_SIZE];    /* Locale direcrtory.            */
  char        I18N_messages_dir[BUF_SIZE];  /* Messages directory.           */

  char        unzip_temp_file[BUF_SIZE];        /* Temp file for unzipping.  */
  char        config_sys_file[BUF_SIZE];        /* Config file: CONFIG.SYS   */
  char        config_sys_backup_file[BUF_SIZE]; /* Backup file for CONFIG.SYS*/
  char        config_sys_work_file[BUF_SIZE];   /* Work file for CONFIG.SYS  */



/*****************************************************************************/
/***                                                                       ***/
/***     Initialization routine for program.                               ***/
/***                                                                       ***/
/*****************************************************************************/

void initialize(int argc, char *argv[])
{
  char    *ptrchar;
  ULONG   drivemap, drivenum ;
  APIRET  rc ;

  return_code = RC_NO_ERROR;            /* Default return code.              */
                                        /* Initialize parameter variables.   */
  parm_drive[0] = '\0';
  parm_force[0] = '\0';
  parm_lang[0] = '\0';
  parm_userint[0] = '\0';
  parm_askdrive[0] = '\0';
  parm_updateconfig[0] = '\0';

                                        /* Find boot drive OS/2 installed on.*/
  rc = DosQuerySysInfo( QSV_BOOT_DRIVE, QSV_BOOT_DRIVE,
                        (PVOID)&drivenum, sizeof(drivenum) ) ;
  if ( rc == NO_ERROR ) {
     boot_drive[0] = toupper( drivenum+'@');
  } else {
     boot_drive[0] = 'C' ;
  }
  boot_drive[1] = ':' ;
  boot_drive[2] = '\0' ;
  sprintf( unzip_temp_file,        "%s%s", boot_drive, UNZIP_TEMP_FILEN ) ;
  sprintf( config_sys_file,        "%s%s", boot_drive, CONFIG_SYS_FILEN ) ;
  sprintf( config_sys_backup_file, "%s%s", boot_drive, CONFIG_SYS_BACKUP_FILEN ) ;
  sprintf( config_sys_work_file,   "%s%s", boot_drive, CONFIG_SYS_WORK_FILEN ) ;

                                        /* Find drive installing from.       */
  strcpy(parm_command, argv[0]);
  if ( parm_command[1] == ':' )
  {                                     /* Drive was specified on command.   */
     install_from_drive[0] = toupper( parm_command[0] );
  }
  else
  {                                     /* Use current drive as default.     */
     DosQueryCurrentDisk( &drivenum, &drivemap ) ;
     install_from_drive[0] = toupper( drivenum+'@');
  }
                                        /* Require install from diskette.    */
/*if ( (install_from_drive[0]!='A') && (install_from_drive[0]!='B') ) 3-23-95*/

                                        /* Require install from valid drive. */
  if ( ! isalpha(install_from_drive[0]) )
  {
     install_from_drive[0] = 'A';
  }
  install_from_drive[1] = ':';
  install_from_drive[2] = '\0';

                                        /* If parameters were specified.     */
  if ( argc > 1 )
  {
                                        /* 1st parm: default drive if I18N   */
                                        /*  not already installed.           */
     strcpy(parm_drive, argv[1]);
     parm_drive[0] = toupper( parm_drive[0] );
     if ( argc > 2 )
     {
                                        /* 2nd parm: force I18N to be        */
                                        /*  installed on this drive.         */
        strcpy(parm_force, argv[2]);
        parm_force[0] = toupper( parm_force[0] );
        if ( argc > 3 )
        {
                                        /* 3rd parm: default language.       */
           strcpy(parm_lang, argv[3]);
           if ( argc > 4 )
           {
                                        /* 4th parm: whether user wants      */
                                        /*  user interface or not.           */
              strcpy(parm_userint, argv[4]);
              parm_userint[0] = toupper( parm_userint[0] );
              if ( argc > 5 )
              {
                                        /* 5th parm: whether to ask user     */
                                        /*  which drive to install on.       */
                 strcpy(parm_askdrive, argv[5]);
                 parm_askdrive[0] = toupper( parm_askdrive[0] );
                 if ( argc > 6 )
                 {
                                        /* 6th parm: whether to ask user     */
                                        /*  about updating config.sys file.  */
                    strcpy(parm_updateconfig, argv[6]);
                    parm_updateconfig[0] = toupper( parm_updateconfig[0] );
                 }
              }
           }
        }
     }
  }
  /*------------------------------------------------------------------------*/
  if ( isalpha(parm_drive[0]) )
  {
     strcpy(install_drive, parm_drive);
     install_drive[1] = ':';
     install_drive[2] = '\0';
  }
  else
  {
     strcpy(install_drive, boot_drive);
  }
  /*------------------------------------------------------------------------*/
  if ( isalpha(parm_force[0]) )
  {
     strcpy(force_drive, parm_force);
  }
  else
  {
     force_drive[0] = '\0';
  }
  /*------------------------------------------------------------------------*/
  if ( isalpha(parm_lang[0]) )
  {
     strcpy(install_lang, parm_lang);
  }
  else
  {
     ptrchar = getenv( "LANG" );
     if ( ptrchar )
     {
        strcpy(install_lang, ptrchar);
     }
     else
     {
        strcpy(install_lang, DEFAULT_LANG);
     }
  }
  /*------------------------------------------------------------------------*/
  if ( isalpha(parm_askdrive[0]) )
  {
     strcpy(askdrive, parm_askdrive);
  }
  else
  {
     strcpy(askdrive, DEFAULT_ASKDRIVE);
  }
  /*------------------------------------------------------------------------*/
  if ( isalpha(parm_updateconfig[0]) )
  {
     strcpy(updateconfig, parm_updateconfig);
  }
  else
  {
     strcpy(updateconfig, DEFAULT_UPDATECONFIG);
  }
  /*------------------------------------------------------------------------*/
  if ( isalpha(parm_userint[0]) )
  {
     strcpy(userint, parm_userint);
     if ( userint[0] == 'N' )
     {
        askdrive[0] = 'N';
        if ( updateconfig[0] == 'A' )  updateconfig[0] = 'Y';
     }
  }
  else
  {
     strcpy(userint, DEFAULT_USERINT);
  }
  /*------------------------------------------------------------------------*/

}



/*****************************************************************************/
/***                                                                       ***/
/***     Query if I18N is already installed                                ***/
/***                                                                       ***/
/*****************************************************************************/

int is_i18n_installed(double *ver_num, char *inst_drive)
{
  char    load_error[BUF_SIZE];         /* Returned buffer if API fails.     */
  char    mod_name[BUF_SIZE];           /* Returned buffer for module name.  */
  HMODULE mod_handle;                   /* Handle to SETLOC.DLL              */
  int     rc, rc2;                      /* Return codes from the APIs.       */

                                        /* Function variable declarations for*/
                                        /*  STRCOLL and GET_I18N_VERSION     */
  int (* strcoll_addr) (const char *, const char *);
  double (* get_version_addr) (void);

                                        /* Set default version number of     */
                                        /*  installed I18N  to version 0.    */
                                        /* Try to open up SETLOC.DLL         */
                                        /* If we opened it without problem...*/
                                        /*  Get the address for strcoll...   */
                                        /*  (This makes sure that the SETLOC */
                                        /*   DLL opened is really our I18N.) */
  *ver_num = 0.0;
  rc = DosLoadModule(load_error, sizeof(load_error), MODULE_NAME, &mod_handle);
  if (rc == NO_ERROR)
  {
     rc = DosQueryProcAddr(mod_handle, 0, STRC_PROC,
                           (PFN *) &strcoll_addr);

                                        /* Get the address of the get version*/
                                        /*  API.                             */
                                        /* If found (old versions of I18N    */
                                        /*  did not have this API)...        */
                                        /*  Call on function to get version  */
                                        /*   number.                         */
     rc2 = DosQueryProcAddr(mod_handle, 0, VER_PROC,
                           (PFN *) &get_version_addr);
     if (rc2 == NO_ERROR)
     {
        *ver_num = get_version_addr();
                                        /* Get the drive, path and module    */
                                        /*  name of this I18N DLL.           */
                                        /* If found, set the drive which this*/
                                        /*  DLL was found (from LIBPATH).    */
        rc2 = DosQueryModuleName(mod_handle, sizeof(mod_name), mod_name);
        if (rc2 == NO_ERROR)
        {
           inst_drive[0] = mod_name[0];
        }
     }
                                        /*  Free the module handle.          */
     DosFreeModule(mod_handle);
  }
                                        /* Return results of our open  and   */
                                        /*  locate function attempt.         */
  return(rc == NO_ERROR);
}



/*****************************************************************************/
/***                                                                       ***/
/***     Select Installation drive procedure.                              ***/
/***                                                                       ***/
/*****************************************************************************/

MRESULT EXPENTRY select_drive(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  short   drive;
  ULONG   drivemap, drivenum ;
  char    new_drive[3];
  char    drivevalue[] = " :";
  BOOL    drive_match;

  switch(msg)
  {
                                        /* When we get the "init dialog" msg */
    case WM_INITDLG:
         {
                                        /* Find all of the available drives  */
                                        /* on which the I18N directory could */
                                        /* be installed.                     */
           DosQueryCurrentDisk( &drivenum, &drivemap ) ;

                                        /* Delete all entries from the list. */
           WinSendDlgItemMsg( hwnd, DRIVE_COMBOBOX, LM_DELETEALL, NULL, NULL ) ;

                                        /* Determine which drive letters are */
                                        /*  available on this system (ignore */
                                        /*  drives A and B).                 */
           drive_match = FALSE;
           for ( drive = 0 ; drive < 26 ; drive++ )
              if ( (drivemap & 1L << drive) && (drive>1) )
              {
                                        /* Convert drive number to letter.   */
                 drivevalue[0] = (CHAR) (drive + 'A') ;
                                        /* If default install drive was      */
                                        /*  provided as a parameter, ensure  */
                                        /*  that that drive is available.    */
                 if ( drivevalue[0] == install_drive[0] )
                 {
                    drive_match = TRUE ;
                 }
                                        /* Add each available drive to list. */
                 WinSendDlgItemMsg( hwnd, DRIVE_COMBOBOX, LM_INSERTITEM,
                                    MPFROM2SHORT ( LIT_END, 0 ),
                                    MPFROMP ( drivevalue ) ) ;
              }
                                        /* If parameter drive is not valid,  */
                                        /*  reset install drive to default.  */
           if ( ! drive_match )
           {
              strcpy(install_drive, boot_drive);
           }
                                        /* Set current install drive as the  */
                                        /* default drive.                    */
           WinSetDlgItemText( hwnd, DRIVE_COMBOBOX, install_drive ) ;

           break;
         }
    case WM_COMMAND:
         switch(SHORT1FROMMP(mp1))
         {
                                        /* If they press the install button. */
           case DRIVE_INSTALL_BUTTON:
                                        /* Get the selected install drive,   */
                                        /*  Set the new install drive,  and  */
                                        /*  exit PM interface.               */
                WinQueryDlgItemText(hwnd, DRIVE_COMBOBOX,
                                    sizeof(new_drive), new_drive);
                install_drive[0] = new_drive[0];
                WinPostMsg(hwnd, WM_CLOSE, NULL, NULL);
                WinPostMsg(hwnd, WM_QUIT, NULL, NULL);
                break;
                                        /* If they cancel the install...     */
           case DRIVE_CANCEL_BUTTON:
                                        /* Close the dialog,                 */
                                        /* and exit PM interface.            */
                install_drive[0] = '\0';
                return_code = RC_USER_CANCEL;
                WinPostMsg(hwnd, WM_CLOSE, NULL, NULL);
                WinPostMsg(hwnd, WM_QUIT, NULL, NULL);
                break;
           default : break;
         }
         break;
    default:
         return(WinDefDlgProc(hwnd, msg, mp1, mp2));
  }
  return((MRESULT) 0);
}



/*****************************************************************************/
/***                                                                       ***/
/***     Ask user which available drive to install the I18N package on.    ***/
/***                                                                       ***/
/*****************************************************************************/

void ask_user_which_drive(void)
{
                                        /* Register main window class        */
  WinRegisterClass(habAnchor, CLS_CLIENT, select_drive, CS_SIZEREDRAW, 0);

  hwndFrame = WinLoadDlg( HWND_DESKTOP,  /* Place anywhere on desktop.       */
                          HWND_DESKTOP,  /* Owned by frame                   */
                          select_drive,  /* Address of dialog procedure      */
                          0,             /* Module handle                    */
                          DRIVE_DIALOG,  /* Dialog id in resource            */
                          NULL ) ;       /* Initialization data              */
  if (hwndFrame != NULLHANDLE)
  {
                                        /* Set the size of the dialog  and   */
                                        /*  center it on the screen.         */
     WinQueryWindowPos( hwndFrame, &screen_swp ) ;
     WinSetWindowPos(hwndFrame, NULLHANDLE,
                     (SHORT) (desktop_width - screen_swp.cx) / 2,
                     (SHORT) (desktop_height - screen_swp.cy) / 2,
                     0, 0,
                     SWP_MOVE | SWP_ACTIVATE | SWP_SHOW);

                                        /*  Main message loop:               */
                                        /*  While there are more messages... */
                                        /*   Dispatch this message.          */
     while (WinGetMsg(habAnchor, &qmMsg, NULLHANDLE, 0, 0))
     {
        WinDispatchMsg(habAnchor, &qmMsg);
     }
                                        /*  We're done.  Get rid of the main */
                                        /*   window.                         */
     WinDestroyWindow(hwndFrame);
  }
}



/*****************************************************************************/
/***                                                                       ***/
/***     Installing I18N package status panel.                             ***/
/***                                                                       ***/
/*****************************************************************************/

MRESULT EXPENTRY installing_I18N(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  static char        orig_zip_file[BUF_SIZE];
  static char        zip_file[BUF_SIZE];
  char        unzip_from_file[BUF_SIZE];
  char        unzip_file[BUF_SIZE];
  char        unzip_to_dir[BUF_SIZE];
  char        unzip_to_file[BUF_SIZE];
  char        zip_record[BUF_SIZE];
  char        zip_command[BUF_SIZE];
  char        *ptrchar;
  int         pos ;
  int         ret_code;
  FILE       *file_unzip ;
  static FILE       *file_zip ;

  switch(msg)
  {
                                        /* When we get the "init dialog" msg */
    case WM_INITDLG:
         {
                                        /* Initialize variables,  and        */
                                        /*  start process with 1st zip file. */
           install_zip = 0;
           WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_NEXT_ZIP ), NULL ) ;
           break;
         }
    case WM_COMMAND:
         switch(SHORT1FROMMP(mp1))
         {
                                        /* Find next ZIP file to install.    */
           case INSTALLING_NEXT_ZIP:
                                        /* Set next ZIP file to process.     */
                ++install_zip ;
                install_file = 0;
                                        /* If previous ZIP list file is open,*/
                if ( file_zip )
                {
                                        /* If no files installed from ZIP,   */
                   if ( install_file == 0 )
                   {
                     /************* error ***************/
                   }
                                        /* Close the temporary ZIP list file.*/
                   fclose( file_zip ) ;
                                        /* Delete the temporary ZIP list file*/
                   remove( unzip_temp_file ) ;
                                        /* Delete the copied ZIP file from   */
                                        /*  the installation drive.          */
                   remove( zip_file ) ;
                }
                                        /* If all ZIP file have been done,   */
                                        /*  installation completed OK.       */
                if ( install_zip > INSTALL_ZIP_NUM )
                {
                   WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_OK_BUTTON ), NULL ) ;
                }
                else
                {
                                        /* Based on zip index, select the    */
                                        /*  next zip file to process.        */
                   if ( install_zip == 1 )  strcpy(zip_file, INSTALL_ZIP1 );
                   if ( install_zip == 2 )  strcpy(zip_file, INSTALL_ZIP2 );
                   if ( install_zip == 3 )  strcpy(zip_file, INSTALL_ZIP3 );
                   if ( install_zip == 4 )  strcpy(zip_file, INSTALL_ZIP4 );
                                        /* Set the ZIP file path on both the */
                                        /*  diskette and the install drive.  */
                   sprintf( orig_zip_file, "%s%s", install_from_drive, zip_file );
                   ptrchar = strrchr( orig_zip_file, '\\' );
                   sprintf( zip_file, "%s%s%s", install_drive, I18N_DIR, ptrchar );
                   WinSetDlgItemText( hwnd, INSTALLING_FROM_FILE, orig_zip_file ) ;
                   WinSetDlgItemText( hwnd, INSTALLING_TO_FILE, zip_file ) ;
                   file_zip = fopen( orig_zip_file, "r" ) ;
                                        /* If unable to open original zip    */
                                        /*  file, then inform user and exit. */
                   if ( ! file_zip )
                   {
                      WinLoadString(habAnchor, (HMODULE) NULL, S_INSTALL_TITLE,
                                    sizeof(error_title), error_title );
                      WinLoadString(habAnchor, (HMODULE) NULL, S_NEXT_DISKETTE,
                                    sizeof(string_text), string_text );
                      sprintf( error_text, string_text, orig_zip_file );
                      ret_code = WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                                                error_text, error_title, 0,
                                                MB_OKCANCEL | MB_DEFBUTTON1 |
                                                MB_WARNING | MB_APPLMODAL ) ;
                      if ( ret_code == MBID_OK )
                      {
                         --install_zip ;
                         WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_NEXT_ZIP ), NULL ) ;
                      }
                      else
                      {
                         WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_CANCEL_BUTTON ), NULL ) ;
                      }
                   }
                   else
                   {
                      fclose( file_zip );
                                        /* Copy the ZIP file from diskette   */
                                        /*  to install drive for performance.*/
                      sprintf( zip_command, "COPY %s %s",
                               orig_zip_file, zip_file ) ;
                      system( zip_command );
                                        /* UNZIP to get a list of files to   */
                                        /*  be installed.                    */
                      sprintf( zip_command, "PKUNZIP2 -vb %s >%s",
                               zip_file, unzip_temp_file ) ;
                      system( zip_command );
                      WinSetDlgItemText( hwnd, INSTALLING_TO_FILE, "" ) ;
                                        /* Open UNZIP output which contains  */
                                        /*  list of files in the ZIP file.   */
                      file_zip = fopen( unzip_temp_file, "r" ) ;
                                        /* If temporary file does not exist, */
                                        /*  tell user and terminate install. */
                      if ( ! file_zip )
                      {
                         WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_TITLE,
                                       sizeof(error_title), error_title );
                         WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_UNZIP_LIST_FAIL,
                                       sizeof(string_text), string_text );
                         sprintf( error_text, string_text, zip_file );
                         WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                                        error_text, error_title, 0,
                                        MB_CANCEL | MB_DEFBUTTON1 |
                                        MB_ERROR | MB_APPLMODAL ) ;
                         return_code = RC_FAILED;
                         WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_OK_BUTTON ), NULL ) ;
                      }
                                        /* If temporary file does exist,     */
                                        /*  start installation of files      */
                                        /*  contained in this ZIP file.      */
                      else
                      {
                         WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_NEXT_FILE ), NULL ) ;
                      }
                   }
                }
                break;
                                        /* Find next I18N file to install.   */
           case INSTALLING_NEXT_FILE:
                unzip_from_file[0] = '\0' ;
                                        /* Read records from the temporary   */
                                        /*  UNZIP listing until EOF reached  */
                                        /*  or next .DLL found to install.   */
                while ( !unzip_from_file[0]  &&
                        ( fgets( zip_record, sizeof(zip_record), file_zip ) != NULL ) )
                {
                                        /* See if record contains name of a  */
                                        /*  .DLL file to be installed.       */
                   ptrchar = strstr( zip_record, ".DLL" );
                   if ( !ptrchar ) ptrchar = strstr( zip_record, ".dll" );
                                        /* If .DLL, then find name of the    */
                                        /*  file to install from ZIP file.   */
                   if ( ptrchar )
                   {
                      *(ptrchar+4) = '\0';
                      for( ; ptrchar>zip_record && !isspace(*ptrchar) ; --ptrchar ) ;
                      strcpy( unzip_from_file, ++ptrchar );
                   }
                }
                                        /* If file found to UNZIP,           */
                if ( unzip_from_file[0] )
                {
                                        /* Convert "/" to "\".               */
                   for( ptrchar=unzip_from_file; *ptrchar ; ++ptrchar)
                   {
                      if ( *ptrchar == '/' ) *ptrchar='\\' ;
                   }
                                        /* Find last "\" to find file name. */
                   ptrchar = strrchr( unzip_from_file, '\\' );
                   if ( ptrchar )
                   {
                      strcpy( unzip_file, ++ptrchar );
                   }
                   else
                   {
                      strcpy( unzip_file, unzip_from_file );
                   }
                                        /* If original ZIP file contains    */
                                        /*  "DLL" then I18N code install.   */
                   if ( strstr( orig_zip_file, "DLL" ) )
                   {
                      sprintf( unzip_to_dir, "%s%s%s", install_drive,
                                             I18N_DIR, I18N_DLL_DIR );
                   }
                   else
                                        /* else, I18N locale install.       */
                   {
                      sprintf( unzip_to_dir, "%s%s%s", install_drive,
                                             I18N_DIR, I18N_LOCALE_DIR );
                   }
                                        /* Set file name being installed.   */
                   sprintf( unzip_to_file, "%s\\%s", unzip_to_dir, unzip_file );
                   WinSetDlgItemText( hwnd, INSTALLING_TO_FILE, unzip_to_file );
                                        /* UNZIP this single I18N file.     */
                   sprintf( zip_command, "PKUNZIP2 -o %s %s %s",
                            zip_file, unzip_to_dir, unzip_from_file ) ;
                   system( zip_command );
                                        /* Open installed file to see if    */
                                        /*  it was installed OK.            */
                   file_unzip = fopen( unzip_to_file, "r" ) ;
                                        /* if install failed,               */
                                        /*  tell user and terminate.        */
                   if ( ! file_unzip )
                   {
                      WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_TITLE,
                                    sizeof(error_title), error_title );
                      WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_UNZIP_FAIL,
                                    sizeof(string_text), string_text );
                      sprintf( error_text, string_text, unzip_to_file, unzip_from_file );
                      WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                                     error_text, error_title, 0,
                                     MB_CANCEL | MB_DEFBUTTON1 |
                                     MB_ERROR | MB_APPLMODAL ) ;
                      return_code = RC_FAILED;
                      WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_OK_BUTTON ), NULL ) ;
                   }
                                        /* if install was successful,       */
                                        /*  continue with next file.        */
                   else
                   {
                      fclose( file_unzip ) ;
                      WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_NEXT_FILE ), NULL ) ;
                   }
                }
                else
                {
                   WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_NEXT_ZIP ), NULL ) ;
                }
                break;
                                        /* If installing completed.          */
           case INSTALLING_OK_BUTTON:
                                        /* Close the dialog,                 */
                                        /* and exit PM interface.            */
                WinPostMsg(hwnd, WM_CLOSE, NULL, NULL);
                WinPostMsg(hwnd, WM_QUIT, NULL, NULL);
                break;
                                        /* If they want no cancel installing.*/
           case INSTALLING_CANCEL_BUTTON:
                                        /* Close the dialog,                 */
                                        /* and exit PM interface.            */
                return_code = RC_USER_CANCEL;
                WinPostMsg( hwnd, WM_COMMAND, MPFROMSHORT( INSTALLING_OK_BUTTON ), NULL ) ;
                break;
           default : break;
         }
         break;
    default:
         return(WinDefDlgProc(hwnd, msg, mp1, mp2));
  }
  return((MRESULT) 0);
}



/*****************************************************************************/
/***                                                                       ***/
/***     Install the I18N package.                                         ***/
/***                                                                       ***/
/*****************************************************************************/

void execute_install_I18N(void)
{
  char    I18N_dir[BUF_SIZE];           /* Directory path.                   */
  char    I18N_dll_dir[BUF_SIZE];       /* Directory path.                   */
  char    I18N_locale_dir[BUF_SIZE];    /* Directory path.                   */
  char    I18N_nlspath_dir[BUF_SIZE];   /* Directory path.                   */

  PEAOP2  eabuf ;                       /* Extended attribute buffer.        */
  int     ret_code;                     /* Return code from is_installed API.*/
  int     user_swp_show;


  eabuf = 0;
  ret_code = DosSetDefaultDisk( install_drive[0]-'@' );
  if ( ret_code == NO_ERROR )
  {
                                        /* Set installation directories      */
     sprintf( I18N_dir, "%s%s", install_drive, I18N_DIR );
     sprintf( I18N_dll_dir, "%s%s%s", install_drive, I18N_DIR, I18N_DLL_DIR );
     sprintf( I18N_locale_dir, "%s%s%s", install_drive, I18N_DIR, I18N_LOCALE_DIR );
     sprintf( I18N_nlspath_dir, "%s%s%s", install_drive, I18N_DIR, I18N_NLSPATH_DIR );

                                        /* Create all I18N directories, if   */
                                        /*  they do not already exist.       */
                                        /*  Handle if create fails.          */
     ret_code = DosCreateDir( I18N_dir, eabuf );
     ret_code = DosSetCurrentDir( I18N_dir );
     if ( ret_code == NO_ERROR )
     {
        ret_code = DosCreateDir( I18N_dll_dir, eabuf );
        ret_code = DosSetCurrentDir( I18N_dll_dir );
        if ( ret_code == NO_ERROR )
        {
           ret_code = DosCreateDir( I18N_locale_dir, eabuf );
           ret_code = DosSetCurrentDir( I18N_dll_dir );
           if ( ret_code == NO_ERROR )
           {
              ret_code = DosCreateDir( I18N_nlspath_dir, eabuf );
              ret_code = DosSetCurrentDir( I18N_nlspath_dir );
              if ( ret_code == NO_ERROR )
              {
              }
              else
              {
                 WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_TITLE,
                               sizeof(error_title), error_title );
                 WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_MISSING_DIR,
                               sizeof(string_text), string_text );
                 sprintf( error_text, string_text, I18N_nlspath_dir );
                 WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                                error_text, error_title, 0,
                                MB_CANCEL | MB_DEFBUTTON1 |
                                MB_ERROR | MB_APPLMODAL ) ;
                 return_code = RC_FAILED;
              }
           }
           else
           {
              WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_TITLE,
                            sizeof(error_title), error_title );
              WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_MISSING_DIR,
                            sizeof(string_text), string_text );
              sprintf( error_text, string_text, I18N_locale_dir );
              WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                             error_text, error_title, 0,
                             MB_CANCEL | MB_DEFBUTTON1 |
                             MB_ERROR | MB_APPLMODAL ) ;
              return_code = RC_FAILED;
           }
        }
        else
        {
           WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_TITLE,
                         sizeof(error_title), error_title );
           WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_MISSING_DIR,
                         sizeof(string_text), string_text );
           sprintf( error_text, string_text, I18N_dll_dir );
           WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                          error_text, error_title, 0,
                          MB_CANCEL | MB_DEFBUTTON1 |
                          MB_ERROR | MB_APPLMODAL ) ;
           return_code = RC_FAILED;
        }
     }
     else
     {
        WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_TITLE,
                      sizeof(error_title), error_title );
        WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_MISSING_DIR,
                      sizeof(string_text), string_text );
        sprintf( error_text, string_text, I18N_dir );
        WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                       error_text, error_title, 0,
                       MB_CANCEL | MB_DEFBUTTON1 |
                       MB_ERROR | MB_APPLMODAL ) ;
        return_code = RC_FAILED;
     }
  }
  else
  {
     WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_TITLE,
                   sizeof(error_title), error_title );
     WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_MISSING_DRIVE,
                   sizeof(string_text), string_text );
     sprintf( error_text, string_text, install_drive );
     WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                    error_text, error_title, 0,
                    MB_CANCEL | MB_DEFBUTTON1 |
                    MB_ERROR | MB_APPLMODAL ) ;
     return_code = RC_FAILED;
  }

  if ( ret_code == NO_ERROR )
  {
     WinRegisterClass(habAnchor, CLS_CLIENT, installing_I18N, CS_SIZEREDRAW, 0);

     hwndFrame = WinLoadDlg( HWND_DESKTOP,  /* Place anywhere on desktop.    */
                             HWND_DESKTOP,  /* Owned by frame                */
                             installing_I18N,  /* Address of dialog procedure*/
                             0,             /* Module handle                 */
                             INSTALLING_DIALOG,  /* Dialog id in resource    */
                             NULL ) ;       /* Initialization data           */
     if (hwndFrame != NULLHANDLE)
     {
        if ( userint[0] == 'N' )
        {                                   /* If no user interface wanted.  */
           user_swp_show = 0;
        }
        else
        {                                   /* If user interface wanted.     */
           user_swp_show = SWP_SHOW;
        }
                                        /* Set the size of the dialog  and   */
                                        /*  center it on the screen.         */
        WinQueryWindowPos( hwndFrame, &screen_swp ) ;
        WinSetWindowPos(hwndFrame, NULLHANDLE,
                        (SHORT) (desktop_width - screen_swp.cx) / 2,
                        (SHORT) (desktop_height - screen_swp.cy) / 2,
                        0, 0,
                        SWP_MOVE | SWP_ACTIVATE | user_swp_show);

                                        /*  Main message loop:               */
                                        /*  While there are more messages... */
                                        /*   Dispatch this message.          */
        while (WinGetMsg(habAnchor, &qmMsg, NULLHANDLE, 0, 0))
        {
           WinDispatchMsg(habAnchor, &qmMsg);
        }
                                        /*  We're done.  Get rid of the main */
                                        /*   window.                         */
        WinDestroyWindow(hwndFrame);
  }
  }
}



/*****************************************************************************/
/***                                                                       ***/
/***     Determine the value to be used for the LANG variable.             ***/
/***                                                                       ***/
/*****************************************************************************/

MRESULT EXPENTRY select_lang(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  FILEFINDBUF3 findbuffer ;
  char        filename[BUF_SIZE];
  HDIR        findhandle ;
  ULONG       findcount ;
  int         ret_code;

  switch(msg)
  {
                                        /* When we get the "init dialog" msg */
    case WM_INITDLG:
         {

           findhandle = 0x0001 ;
           findcount = 1 ;
                                        /* Delete all entries from the list. */
           WinSendDlgItemMsg( hwnd, LANG_COMBOBOX, LM_DELETEALL, NULL, NULL ) ;
                                        /* Find the first locale which       */
                                        /*  exists in the I18N directory.    */
           strcpy( filename, install_drive );
           strcat( filename, "\\I18N\\LOCALE\\*.DLL" );
           ret_code = DosFindFirst( filename, &findhandle, 0x0000, &findbuffer,
                                    sizeof(findbuffer), &findcount, FIL_STANDARD ) ;
           while ( ret_code == NO_ERROR )
           {
                                        /* If a locale file name was found,  */
                                        /*  remove the .DLL extension,  and  */
                                        /*  add it to the list.              */
              findbuffer.achName[strlen(findbuffer.achName)-4] = '\0' ;
              WinSendDlgItemMsg( hwnd, LANG_COMBOBOX, LM_INSERTITEM,
                                 MPFROM2SHORT ( LIT_SORTASCENDING, 0 ),
                                 MPFROMP ( findbuffer.achName ) ) ;

                                        /* Get the next locale file from the */
                                        /*  list within the I18N directory.  */
              ret_code = DosFindNext( findhandle, &findbuffer,
                                      sizeof(findbuffer), &findcount ) ;
           }
           DosFindClose( findhandle );
                                        /* Set the default LANG value.       */
           WinSetDlgItemText( hwnd, LANG_COMBOBOX, install_lang ) ;

           break;
         }
    case WM_COMMAND:
         switch(SHORT1FROMMP(mp1))
         {
                                        /* If they press the LANG button.    */
           case LANG_OK_BUTTON:
                                        /* Close the dialog                  */
                                        /* and set the new LANG default.     */
                WinQueryDlgItemText(hwnd, LANG_COMBOBOX,
                                    sizeof(install_lang), install_lang);
                WinLoadString(habAnchor, (HMODULE) NULL, S_CONFIG_UPDATE_LINE2,
                              sizeof(string_text), string_text );
                sprintf( message_text, string_text, I18N_LANG_VAR, install_lang );
                WinSetDlgItemText( hwndFrame, CONFIG_LINE2, message_text ) ;
                WinPostMsg(hwnd, WM_CLOSE, NULL, NULL);
                break;
                                        /* If they want no update CONFIG.SYS */
           case LANG_CANCEL_BUTTON:
                                        /* Close the dialog                  */
                WinPostMsg(hwnd, WM_CLOSE, NULL, NULL);
                break;
           default : break;
         }
         break;
    default:
         return(WinDefDlgProc(hwnd, msg, mp1, mp2));
  }
  return((MRESULT) 0);
}



/*****************************************************************************/
/***                                                                       ***/
/***     Ask user which available LANG value should be set in CONFIG.SYS.  ***/
/***                                                                       ***/
/*****************************************************************************/

void ask_user_lang_value(void)
{
  SWP         lang_swp ;                /* Information about current window. */

  hwndClient = WinLoadDlg( hwndFrame,    /* Place anywhere on desktop.       */
                          hwndFrame,     /* Owned by frame                   */
                          select_lang,   /* Address of dialog procedure      */
                          0,             /* Module handle                    */
                          LANG_DIALOG,   /* Dialog id in resource            */
                          NULL ) ;       /* Initialization data              */
  if (hwndClient != NULLHANDLE)
  {
                                        /* Set the size of the dialog  and   */
                                        /*  center it on the screen.         */
     WinQueryWindowPos( hwndClient, &lang_swp ) ;
     WinSetWindowPos(hwndClient, NULLHANDLE,
                     (SHORT) (screen_swp.cx - lang_swp.cx) / 2,
                     (SHORT) (screen_swp.cy - lang_swp.cy) / 2,
                     0, 0,
                     SWP_MOVE | SWP_ACTIVATE | SWP_SHOW);
  }
}



/*****************************************************************************/
/***                                                                       ***/
/***     Determine whether to update CONFIG.SYS procedure.                 ***/
/***                                                                       ***/
/*****************************************************************************/

MRESULT EXPENTRY update_config(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch(msg)
  {
                                        /* When we get the "init dialog" msg */
    case WM_INITDLG:
         {
                                        /* Find all of the available drives  */
                                        /* on which the I18N directory could */
                                        /* be installed.                     */
           WinLoadString(habAnchor, (HMODULE) NULL, S_CONFIG_UPDATE_LINE1,
                         sizeof(string_text), string_text );
           sprintf( I18N_dll_dir, "%s%s%s", install_drive, I18N_DIR, I18N_DLL_DIR );
           sprintf( message_text, string_text, I18N_dll_dir );
           WinSetDlgItemText( hwnd, CONFIG_LINE1, message_text ) ;
           WinLoadString(habAnchor, (HMODULE) NULL, S_CONFIG_UPDATE_LINE2,
                         sizeof(string_text), string_text );
           sprintf( message_text, string_text, I18N_LANG_VAR, install_lang );
           WinSetDlgItemText( hwnd, CONFIG_LINE2, message_text ) ;
           WinLoadString(habAnchor, (HMODULE) NULL, S_CONFIG_UPDATE_LINE3,
                         sizeof(string_text), string_text );
           sprintf( I18N_locale_dir, "%s%s%s", install_drive, I18N_DIR, I18N_LOCALE_DIR );
           sprintf( message_text, string_text, I18N_LOCPATH_VAR, I18N_locale_dir );
           WinSetDlgItemText( hwnd, CONFIG_LINE3, message_text ) ;
           WinLoadString(habAnchor, (HMODULE) NULL, S_CONFIG_UPDATE_LINE4,
                         sizeof(string_text), string_text );
           sprintf( I18N_messages_dir, "%s%s%s%s", install_drive, I18N_DIR,
                                          I18N_NLSPATH_DIR, I18N_NLSPATH_VARS );
           sprintf( message_text, string_text, I18N_NLSPATH_VAR, I18N_messages_dir );
           WinSetDlgItemText( hwnd, CONFIG_LINE4, message_text ) ;

           break;
         }
    case WM_COMMAND:
         switch(SHORT1FROMMP(mp1))
         {
                                        /* If they press the LANG button.    */
           case CONFIG_LANG_BUTTON:
                                        /* Find out the value to be used for */
                                        /*  setting the LANG variable.       */
                ask_user_lang_value() ;
                break;

           case CONFIG_UPDATE_BUTTON:
                                        /* Close the dialog,                 */
                                        /* and exit PM interface.            */
                updateconfig[0] = 'Y';
                WinPostMsg(hwnd, WM_CLOSE, NULL, NULL);
                WinPostMsg(hwnd, WM_QUIT, NULL, NULL);
                break;
                                        /* If they want no update CONFIG.SYS */
           case CONFIG_NO_UPDATE_BUTTON:
                                        /* Close the dialog,                 */
                                        /* and exit PM interface.            */
                updateconfig[0] = 'N';
                WinPostMsg(hwnd, WM_CLOSE, NULL, NULL);
                WinPostMsg(hwnd, WM_QUIT, NULL, NULL);
                break;
           default : break;
         }
         break;
    default:
         return(WinDefDlgProc(hwnd, msg, mp1, mp2));
  }
  return((MRESULT) 0);
}



/*****************************************************************************/
/***                                                                       ***/
/***     Ask user whether to update the CONFIG.SYS file with the I18N      ***/
/***     required values.                                                  ***/
/***                                                                       ***/
/*****************************************************************************/

void ask_user_update_config(void)
{
  QMSG           qmMsg;                 /* A message to pull from queue.     */

                                        /* Register main window class        */
  WinRegisterClass(habAnchor, CLS_CLIENT, update_config, CS_SIZEREDRAW, 0);

  hwndFrame = WinLoadDlg( HWND_DESKTOP,  /* Place anywhere on desktop.       */
                          HWND_DESKTOP,  /* Owned by frame                   */
                          update_config, /* Address of dialog procedure      */
                          0,             /* Module handle                    */
                          CONFIG_DIALOG, /* Dialog id in resource            */
                          NULL ) ;       /* Initialization data              */
  if (hwndFrame != NULLHANDLE)
  {
     WinQueryWindowPos( hwndFrame, &screen_swp ) ;
     WinSetWindowPos(hwndFrame, NULLHANDLE,
                     (SHORT) (desktop_width - screen_swp.cx) / 2,
                     (SHORT) (desktop_height - screen_swp.cy) / 2,
                     0, 0,
                     SWP_MOVE | SWP_ACTIVATE | SWP_SHOW);

                                        /*  Main message loop:               */
                                        /*  While there are more messages... */
                                        /*   Dispatch this message.          */
     while (WinGetMsg(habAnchor, &qmMsg, NULLHANDLE, 0, 0))
     {
        WinDispatchMsg(habAnchor, &qmMsg);
     }
                                        /*  We're done.  Get rid of the main */
                                        /*   window.                         */
     if ( hwndClient )
     {
        WinDestroyWindow(hwndClient);
     }
     WinDestroyWindow(hwndFrame);
  }
}



/*****************************************************************************/
/***                                                                       ***/
/***     Add the specified directory to the beginning of the passed        ***/
/***     CONFIG.SYS statement.                                             ***/
/***                                                                       ***/
/*****************************************************************************/

void add_dir_config(char *line_text, char *line_upper, char *add_dir)
{
  char        work_line[CONFIG_SIZE];       /* Work record for CONFIG.SYS.   */
  char        *ptrchar;
  char        *ptrchar2;
                                            /* If directory data to be added */
                                            /*  does not yet exist on this   */
                                            /*  line, then add it at the     */
                                            /*  beginning of library list.   */
  ptrchar = strstr( line_upper, add_dir );
  if ( !ptrchar )
  {
                                            /* Save current line up to and   */
                                            /*  including the "=".           */
     strcpy( work_line, line_text );
     ptrchar = strchr( work_line, '=' );
     *(ptrchar+1) = '\0';
                                            /* Find start of data after "=". */
     ptrchar = strchr( line_text, '=' );
     for( ptrchar2=ptrchar+1; *ptrchar2 && isspace(*ptrchar2); ++ptrchar2 );

     strcat( work_line, add_dir );          /* Append new directory data.    */
     strcat( work_line, ";" );              /* Append ";" library separator. */
     strcat( work_line, ptrchar2 );         /* Append original data.         */
     strcpy( line_text, work_line );        /* Reset CONFIG.SYS line         */
  }
}



/*****************************************************************************/
/***                                                                       ***/
/***     Update the CONFIG.SYS file with the I18N statements.              ***/
/***                                                                       ***/
/*****************************************************************************/

void execute_update_config(void)
{
  FILE       *file_config;                 /* File for CONFIG.SYS update.    */
  FILE       *file_work;                   /* File for CONFIG.SYS update.    */
  char        config_record[CONFIG_SIZE];  /* Record from CONFIG.SYS file.   */
  char        config_upper[CONFIG_SIZE];   /* Record from CONFIG.SYS file.   */
  char        config_text[CONFIG_SIZE];    /* Record for CONFIG.SYS file.    */
  char        exec_command[BUF_SIZE];
  char        *ptrchar;
  BOOL        create_backup = TRUE;        /* Whether to create backup file. */
  BOOL        libpath_updated = FALSE;     /* Whether LIBPATH is done.       */
  BOOL        lang_updated = FALSE;        /* Whether LANG is done.          */
  BOOL        locpath_updated = FALSE;     /* Whether LOCPATH is done.       */
  BOOL        nlspath_updated = FALSE;     /* Whether NLSPATH is done.       */
  int         ret_code;


                                        /* If CONFIG.SYS backup file already */
                                        /*  exists, find out whether to      */
                                        /*  replace file or not.             */
  file_work = fopen( config_sys_backup_file, "r" ) ;
  if ( file_work )
  {
     WinLoadString(habAnchor, (HMODULE) NULL, S_INSTALL_TITLE,
                   sizeof(error_title), error_title );
     WinLoadString(habAnchor, (HMODULE) NULL, S_ERROR_CONFIG_BACKUP,
                   sizeof(string_text), string_text );
     sprintf( error_text, string_text, config_sys_backup_file );
     ret_code = WinMessageBox( HWND_DESKTOP, NULLHANDLE,
                               error_text, error_title, 0,
                               MB_YESNO | MB_DEFBUTTON1 |
                               MB_WARNING | MB_APPLMODAL ) ;
     if ( ret_code == MBID_NO )
     {
        create_backup = FALSE;
     }
     fclose( file_work );
  }
                                        /* Copy the current CONFIG.SYS to    */
                                        /*  the I18N backup file.            */
  if ( create_backup )
  {
     sprintf( exec_command, "COPY %s %s",
              config_sys_file, config_sys_backup_file ) ;
     system( exec_command );
  }
                                        /* Open input and output files.      */
  file_config = fopen( config_sys_file, "r" ) ;
  file_work = fopen( config_sys_work_file, "w+" ) ;
  if ( file_config && file_work )
  {
                                        /* Read from the input CONFIG.SYS,   */
                                        /*  writing out updated records.     */
     while ( fgets( config_record, sizeof(config_record), file_config ) != NULL )
     {
                                        /* Convert data to uppercase.       */
        strcpy( config_upper, config_record );
        strupr( config_upper );
                                        /* First 1st token from record.      */
        strcpy( config_text, config_upper );
        ptrchar = strtok( config_text, " " );
                                        /* If not a comment, analyze further.*/
        if ( ptrchar && strcmp( ptrchar, "REM" ) )
        {
                                        /* If LIBPATH line, add I18N path    */
                                        /*  information at beginning of data.*/
           if ( strstr( ptrchar, I18N_LIBPATH_VAR ) )
           {
              add_dir_config( config_record, config_upper, I18N_dll_dir );
              libpath_updated = TRUE;
           }
           else
           {
                                        /* If SET line, look for variable.   */
              if ( !strcmp( ptrchar, "SET" ) )
              {
                                        /* If LANG line, ignore for now as   */
                                        /*  it will be added at the end.     */
                 if ( strstr( config_upper, I18N_LANG_VAR ) )
                 {
                    continue ;          /* Force writing out new SET LANG=   */
                 }
                                        /* If LOCPATH line, add I18N path    */
                                        /*  information at beginning of data.*/
                 if ( strstr( config_upper, I18N_LOCPATH_VAR ) )
                 {
                    add_dir_config( config_record, config_upper, I18N_locale_dir );
                    locpath_updated = TRUE;
                 }
                                        /* If NLSPATH line, add I18N path    */
                                        /*  information at beginning of data.*/
                 if ( strstr( config_upper, I18N_NLSPATH_VAR ) )
                 {
                    add_dir_config( config_record, config_upper, I18N_messages_dir );
                    nlspath_updated = TRUE;
                 }
              }
           }
        }
                                        /* Write out previous or updated line*/
        ret_code = fputs( config_record, file_work );
        if ( ret_code == EOF ) return_code = RC_CONFIG_FAILED ;
     }
                                        /* If LIBPATH is not updated, add    */
                                        /* new line at end of file.          */
     if ( !libpath_updated )
     {
        sprintf( config_text, "%s%s\n",I18N_LIBPATH_VAR, I18N_dll_dir );
        ret_code = fputs( config_text, file_work );
        if ( ret_code == EOF ) return_code = RC_CONFIG_FAILED ;
     }
                                        /* If LANG is not updated, add       */
                                        /* new line at end of file.          */
     if ( !lang_updated )
     {
        WinLoadString(habAnchor, (HMODULE) NULL, S_CONFIG_UPDATE_LINE2,
                      sizeof(string_text), string_text );
        sprintf( config_text, string_text, I18N_LANG_VAR, install_lang );
        strcat( config_text, "\n" );
        ret_code = fputs( config_text, file_work );
        if ( ret_code == EOF ) return_code = RC_CONFIG_FAILED ;
     }
                                        /* If LOCPATH is not updated, add    */
                                        /* new line at end of file.          */
     if ( !locpath_updated )
     {
        WinLoadString(habAnchor, (HMODULE) NULL, S_CONFIG_UPDATE_LINE3,
                      sizeof(string_text), string_text );
        sprintf( config_text, string_text, I18N_LOCPATH_VAR, I18N_locale_dir );
        strcat( config_text, "\n" );
        ret_code = fputs( config_text, file_work );
        if ( ret_code == EOF ) return_code = RC_CONFIG_FAILED ;
     }
                                        /* If NLSPATH is not updated, add    */
                                        /* new line at end of file.          */
     if ( !nlspath_updated )
     {
        WinLoadString(habAnchor, (HMODULE) NULL, S_CONFIG_UPDATE_LINE4,
                      sizeof(string_text), string_text );
        sprintf( config_text, string_text, I18N_NLSPATH_VAR, I18N_messages_dir );
        strcat( config_text, "\n" );
        ret_code = fputs( config_text, file_work );
        if ( ret_code == EOF ) return_code = RC_CONFIG_FAILED ;
     }
  }
  else
  {
     return_code = RC_CONFIG_FAILED;
  }
                                        /* Close files.                      */
  if ( file_config ) fclose( file_config );
  if ( file_work ) fclose( file_work );

                                        /* If no problems, replace the real  */
                                        /* CONFIG.SYS file with updates.     */
  if ( return_code == RC_NO_ERROR )
  {
     sprintf( exec_command, "COPY %s %s",
              config_sys_work_file, config_sys_file ) ;
     system( exec_command );
  }
                                        /* Delete temporary file.            */
  remove( config_sys_work_file );
  if ( return_code != RC_NO_ERROR ) return_code = RC_CONFIG_FAILED;
}



/*****************************************************************************/
/*****************************************************************************/
/***                                                                       ***/
/***     Main program                                                      ***/
/***                                                                       ***/
/*****************************************************************************/
/*****************************************************************************/

INT main(int argc, char *argv[])
{
  double         installed_version;     /* Version number of I18N already    */
                                        /*  installed on the system.         */
  int ret_code;                         /* Return code from is_installed API.*/



                                        /* Initialize parameter variables.   */
  initialize( argc, argv );

                                        /* Call API to determine if I18N  is */
                                        /*  already installed.               */
  ret_code = is_i18n_installed(&installed_version, install_drive);

                                        /* If development wants to "force"   */
                                        /* installation on a specific drive, */
                                        /* handle this situation.            */
  if ( (force_drive[0]) && (force_drive[0] != install_drive[0]) )
  {
     installed_version = 0.01 ;
     install_drive[0] = force_drive[0];
  }

                                        /* If need to update the I18N package*/
                                        /*  perform necessary functions.     */

  if (installed_version <= I18N_VERSION_NUM)
  {
                                        /* Get the anchor block for program. */
                                        /* Create message queue for program. */
     habAnchor = WinInitialize(0);
     hmqQueue = WinCreateMsgQueue(habAnchor, 0);
     desktop_width = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN);
     desktop_height = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);
                                        /* If need to ask user what drive to */
                                        /*  install package on, do it now.   */
     if ( ( askdrive[0] != 'N' ) &&
          ( ( askdrive[0] != 'U' ) ||
            ( installed_version == 0.0 ) ) )
     {
        ask_user_which_drive() ;
     }
                                        /* Install the I18N package.         */
     if ( install_drive[0] )
     {
        execute_install_I18N() ;
        if ( return_code == RC_NO_ERROR )
        {
                                        /* If need to ask user whether to    */
                                        /*  update CONFIG.SYS, do it now.    */
           if ( updateconfig[0] == 'A' )
           {
              ask_user_update_config() ;
           }
                                        /* If requested to updated CONFIG.SYS*/
                                        /*  add I18N information.            */
           if ( updateconfig[0] == 'Y' )
           {
              execute_update_config() ;
           }
        }
     }
                                        /* Get rid of the message queue.     */
                                        /* Get rid of the anchor block.      */
     WinDestroyMsgQueue(hmqQueue);
     WinTerminate(habAnchor);
  }                                     /* I18N versions are different.      */

                                        /* Terminate the program.            */
  return(return_code);
}


