/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* XPG/4 library.                    */
#include <locale.h>                     /* Locale definitions.               */
#include <langinfo.h>                   /* Definitions for locale defs.      */

/*****************************************************************************/
/***     Get locale-specific info from the table.                          ***/
/*****************************************************************************/

void get_locale_info(void)
{
  struct lconv *table;                  /* Table return info.                */

                                        /* Get the table of locale info.     */
                                        /* Print a header.                   */
                                        /* Print some information from the   */
                                        /*  table.                           */
  table = localeconv();
  printf("\nData from LOCALECONV:\n");
  printf("---------------------\n");
  printf("International monetary symbol: %s\n", table->int_curr_symbol);
  printf("Negative sign: %s\n", table->negative_sign);
  printf("Number of fractional digits (after decimal point): %d\n",
         table->frac_digits);

                                        /* Print a header.                   */
                                        /* Print some information about the  */
                                        /*  locale, using nl_langinfo.       */
  printf("\nData from NL_LANGINFO:\n");
  printf("----------------------\n");
  printf("Days of the week: %s %s %s %s %s %s %s\n",
         nl_langinfo(ABDAY_1), nl_langinfo(ABDAY_2), nl_langinfo(ABDAY_3),
         nl_langinfo(ABDAY_4), nl_langinfo(ABDAY_5), nl_langinfo(ABDAY_6),
         nl_langinfo(ABDAY_7));

  printf("Radix character is: %s\nThousands separator: %s\n",
         nl_langinfo(RADIXCHAR), nl_langinfo(THOUSEP));
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
                                        /* Print a header.                   */
                                        /* Print the locale values.          */
  setlocale(LC_ALL, "");
  printf("\nWARNING: Different values reported by this program are based on\n");
  printf("         different locale settings (LC_MONETARY, LC_TIME...)\n\n");
  printf("Locale settings: %s\n", setlocale(LC_ALL, NULL));

                                        /* Get info from locale table.       */
  get_locale_info();
}
