/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */
#include <time.h>                       /* Standard date/time functions.     */

#include <wchar.h>                      /* XPG/4 library.                    */
#include <locale.h>                     /* Locale definitions.               */

/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

char *locale;                           /* Name of locale string.            */

/*****************************************************************************/
/***     Sample date and time conversion                                   ***/
/*****************************************************************************/

void date_time_functs(void)
{
  struct tm *time_ptr;                  /* Pointer to date/time structure.   */
  char temp_string[100];                /* String to hold temp values.       */
  char *ret_string;                     /* Output string.                    */
  time_t temp_time;                     /* Variable used to get current time.*/
  wchar_t temp_w_string[200];           /* Temp string of wchar_t's.         */

                                        /* Print a header.                   */
  printf("\nLocale for date and time: %s\n", locale);

                                        /* Allocate memory for tm structure. */
                                        /* If structure allocated OK...      */
  time_ptr = (struct tm *) malloc(sizeof(struct tm));
  if (time_ptr != NULL)
  {
                                        /* Copy a date and time into a string*/
                                        /* Copy into structure with strptime */
                                        /* If copied OK...                   */
                                        /*  Format date/time from structure  */
                                        /*  Print it out.                    */
                                        /* Else, print an error message.     */
     strcpy(temp_string, "12:34:56 10 21 93");
     ret_string = strptime(temp_string, "%T %m %d %y", time_ptr);
     if   (ret_string != NULL)
     {
          strftime(temp_string, 100,
                   "Loaded in date: %9x and time: %9X  ", time_ptr);
          printf("\n%s\n", temp_string);
     }
     else printf("\nstrptime returned NULL");

                                        /* Get the current time.             */
                                        /* Convert to local time.            */
                                        /* Format the time into a pretty str.*/
                                        /* Print out the string.             */
     temp_time = time(NULL);
     time_ptr = localtime(&temp_time);
     strftime(temp_string, 100,
              "Today is: %A, %B %d %Y. Time is: %9X %p", time_ptr);
     printf("\n%s\n", temp_string);

                                        /* Convert exactly the same time with*/
                                        /*  the wchar_t functions and types. */
                                        /* Print the output.                 */
     wcsftime(temp_w_string, 100,
              "Today is: %A, %B %d %Y. Time is: %9X %p", time_ptr);
     printf("\nDate converted with wchar_t type:\n%S\n", temp_w_string);

                                        /* Free up allocated structure.      */
     free (time_ptr);
  }
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
                                        /* Get the locale for date/time.     */
  setlocale(LC_ALL, "");
  locale = setlocale(LC_TIME, NULL);

                                        /* Show date and time functions.     */
  date_time_functs();
}
