/*****************************************************************************/
/***     Global defines.                                                   ***/
/*****************************************************************************/

#define BELL 7                          /* Character to print a bell.        */

#define EXIT_ERROR  1                   /* The program exited with an error. */

/*****************************************************************************/
/***     Include files.                                                    ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO.                      */

#include <wchar.h>                      /* Wide char functions.              */
#include <locale.h>                     /* Locale-specific information.      */

#include "test_msg.h"                   /* Header file for catalog IDs.      */

/*****************************************************************************/
/***     Global variables.                                                 ***/
/*****************************************************************************/

nl_catd cat_handle;                     /* Handle to catalog file.           */
char *ret_string;                       /* String returned from catgets.     */

/*****************************************************************************/
/***     Main program.                                                     ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale.                   */
                                        /* Print out the locale we are in for*/
                                        /*  messages.                        */
  setlocale(LC_ALL, "");
  printf("\nName of messaging locale is: %s\n\n",
         setlocale(LC_MESSAGES, NULL));

                                        /* Open the catalog.                 */
                                        /*  (using LC_MESSAGES, not LANG via */
                                        /*   the second argument).           */
                                        /* If catalog not found...           */
                                        /*  Print an error message.          */
                                        /*  Exit the program.                */
  cat_handle = catopen(MF_TEST, NL_CAT_LOCALE);
  if (cat_handle == CATD_ERR)
  {
     printf("%cCould not open catalog!\n", BELL);
     exit(EXIT_ERROR);
  }

                                        /* Read a message from the catalog.  */
                                        /* Print out the message.            */
  ret_string = catgets(cat_handle, MS_SET2, MSG_1, "No message read.");
  printf("String: %s\n", ret_string);

                                        /* Attempt to read a message which is*/
                                        /*  not in the catalog.              */
                                        /* Print out the results.            */
  ret_string = catgets(cat_handle, 400, 500, "No message read.\n");
  printf("String: %s\n", ret_string);

                                        /* Read a message so we can put in   */
                                        /*  positional arguments.            */
                                        /* Print a header.                   */
                                        /* Print the string with four        */
                                        /*  positional arguments.            */
                                        /*  (NOTE: the order of the arguments*/
                                        /*   in the printf call is NOT the   */
                                        /*   order in which they are printed */
                                        /*   in the output string.           */
  ret_string = catgets(cat_handle, MS_SET1, MSG_1, "No message read.\n");
  printf("String: ");
  printf(ret_string, "myfile.sys", "3/29/94", "5:04PM", "PS");

                                        /* Close the catalog.                */
  catclose(cat_handle);

                                        /* Now try to read a message from    */
                                        /*  a catalog with an invalid handle.*/
                                        /* This should return back the       */
                                        /*  default message.                 */
  ret_string = catgets(cat_handle, MS_SET1, MSG_1, "No catalog open.\n");
  printf("\nString: %s\n", ret_string);
}
