/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */
#include <stdlib.h>                     /* Needed for getenv call.           */
#include <wchar.h>                      /* XPG/4 library.                    */

/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define TEST_ALIAS "my_french_alias"    /* Locale alias to use.              */

/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

char ret_string[LOCALE_STR_LEN];        /* Return string from find_locale API*/
int ret_val;                            /* Return value from APIs.           */

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Find the path of the alias table. */
                                        /* Print results of get call.        */
  ret_val = get_alias_table_path(ret_string);
  if   (ret_val == ALIAS_OK)
  {
       printf("\nPath of alias table is: %s\n", ret_string);
  }
  else
  {
       printf("\nCould not locate the alias table!\n");
  }

                                        /* Make sure that test alias is not  */
                                        /*  in the alias table.              */
                                        /* Print results of remove call.     */
  ret_val = remove_locale_alias(TEST_ALIAS);
  if   (ret_val == ALIAS_OK)
  {
       printf("Removed the test alias.\n");
  }
  else
  {
       printf("Test alias was not removed.\n");
  }

                                        /* Try to find test alias in table.  */
                                        /* If found, print value found.      */
                                        /* Else, report that it wasn't found.*/
  ret_val = find_locale_alias(TEST_ALIAS, ret_string);
  if   (ret_val == ALIAS_OK)
  {
       printf("Located the test alias.  Value of alias is: %s\n", ret_string);
  }
  else
  {
       printf("Test alias was not found in the table.\n");
  }

                                        /* Add a test alias in the table.    */
                                        /* Print status of add API.          */
  ret_val = add_locale_alias(TEST_ALIAS, "fr_fr.437");
  if   (ret_val == ALIAS_OK)
  {
       printf("Test alias added to the table.\n");
  }
  else
  {
       printf("Test alias could not be added to the table.\n");
  }

                                        /* Try to find test alias in table.  */
                                        /* If found, print value found.      */
                                        /* Else, report that it wasn't found.*/
  ret_val = find_locale_alias(TEST_ALIAS, ret_string);
  if   (ret_val == ALIAS_OK)
  {
       printf("Located the test alias.  Value of alias is: %s\n", ret_string);
  }
  else
  {
       printf("Test alias was not found in the table.\n");
  }

                                        /* Map a common locale name.         */
                                        /* Report the results.               */
  map_string_to_locale("en_us", ret_string);
  printf("Mapped: en_us to: %s\n", ret_string);

                                        /* Map a locale name with optional   */
                                        /*  codepage number following.       */
                                        /* Report the results.               */
  map_string_to_locale("ja_jp.932", ret_string);
  printf("Mapped: ja_jp.932 to: %s\n", ret_string);

                                        /* Try to remap a string that should */
                                        /*  not be legal.                    */
                                        /* Report the results.               */
  ret_val = map_string_to_locale("1234ABC", ret_string);
  if   (ret_val == ALIAS_OK)
  {
       printf("Mapping of 1234ABC worked, when it should not have!\n");
  }
  else
  {
       printf("Could not remap the locale string 1234ABC\n");
  }

                                        /* If the LANG environment variable  */
                                        /*  is not defined...                */
                                        /*  Report this.                     */
                                        /* Else, remap it, and report it.    */
  if   (getenv("LANG") == NULL)
  {
       printf("LANG environment variable not defined.  Cannot map it.\n");
  }
  else
  {
       ret_val = map_string_to_locale(getenv("LANG"), ret_string);
       if   (ret_val == ALIAS_OK)
       {
            printf("LANG environment variable remapped to: %s\n",
                   ret_string);
       }
       else
       {
            printf("LANG environment variable could not be remapped.\n");
       }
  }

                                        /* Use the mapping API to look the   */
                                        /*  string up in the alias table, and*/
                                        /*  then to remap it.                */
                                        /* Report the results.               */
  map_string_to_locale(TEST_ALIAS, ret_string);
  printf("Used mapping to look up in alias table.  ");
  printf("Mapped: %s to: %s\n", TEST_ALIAS, ret_string);

                                        /* Make sure that test alias is gone.*/
  remove_locale_alias(TEST_ALIAS);
}
