/** NL_TYPES.H National Language Support OS2 Include File
*.
*.      (C) COPYRIGHT International Business Machines Corp. 1985, 1990
*.      All Rights Reserved
*.      Licensed Materials - Property of IBM
*.
*.      US Government Users Restricted Rights - Use, duplication or
*.      disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*.
** Description:
*
** Notes:
**/

#ifndef     _H_NL_TYPES
    #define _H_NL_TYPES

#include <stdio.h>

#ifdef __cplusplus
   extern "C" {
#endif

  struct _header {
          int             _magic;
          unsigned short  _n_sets,
                          _setmax;
          char            _filler[20];
  };
  
  struct _msgptr {
          unsigned short  _msgno,
                          _msglen;
          unsigned long   _offset;
  };
  
  
  struct _catset {
          unsigned short  _setno,
                          _n_msgs;
          struct _msgptr  *_mp;
          char    **_msgtxt;
  };

  struct _catalog_descriptor {
          char            *_mem;
          char            *_name;
          FILE            *_fd;
          struct _header  *_hd;
          struct _catset  *_set;
          int             _setmax;
          int             _count;
          int             _pid;
          int             _oflag;
  };

  typedef int nl_item;

  typedef struct _catalog_descriptor *nl_catd;

  #define NL_SETD         1
  #define NL_CAT_LOCALE   1

  #define CAT_MAGIC       505
  #define CATD_ERR        ((nl_catd) -1)
  #define NL_MAXOPEN      10

  int catclose(nl_catd catd);
  char *catgets(nl_catd catd, int set_id, int msg_id, const char *s);
  nl_catd catopen(const char *name, int oflag);
  
#ifdef __cplusplus
   }
#endif



#endif
