       IDENTIFICATION DIVISION.
       PROGRAM-ID.
           HYPRDEMO.
      ***********************************************
      *                                             *
      *     H   Y   P   E   R   D   E   M   O       *
      *                                             *
      ***********************************************
      *                                             *
      *   PURPOSE: DEMONSTRATE THE FUNCTIONS OF THE *
      *            COBOL HYPERCODE FACILITY.        *
      *                                             *
      *   DESCRIPTION: THIS PROGRAM READS A FLAT    *
      *                FILE CONTAINING CUSTOMER     * 
      *                RECORDS AND GENERATES A      *
      *                REPORT TO BE PRINTED OUT     *
      *                ON MAILING LABELS.  IN       *
      *                ADDITION, THE RECORDS ARE    *
      *                WRITTEN TO AN INDEXED FILE   *
      *                FOR SUBSEQUENT PROCESSING.   *
      ***********************************************
       AUTHOR.
           CASEy Software.
       COPY COPYRITE.
       INSTALLATION.
           AMD 486.
       DATE-WRITTEN.
           SEPTEMBER 13 1994.
       DATE-COMPILED.
           SEPTEMBER 13 1994.
       SECURITY.
           NONE.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER.
           AMD-486 WITH DEBUGGING MODE.
       OBJECT-COMPUTER.
           AMD-486 MEMORY SIZE 384000 WORDS.
       SPECIAL-NAMES. 
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       SELECT IN-FILE 
           ASSIGN TO DISK.
           SELECT OUT-FILE
               ASSIGN TO DISK
               ORGANIZATION IS INDEXED
               ACCESS MODE IS RANDOM
               RECORD KEY IS OUT-KEY.
       DATA DIVISION.
       FILE SECTION.
       FD  IN-FILE
           LABEL RECORDS ARE STANDARD
           BLOCK CONTAINS 0 RECORDS
           VALUE OF FILE-ID IS 'CUST.DAT'
           DATA RECORD IS IN-FILE-RECORD.
        01 IN-FILE-RECORD.
           03 NAME.
              05 FIRST-NAME         PIC X(15).
              05 MI                 PIC X(1).
              05 LAST-NAME          PIC X(15).
           03 ADDRESS.
              05 STREET-ADDRESS     PIC X(20).
              05 CITY               PIC X(15).
              05 STATE              PIC X(02).
              05 ZIP                PIC X(09).
           03 COMPUSERVE-ID         PIC X(09).
           03 PHONE.
              05 AREA-CODE          PIC X(03).
              05 PREFIX             PIC X(03).
              05 SUFFIX             PIC X(04).
       FD OUT-FILE
           LABEL RECORDS ARE STANDARD
           VALUE OF FILE-ID IS 'OUTFILE.DAT' 
           DATA RECORD IS OUT-FILE-RECORD.
       01 OUT-FILE-RECORD.
           03 OUT-KEY               PIC X(31).
           03 FILLER                PIC X(65).
       WORKING-STORAGE SECTION.
       01 IN-FILE-EOF-FLAG          PIC X(01) VALUE 'N'.
          88 IN-FILE-EOF    VALUE 'Y'.
       PROCEDURE DIVISION.
       M1-MAINLINE SECTION.
      ***********************************************
      *     M  1  -  M  A  I  N  L  I  N  E         *
      ***********************************************
       MAINLINE.
      ***********************************************
      *         M  A  I  N  L  I  N  E              *
      ***********************************************
      *   MAIN DRIVER FOR THE  PROGRAM              *
      ***********************************************
           PERFORM OPEN-FILES.
           PERFORM INFILE-GET-FIRST.
           IF NOT IN-FILE-EOF
             PERFORM INFILE-PROCESS-GET-NEXT
               UNTIL IN-FILE-EOF.
           PERFORM CLOSE-FILES. 
           STOP RUN.
       OPEN-FILES.
      ***********************************************
      *    O  P  E  N    F  I  L  E  S              *
      ***********************************************
      *   OPENS FILES USED BY HYPRDEMO              *
      ***********************************************
           OPEN INPUT IN-FILE.
           OPEN OUTPUT OUT-FILE.
       INFILE-GET-FIRST.
      ***********************************************
      *  I N F I L E - G E T - F I R S T            *
      ***********************************************
      *   GETS THE FIRST INPUT FILE RECORD          *
      ***********************************************
           READ IN-FILE
             AT END MOVE 'Y' TO IN-FILE-EOF-FLAG.
       INFILE-PROCESS-GET-NEXT.
      ***********************************************
      *  I N F I L E - G E T - N E X T              *
      ***********************************************
      *   GETS THE NEXT INPUT FILE RECORD           *
      ***********************************************
           PERFORM PROCESS-IN-FILE        
           READ IN-FILE
             AT END MOVE 'Y' TO IN-FILE-EOF-FLAG.
        PROCESS-IN-FILE.
      ***********************************************
      * P R O C E S S - I N - F I L E - R E C O R D *
      ***********************************************
      *   PRINTS THE CURRENT IN FILE RECORD TO THE  *
      *   CONSOLE AND WRITES IT TO THE OUTPUT FILE  *
      ***********************************************
           DISPLAY '                           '
           DISPLAY '=======MAILING LABEL======='
           DISPLAY FIRST-NAME MI LAST-NAME
           DISPLAY STREET-ADDRESS CITY STATE ZIP
           DISPLAY '                           '

           MOVE IN-FILE-RECORD TO OUT-FILE-RECORD.
           WRITE OUT-FILE-RECORD.
       CLOSE-FILES.
      ***********************************************
      *    C  L  O  S  E    F  I  L  E  S           *
      ***********************************************
      *   CLOSES FILES USED BY HYPRDEMO             *
      ***********************************************
           CLOSE IN-FILE.
           CLOSE OUT-FILE.
