/* Boot manager, just enough to get by */

/* sector 0 */

/* The boot block is a FAT boot block.  I think it's a completely
   standard FAT boot block for a size-0 filesystem. */

struct bootmgr_boot_block
{
  unsigned char jmp[3];
  unsigned char oem_id[8];		/* "APJ&WN" */
  unsigned char bytes_per_sector[2];	/* 512 */
  unsigned char sectors_per_cluster;
  unsigned char n_reserved_sectors[2];
  unsigned char n_fats;
  unsigned char n_rootdir_entries[2];
  unsigned char n_sectors_s[2];		/* 32 */
  unsigned char media_byte;
  unsigned short sectors_per_fat;
  unsigned short sectors_per_track;
  unsigned short heads_per_cyl;
  unsigned int n_hidden_sectors;	/* 32 */
  unsigned int n_sectors_l;
  unsigned char drive_number;		/* 80h -- in this case it's true */
  unsigned char mbz;
  unsigned char sig_29h;		/* 29h */
  unsigned char vol_serno[4];
  unsigned char vol_label[11];
  unsigned char sig_fat[8];		/* "FAT     " */
  unsigned char pad[448];
  unsigned short magic;			/* aa55 */
};

/* sector 1 */

/* This looks like transient data.  SETBOOT probably only writes sector 1. */

struct boot_manager_transient
{
  unsigned unk1, unk2;			/* Misc numbers, probably timeouts
					   and so on */
  unsigned short zero1;
  unsigned char boot_device;		/* /IBD:X goes here */
  unsigned char zero2;
  unsigned zero3[14];
  unsigned char boot_tag[8];		/* /IBA:name goes here */
  unsigned zero4;
  unsigned char current_selection[8];	/* OS last booted.  This line is
					   highlighted in the initial menu. */
  unsigned zero5[74];
};

/* sector 3 */

/* Menu info for all primary partitions on all disks.
   This is probably only written by FDISK.
   The first four entries are disk 80h, the next four are 81h, and so on. */

struct boot_manager_menu
{
  struct partition_data {
    unsigned disk_number : 7;		/* 0 = 80h, 1 = 81h, etc */
    unsigned startable : 1;		/* set on boot manager partition */
    unsigned numbers : 24;		/* cylinder numbers or something */
    unsigned bootable : 1;		/* 0 = ignore, 1 = bootable */
    unsigned zeroflags : 7;
    unsigned char tag[8];		/* OS name, trailing spaces */
    unsigned char zero2[3];
  } partition_data[32];
};

/* The data for a logical partition is out in the logical partition itself.
   The partition boot sector has the standard logical partition
   table at the end, and the Bootable flag and OS tag are at 0x18a
   in the unused part of the block. */

struct partition_boot_sector
{
  unsigned char skip1[394];
  unsigned char bootable;		/* 01 = bootable */
  unsigned char tag[8];			/* OS name, trailing spaces */
  unsigned char skip2[43];
  struct {
    unsigned char xxx0 : 7;
    unsigned char active : 1;		/* boot indicator */
    unsigned char xxx1[3];
    unsigned char system_indicator;	/* 5 = extended, 1 = dos, etc */
    unsigned char xxx2[3];
    unsigned sector_number __attribute__ ((packed));
    unsigned char xxx3[4];
  } partition[4];
  unsigned short magic;
};

/*
   Local Variables:
   comment-column: 40
   End:
*/
