/* test module

   Copyright (c) 1994 Spitfire Software

*/


/* system includes */
#ifdef __OS2__                          // test for os/2 or dos
  #define INCL_DOSQUEUES                // include part of OS/2 header file
  #define INCL_BASE                    	// include part of OS/2 header file
  #define INCL_NOPM                     // include part of OS/2 header file
  #define INCL_DOSFILEMGR               // File manager values
  #include <os2.h>                      // required for guirun.h and OS/2 functions
  #include "d:\guide\sys\guirun.h"      // Guidelines OS/2 header: for String class
#else
  #include <windows.h>                  // Windows functions
  #include "d:\guide\sys\guiwun.h"	// Guidelines Win header: for String
#endif
#include "test.h"
#include "string.h"


#define PIPESIZE 1
#define HF_STDOUT 1

/* definition of GuideLines variables */
extern LONG TerminateSw;

/* routine to start a subprocess and display its
   output to stdout in a GuideLines list Box.

   Input: progname: Name of program to be executed
          args:     Argument string to be passed to program

   Return: 0 no errors
           1 could not start program
*/
LONG readprog(String & progname, String & args)
{
 CHAR buff[1000]; //buffer for building string to send to GL list box
 CHAR * ptr;      //pointer used for multiple purposes
 CHAR abuff[200]; //argument string for invoke requested program
 HPIPE hpR, hpW;  //pipe handles
 RESULTCODES resc;  //pipe create result code
 ULONG cbRead;    //number of bytes read from pipe
 CHAR achBuf[PIPESIZE],        //input buffer for reading from pipe
      szFailName[CCHMAXPATH];  //failure buffer for DosExecPgm

 HFILE hfSave = -1,            //buffer for saving normal stdout handle
       hfNew = HF_STDOUT;      //pipe handle for writing

 // build arg string for DosExecPgm
 strcpy(abuff,(char *) progname);  //get prog name
 ptr = abuff + strlen(abuff) + 1;  // set up for putting second string after prog
                                   // name
 strcpy (ptr,(char *) args);       // add arg string after prog name
 *(ptr + strlen(ptr) + 1) = 0;     // add double 0 to terminate list of strings
 *buff = 0;                        // clear list box string build buffer
 ptr = buff;                       // set temp pointer
 DosDupHandle(HF_STDOUT,&hfSave);       // Save standard output handle
 DosCreatePipe(&hpR,&hpW,PIPESIZE);     //Creates pipe
 DosDupHandle(hpW,&hfNew);              //Duplicates standard output handle
 if (DosExecPgm(szFailName,sizeof(szFailName),
            EXEC_ASYNC, (PSZ) abuff, (PSZ) NULL,
            &resc, (PSZ) progname) != 0) return (-1);
 DosClose(hpW);                         //Closes write handle to ensure notification
                                        // at child termination
 DosDupHandle(hfSave,&hfNew);           //Brings stdout back
 DosRead(hpR,achBuf,sizeof(achBuf),&cbRead);
 while (cbRead && !TerminateSw)         //Read chars from pipe while open and
  {                                     //  teerminate sw not set
   if (*achBuf == 13)                   // if new line send string to GL
    {
     *ptr = 0;                          // set sting terminator
     UpdateList((String) buff);         // call GL to update list box
     *buff = 0;                         // reset for new string
     ptr = buff;
    }
   else if (*achBuf != 10) *ptr++ = *achBuf;  //if not line feed add char to
                                              //  GL string buffer
   DosRead(hpR,achBuf,sizeof(achBuf),&cbRead);//get next char from pipe
  }
 if (TerminateSw) DosKillProcess((ULONG) 0,resc.codeTerminate); //Kill process if requested
 DosClose(hpR);                         // close pipe
 return(0L);                            // end function with all ok
}





