#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "greet.h"

int main(int ac, char*av[])
{
    handle_t                 h;
    error_status_t           st, error_inq_st;
    idl_char                 *string_binding;
    int                      i, MAX_PASS;
    char                     server_reply[STR_SZ], error_string [1024],
                             *server_name;
    rpc_ns_import_handle_t   import_context;


    if (ac != 2)  {
        printf("Usage: %s passes\n", av[0]);
        exit (1);
    }


    /* import compatible server bindings from the namespace */

    rpc_ns_binding_import_begin(rpc_c_ns_syntax_dce,
                                "/.:/servers/greet", greet_v1_0_c_ifspec,
                               (uuid_t *)NULL, &import_context, &st);
    printf("rpc_ns_binding_import_begin status is %x\n", st);

    if (st != error_status_ok) {
        dce_error_inq_text(st, error_string, &error_inq_st);
        fprintf(stderr, "dce_error_inq_text status is %x\n", error_inq_st);
        fprintf(stderr, "Cannot begin importing binding - %s\n",
                error_string);
        exit(1);
       }

    /* sift through bindings and choose the first one over udp */
    /***************************************************************
    For the OS/2 DCE Toolkit rel:  RPC only works over UDP right now
    ***************************************************************/

    while (1) {
        rpc_ns_binding_import_next(import_context, &h, &st);
        printf("rpc_ns_binding_import_next status is %x\n", st);
        if (st == rpc_s_no_more_bindings) {
           dce_error_inq_text(st, error_string, &error_inq_st);
           fprintf(stderr, "Cannot find binding over udp: %s\n",
                   error_string);
           exit(1);
        }

         rpc_binding_to_string_binding(h, &string_binding, &st);
         printf("rpc_binding_to_string_binding status is %x\n", st);
         if (st != error_status_ok) {
            dce_error_inq_text(st, error_string, &error_inq_st);
            fprintf(stderr,
                    "Cannot convert binding to string binding: %s\n",
                    error_string);
            exit(1);
         }

         /* out of curiosity, print the binding */

         if (strstr(string_binding, "ncadg_ip_udp") != 0) {
             printf("Client bound to server %s at %s\n",
             "/.:/servers/greet", string_binding);
             rpc_string_free(&string_binding, &st);
             break;
          }
       }

   /* end the binding import lookup loop */

   rpc_ns_binding_import_done(&import_context, &st);
   printf("rpc_ns_binding_import_done status is %x\n", st);
   if (st != error_status_ok) {
       dce_error_inq_text(st, error_string, &error_inq_st);
       fprintf(stderr, "Cannot end binding import: %s\n",
               error_string);
       exit(1);
   }

    printf("\n");

    MAX_PASS= atoi(av[1]);

         for (i=1; i <= MAX_PASS; i++) {
             printf("greet_rpc call for pass %d is next\n", i);
             greet_rpc(h, "Hello Server !", server_reply);
             printf("The Greet Server said: %s\n", server_reply);
          }

}
