{
    $Id: symtable.pas,v 1.70 1998/09/09 11:50:57 pierre Exp $
    Copyright (c) 1993-98 by Florian Klaempfl, Pierre Muller

    This unit handles the symbol tables

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ****************************************************************************
}
{$ifdef TP}
  {$N+,E+,F+}
{$endif}
unit symtable;

  interface

    uses
{$ifdef TP}
       objects,
{$endif}
       cobjects,verbose,comphook,systems,globals,strings,aasm,files,gendef
{$ifdef i386}
       ,i386
{$endif}
{$ifdef m68k}
       ,m68k
{$endif}
{$ifdef alpha}
       ,alpha
{$endif}
{$ifdef GDB}
       ,gdb
{$endif}
{$ifdef UseBrowser}
       ,browser
{$endif UseBrowser}
       ;

    const
       { different options }
       sp_public     = 0;
       sp_forwarddef = 1;
       sp_protected  = 2;
       sp_private    = 4;
       sp_static     = 8;
       sp_published  = 16;

       { flags for a definition }
       df_needsrtti = $1;           { the definitions needs rtti }
       df_hasrtti   = $2;           { the rtti is generated      }

       { options for tprocdef and tprocvardef }
       poexceptions     = $1;        { unused }
       povirtualmethod  = $2;        { Procedure is a virtual method }
       poclearstack     = $4;        { Use IBM flat calling convention. (Used by GCC.) }
       poconstructor    = $8;        { Procedure is a constructor }
       podestructor     = $10;       { Procedure is a destructor }
       pointernproc     = $20;       { Procedure has compiler magic}
       poexports        = $40;       { Procedure is exported }
       poiocheck        = $80;       { IO checking should be done after a call to the procedure }
       poabstractmethod = $100;      { Procedure is an abstract method }
       pointerrupt      = $200;      { Procedure is an interrupt handler }
       poinline         = $400;      { Procedure is an assembler macro }
       poassembler      = $800;      { Procedure is written in assembler }
       pooperator       = $1000;     { Procedure defines an operator }
       poexternal       = $2000;     { Procedure is external (in other object or lib)}
       poleftright      = $4000;     { Push parameters from left to right }
       poproginit       = $8000;     { Program initialisation }
       postaticmethod   = $10000;    { static method }
       pooverridingmethod=$20000;    { method with override directive }
       poclassmethod    = $40000;    { class method }
       pounitinit       = $80000;    { unit initialisation }
       pomethodpointer  = $100000;   { method pointer, only in procvardef, also used for 'with object do' }
       pocdecl          = $200000;   { procedure uses C styled calling }
       popalmossyscall  = $400000;   { procedure is a PalmOS system call }
       pointernconst    = $800000;   { procedure has constant evaluator intern }
       poregister       = $1000000;  { procedure uses register (fastcall) calling }

       { relevant options for assigning a proc or a procvar to a procvar }
       po_compatibility_options = $7FFFFFFF;

       hasharraysize = 97;

       { last operator which can be overloaded }
       last_overloaded = ASSIGNMENT;

       { options for objects and classes }
       oois_abstract   = $1;
       oois_class      = $2;
       oo_hasvirtual   = $4;
       oo_hasprivate   = $8;
       oo_hasprotected = $10;
       oo_isforward    = $20;
       oo_can_have_published = $40;

       { options for properties }
       ppo_indexed = $1;
       ppo_defaultproperty = $2;
       ppo_stored = $4;

       { options for variables }
       vo_regable     = 1;
       vo_is_C_var    = 2;
       vo_is_external = 4;


    type
       { needed for owner (table) of symbol }
       psymtable     = ^tsymtable;
       punitsymtable = ^tunitsymtable;

       { needed for names by the defenitions }
       ptypesym = ^ttypesym;
       penumsym = ^tenumsym;

{************************************************
                    TDef
************************************************}

       { definition contains the informations about a type }
       tdeftype = (abstractdef,arraydef,recorddef,pointerdef,orddef,
                   stringdef,enumdef,procdef,objectdef,errordef,
                   filedef,formaldef,setdef,procvardef,floatdef,
                   classrefdef);

       pdef = ^tdef;
       tdef = object
          deftype  : tdeftype;
          indexnb  : word;
          savesize : longint;
          next     : pdef;
          owner    : psymtable;
          sym      : ptypesym;  { which type the definition was generated this def }

          has_inittable : boolean;
          { adress of init informations }
          inittable_label : plabel;

          has_rtti   : boolean;
          { address of rtti }
          rtti_label : plabel;

{$ifdef GDB}
          globalnb       : word;
          nextglobal,
          previousglobal : pdef;
          is_def_stab_written : boolean;
{$endif GDB}
          constructor init;
          constructor load;
          destructor  done;virtual;
          procedure write;virtual;
          procedure writename;
          function  size:longint;virtual;
{$ifdef GDB}
          function  NumberString:string;
          procedure set_globalnb;
          function  stabstring : pchar;virtual;
          function  allstabstring : pchar;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          procedure deref;virtual;

          { init. tables }
          function  needs_inittable : boolean;virtual;
          procedure generate_inittable;
          function  get_inittable_label : plabel;
          { the default implemenation calls write_rtti_data     }
          { if init and rtti data is different these procedures }
          { must be overloaded                                  }
          procedure write_init_data;virtual;
          { writes rtti of child to avoid mixup of rtti }
          procedure write_child_init_data;virtual;

          { rtti }
          function get_rtti_label : plabel;

          procedure generate_rtti;virtual;
          procedure write_rtti_data;virtual;
          procedure write_child_rtti_data;virtual;

          { returns true, if the definition can be published }
          function is_publishable : boolean;virtual;
       end;

       targconvtyp = (act_convertable,act_equal,act_exact);

       tvarspez = (vs_value,vs_const,vs_var);

       pdefcoll = ^tdefcoll;
       tdefcoll = record
          data    : pdef;
          next    : pdefcoll;
          paratyp : tvarspez;
          argconvtyp : targconvtyp;
       end;

       tfiletype = (ft_text,ft_typed,ft_untyped);

       pfiledef = ^tfiledef;
       tfiledef = object(tdef)
          filetype : tfiletype;
          typed_as : pdef;
          constructor init(ft : tfiletype;tas : pdef);
          constructor load;
          procedure write;virtual;
          procedure deref;virtual;
          procedure setsize;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       pformaldef = ^tformaldef;
       tformaldef = object(tdef)
          constructor init;
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       perrordef = ^terrordef;
       terrordef = object(tdef)
          constructor init;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif GDB}
       end;

       { tpointerdef and tclassrefdef should get a common
         base class, but I derived tclassrefdef from tpointerdef
         to avoid problems with bugs (FK)
       }

       ppointerdef = ^tpointerdef;
       tpointerdef = object(tdef)
          definition : pdef;
          defsym : ptypesym;
          constructor init(def : pdef);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          procedure deref;virtual;
       end;

       pobjectdef = ^tobjectdef;
       tobjectdef = object(tdef)
          childof : pobjectdef;
          name : pstring;
          { privatesyms : psymtable;
          protectedsyms : psymtable; }
          publicsyms : psymtable;
          options : longint;
          constructor init(const n : string;c : pobjectdef);
          destructor done;virtual;
          procedure check_forwards;
          function isrelated(d : pobjectdef) : boolean;
          function size : longint;virtual;
          constructor load;
          procedure write;virtual;
          function vmt_mangledname : string;
          function rtti_name : string;
          function isclass : boolean;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif GDB}
          procedure deref;virtual;

          function  needs_inittable : boolean;virtual;
          procedure write_init_data;virtual;
          procedure write_child_init_data;virtual;

          { rtti }
          procedure generate_rtti;virtual;
          procedure write_rtti_data;virtual;
          procedure write_child_rtti_data;virtual;
          function next_free_name_index : longint;
          function is_publishable : boolean;virtual;
       end;


       pclassrefdef = ^tclassrefdef;
       tclassrefdef = object(tpointerdef)
          constructor init(def : pdef);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       parraydef = ^tarraydef;
       tarraydef = object(tdef)
          lowrange : longint;
          highrange : longint;
          rangenr : longint;
          definition : pdef;
          rangedef : pdef;
          function elesize : longint;
          constructor init(l,h : longint;rd : pdef);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          procedure deref;virtual;
          function size : longint;virtual;
          { generates the ranges needed by the asm instruction BOUND (i386)
            or CMP2 (Motorola) }
          procedure genrangecheck;
          function needs_inittable : boolean;virtual;
          procedure write_rtti_data;virtual;
          procedure write_child_rtti_table;virtual;
       end;

       precdef = ^trecdef;
       trecdef = object(tdef)
          symtable : psymtable;
          constructor init(p : psymtable);
          constructor load;
          destructor done;virtual;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          procedure deref;virtual;
          function  needs_inittable : boolean;virtual;
          procedure write_rtti_data;virtual;
          procedure write_init_data;virtual;
          procedure write_child_rtti_data;virtual;
          procedure write_child_init_data;virtual;
       end;

       { base types }
       tbasetype = (uauto,uvoid,uchar,
                    u8bit,u16bit,u32bit,
                    s8bit,s16bit,s32bit,
                    bool8bit,bool16bit,bool32bit { uwchar,bool1bit,bitfield});

       porddef = ^torddef;
       torddef = object(tdef)
          low,high : longint;
          rangenr  : longint;
          typ      : tbasetype;
          {
          bits     : byte;
          }
          constructor init(t : tbasetype;v,b : longint);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif GDB}
          procedure setsize;

          { generates the ranges needed by the asm instruction BOUND }
          { or CMP2 (Motorola)                                       }
          procedure genrangecheck;
          procedure write_rtti_data;virtual;
          function is_publishable : boolean;virtual;
       end;

       { sextreal is dependant on the cpu, s64bit is also }
       { dependant on the size (tp = 80bit for both)      }
       { The EXTENDED format exists on the motorola FPU   }
       { but it uses 96 bits instead of 80, with some     }
       { unused bits within the number itself! Pretty     }
       { complicated to support, so no support for the    }
       { moment.                                          }
       { s64 bit is considered as a real because all      }
       { calculations are done by the fpu.                }
       tfloattype = (f32bit,s32real,s64real,s80real,s64bit,f16bit);

       pfloatdef = ^tfloatdef;
       tfloatdef = object(tdef)
          typ : tfloattype;
          constructor init(t : tfloattype);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif GDB}
          procedure setsize;
          function is_publishable : boolean;virtual;
          procedure write_rtti_data;virtual;
       end;

       pabstractprocdef = ^tabstractprocdef;
       tabstractprocdef = object(tdef)
          { saves a definition to the return type }
          retdef : pdef;
{$ifdef StoreFPULevel}
          fpu_used : byte; { how many stack fpu must be empty }
{$endif StoreFPULevel}
          { save the procedure options }
          options : longint;
          para1 : pdefcoll;
          constructor init;
          constructor load;
          destructor done;virtual;
          procedure concatdef(p : pdef;vsp : tvarspez);
          procedure deref;virtual;
          function para_size : longint;
          function demangled_paras : string;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          procedure write;virtual;
       end;

       pprocvardef = ^tprocvardef;
       tprocvardef = object(tabstractprocdef)
          constructor init;
          constructor load;
          procedure write;virtual;
          function size : longint;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput); virtual;
{$endif GDB}
          procedure write_child_rtti_data;virtual;
          function is_publishable : boolean;virtual;
          procedure write_rtti_data;virtual;
       end;

       pprocdef = ^tprocdef;
       tprocdef = object(tabstractprocdef)
          extnumber : longint;
          nextoverloaded : pprocdef;
          { pointer to the local symbol table }
          localst : psymtable;
          { pointer to the parameter symbol table }
          parast : psymtable;
{$ifdef UseBrowser}
          lastref,
          defref,
          lastwritten : pref;
          refcount : longint;
{$endif UseBrowser}
          _class : pobjectdef;
          _mangledname : pchar;
          { it's a tree, but this not easy to handle }
          { used for inlined procs                   }
          code : pointer;
          { true, if the procedure is only declared }
          { (forward procedure) }
          forwarddef : boolean;
          { set which contains the modified registers }
{$ifdef i386}
          usedregisters : byte;
{$endif}
{$ifdef m68k}
          usedregisters : word;
{$endif}
{$ifdef alpha}
          usedregisters_int : longint;
          usedregisters_fpu : longint;
{$endif}
          constructor init;
          destructor done;virtual;
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function cplusplusmangledname : string;
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          procedure deref;virtual;
          function mangledname : string;
          procedure setmangledname(const s : string);
{$ifdef UseBrowser}
          procedure load_references;
          procedure write_references;
          procedure add_to_browserlog;
{$endif UseBrowser}
       end;

       tstringtype = (st_shortstring, st_longstring, st_ansistring, st_widestring);

       pstringdef = ^tstringdef;
       tstringdef = object(tdef)
          string_typ : tstringtype;
          len : longint;
          constructor init(l : byte);
          constructor load;
          constructor longinit(l : longint);
          constructor longload;
          constructor ansiinit(l : longint);
          constructor ansiload;
          constructor wideinit(l : longint);
          constructor wideload;
          function size : longint;virtual;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          function needs_inittable : boolean;virtual;
          procedure write_rtti_data;virtual;
          function is_publishable : boolean;virtual;
       end;

       penumdef = ^tenumdef;
       tenumdef = object(tdef)
          minval,
          maxval    : longint;
          has_jumps : boolean;
          first     : penumsym;
          basedef   : penumdef;
          constructor init;
          constructor init_subrange(_basedef:penumdef;_min,_max:longint);
          constructor load;
          destructor done;virtual;
          procedure write;virtual;
          procedure deref;virtual;
          procedure calcsavesize;
          procedure setmax(_max:longint);
          procedure setmin(_min:longint);
          function  min:longint;
          function  max:longint;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif GDB}
          procedure write_child_rtti_data;virtual;
          procedure write_rtti_data;virtual;
          function is_publishable : boolean;virtual;
       end;

       tsettype = (normset,smallset,varset);

       psetdef = ^tsetdef;
       tsetdef = object(tdef)
          setof : pdef;
          settype : tsettype;
          constructor init(s : pdef;high : longint);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          procedure deref;virtual;
          function is_publishable : boolean;virtual;
          procedure write_rtti_data;virtual;
          procedure write_child_rtti_data;virtual;
       end;

{************************************************
                   TSym
************************************************}

       symprop = byte;

       { possible types for symtable entries }
       tsymtyp = (abstractsym,varsym,typesym,procsym,unitsym,programsym,
                  constsym,enumsym,typedconstsym,errorsym,syssym,
                  labelsym,absolutesym,propertysym,funcretsym);
                  { varsym_C,typedconstsym_C); }

       { this object is the base for all symbol objects }
       psym = ^tsym;
       tsym = object
          typ        : tsymtyp;
          _name      : pchar;
          left,right : psym;
          speedvalue : longint;
          properties : symprop;
          owner      : psymtable;
          indexnb    : word;
          fileinfo   : tfileposinfo;
{$ifdef GDB}
          isstabwritten : boolean;
{$endif GDB}
{$ifdef UseBrowser}
          lastref,
          defref,
          lastwritten : pref;
          refcount    : longint;
{$endif UseBrowser}
          constructor init(const n : string);
          constructor load;
          destructor done;virtual;
          procedure write;virtual;
          procedure deref;virtual;
          function name : string;
          function mangledname : string;virtual;
          procedure setname(const s : string);
          procedure insert_in_data;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
{$ifdef UseBrowser}
          procedure load_references;virtual;
          procedure write_references;virtual;
          procedure add_to_browserlog;virtual;
{$endif UseBrowser}
       end;

       plabelsym = ^tlabelsym;
       tlabelsym = object(tsym)
          number : plabel;
          defined : boolean;
          constructor init(const n : string; l : plabel);
          destructor done;virtual;
          function mangledname : string;virtual;
          procedure write;virtual;
       end;

       punitsym = ^tunitsym;
       tunitsym = object(tsym)
          unitsymtable : punitsymtable;
          prevsym : punitsym;
          refs : longint;
          constructor init(const n : string;ref : punitsymtable);
          destructor done;virtual;
          procedure write;virtual;
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       pmacrosym = ^tmacrosym;
       tmacrosym = object(tsym)
          defined : boolean;
          buftext : pchar;
          buflen : longint;
          { macros aren't written to PPU files ! }
          constructor init(const n : string);
          destructor done;virtual;
       end;

       perrorsym = ^terrorsym;
       terrorsym = object(tsym)
          constructor init;
       end;

       pprocsym = ^tprocsym;
       tprocsym = object(tsym)
          definition : pprocdef;
{$ifdef CHAINPROCSYMS}
          nextprocsym : pprocsym;
{$endif CHAINPROCSYMS}
{$ifdef GDB}
          is_global : boolean;{necessary for stab}
{$endif GDB}
          constructor init(const n : string);
          constructor load;
          destructor done;virtual;
          function mangledname : string;virtual;
          function demangledname:string;
          { writes all declarations }
          procedure write_parameter_lists;
          { tests, if all procedures definitions are defined and not }
          { only forward                                             }
          procedure check_forward;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef UseBrowser}
          procedure load_references;virtual;
          procedure write_references;virtual;
          procedure add_to_browserlog;virtual;
{$endif UseBrowser}
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       ttypesym = object(tsym)
          definition : pdef;
          forwardpointer : ppointerdef;
{$ifdef GDB}
          isusedinstab : boolean;
{$endif GDB}
          constructor init(const n : string;d : pdef);
          constructor load;
          destructor done;virtual;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef UseBrowser}
          procedure load_references;virtual;
          procedure write_references;virtual;
          procedure add_to_browserlog;virtual;
{$endif UseBrowser}
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       pvarsym = ^tvarsym;
       tvarsym = object(tsym)
          address      : longint;
          definition   : pdef;
          refs         : longint;
          var_options  : byte;
          _mangledname : pchar;
          reg          : tregister; { if reg<>R_NO, then the variable is an register variable }
          varspez      : tvarspez;  { sets the type of access }
          is_valid     : byte;
          constructor init(const n : string;p : pdef);
          constructor load;
          constructor init_C(const n,mangled : string;p : pdef);
          constructor load_C;
          destructor done;virtual;
          function mangledname : string;virtual;
          procedure insert_in_data;virtual;
          function getsize : longint;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       ppropertysym = ^tpropertysym;
       tpropertysym = object(tsym)
          options : longint;
          proptype : pdef;
          { proppara : pdefcoll; }
          readaccesssym,writeaccesssym,storedsym : psym;
          readaccessdef,writeaccessdef,storeddef : pdef;
          index,default : longint;
          constructor init(const n : string);
          destructor done;virtual;
          constructor load;
          function getsize : longint;virtual;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef GDB}
          { I don't know how (FK) }
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       pfuncretsym = ^tfuncretsym;
       tfuncretsym = object(tsym)
          funcretprocinfo : pointer{ should be pprocinfo};
          funcretdef : pdef;
          address : longint;
          constructor init(const n : string;approcinfo : pointer{pprocinfo});
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       absolutetyp = (tovar,toasm,toaddr);

       pabsolutesym = ^tabsolutesym;
       tabsolutesym = object(tvarsym)
          abstyp : absolutetyp;
          absseg : boolean;
          ref : psym;
          asmname : pstring;
          constructor load;
          procedure deref;virtual;
          function mangledname : string;virtual;
          procedure write;virtual;
          procedure insert_in_data;virtual;
          { this creates a problem in gen_vmt !!!!!
          because the pdef is not resolved yet !!
          we should fix this
          constructor init(const s : string;p : pdef;newref : psym);}
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       ptypedconstsym = ^ttypedconstsym;
       ttypedconstsym = object(tsym)
          prefix : pstring;
          definition : pdef;
          constructor init(const n : string;p : pdef);
          constructor load;
          destructor done;virtual;
          function  mangledname : string;virtual;
          procedure write;virtual;
          procedure deref;virtual;
          procedure insert_in_data;virtual;
          procedure really_insert_in_data;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif GDB}
       end;

       tconsttype = (constord,conststring,constreal,constbool,
                     constint,constchar,constset);

       pconstsym = ^tconstsym;
       tconstsym = object(tsym)
          definition : pdef;
          consttype  : tconsttype;
          value      : longint;
          constructor init(const n : string;t : tconsttype;v : longint;def : pdef);
          constructor load;
          function  mangledname : string;virtual;
          destructor done;virtual;
          procedure deref;virtual;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       tenumsym = object(tsym)
          value : longint;
          definition : penumdef;
          next : penumsym;
          constructor init(const n : string;def : penumdef;v : longint);
          constructor load;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef GDB}
          procedure order;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;

       pprogramsym = ^tprogramsym;
       tprogramsym = object(tsym)
          constructor init(const n : string);
       end;

       psyssym = ^tsyssym;
       tsyssym = object(tsym)
          number : longint;
          constructor init(const n : string;l : longint);
          procedure write;virtual;
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
       end;


{************************************************
                 TSymtable
************************************************}

       tsymtabletype = (invalidsymtable,withsymtable,staticsymtable,
                        globalsymtable,unitsymtable,
                        objectsymtable,recordsymtable,
                        macrosymtable,localsymtable,
                        parasymtable,inlineparasymtable,
                        inlinelocalsymtable,stt_exceptsymtable);

       tcallback = procedure(p : psym);

       tsymtablehasharray = array[0..hasharraysize-1] of psym;
       psymtablehasharray = ^tsymtablehasharray;

       tsymtable = object
          symtabletype : tsymtabletype;
          unitid    : word;           { each symtable gets a number }
          name      : pstring;
          datasize  : longint;
          root      : psym;
          hasharray : psymtablehasharray;
          next      : psymtable;
          defowner  : pdef; { for records and objects }
          { only used for parameter symtable to determine the offset relative }
          { to the frame pointer                                              }
          call_offset : longint;
          { this saves all definition to allow a proper clean up }
          rootdef      : pdef;
          { separate lexlevel from symtable type }
          symtablelevel : byte;
          constructor init(t : tsymtabletype);
          destructor  done;virtual;
          { access }
          procedure number_units;
          procedure number_defs;
          procedure number_symbols;
          function getdefnr(l : word) : pdef;
          function getsymnr(l : word) : psym;
          { load/write }
          constructor load;
          procedure write;
          constructor loadasstruct(typ : tsymtabletype);
          procedure writeasstruct;
          procedure loaddefs;
          procedure loadsyms(doderef:boolean);
          procedure writedefs;
          procedure writesyms;
          procedure clear;
          function  insert(sym : psym):psym;
          function  search(const s : stringid) : psym;
          procedure registerdef(p : pdef);
          procedure foreach(proc2call : tcallback);
          procedure allsymbolsused;
          procedure allunitsused;
          procedure check_forwards;
{$ifdef CHAINPROCSYMS}
          procedure chainprocsyms;
{$endif CHAINPROCSYMS}
{$ifdef UseBrowser}
          procedure load_browser;
          procedure write_browser;
          procedure writebrowserlog;
{$endif UseBrowser}
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif GDB}
          function getnewtypecount : word; virtual;
       end;

       tunitsymtable = object(tsymtable)
          checksum,maschstart : longint;
          dbx_count : longint;
          is_stab_written : boolean;
          prev_dbx_counter : plongint;
          dbx_count_ok : boolean;
          unittypecount  : word;
          unitsym : punitsym;

          constructor init(t : tsymtabletype;const n : string);
          constructor loadasunit;
          procedure writeasunit;
{$ifdef GDB}
          procedure orderdefs;
          procedure concattypestabto(asmlist : paasmoutput);
{$endif GDB}
          function getnewtypecount : word; virtual;
       end;

{****************************************************************************
                              Var / Consts
****************************************************************************}

    var
       { for STAB debugging }
       globaltypecount : word;
       pglobaltypecount : pword;

       registerdef : boolean;      { true, wenn Definitionen           }
                                   { registriert werden sollen         }

       symtablestack : psymtable;  { root der verketteten Liste von  }
                                   { Symboltabellen                    }

       srsym : psym;               { enthlt das Ergebnis der letzten  }
       srsymtable : psymtable;     { Suche nach einem Symbol           }
       lastsrsym : psym;           { last sym found in statement }
       lastsrsymtable : psymtable;
       lastsymknown : boolean;

       forwardsallowed : boolean;  { true, wenn Pointertypen "forward" }
                                   { eingefgt werden drfen           }

       constsymtable : psymtable;  { Symboltabelle in die die          }
                                   { Konstanten von z.B. forzhlungs-  }
                                   { typen eingefgt werden            }

                                   { wird von quelltext initialisiert  }
                                   { (ist resulttype einer Procedure)  }
       voidpointerdef : ppointerdef;
                                   { pointer for "void"-Pointerdef      }

       voiddef   : porddef;        { Pointer to Void (procedure)       }
       cchardef  : porddef;        { Pointer to Char                   }
       u8bitdef  : porddef;        { Pointer to 8-Bit unsigned         }
       u16bitdef : porddef;        { Pointer to 16-Bit unsigned        }
       u32bitdef : porddef;        { Pointer to 32-Bit unsigned        }
       s32bitdef : porddef;        { Pointer to 32-Bit signed          }
       booldef   : porddef;        { pointer to boolean type           }

       c64floatdef : pfloatdef;    { pointer for realconstn            }
       s80floatdef : pfloatdef;    { pointer to type of temp. floats   }
       s32fixeddef : pfloatdef;    { pointer to type of temp. fixed    }

       cstringdef     : pstringdef;  { pointer to type of short string const   }
       clongstringdef : pstringdef;  { pointer to type of long string const   }
       cansistringdef : pstringdef;  { pointer to type of ansi string const  }
       cwidestringdef : pstringdef;  { pointer to type of wide string const  }

       cfiledef : pfiledef;       { get the same definition for all file }
                                  { uses for stabs }
       firstglobaldef,
       lastglobaldef : pdef;

       class_tobject : pobjectdef; { pointer to the anchestor of all   }
                                   { clases                            }

       aktprocsym : pprocsym;      { pointer for den Symboltablellen-   }
                                   { eintrag der momentan geparseten   }
                                   { procedure                         }

       procprefix : string;        { eindeutige Namen bei geschachtel- }
                                   { ten Unterprogrammen erzeugen      }

       lexlevel : longint;         { level of code                     }
                                   { 1 for main procedure              }
                                   { 2 for normal function or proc     }
                                   { higher for locals                 }

       macros : psymtable;         { pointer for die Symboltabelle mit  }
                                   { Makros                            }

       read_member : boolean;      { true, wenn Members aus einer PPU-  }
                                   { Datei gelesen werden, d.h. ein     }
                                   { varsym seine Adresse einlesen soll }

       generrorsym : psym;         { Jokersymbol, wenn das richtige    }
                                   { Symbol nicht gefunden wird        }

       generrordef : pdef;         { Jokersymbol for eine fehlerhafte  }
                                   { Typdefinition                     }

       aktobjectdef : pobjectdef;  { used for private functions check !! }

       overloaded_operators : array[PLUS..last_overloaded] of pprocsym;
      { unequal is not equal}
    const
       overloaded_names : array [PLUS..last_overloaded] of string[16] =
         ('plus','minus','star','slash','equal',
          'greater','lower','greater_or_equal',
          'lower_or_equal','as','is','in','sym_diff',
          'starstar','assign');

       systemunit            : punitsymtable = nil; { pointer to the system unit }
       current_object_option : symprop = sp_public;

{****************************************************************************
                             Functions
****************************************************************************}

{*** Misc ***}
    function  globaldef(const s : string) : pdef;
    procedure maybe_concat_external(symt : psymtable;const name : string);

{*** Search ***}
    function  search_a_symtable(const symbol:string;symtabletype:tsymtabletype):Psym;
    procedure getsym(const s : stringid;notfounderror : boolean);
    procedure getsymonlyin(p : psymtable;const s : stringid);

{*** Forwards ***}
    procedure save_forward(ppd : ppointerdef;typesym : ptypesym);
    procedure resolve_forwards;

{*** PPU Write/Loading ***}
    procedure writeunitas(const s : string;unittable : punitsymtable);
    procedure numberunits;
    procedure load_interface;

{*** GDB ***}
{$ifdef GDB}
    function  typeglobalnumber(const s : string) : string;
    procedure reset_gdb_info;
{$endif}

{*** Browser ***}
{$ifdef UseBrowser}
    procedure write_browser_log;
{$endif}

{*** Object Helpers ***}
    function search_class_member(pd : pobjectdef;const n : string) : psym;
    function search_default_property(pd : pobjectdef) : ppropertysym;

{*** Macro ***}
    procedure def_macro(const s : string);
    procedure set_macro(const s : string;value : string);

{*** symtable stack ***}
    procedure dellexlevel;
{$ifdef DEBUG}
    procedure test_symtablestack;
    procedure list_symtablestack;
{$endif DEBUG}

{*** Init / Done ***}
    procedure InitSymtable;
    procedure DoneSymtable;


implementation

  uses
     types,ppu
     ,hcodegen
     ;

  var
     aktrecordsymtable : psymtable; { current record read from ppu symtable }
     asmoutput : paasmoutput;

{$ifdef TP}
   {$ifndef dpmi}
       symbolstream : temsstream;  { stream which is used to store some info }
   {$else}
       symbolstream : tmemorystream;
   {$endif}
{$endif}

   {to dispose the global symtable of a unit }
  const
     dispose_global : boolean = false;
     object_options : boolean = false;
     memsizeinc = 2048; { for long stabstrings }
     tagtypes : Set of tdeftype =
       [recorddef,enumdef,
       {$IfNDef GDBKnowsStrings}
       stringdef,
       {$EndIf not GDBKnowsStrings}
       {$IfNDef GDBKnowsFiles}
       filedef,
       {$EndIf not GDBKnowsFiles}
       objectdef];

{*****************************************************************************
                             Helper Routines
*****************************************************************************}

    function demangledparas(s : string) : string;
      var
         r : string;
         l : longint;
      begin
         demangledparas:='';
         r:=',';
         { delete leading $$'s }
         l:=pos('$$',s);
         while l<>0 do
           begin
              delete(s,1,l+1);
              l:=pos('$$',s);
           end;
         l:=pos('$',s);
         if l=0 then
           exit;
         delete(s,1,l);
         l:=pos('$',s);
         if l=0 then
           l:=length(s)+1;
         while s<>'' do
           begin
              r:=r+copy(s,1,l-1)+',';
              delete(s,1,l);
           end;
         delete(r,1,1);
         delete(r,length(r),1);
         demangledparas:=r;
      end;


    procedure numberunits;
      var
        counter : longint;
        hp      : pused_unit;
      begin
        counter:=1;
        psymtable(current_module^.symtable)^.unitid:=0;
        hp:=pused_unit(current_module^.used_units.first);
        while assigned(hp) do
         begin
           psymtable(hp^.u^.symtable)^.unitid:=counter;
           inc(counter);
           hp:=pused_unit(hp^.next);
         end;
      end;


    procedure maybe_concat_external(symt : psymtable;const name : string);
      begin
         if (symt^.symtabletype=unitsymtable) or
            ((symt^.symtabletype=objectsymtable) and
             (symt^.defowner^.owner^.symtabletype=unitsymtable)) then
           concat_external(name,EXT_NEAR);
      end;


   procedure setstring(var p : pchar;const s : string);
     begin
{$ifdef TP}
       if use_big then
        begin
          p:=pchar(symbolstream.getsize);
          symbolstream.seek(longint(p));
          symbolstream.writestr(@s);
        end
       else
{$endif TP}
        p:=strpnew(s);
     end;



{*****************************************************************************
                           PPU Reading Writing
*****************************************************************************}

{$I symppu.inc}


{*****************************************************************************
                            Definition Helpers
*****************************************************************************}

    function globaldef(const s : string) : pdef;

      var st : string;
          symt : psymtable;
      begin
         srsym := nil;
         if pos('.',s) > 0 then
           begin
           st := copy(s,1,pos('.',s)-1);
           getsym(st,false);
           st := copy(s,pos('.',s)+1,255);
           if assigned(srsym) then
             begin
             if srsym^.typ = unitsym then
               begin
               symt := punitsym(srsym)^.unitsymtable;
               srsym := symt^.search(st);
               end else srsym := nil;
             end;
           end else st := s;
         if srsym = nil then getsym(st,false);
         if srsym = nil then
           getsymonlyin(systemunit,st);
         if srsym^.typ<>typesym then
           begin
             Message(type_e_type_id_expected);
             exit;
           end;
         globaldef := ptypesym(srsym)^.definition;
      end;

{*****************************************************************************
                        Symbol / Definition Resolving
*****************************************************************************}

    procedure resolvesym(var d : psym);
      begin
        if longint(d)=$ffffffff then
          d:=nil
        else
          begin
            if (longint(d) and $ffff)=$ffff then
              d:=aktrecordsymtable^.getsymnr(longint(d) shr 16)
            else
              d:=psymtable(current_module^.map^[longint(d) and $ffff])^.getsymnr(longint(d) shr 16);
          end;
      end;

    procedure resolvedef(var d : pdef);
      begin
        if longint(d)=$ffffffff then
          d:=nil
        else
          begin
            if (longint(d) and $ffff)=$ffff then
              d:=aktrecordsymtable^.getdefnr(longint(d) shr 16)
            else
              d:=psymtable(current_module^.map^[longint(d) and $ffff])^.getdefnr(longint(d) shr 16);
           end;
      end;


{*****************************************************************************
                        Symbol Call Back Functions
*****************************************************************************}

    procedure writesym(p : psym);
      begin
         p^.write;
      end;

    procedure derefsym(p : psym);
      begin
         p^.deref;
      end;

    procedure derefsymsdelayed(p : psym);
      begin
         if p^.typ in [absolutesym,propertysym] then
           p^.deref;
      end;

    procedure check_procsym_forward(sym : psym);
      begin
         if sym^.typ=procsym then
           pprocsym(sym)^.check_forward
         { check also object method table             }
         { we needn't to test the def list            }
         { because each object has to have a type sym }
         else
          if (sym^.typ=typesym) and
             assigned(ptypesym(sym)^.definition) and
             (ptypesym(sym)^.definition^.deftype=objectdef) then
           pobjectdef(ptypesym(sym)^.definition)^.check_forwards;
      end;

    procedure unitsymbolused(p : psym);
      begin
         if p^.typ=unitsym then
           if (punitsym(p)^.refs=0) then
             comment(V_info,'Unit '+p^.name+' is not used');
      end;

    procedure varsymbolused(p : psym);
      var
        oldaktfilepos : tfileposinfo;
      begin
         if (p^.typ=varsym) and
            ((p^.owner^.symtabletype in [parasymtable,localsymtable,staticsymtable])) then
           { unused symbol should be reported only if no }
           { error is reported                           }
           { if the symbol is in a register it is used   }
           if (pvarsym(p)^.refs=0) and
              (status.errorcount=0) {and
              (pvarsym(p)^.reg=R_NO)} then
             begin
                oldaktfilepos:=aktfilepos;
                aktfilepos:=p^.fileinfo;
                if p^.owner^.symtabletype=parasymtable then
                  Message1(sym_n_para_identifier_not_used,p^.name)
                else
                  Message1(sym_w_local_identifier_not_used,p^.name);
                aktfilepos:=oldaktfilepos;
             end;
      end;

{$ifdef GDB}
    procedure concatstab(p : psym);
      begin
        if p^.typ <> procsym then
          p^.concatstabto(asmoutput);
      end;

    procedure concattypestab(p : psym);
      begin
        if p^.typ = typesym then
         begin
           p^.isstabwritten:=false;
           p^.concatstabto(asmoutput);
         end;
      end;

    procedure forcestabto(asmlist : paasmoutput; pd : pdef);
      begin
        if not pd^.is_def_stab_written then
         begin
           if assigned(pd^.sym) then
            pd^.sym^.isusedinstab := true;
           pd^.concatstabto(asmlist);
         end;
      end;
{$endif}

{$ifdef CHAINPROCSYMS}
    procedure chainprocsym(p : psym);
      var
         storesymtablestack : psymtable;
      begin
         if p^.typ=procsym then
           begin
              storesymtablestack:=symtablestack;
              symtablestack:=p^.owner^.next;
              while assigned(symtablestack) do
                begin
                  { search for same procsym in other units }
                  getsym(p^.name,false);
                  if assigned(srsym) and (srsym^.typ=procsym) then
                    begin
                       pprocsym(p)^.nextprocsym:=pprocsym(srsym);
                       symtablestack:=storesymtablestack;
                       exit;
                    end
                  else if srsym=nil then
                    symtablestack:=nil
                  else
                    symtablestack:=srsymtable^.next;
                end;
              symtablestack:=storesymtablestack;
           end;
      end;
{$endif}


{$ifdef UseBrowser}
    procedure write_refs(sym : psym);
      begin
         sym^.write_references;
      end;

    procedure add_to_browserlog(p : psym);
      begin
         p^.add_to_browserlog;
      end;
{$endif UseBrowser}

{****************************************************************************
                             Forward Resolving
****************************************************************************}

    type
       presolvelist = ^tresolvelist;
       tresolvelist = record
          p : ppointerdef;
          typ : ptypesym;
          next : presolvelist;
       end;

    var
       sroot : presolvelist;

{

    Not used ?!?  (PFV)

    procedure clear_forwards;

      var
         p : presolvelist;

      begin
         p:=sroot;
         while assigned(p) do
         begin
              sroot:=p^.next;
            dispose(p);
            p := sroot;
         end;
      end;
}

    procedure save_forward(ppd : ppointerdef;typesym : ptypesym);
      var
         p : presolvelist;
      begin
         new(p);
         p^.next:=sroot;
         p^.p:=ppd;
         ppd^.defsym := typesym;
         p^.typ:=typesym;
         sroot:=p;
      end;

    procedure resolve_forwards;
      var
         p : presolvelist;
      begin
         p:=sroot;
         while p<>nil do
           begin
              sroot:=sroot^.next;
              p^.p^.definition:=p^.typ^.definition;
              dispose(p);
              p:=sroot;
           end;
      end;


{*****************************************************************************
                          Search Symtables for Syms
*****************************************************************************}

    procedure getsym(const s : stringid;notfounderror : boolean);
{$ifndef dummy}
      begin
         lastsrsym:=nil;
         srsymtable:=symtablestack;
         while assigned(srsymtable) do
           begin
              srsym:=srsymtable^.search(s);
              if assigned(srsym) then
                exit
              else
                srsymtable:=srsymtable^.next;
           end;
         if forwardsallowed then
           begin
              srsymtable:=symtablestack;
              while (srsymtable^.symtabletype in [objectsymtable,recordsymtable]) do
                   srsymtable:=srsymtable^.next;
              srsym:=new(ptypesym,init(s,nil));
              srsym^.properties:=sp_forwarddef;
              srsymtable^.insert(srsym);
           end
         else if notfounderror then
           begin
              Message1(sym_e_id_not_found,s);
              srsym:=generrorsym;
           end
         else srsym:=nil;
      end;

{$else dummy}
       begin
         lastsrsym:=nil;
         srsymtable:=symtablestack;
         { all ^defs are forwards until the end of
         the type definition }
         if forwardsallowed then
           begin
              { only accept if it is in the global static or local symtable }
              while (srsymtable^.symtabletype in [objectsymtable,recordsymtable]) do
                begin
                   srsym:=srsymtable^.search(s);
                   if assigned(srsym) then exit;
                   srsymtable:=srsymtable^.next;
                end;
              srsym:=srsymtable^.search(s);
              if assigned(srsym) then exit;
              { static symtable cannot have the same
              symbols as global symtable !! }
              if (srsymtable^.symtabletype=staticsymtable) and
                 (srsymtable^.next^.symtabletype=globalsymtable) then
                begin
                   srsym:=srsymtable^.next^.search(s);
                   if assigned(srsym) then
                     begin
                        srsymtable:=srsymtable^.next;
                        exit;
                     end;
                end;
              srsym:=new(ptypesym,init(s,nil));
              { forward are never stored in objects nor in
              records }
              srsym^.properties:=sp_forwarddef;
              srsymtable^.insert(srsym);
           end
         else
           begin
              while assigned(srsymtable) do
                begin
                   srsym:=srsymtable^.search(s);
                   if assigned(srsym) then
                     exit
                   else
                     srsymtable:=srsymtable^.next;
                end;
              if notfounderror then
                begin
                   Message1(sym_e_id_not_found,s);
                   srsym:=generrorsym;
                end
              else srsym:=nil;
           end;
      end;
{$endif dummy}


    procedure getsymonlyin(p : psymtable;const s : stringid);
      begin
         { the caller have to take care if srsym=nil (FK) }
         srsym:=nil;
         if assigned(p) then
           begin
              srsymtable:=p;
              srsym:=srsymtable^.search(s);
              if assigned(srsym) then
                exit
              else
               Message1(sym_e_id_not_found,s);
           end;
      end;


    function search_a_symtable(const symbol:string;symtabletype:tsymtabletype):Psym;
    {Search for a symbol in a specified symbol table. Returns nil if
     the symtable is not found, and also if the symbol cannot be found
     in the desired symtable }
    var hsymtab:Psymtable;
        res:Psym;
    begin
        res:=nil;
        hsymtab:=symtablestack;
        while (hsymtab<>nil) and (hsymtab^.symtabletype<>symtabletype) do
            hsymtab:=hsymtab^.next;
        if hsymtab<>nil then
            {We found the desired symtable. Now check if the symbol we
             search for is defined in it }
            res:=hsymtab^.search(symbol);
        search_a_symtable:=res;
    end;

{****************************************************************************
                                TSYMTABLE
****************************************************************************}

    constructor tsymtable.init(t : tsymtabletype);
      begin
         symtabletype:=t;
         symtablelevel:=0;
         root:=nil;
         defowner:=nil;
         unitid:=0;
         next:=nil;
         name:=nil;
         call_offset:=0;
         if symtabletype=objectsymtable then
           datasize:=Sizeof(pointer)
         else
           datasize:=0;
         rootdef:=nil;
         hasharray:=nil;
      end;


    destructor tsymtable.done;
      var
         hp : pdef;
{$ifdef GDB}
         last : pdef;
{$endif GDB}
      begin
      { clear all entries, pprocsyms have still the definitions left }
        clear;
        stringdispose(name);
{$ifdef GDB}
        last := Nil;
{$endif GDB}
         hp:=rootdef;
         while assigned(hp) do
           begin
{$ifdef GDB}
              if hp^.owner=@self then
               begin
                 if assigned(last) then
                  last^.next := hp^.next;
{$endif GDB}
                 rootdef:=hp^.next;
                 dispose(hp,done);
{$ifdef GDB}
                end
              else
                begin
                  last := hp;
                  rootdef:=hp^.next;
                end;
{$endif GDB}
              hp:=rootdef;
           end;
      end;

{***********************************************
                Helpers
***********************************************}

   function tsymtable.getnewtypecount : word;
      begin
         getnewtypecount:=pglobaltypecount^;
         inc(pglobaltypecount^);
      end;

    procedure tsymtable.registerdef(p : pdef);
      begin
         p^.next:=rootdef;
         rootdef:=p;
         p^.owner:=@self;
      end;

    procedure tsymtable.foreach(proc2call : tcallback);

        procedure a(p : psym);
        { must be preorder, because it's used by reading in }
        { a PPU file                                        }
        begin
          proc2call(p);
          if assigned(p^.left) then
            a(p^.left);
          if assigned(p^.right) then
            a(p^.right);
        end;

      var
         i : longint;
      begin
        if assigned(hasharray) then
         begin
           for i:=0 to hasharraysize-1 do
            if assigned(hasharray^[i]) then
             a(hasharray^[i]);
         end
        else
         if assigned(root) then
          a(root);
      end;


    procedure tsymtable.number_units;
      var
         counter : word;
         p : psymtable;
      begin
         unitid:=0;

         { First number interface uses }
         p:=next;
         counter:=1;

         { Skip implementation }
         if symtabletype<>globalsymtable then
           begin
              while (p^.symtabletype<>globalsymtable) do
                p:=p^.next;
              p:=p^.next;
           end;

         { number units }
         while assigned(p) do
           begin
             if p^.symtabletype=unitsymtable then
              begin
                p^.unitid:=counter;
                inc(counter);
              end;
             p:=p^.next;
           end;
      end;


    procedure tsymtable.number_defs;
      var
         pd : pdef;
         counter : longint;
      begin
         counter:=0;
         pd:=rootdef;
         while assigned(pd) do
           begin
              pd^.indexnb:=counter;
              inc(counter);
              pd:=pd^.next;
           end;
      end;


    procedure tsymtable.number_symbols;
      var
        index,i : longint;

        procedure numbersym(var osym : psym);
        begin
          if osym=nil then
           exit;
          numbersym(osym^.left);
          osym^.indexnb:=index;
          inc(index);
          numbersym(osym^.right);
        end;

      begin
        index:=0;
        if assigned(hasharray) then
         begin
           for i:=0 to hasharraysize-1 do
            numbersym(hasharray^[i])
         end
        else
         numbersym(root);
      end;


{***********************************************
       LOAD / WRITE SYMTABLE FROM PPU
***********************************************}

    procedure tsymtable.loaddefs;
      var
        counter : longint;
        hp      : pdef;
        b       : byte;
      begin
       { read definitions }
         counter:=0;
         { was missing for empty records }
         rootdef:=nil;
         repeat
           b:=current_ppu^.readentry;
           case b of
              ibpointerdef : hp:=new(ppointerdef,load);
                ibarraydef : hp:=new(parraydef,load);
                  iborddef : hp:=new(porddef,load);
                ibfloatdef : hp:=new(pfloatdef,load);
                 ibprocdef : hp:=new(pprocdef,load);
               ibstringdef : hp:=new(pstringdef,load);
           iblongstringdef : hp:=new(pstringdef,longload);
           ibansistringdef : hp:=new(pstringdef,ansiload);
           ibwidestringdef : hp:=new(pstringdef,wideload);
               ibrecorddef : hp:=new(precdef,load);
               ibobjectdef : hp:=new(pobjectdef,load);
                 ibenumdef : hp:=new(penumdef,load);
                  ibsetdef : hp:=new(psetdef,load);
              ibprocvardef : hp:=new(pprocvardef,load);
                 ibfiledef : hp:=new(pfiledef,load);
             ibclassrefdef : hp:=new(pclassrefdef,load);
               ibformaldef : hp:=new(pformaldef,load);
                ibenddefs : break;
                    ibend : Message(unit_f_ppu_read_error);
           else
             Message1(unit_f_ppu_invalid_entry,tostr(b));
           end;
         { each def gets a number }
           hp^.indexnb:=counter;
           inc(counter);
           hp^.next:=rootdef;
           rootdef:=hp;
         until false;
      end;


    procedure tsymtable.writedefs;
      var
         pd : pdef;
      begin
       { each definition get a number ... }
         number_defs;

       { now write the definition }
         pd:=rootdef;
         while assigned(pd) do
           begin
              pd^.write;
              pd:=pd^.next;
           end;
       { write end of defenitions }
         current_ppu^.writeentry(ibenddefs);
      end;


    procedure tsymtable.loadsyms(doderef:boolean);
      var
        b   : byte;
        sym : psym;
      begin
       { now read the symbols }
         repeat
           b:=current_ppu^.readentry;
           case b of
                ibtypesym : sym:=new(ptypesym,load);
                ibprocsym : sym:=new(pprocsym,load);
               ibconstsym : sym:=new(pconstsym,load);
                 ibvarsym : sym:=new(pvarsym,load);
               ibvarsym_C : sym:=new(pvarsym,load_C);
            ibabsolutesym : sym:=new(pabsolutesym,load);
                ibenumsym : sym:=new(penumsym,load);
          ibtypedconstsym : sym:=new(ptypedconstsym,load);
            ibpropertysym : sym:=new(ppropertysym,load);
                ibendsyms : break;
                    ibend : Message(unit_f_ppu_read_error);
           else
             Message1(unit_f_ppu_invalid_entry,tostr(b));
           end;
           if doderef then
            begin
              { don't deref absolute symbols there, because it's possible   }
              { that the var sym which the absolute sym refers, isn't       }
              { loaded                                                      }
              { but syms must be derefered to determine the definition      }
              { because must know the varsym size when inserting the symbol }
              if not(b in [ibabsolutesym,ibpropertysym]) then
                sym^.deref;
            end;
           insert(sym);
         until false;

         if doderef then
          begin
            {$ifdef tp}
             foreach(derefsymsdelayed);
            {$else}
             foreach(@derefsymsdelayed);
            {$endif}
          end;

       { symbol numbering for references }
{$ifdef UseBrowser}
         number_symbols;
{$endif UseBrowser}
      end;


    procedure tsymtable.writesyms;
      begin
         { symbol numbering for references }
{$ifdef UseBrowser}
         number_symbols;
{$endif UseBrowser}

         { foreach is used to write all symbols }
         {$ifdef tp}
           foreach(writesym);
         {$else}
           foreach(@writesym);
         {$endif}

         { end of symbols }
         current_ppu^.writeentry(ibendsyms);
      end;


    constructor tsymtable.load;
      var
         hp : pdef;
      begin
         current_module^.map^[0]:=@self;

         symtabletype:=unitsymtable;
         symtablelevel:=0;

         { unused for units }
         call_offset:=0;

         { reset hash array }
         new(hasharray);
         fillchar(hasharray^,sizeof(hasharray^),0);

         datasize:=0;
         root:=nil;
         next:=nil;
         rootdef:=nil;
         defowner:=nil;

         unitid:=0;
         defowner:=nil;

       { load definitions }
         loaddefs;
       { solve the references of the symbols for each definition }
         hp:=rootdef;
         while assigned(hp) do
           begin
              hp^.deref;
              { insert also the owner }
              hp^.owner:=@self;
              hp:=hp^.next;
           end;
       { load symbols }
         loadsyms(true);
      end;


    procedure tsymtable.write;
      begin
      { write definitions }
         writedefs;
      { write symbols }
         writesyms;
      end;


    constructor tsymtable.loadasstruct(typ : tsymtabletype);
      begin
         symtabletype:=typ;
         hasharray:=nil;
         aktrecordsymtable:=@self;
         name:=nil;
         if symtabletype=objectsymtable then
           datasize:=sizeof(pointer)
         else
           datasize:=0;
         { isn't used there }
         call_offset := 0;
         root:=nil;
         next:=nil;
         rootdef:=nil;
         { also unused }
         unitid:=0;

      { load definitions }
         loaddefs;
      { load symbols }
         loadsyms(false);
      end;


    procedure tsymtable.writeasstruct;
      var
        oldtyp : byte;
      begin
        oldtyp:=current_ppu^.entrytyp;
        current_ppu^.entrytyp:=subentryid;
      { write definitions }
        writedefs;
      { write symbols }
        writesyms;
        current_ppu^.entrytyp:=oldtyp;
      end;


{***********************************************
          Get Symbol / Def by Number
***********************************************}

    function tsymtable.getsymnr(l : word) : psym;
      var
         hp : psym;
         i  : word;
      begin
          getsymnr:=nil;
          if assigned(hasharray) then
            begin
               hp:=nil;
               for i:=0 to hasharraysize-1 do
                 if assigned(hasharray^[i]) and (hasharray^[i]^.indexnb>=l) then
                   begin
                      hp:=hasharray^[i];
                      break;
                   end;
            end
          else
            hp:=root;
          while assigned(hp) do
            begin
               if hp^.indexnb<l then
                 hp:=hp^.right
               else
               if hp^.indexnb>l then
                 hp:=hp^.left
               else
                 begin
                    getsymnr:=hp;
                    exit;
                 end;
            end;
      end;


    function tsymtable.getdefnr(l : word) : pdef;
      var
         hp : pdef;
      begin
         hp:=rootdef;
         while (assigned(hp)) and (hp^.indexnb<>l) do
           hp:=hp^.next;
         getdefnr:=hp;
      end;

{***********************************************
                Table Access
***********************************************}

    procedure tsymtable.clear;
      var
         w : longint;
      begin
         { remove no entry from a withsymtable as it is only a pointer to the
         recorddef  or objectdef symtable }
         if symtabletype=withsymtable then
           exit;
         { remove all entry from a symbol table }
         if assigned(root) then
           dispose(root,done);
         if assigned(hasharray) then
           begin
              for w:=0 to hasharraysize-1 do
                if assigned(hasharray^[w]) then
                  dispose(hasharray^[w],done);
              dispose(hasharray);
           end;
      end;


    function tsymtable.insert(sym:psym):psym;
{$ifdef UseBrowser}
      var
        ref : pref;
{$endif UseBrowser}

      function _insert(var osym : psym):psym;
      {To prevent TP from allocating temp space for temp strings, we allocate
       some temp strings manually. We can use two temp strings, plus a third
       one that TP adds, where TP alone needs five temp strings!. Storing
       these on the heap saves even more, totally 1016 bytes per recursion!}
        var
          s1,s2:^string;
        begin
           if osym=nil then
             begin
               osym:=sym;
               _insert:=osym;
             end

         { first check speedvalue, to allow a fast insert }
           else
             if osym^.speedvalue>sym^.speedvalue then
               _insert:=_insert(osym^.right)
           else
             if osym^.speedvalue<sym^.speedvalue then
               _insert:=_insert(osym^.left)
           else
             begin
                new(s1);
                new(s2);
                s1^:=osym^.name;
                s2^:=sym^.name;
                if s1^>s2^ then
                  begin
                    dispose(s2);
                    dispose(s1);
                    _insert:=_insert(osym^.right);
                  end
                else
                  if s1^<s2^ then
                    begin
                      dispose(s2);
                      dispose(s1);
                      _insert:=_insert(osym^.left);
                    end
                else
                  begin
                     dispose(s2);
                     dispose(s1);
                     if (osym^.typ=typesym) and (osym^.properties=sp_forwarddef) then
                       begin
                          if (sym^.typ<>typesym) then
                           Message(sym_f_id_already_typed);
                          {
                          if (ptypesym(sym)^.definition^.deftype<>recorddef) and
                             (ptypesym(sym)^.definition^.deftype<>objectdef) then
                             Message(sym_f_type_must_be_rec_or_class);
                          }
                          ptypesym(osym)^.definition:=ptypesym(sym)^.definition;
                          osym^.properties:=sp_public;
                          { resolve the definition right now !! }
{$ifdef UseBrowser}
                          {forward types have two defref chained
                          the first corresponding to the location
                          of  the
                             ptype = ^ttype;
                          and the second
                          to the line
                             ttype = record }
                          new(ref,init(nil,@tokenpos));
                          ref^.nextref:=osym^.defref;
                          osym^.defref:=ref;
{$endif UseBrowser}
                          ptypesym(osym)^.forwardpointer^.definition:=ptypesym(osym)^.definition;
                          if ptypesym(osym)^.definition^.sym = ptypesym(sym) then
                            ptypesym(osym)^.definition^.sym := ptypesym(osym);
{$ifdef GDB}
                         ptypesym(osym)^.isusedinstab := true;
                         if (cs_debuginfo in aktmoduleswitches) and assigned(debuglist) then
                            osym^.concatstabto(debuglist);
{$endif GDB}
                          { don't do a done on sym
                          because it also disposes left and right !!
                           sym is new so it has no left nor right }
                          dispose(sym,done);
                          _insert:=osym;
                       end
                     else
                       begin
                         Message1(sym_e_duplicate_id,sym^.name);
                         _insert:=osym;
                       end;

                  end;
             end;
        end;

      var
         l  : longint;
         hp : psymtable;
         hsym : psym;
      begin
         { bei Symbolen for Variablen die Adresse eintragen, }
         { und Gre der Symboltabellendaten berechnen       }
         sym^.owner:=@self;
{$ifdef CHAINPROCSYMS}
         { set the nextprocsym field }
         if sym^.typ=procsym then
           chainprocsym(sym);
{$endif CHAINPROCSYMS}
         { writes the symbol in data segment if required }
         { also sets the datasize of owner               }
         sym^.insert_in_data;
         if (symtabletype in [staticsymtable,globalsymtable]) then
           begin
              hp:=symtablestack;
              while assigned(hp) do
                begin
                   if hp^.symtabletype in [staticsymtable,globalsymtable] then
                    begin
                       hsym:=hp^.search(sym^.name);
                       if (assigned(hsym)) and
                          (hsym^.properties and sp_forwarddef=0) then
                             Message1(sym_e_duplicate_id,sym^.name);
                    end;
                  hp:=hp^.next;
                end;
           end;

         { check for duplicate id in local and parsymtable symtable }
         if (symtabletype=localsymtable) then
           { to be on the sure side: }
           begin
              if assigned(next) and
                (next^.symtabletype=parasymtable) then
                begin
                   hsym:=next^.search(sym^.name);
                   if assigned(hsym) then
                     Message1(sym_e_duplicate_id,sym^.name);
                end
              else
                internalerror(43789);
           end;

         { check for duplicate id in local symtable of methods }
         if (symtabletype=localsymtable) and
           assigned(next) and
           assigned(next^.next) and
          { funcretsym is allowed !! }
           (sym^.typ <> funcretsym) and
           (next^.next^.symtabletype=objectsymtable) then
           begin
              if search_class_member(pobjectdef(next^.next^.defowner),sym^.name)<>nil then
                Message1(sym_e_duplicate_id,sym^.name);
           end;
         if sym^.typ = typesym then
           if assigned(ptypesym(sym)^.definition) then
             begin
             if not assigned(ptypesym(sym)^.definition^.owner) then
              registerdef(ptypesym(sym)^.definition);
{$ifdef GDB}
             if (cs_debuginfo in aktmoduleswitches) and assigned(debuglist)
                and (symtabletype in [globalsymtable,staticsymtable]) then
                   begin
                   ptypesym(sym)^.isusedinstab := true;
                   sym^.concatstabto(debuglist);
                   end;
{$endif GDB}
             end;
         if sym^.typ=funcretsym then
           begin
              { allocate space in local if ret in acc or in fpu }
              if ret_in_acc(procinfo.retdef) or (procinfo.retdef^.deftype=floatdef) then
                begin
                   l:=pfuncretsym(sym)^.funcretdef^.size;
                   inc(datasize,l);
{$ifdef m68k}
                   { word alignment required for motorola }
                   if (l=1) then
                    inc(datasize,1)
                   else
{$endif}
                   if (l>=4) and ((datasize and 3)<>0) then
                     inc(datasize,4-(datasize and 3))
                   else if (l>=2) and ((datasize and 1)<>0) then
                     inc(datasize,2-(datasize and 1));
                   pfuncretsym(sym)^.address:=datasize;
                   procinfo.retoffset:=-datasize;
                end;
           end;
         sym^.speedvalue:=getspeedvalue(sym^.name);
         if assigned(hasharray) then
           insert:=_insert(hasharray^[sym^.speedvalue mod hasharraysize])
         else
           insert:=_insert(root);
      end;

    function tsymtable.search(const s : stringid) : psym;
      var
         hp : psym;
         speedvalue : longint;
      begin
         speedvalue:=getspeedvalue(s);
         if assigned(hasharray) then
           hp:=hasharray^[speedvalue mod hasharraysize]
         else
           hp:=root;
         while assigned(hp) do
           begin
              if speedvalue>hp^.speedvalue then hp:=hp^.left
              else if speedvalue<hp^.speedvalue then hp:=hp^.right
              else
                begin
                   if (hp^.name=s) then
                     begin
                        { reject non static members in static procedures }
                        if (symtabletype=objectsymtable) and
                           ((hp^.properties and sp_static)=0) and
                           assigned(aktprocsym) and
                           ((aktprocsym^.definition^.options and postaticmethod)<>0) then
                               Message(sym_e_only_static_in_static);
                        (* this is done in firstsubscriptn and firstloadn
                        { should we allow use of private field in the whole
                        unit ? }
                        if (symtabletype=objectsymtable) and
                           (hp^.properties=sp_private) and
                           {defowner is the objectdef and the owner of the objectdef
                           is a unitsymtable, or golbalsymtable if we are compiling it !!}
                           (psymtable(defowner^.owner)^.symtabletype<>globalsymtable) and
                           (aktobjectdef<>pobjectdef(defowner)) and
                           ((aktprocsym^.definition=nil) or
                           (aktprocsym^.definition^._class<>pobjectdef(defowner))) then
                           begin
                              search:=nil;
                              exit;
                           end;
                        *)
                        search:=hp;
                        if (symtabletype=unitsymtable) and
                           assigned(punitsymtable(@self)^.unitsym) then
                          inc(punitsymtable(@self)^.unitsym^.refs);
{$ifdef UseBrowser}
                        if make_ref then
                          hp^.lastref:=new(pref,init(hp^.lastref,@tokenpos));
                        { for symbols that are in tables without
                        browser info or syssyms (PM) }
                        if hp^.refcount=0 then
                          hp^.defref:=hp^.lastref;
                        inc(hp^.refcount);
{$endif UseBrowser}
                        exit;
                     end
                  else if s>hp^.name then hp:=hp^.left
                  else hp:=hp^.right;
                end;
           end;
         search:=nil;
      end;

{***********************************************
                Browser
***********************************************}

{$ifdef UseBrowser}

    procedure tsymtable.load_browser;
      var
        b     : byte;
        sym   : psym;
        prdef : pdef;
        oldrecsyms : psymtable;
      begin
         if symtabletype in [recordsymtable,objectsymtable] then
           begin
              oldrecsyms:=aktrecordsymtable;
              aktrecordsymtable:=@self;
           end;
      { only realy parse if we want to use the browser }
        if cs_browser in aktmoduleswitches then
         begin
           repeat
             b:=current_ppu^.readentry;
             case b of
             ibsymref : begin
                          sym:=readsymref;
                          resolvesym(sym);
                          if assigned(sym) then
                            sym^.load_references;
                          if sym^.typ=typesym then
                            begin
                               if (ptypesym(sym)^.definition^.deftype=recorddef) then
                                begin
                                  precdef(ptypesym(sym)^.definition)^.symtable^.load_browser;
                                end;
                               if (ptypesym(sym)^.definition^.deftype=objectdef) then
                                begin
                                  pobjectdef(ptypesym(sym)^.definition)^.publicsyms^.load_browser;
                                end;
                             end;
                        end;
             ibdefref : begin
                          prdef:=readdefref;
                          resolvedef(prdef);
                          if assigned(prdef) then
                           begin
                             if prdef^.deftype<>procdef then
                              Message(unit_f_ppu_read_error);
                             pprocdef(prdef)^.load_references;
                           end;
                        end;
         ibendbrowser : break;
             else
               Message1(unit_f_ppu_invalid_entry,tostr(b));
             end;
           until false;
         end
        else
         begin
           current_ppu^.skipuntilentry(ibendbrowser);
         end;
         if symtabletype in [recordsymtable,objectsymtable] then
           aktrecordsymtable:=oldrecsyms;
      end;


    procedure tsymtable.write_browser;
      begin
      {$ifdef tp}
         foreach(write_refs);
      {$else}
         foreach(@write_refs);
      {$endif}
      end;


    procedure tsymtable.writebrowserlog;
      begin
        if cs_browser in aktmoduleswitches then
         begin
           if assigned(name) then
             Browse.AddLog('---Symtable '+name^)
           else
             Browse.AddLog('---Symtable with no name');
           Browse.Ident;
         {$ifdef tp}
           foreach(add_to_browserlog);
         {$else}
           foreach(@add_to_browserlog);
         {$endif}
           Browse.Unident;
         end;
      end;
{$endif UseBrowser}

{***********************************************
           Process all entries
***********************************************}

    { checks, if all procsyms and methods are defined }
    procedure tsymtable.check_forwards;
      begin
      {$ifdef tp}
         foreach(check_procsym_forward);
      {$else}
         foreach(@check_procsym_forward);
      {$endif}
      end;

    procedure tsymtable.allunitsused;
      begin
      {$ifdef tp}
         foreach(unitsymbolused);
      {$else}
         foreach(@unitsymbolused);
      {$endif}
      end;

    procedure tsymtable.allsymbolsused;
      begin
      {$ifdef tp}
         foreach(varsymbolused);
      {$else}
         foreach(@varsymbolused);
      {$endif}
      end;

{$ifdef CHAINPROCSYMS}
    procedure tsymtable.chainprocsyms;
      begin
      {$ifdef tp}
         foreach(chainprocsym);
      {$else}
         foreach(@chainprocsym);
      {$endif}
      end;
{$endif CHAINPROCSYMS}

{$ifdef GDB}
      procedure tsymtable.concatstabto(asmlist : paasmoutput);
      begin
        asmoutput:=asmlist;
      {$ifdef tp}
        foreach(concatstab);
      {$else}
        foreach(@concatstab);
      {$endif}
      end;
{$endif}


{****************************************************************************
                              TUNITSYMTABLE
****************************************************************************}

    constructor tunitsymtable.init(t : tsymtabletype; const n : string);
      begin
         inherited init(t);
         name:=stringdup(n);
         unitsym:=nil;
{$ifdef GDB}
         if t = globalsymtable then
           begin
              prev_dbx_counter := dbx_counter;
              dbx_counter := @dbx_count;
           end;
         dbx_count := 0;
         unitid:=0;
{$endif GDB}
         new(hasharray);
         fillchar(hasharray^,sizeof(hasharray^),0);
         is_stab_written:=false;
{$ifdef GDB}
         if use_dbx then
           begin
             if (symtabletype=globalsymtable) then
               pglobaltypecount := @unittypecount;
             debuglist^.concat(new(pai_stabs,init(strpnew('"'+name^+'",'+tostr(N_BINCL)+',0,0,0'))));
             unitid:=current_module^.unitcount;
             inc(current_module^.unitcount);
             debuglist^.concat(new(pai_asm_comment,init(strpnew('Global '+name^+' has index '+tostr(unitid)))));
           end;
{$endif GDB}
      end;


    constructor tunitsymtable.loadasunit;
      var
        storeGlobalTypeCount : pword;
        b : byte;
      begin
         name:=stringdup(current_module^.modulename^);
         unitsym:=nil;
         unitid:=0;
         dbx_count := 0;
         if (current_module^.flags and uf_has_dbx)<>0 then
           begin
              storeGlobalTypeCount:=PGlobalTypeCount;
              PglobalTypeCount:=@UnitTypeCount;
           end;

       { load symtables }
         inherited load;

{$ifdef UseBrowser}
       { load browser }
         if (current_module^.flags and uf_has_browser)<>0 then
           load_browser;
{$endif UseBrowser}

       { dbx count }
         if (current_module^.flags and uf_has_dbx)<>0 then
           begin
              b := current_ppu^.readentry;
              if b <> ibdbxcount then
               Message(unit_f_ppu_dbx_count_problem)
              else
               dbx_count := readlong;
              dbx_count_ok := true;
              PGlobalTypeCount:=storeGlobalTypeCount;
           end;
         is_stab_written:=false;

      { After this follows the implementation part, these are read in
        pmodules }
      end;


    procedure tunitsymtable.writeasunit;
{$ifdef UseBrowser}
      var
         pus : punitsymtable;
{$endif UseBrowser}
      begin
      { first the unitname }
        current_ppu^.putstring(name^);
        current_ppu^.writeentry(ibmodulename);

        writesourcefiles;

        writeusedunit;

     { write the objectfiles and libraries that come for this unit,
       preserve the containers becuase they are still needed to load
       the link.res }
       writecontainer(current_module^.linkofiles,iblinkofiles,true);
       writecontainer(current_module^.linksharedlibs,iblinksharedlibs,true);
       writecontainer(current_module^.linkstaticlibs,iblinkstaticlibs,true);
     { writes the names of the units which should be init'ed
       writecontainer(usedunits^,ibinitunit,false); }
       current_ppu^.writeentry(ibendinterface);

     { write the symtable entries }
       inherited write;

{$ifdef UseBrowser}
     { write browser section }
       if (current_module^.flags and uf_has_browser)<>0 then
        begin
          current_ppu^.do_crc:=false; { doesn't affect crc }
          pus:=@self;
          while assigned(pus) do
           begin
             if pus^.symtabletype = unitsymtable then
              pus^.write_browser;
             pus:=punitsymtable(pus^.next);
           end;
          current_ppu^.writeentry(ibendbrowser);
          current_ppu^.do_crc:=true;
        end;
{$endif UseBrowser}

     { write dbx count }
       if use_dbx then
        begin
{$IfDef EXTDEBUG}
          writeln('Writing dbx_count ',dbx_count,' in unit ',name^,'.ppu');
{$ENDIF EXTDEBUG}
          current_ppu^.putlongint(dbx_count);
          current_ppu^.writeentry(ibdbxcount);
        end;
       current_ppu^.writeentry(ibendimplementation);

     { the last entry ibend is written automaticly }
     end;


   function tunitsymtable.getnewtypecount : word;

      begin
         if not use_dbx then
           getnewtypecount:=tsymtable.getnewtypecount
         else
           if symtabletype = staticsymtable then
           getnewtypecount:=tsymtable.getnewtypecount
         else
           begin
              getnewtypecount:=unittypecount;
              inc(unittypecount);
           end;
      end;


{$ifdef GDB}
    procedure tunitsymtable.orderdefs;
      var
         first, last, nonum, pd, cur, prev, lnext : pdef;

      begin
         pd:=rootdef;
         first:=nil;
         last:=nil;
         nonum:=nil;
         while assigned(pd) do
           begin
              lnext:=pd^.next;
              if pd^.globalnb > 0 then
                if first = nil then
                  begin
                     first:=pd;
                     last:=pd;
                     last^.next:=nil;
                  end
                else
                  begin
                     cur:=first;
                     prev:=nil;
                     while assigned(cur) and
                           (prev <> last) and
                           (cur^.globalnb>0) and
                           (cur^.globalnb<pd^.globalnb) do
                       begin
                          prev:=cur;
                          cur:=cur^.next;
                       end;
                     if cur = first then
                       begin
                          pd^.next:=first;
                          first:=pd;
                       end
                     else
                     if prev = last then
                       begin
                          pd^.next:=nil;
                          last^.next:=pd;
                          last:=pd;
                       end
                     else
                       begin
                          pd^.next:=cur;
                          prev^.next:=pd;
                       end;
                  end
                else  { without number }
                  begin
                     pd^.next:=nonum;
                     nonum:=pd;
                  end;
              pd:=lnext;
           end;
         if assigned(first) then
           begin
              rootdef:=first;
              last^.next:=nonum;
           end else
           rootdef:=nonum;
      end;

      procedure tunitsymtable.concattypestabto(asmlist : paasmoutput);
        var prev_dbx_count : plongint;
        begin
           if is_stab_written then exit;
           if not assigned(name) then name := stringdup('Main_program');
           if symtabletype = unitsymtable then
             begin
                unitid:=current_module^.unitcount;
                inc(current_module^.unitcount);
             end;
           asmlist^.concat(new(pai_asm_comment,init(strpnew('Begin unit '+name^
                  +' has index '+tostr(unitid)))));
           if use_dbx then
             begin
                if dbx_count_ok then
                  begin
                     asmlist^.insert(new(pai_asm_comment,init(strpnew('"repeated" unit '+name^
                              +' has index '+tostr(unitid)))));
                     do_count_dbx:=true;
                     asmlist^.concat(new(pai_stabs,init(strpnew('"'+name^+'",'
                       +tostr(N_EXCL)+',0,0,'+tostr(dbx_count)))));
                     exit;
                  end;
                prev_dbx_count := dbx_counter;
                dbx_counter := nil;
                if symtabletype = unitsymtable then
                  asmlist^.concat(new(pai_stabs,init(strpnew('"'+name^+'",'
                    +tostr(N_BINCL)+',0,0,0'))));
                dbx_counter := @dbx_count;
             end;
           asmoutput:=asmlist;
           {$ifdef tp}
             foreach(concattypestab);
           {$else}
             foreach(@concattypestab);
           {$endif}
           if use_dbx then
             begin
                dbx_counter := prev_dbx_count;
                do_count_dbx:=true;
                asmlist^.concat(new(pai_stabs,init(strpnew('"'+name^+'",'
                  +tostr(N_EINCL)+',0,0,0'))));
                dbx_count_ok := true;
             end;
           asmlist^.concat(new(pai_asm_comment,init(strpnew('End unit '+name^
                  +' has index '+tostr(unitid)))));
           is_stab_written:=true;
        end;
{$endif}

{****************************************************************************
                              Definitions
****************************************************************************}

{$I symdef.inc}

{****************************************************************************
                                Symbols
****************************************************************************}

{$I symsym.inc}

{****************************************************************************
                               GDB Helpers
****************************************************************************}

{$ifdef GDB}
    function typeglobalnumber(const s : string) : string;

      var st : string;
          symt : psymtable;
          old_make_ref : boolean;
      begin
         old_make_ref:=make_ref;
         make_ref:=false;
         typeglobalnumber := '0';
         srsym := nil;
         if pos('.',s) > 0 then
           begin
           st := copy(s,1,pos('.',s)-1);
           getsym(st,false);
           st := copy(s,pos('.',s)+1,255);
           if assigned(srsym) then
             begin
             if srsym^.typ = unitsym then
               begin
               symt := punitsym(srsym)^.unitsymtable;
               srsym := symt^.search(st);
               end else srsym := nil;
             end;
           end else st := s;
         if srsym = nil then getsym(st,true);
         if srsym^.typ<>typesym then
           begin
             Message(type_e_type_id_expected);
             exit;
           end;
         typeglobalnumber := ptypesym(srsym)^.definition^.numberstring;
         make_ref:=old_make_ref;
      end;


   procedure reset_gdb_info;
     var
       def : pdef;
     begin
        def:=firstglobaldef;
        {if not current_module^.in_implementation then
          GlobalTypeCount:=1;
        let all units use the same
        numbering
        this does not hurt I hope PM }
        pglobaltypecount:=@globaltypecount;
        while assigned(def) do
          begin
            if assigned(def^.sym) then
              def^.sym^.isusedinstab:=false;
            def^.is_def_stab_written:=false;
            if not current_module^.in_implementation then
              begin
                {def^.globalnb:=0;}
                case def^.deftype of
               orddef : porddef(def)^.rangenr:=0;
             arraydef : parraydef(def)^.rangenr:=0;
                end;
              end;
            def:=def^.nextglobal;
          end;
     end;
{$endif GDB}


{****************************************************************************
                              Object Helpers
****************************************************************************}

    function search_class_member(pd : pobjectdef;const n : string) : psym;
    { searches n in symtable of pd and all anchestors }
      var
         sym : psym;
      begin
         sym:=nil;
         while assigned(pd) do
           begin
              sym:=pd^.publicsyms^.search(n);
              if assigned(sym) then
                break;
              pd:=pd^.childof;
           end;
         search_class_member:=sym;
      end;

   var
      _defaultprop : ppropertysym;

   procedure testfordefaultproperty(p : psym);
     begin
        if (p^.typ=propertysym) and ((ppropertysym(p)^.options and ppo_defaultproperty)<>0) then
          _defaultprop:=ppropertysym(p);
     end;


   function search_default_property(pd : pobjectdef) : ppropertysym;
   { returns the default property of a class, searches also anchestors }
     begin
        _defaultprop:=nil;
        while assigned(pd) do
          begin
           {$ifdef tp}
             pd^.publicsyms^.foreach(testfordefaultproperty);
           {$else}
             pd^.publicsyms^.foreach(@testfordefaultproperty);
           {$endif}
             if assigned(_defaultprop) then
               break;
             pd:=pd^.childof;
          end;
        search_default_property:=_defaultprop;
     end;

{****************************************************************************
                               Macro's
****************************************************************************}

      procedure def_macro(const s : string);
        var
          mac : pmacrosym;
        begin
           mac:=pmacrosym(macros^.search(s));
           if mac=nil then
             begin
               mac:=new(pmacrosym,init(s));
               Message1(parser_m_macro_defined,mac^.name);
               macros^.insert(mac);
             end;
           mac^.defined:=true;
        end;


      procedure set_macro(const s : string;value : string);
        var
          mac : pmacrosym;
        begin
           mac:=pmacrosym(macros^.search(s));
           if mac=nil then
             begin
               mac:=new(pmacrosym,init(s));
               macros^.insert(mac);
             end
           else
             begin
                if assigned(mac^.buftext) then
                  freemem(mac^.buftext,mac^.buflen);
             end;
           Message2(parser_m_macro_set_to,mac^.name,value);
           mac^.buflen:=length(value);
           getmem(mac^.buftext,mac^.buflen);
           move(value[1],mac^.buftext^,mac^.buflen);
           mac^.defined:=true;
        end;


{****************************************************************************
                               Browser
****************************************************************************}

{$ifdef UseBrowser}
   procedure write_browser_log;
     var
       p : psymtable;
     begin
       Browse.CreateLog;
       p:=symtablestack;
       while assigned(p) do
        begin
          if p^.symtabletype in [globalsymtable,staticsymtable,unitsymtable] then
           p^.writebrowserlog;
          p:=p^.next;
        end;
       Browse.CloseLog;
     end;
{$endif}


{****************************************************************************
                            Symtable Stack
****************************************************************************}

    procedure dellexlevel;
      var
         p : psymtable;
      begin
         p:=symtablestack;
         symtablestack:=p^.next;
         { symbol tables of unit interfaces are never disposed }
         { this is handle by the unit unitm                    }
         if not(p^.symtabletype in [unitsymtable,globalsymtable,stt_exceptsymtable]) or dispose_global then
          dispose(p,done);
      end;

{$ifdef DEBUG}
    procedure test_symtablestack;
      var
         p : psymtable;
         i : longint;
      begin
         p:=symtablestack;
         i:=0;
         while assigned(p) do
           begin
              inc(i);
              p:=p^.next;
              if i>500 then
               Message(sym_f_internal_error_in_symtablestack);
           end;
      end;

    procedure list_symtablestack;
      var
         p : psymtable;
         i : longint;
      begin
         p:=symtablestack;
         i:=0;
         while assigned(p) do
           begin
              inc(i);
              writeln(i,' ',p^.name^);
              p:=p^.next;
              if i>500 then
               Message(sym_f_internal_error_in_symtablestack);
           end;
      end;
{$endif DEBUG}


{****************************************************************************
                           Init/Done Symtable
****************************************************************************}

{$ifdef tp}
   procedure do_streamerror;
     begin
       if symbolstream.status=-2 then
        WriteLn('Error: Not enough EMS memory')
       else
        WriteLn('Error: EMS Error ',symbolstream.status);
       halt(1);
     end;
{$endif TP}

   procedure InitSymtable;
     begin
{$ifdef TP}
     { Allocate stream }
        if use_big then
         begin
           streamerror:=@do_streamerror;
         { symbolstream.init('TMPFILE',stcreate,16000); }
         {$ifndef dpmi}
           symbolstream.init(10000,4000000); {using ems streams}
         {$else}
           symbolstream.init(1000000,16000); {using memory streams}
         {$endif}
           if symbolstream.errorinfo=stiniterror then
            do_streamerror;
         { write something, because pos 0 means nil pointer }
           symbolstream.writestr(@inputfile);
         end;
{$endif tp}
      { Reset symbolstack }
        registerdef:=false;
        read_member:=false;
        symtablestack:=nil;
        sroot:=nil;
{$ifdef GDB}
        firstglobaldef:=nil;
        lastglobaldef:=nil;
{$endif GDB}
        globaltypecount:=1;
        pglobaltypecount:=@globaltypecount;
     { create error syms and def }
        generrorsym:=new(perrorsym,init);
        generrordef:=new(perrordef,init);
     end;


   procedure DoneSymtable;
      begin
        dispose(generrorsym,done);
        dispose(generrordef,done);
      { unload all symtables }
        dispose_global:=true;
        while assigned(symtablestack) do
          dellexlevel;
{$ifdef TP}
      { close the stream }
        if use_big then
         symbolstream.done;
{$endif}
     end;

end.
{
  $Log: symtable.pas,v $
  Revision 1.70  1998/09/09 11:50:57  pierre
    * forward def are not put in record or objects
    + added check for forwards also in record and objects
    * dummy parasymtable for unit initialization removed from
    symtable stack

  Revision 1.69  1998/09/07 23:10:25  florian
    * a lot of stuff fixed regarding rtti and publishing of properties,
      basics should now work

  Revision 1.68  1998/09/07 19:33:26  florian
    + some stuff for property rtti added:
       - NameIndex of the TPropInfo record is now written correctly
       - the DEFAULT/NODEFAULT keyword is supported now
       - the default value and the storedsym/def are now written to
         the PPU fiel

  Revision 1.67  1998/09/07 18:46:14  peter
    * update smartlinking, uses getdatalabel
    * renamed ptree.value vars to value_str,value_real,value_set

  Revision 1.66  1998/09/07 17:37:05  florian
    * first fixes for published properties

  Revision 1.65  1998/09/06 22:42:03  florian
    + rtti genreation for properties added

  Revision 1.64  1998/09/05 22:11:04  florian
    + switch -vb
    * while/repeat loops accept now also word/longbool conditions
    * makebooltojump did an invalid ungetregister32, fixed

  Revision 1.63  1998/09/04 17:34:23  pierre
    * bug with datalabel corrected
    + assembler errors better commented
    * one nested record crash removed

  Revision 1.62  1998/09/04 08:42:10  peter
    * updated some error messages

  Revision 1.61  1998/09/03 16:03:21  florian
    + rtti generation
    * init table generation changed

  Revision 1.60  1998/09/01 17:39:52  peter
    + internal constant functions

  Revision 1.59  1998/09/01 12:53:27  peter
    + aktpackenum

  Revision 1.58  1998/09/01 07:54:26  pierre
    * UseBrowser a little updated (might still be buggy !!)
    * bug in psub.pas in function specifier removed
    * stdcall allowed in interface and in implementation
      (FPC will not yet complain if it is missing in either part
      because stdcall is only a dummy !!)

  Revision 1.57  1998/08/31 12:26:33  peter
    * m68k and palmos updates from surebugfixes

  Revision 1.56  1998/08/21 14:08:55  pierre
    + TEST_FUNCRET now default (old code removed)
      works also for m68k (at least compiles)

  Revision 1.55  1998/08/21 08:43:32  pierre
    * pocdecl and poclearstack are now different
      external must but written as last specification

  Revision 1.54  1998/08/20 09:26:48  pierre
    + funcret setting in underproc testing
      compile with _dTEST_FUNCRET

  Revision 1.53  1998/08/19 18:04:56  peter
    * fixed current_module^.in_implementation flag

  Revision 1.51  1998/08/18 14:17:12  pierre
    * bug about assigning the return value of a function to
      a procvar fixed : warning
      assigning a proc to a procvar need @ in FPC mode !!
    * missing file/line info restored

  Revision 1.50  1998/08/17 10:10:13  peter
    - removed OLDPPU

  Revision 1.49  1998/08/12 19:39:31  peter
    * fixed some crashes

  Revision 1.48  1998/08/10 14:50:32  peter
    + localswitches, moduleswitches, globalswitches splitting

  Revision 1.47  1998/08/10 10:00:19  peter
    * Moved symbolstream to symtable.pas

  Revision 1.46  1998/08/08 10:19:19  florian
    * small fixes to write the extended type correct

  Revision 1.45  1998/08/02 16:42:00  florian
    * on o : tobject do should also work now, the exceptsymtable shouldn't be
      disposed by dellexlevel

  Revision 1.44  1998/07/30 11:18:21  florian
    + first implementation of try ... except on .. do end;
    * limitiation of 65535 bytes parameters for cdecl removed

  Revision 1.43  1998/07/28 21:52:56  florian
    + implementation of raise and try..finally
    + some misc. exception stuff

  Revision 1.42  1998/07/20 10:23:03  florian
    * better ansi string assignement

  Revision 1.41  1998/07/18 22:54:31  florian
    * some ansi/wide/longstring support fixed:
       o parameter passing
       o returning as result from functions

  Revision 1.40  1998/07/14 14:47:09  peter
    * released NEWINPUT

  Revision 1.39  1998/07/10 00:00:06  peter
    * fixed ttypesym bug finally
    * fileinfo in the symtable and better using for unused vars

  Revision 1.38  1998/07/07 11:20:17  peter
    + NEWINPUT for a better inputfile and scanner object

  Revision 1.37  1998/06/24 14:48:42  peter
    * ifdef newppu -> ifndef oldppu

  Revision 1.36  1998/06/17 14:10:19  peter
    * small os2 fixes
    * fixed interdependent units with newppu (remake3 under linux works now)

  Revision 1.35  1998/06/16 08:56:35  peter
    + targetcpu
    * cleaner pmodules for newppu

  Revision 1.34  1998/06/15 15:38:12  pierre
    * small bug in systems.pas corrected
    + operators in different units better hanlded

  Revision 1.33  1998/06/15 14:10:53  daniel
  * File was ruined, fixed.

  Revision 1.31  1998/06/13 00:10:20  peter
    * working browser and newppu
    * some small fixes against crashes which occured in bp7 (but not in
      fpc?!)

  Revision 1.30  1998/06/09 16:01:53  pierre
    + added procedure directive parsing for procvars
      (accepted are popstack cdecl and pascal)
    + added C vars with the following syntax
      var C calias 'true_c_name';(can be followed by external)
      reason is that you must add the Cprefix

      which is target dependent

  Revision 1.29  1998/06/07 15:30:26  florian
    + first working rtti
    + data init/final. for local variables

  Revision 1.28  1998/06/06 09:27:39  peter
    * new depend file generated

  Revision 1.27  1998/06/05 14:37:38  pierre
    * fixes for inline for operators
    * inline procedure more correctly restricted

  Revision 1.26  1998/06/04 23:52:03  peter
    * m68k compiles
    + .def file creation moved to gendef.pas so it could also be used
      for win32

  Revision 1.25  1998/06/04 09:55:48  pierre
    * demangled name of procsym reworked to become independant of the
      mangling scheme

  Revision 1.24  1998/06/03 22:49:04  peter
    + wordbool,longbool
    * rename bis,von -> high,low
    * moved some systemunit loading/creating to psystem.pas

  Revision 1.23  1998/05/28 14:40:30  peter
    * fixes for newppu, remake3 works now with it

  Revision 1.22  1998/05/27 19:45:09  peter
    * symtable.pas splitted into includefiles
    * symtable adapted for $ifndef OLDPPU

  Revision 1.21  1998/05/23 01:21:31  peter
    + aktasmmode, aktoptprocessor, aktoutputformat
    + smartlink per module $SMARTLINK-/+ (like MMX) and moved to aktswitches
    + $LIBNAME to set the library name where the unit will be put in
    * splitted cgi386 a bit (codeseg to large for bp7)
    * nasm, tasm works again. nasm moved to ag386nsm.pas

  Revision 1.20  1998/05/21 19:33:37  peter
    + better procedure directive handling and only one table

  Revision 1.19  1998/05/20 09:42:37  pierre
    + UseTokenInfo now default
    * unit in interface uses and implementation uses gives error now
    * only one error for unknown symbol (uses lastsymknown boolean)
      the problem came from the label code !
    + first inlined procedures and function work
      (warning there might be allowed cases were the result is still wrong !!)
    * UseBrower updated gives a global list of all position of all used symbols
      with switch -gb

  Revision 1.18  1998/05/11 13:07:57  peter
    + $ifndef OLDPPU for the new ppuformat
    + $define GDB not longer required
    * removed all warnings and stripped some log comments
    * no findfirst/findnext anymore to remove smartlink *.o files

  Revision 1.17  1998/05/06 08:38:48  pierre
    * better position info with UseTokenInfo
      UseTokenInfo greatly simplified
    + added check for changed tree after first time firstpass
      (if we could remove all the cases were it happen
      we could skip all firstpass if firstpasscount > 1)
      Only with ExtDebug

  Revision 1.16  1998/05/05 15:24:20  michael
  * Fix to save units with classes.

  Revision 1.15  1998/05/04 17:54:29  peter
    + smartlinking works (only case jumptable left todo)
    * redesign of systems.pas to support assemblers and linkers
    + Unitname is now also in the PPU-file, increased version to 14

  Revision 1.14  1998/05/01 16:38:46  florian
    * handling of private and protected fixed
    + change_keywords_to_tp implemented to remove
      keywords which aren't supported by tp
    * break and continue are now symbols of the system unit
    + widestring, longstring and ansistring type released

  Revision 1.13  1998/05/01 09:01:25  florian
    + correct semantics of private and protected
    * small fix in variable scope:
       a id can be used in a parameter list of a method, even it is used in
       an anchestor class as field id

  Revision 1.12  1998/05/01 07:43:57  florian
    + basics for rtti implemented
    + switch $m (generate rtti for published sections)

  Revision 1.11  1998/04/30 15:59:42  pierre
    * GDB works again better :
      correct type info in one pass
    + UseTokenInfo for better source position
    * fixed one remaining bug in scanner for line counts
    * several little fixes

  Revision 1.10  1998/04/29 10:34:05  pierre
    + added some code for ansistring (not complete nor working yet)
    * corrected operator overloading
    * corrected nasm output
    + started inline procedures
    + added starstarn : use ** for exponentiation (^ gave problems)
    + started UseTokenInfo cond to get accurate positions

  Revision 1.9  1998/04/27 23:10:29  peter
    + new scanner
    * $makelib -> if smartlink
    * small filename fixes pmodule.setfilename
    * moved import from files.pas -> import.pas

  Revision 1.8  1998/04/21 10:16:48  peter
    * patches from strasbourg
    * objects is not used anymore in the fpc compiled version

  Revision 1.7  1998/04/13 22:20:36  florian
    + stricter checking for duplicate id, solves also bug0097

  Revision 1.6  1998/04/13 17:20:43  florian
    * tdef.done much faster implemented

  Revision 1.5  1998/04/10 21:36:56  florian
    + some stuff to support method pointers (procedure of object) added
      (declaration, parameter handling)

  Revision 1.4  1998/04/08 16:58:08  pierre
    * several bugfixes
      ADD ADC and AND are also sign extended
      nasm output OK (program still crashes at end
      and creates wrong assembler files !!)
      procsym types sym in tdef removed !!

  Revision 1.3  1998/04/07 13:19:52  pierre
    * bugfixes for reset_gdb_info
      in MEM parsing for go32v2
      better external symbol creation
      support for rhgdb.exe (lowercase file names)

  Revision 1.2  1998/04/06 13:09:04  daniel
  * Emergency solution for bug in reset_gdb_info.
}

