{
    $Id: options.pas,v 1.41 1998/09/03 11:21:51 peter Exp $
    Copyright (c) 1993-98 by the FPC development team

    Reads command line options and config files

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************
}
unit options;

interface

uses
  verbose;

type
  POption=^TOption;
  TOption=object
    FirstPass,
    NoPressEnter,
    Logowritten : boolean;
    FileLevel : longint;
    Constructor Init;
    Destructor Done;
    procedure WriteLogo;
    procedure WriteInfo;
    procedure WriteHelpPages;
    procedure IllegalPara(const opt:string);
    function  Setbool(const opts:string):boolean;
    procedure interpret_proc_specific_options(const opt:string);virtual;
    procedure interpret_option(const opt :string);
    procedure Interpret_file(const filename : string);
    procedure Read_Parameters;
    procedure parsecmd(cmd:string);
  end;

procedure read_arguments(const cmd:string);


implementation

uses
  dos,cobjects,comphook,systems,globals,
  scanner,link,messages,gendef
{$ifdef UseBrowser}
  ,browser
{$endif}
{$ifdef i386}
  ,opts386
{$endif}
{$ifdef m68k}
  ,opts68k
{$endif}
  ;

const
  page_size = 24;
{$ifdef i386}
  ppccfg : string = 'ppc386.cfg';
{$else}
  ppccfg : string = 'ppc.cfg';
{$endif}

var
  read_configfile,          { read config file, set when a cfgfile is found }
  target_is_set : boolean;  { do not allow contradictory target settings }
  msgfilename,
  param_file    : string;   { file to compile specified on the commandline }
  option        : poption;

{****************************************************************************
                                 Defines
****************************************************************************}

procedure def_symbol(const s : string);
begin
  if s='' then
   exit;
  initdefines.concat(new(pstring_item,init(upper(s))));
end;


procedure undef_symbol(const s : string);
var
  item,next : pstring_item;
begin
  if s='' then
   exit;
  item:=pstring_item(initdefines.first);
  while assigned(item) do
   begin
     if (item^.str^=s) then
      begin
        next:=pstring_item(item^.next);
        initdefines.remove(item);
        item:=next;
      end
     else
      if item<>pstring_item(item^.next) then
       item:=pstring_item(item^.next)
      else
       break;
   end;
end;


function check_symbol(const s:string):boolean;
var
  hp : pstring_item;
begin
  hp:=pstring_item(initdefines.first);
  while assigned(hp) do
   begin
     if (hp^.str^=s) then
      begin
        check_symbol:=true;
        exit;
      end;
     hp:=pstring_item(hp^.next);
   end;
  check_symbol:=false;
end;

{****************************************************************************
                                 Toption
****************************************************************************}

procedure Toption.WriteLogo;
var
  i : tmsgconst;
begin
  if Logowritten then
   exit;
  for i:=option_logo_start to option_logo_end do
   Message1(i,target_string);
  Logowritten:=true;
end;


procedure Toption.WriteInfo;
var
  i : tmsgconst;
begin
  for i:=option_info_start to option_info_end do
   Message(i);
  Stop;
end;


procedure Toption.WriteHelpPages;

  function PadEnd(s:string;i:longint):string;
  begin
    while (length(s)<i) do
     s:=s+' ';
    PadEnd:=s;
  end;

var
  idx,
  lastident,
  j,outline,
  ident,
  lines : longint;
  show  : boolean;
  opt   : string[32];
  input,
  s     : string;
begin
  Message1(option_usage,paramstr(0));
  lastident:=0;
  if logowritten then
   lines:=3
  else
   lines:=1;
  for idx:=ord(ol_begin) to ord(ol_end) do
   begin
   { get a line and reset }
     s:=msg^.Get(idx);
     ident:=0;
     show:=false;
   { parse options }
     case s[1] of
{$ifdef i386}
      '3',
{$endif}
{$ifdef m68k}
      '6',
{$endif}
      '*' : show:=true;
     end;
     if show then
      begin
        case s[2] of
{$ifdef TP}
         't',
{$endif}
{$ifdef GDB}
         'g',
{$endif}
{$ifdef linux}
         'L',
{$endif}
{$ifdef os2}
         'O',
{$endif}
         '*' : show:=true;
        else
         show:=false;
        end;
      end;
   { now we may show the message or not }
     if show then
      begin
        case s[3] of
         '0' : begin
                 ident:=0;
                 outline:=0;
               end;
         '1' : begin
                 ident:=2;
                 outline:=7;
               end;
         '2' : begin
                 ident:=11;
                 outline:=11;
               end;
         '3' : begin
                 ident:=21;
                 outline:=6;
               end;
        end;
        j:=pos('_',s);
        opt:=Copy(s,4,j-4);
        if opt='*' then
         opt:=''
        else
         opt:=PadEnd('-'+opt,outline);
        if (ident=0) and (lastident<>0) then
         begin
           Comment(V_Normal,'');
           inc(Lines);
         end;
      { page full ? }
        if (lines>=page_size) then
         begin
           if not NoPressEnter then
            begin
              write('*** press enter ***');
              readln(input);
              if upper(input)='Q' then
               stop;
            end;
           lines:=0;
         end;
        Comment(V_Normal,PadEnd('',ident)+opt+Copy(s,j+1,255));
        LastIdent:=Ident;
        inc(Lines);
      end;
   end;
  stop;
end;


procedure Toption.IllegalPara(const opt:string);
begin
  Message1(option_illegal_para,opt);
  Message(option_help_pages_para);
  stop;
end;


function Toption.Setbool(const opts:string):boolean;
var
  i : longint;
begin
  SetBool:=true;
  for i:=3 to length(opts) do
   case opts[i] of
    '-' : SetBool:=false;
    '+' : SetBool:=true;
   else
    IllegalPara(opts);
   end;
end;


procedure TOption.interpret_proc_specific_options(const opt:string);
begin
end;


procedure TOption.interpret_option(const opt:string);
var
  code : word;
  c    : char;
  more : string;
  j    : longint;
  d    : DirStr;
  e    : ExtStr;
begin
  if opt='' then
   exit;
  case opt[1] of
 '-' : begin
         more:=Copy(opt,3,255);
         case opt[2] of
              '?' : WriteHelpPages;
              'a' : begin
                      initglobalswitches:=initglobalswitches+[cs_asm_leave];
                      for j:=1 to length(more) do
                       case more[j] of
                        'l' : initglobalswitches:=initglobalswitches+[cs_asm_source];
                       else
                         IllegalPara(opt);
                       end;
                    end;
{$ifdef UseBrowser}
              'b' : begin
                      initmoduleswitches:=initmoduleswitches+[cs_browser];
                      if More<>'' then
                       Browse.SetFileName(More);
                    end;
{$endif UseBrowser}
              'B' : if more='' then
                     do_build:=true
                    else
                     IllegalPara(opt);
              'C' : begin
                      for j:=1 to length(more) do
                       case more[j] of
                        'D' : begin
                                initmoduleswitches:=initmoduleswitches+[cs_create_sharedlib];
                                initmoduleswitches:=initmoduleswitches-[cs_create_staticlib];
{$ifdef i386}
                                if target_info.target in [target_GO32V1,target_GO32V2] then
                                 begin
                                   Message(option_no_shared_lib_under_dos);
                                   initmoduleswitches:=initmoduleswitches+[cs_create_staticlib];
                                   initmoduleswitches:=initmoduleswitches-[cs_create_sharedlib];
                                 end;
{$endif}
                               end;
                         'h' : begin
                                 val(copy(more,j+1,length(more)-j),heapsize,code);
                                 if (code<>0) or (heapsize>=67107840) or (heapsize<1024) then
                                  IllegalPara(opt);
                                 break;
                               end;
                         'i' : initlocalswitches:=initlocalswitches+[cs_check_io];
                         'n' : initglobalswitches:=initglobalswitches+[cs_link_extern];
                         'o' : initlocalswitches:=initlocalswitches+[cs_check_overflow];
                         'r' : initlocalswitches:=initlocalswitches+[cs_check_range];
                         's' : begin
                                 val(copy(more,j+1,length(more)-j),stacksize,code);
                                 if (code<>0) or (stacksize>=67107840) or (stacksize<1024) then
                                  IllegalPara(opt);
                                 break;
                               end;
                         't' : initlocalswitches:=initlocalswitches+[cs_check_stack];
                         'x' : initmoduleswitches:=initmoduleswitches+[cs_smartlink];
                         'S' : begin
                                 initmoduleswitches:=initmoduleswitches+[cs_create_staticlib];
                                 initmoduleswitches:=initmoduleswitches-[cs_create_sharedlib];
                               end;
                       else
                         IllegalPara(opt);
                       end;
                    end;
              'd' : def_symbol(more);
              'D' : begin
                      initglobalswitches:=initglobalswitches+[cs_link_deffile];
                      for j:=1 to length(more) do
                       case more[j] of
                        'd' : begin
                                description:=Copy(more,j+1,255);
                                break;
                              end;
                        'w' : usewindowapi:=true;
                       else
                         IllegalPara(opt);
                       end;
                    end;
              'e' : exepath:=FixPath(More);
              { Just used by RHIDE }
              'E' : if (length(more)=0) or (more[1]='-') then
                      initglobalswitches:=initglobalswitches+[cs_link_extern]
                    else
                      initglobalswitches:=initglobalswitches-[cs_link_extern];
              'F' : begin
                      c:=more[1];
                      Delete(more,1,1);
                      case c of
                       'e' : SetRedirectFile(More);
                       'i' : AddPathToList(includesearchpath,More,not firstpass);
                       'g',
                       'l' : AddPathToList(Linker.LibrarySearchPath,More,not firstpass);
                       'L' : if More<>'' then
                              Linker.DynamicLinker:=More
                             else
                              IllegalPara(opt);
                       'o' : AddPathToList(objectsearchpath,More,not firstpass);
                       'r' : Msgfilename:=More;
                       'u' : AddPathToList(unitsearchpath,More,not firstpass);
                      else
                        IllegalPara(opt);
                      end;
                    end;
              'g' : begin
{$ifdef GDB}
                      initmoduleswitches:=initmoduleswitches+[cs_debuginfo];
                      for j:=1 to length(more) do
                       case more[j] of
                        'd' : use_dbx:=true;
                        'g' : use_gsym:=true;
{$ifdef EXTDEBUG}
                        'p' : only_one_pass:=true;
{$endif EXTDEBUG}
                       else
                         IllegalPara(opt);
                       end;
{$else GDB}
                      Message(option_no_debug_support);
                      Message(option_no_debug_support_recompile_fpc);
{$endif GDB}
                    end;
              'h' : begin
                      NoPressEnter:=true;
                      WriteHelpPages;
                    end;
              'i' : if more='' then
                     WriteInfo
                    else
                     IllegalPara(Opt);
              'I' : AddPathToList(includesearchpath,More,not firstpass);
              'k' : if more<>'' then
                     Linker.LinkOptions:=Linker.LinkOptions+' '+More
                    else
                     IllegalPara(opt);
              'l' : if more='' then
                     WriteLogo
                    else
                     IllegalPara(opt);
              'n' : if More='' then
                     read_configfile:=false
                    else
                     IllegalPara(opt);
              'o' : if More<>'' then
                     Fsplit(More,d,OutputFile,e)
                    else
                     IllegalPara(opt);
              'p' :
{$ifdef Splitheap}
                  if length(opt)=2 then
                     testsplit:=true
                    else
{$endif Splitheap}
                   begin
                     case more[1] of
                      'g' : initmoduleswitches:=initmoduleswitches+[cs_profile];
                     else
                      IllegalPara(opt);
                     end;
                   end;
{$ifdef linux}
              'P' : initglobalswitches:=initglobalswitches+[cs_asm_pipe];
{$endif}
              's' : initglobalswitches:=initglobalswitches+[cs_asm_extern,cs_link_extern];
              'S' : begin
                      for j:=1 to length(more) do
                       case more[j] of
                        '2' : begin
                                initmoduleswitches:=initmoduleswitches+[cs_delphi2_compatible];
                                initglobalswitches:=initglobalswitches+[cs_load_objpas_unit]
                              end;
                        'c' : initmoduleswitches:=initmoduleswitches+[cs_support_c_operators];
                        'd' : dispose_asm_lists:=true;
                        'e' : status.MaxErrorCount:=1;
                        'g' : initmoduleswitches:=initmoduleswitches+[cs_support_goto];
                        'i' : initmoduleswitches:=initmoduleswitches+[cs_support_inline];
                        'm' : initmoduleswitches:=initmoduleswitches+[cs_support_macro];
                        'o':  begin
                                initmoduleswitches:=initmoduleswitches+[cs_tp_compatible];
                                change_to_tp_keywords;
                              end;
                        'p' : begin
                                initmoduleswitches:=initmoduleswitches+[cs_gpc_compatible];
                                initglobalswitches:=initglobalswitches+[cs_load_gpc_unit]
                              end;
                        's' : initglobalswitches:=initglobalswitches+[cs_constructor_name];
                        't' : initglobalswitches:=initglobalswitches+[cs_static_keyword];
                        'v' : initmoduleswitches:=initmoduleswitches+[cs_support_c_var];
                       else
                        IllegalPara(opt);
                       end;
                    end;
              'T' : begin
                      more:=Upper(More);
                      if not target_is_set then
                       begin
                       { her we should undefine the default target }
                         undef_symbol(target_info.short_name);
                         if not(set_string_target(More)) then
                          IllegalPara(opt);
                         def_symbol(target_info.short_name);
                         target_is_set:=true;
                       end
                      else
                       if More<>target_info.short_name then
                        Message1(option_target_is_already_set,target_info.short_name)
                       else if FileLevel=0 then
                          { VERY important !!
                            sets the default assembler back PM }
                            begin
                               set_string_target(More);
                            end;
                    end;
              'u' : undef_symbol(upper(More));
              'U' : begin
                      for j:=1 to length(more) do
                       case more[j] of
                        'n' : initglobalswitches:=initglobalswitches+[cs_check_unit_name];
                        'p' : begin
                                AddPathToList(unitsearchpath,Copy(More,j+1,255),not firstpass);
                                break;
                              end;
                        's' : initmoduleswitches:=initmoduleswitches+[cs_compilesystem];
                       else
                         IllegalPara(opt);
                       end;
                    end;
              'v' : if not setverbosity(More) then
                     IllegalPara(opt);
              'X' : begin
                      for j:=1 to length(More) do
                       case More[j] of
                        'c' : Linker.LinkToC:=true;
                        's' : Linker.Strip:=true;
                        'D' : begin
                                def_symbol('FPC_LINK_DYNAMIC');
                                undef_symbol('FPC_LINK_STATIC');
                                initglobalswitches:=initglobalswitches+[cs_link_shared];
                                initglobalswitches:=initglobalswitches-[cs_link_static];
                              end;
                        'S' : begin
                                def_symbol('FPC_LINK_STATIC');
                                undef_symbol('FPC_LINK_DYNAMIC');
                                initglobalswitches:=initglobalswitches-[cs_link_shared];
                                initglobalswitches:=initglobalswitches+[cs_link_static];
                              end;
                       else
                         IllegalPara(opt);
                       end;
                    end;
       { give processor specific options a chance }
         else
          interpret_proc_specific_options(opt);
         end;
       end;
 '@' : begin
         Message(option_no_nested_response_file);
         Stop;
       end;
  else
   begin
     if (length(param_file)<>0) then
       Message(option_only_one_source_support);
     param_file:=opt;
   end;
  end;
end;


procedure Toption.Interpret_file(const filename : string);

  procedure RemoveSep(var fn:string);
  var
    i : longint;
  begin
    i:=0;
    while (i<length(fn)) and (fn[i+1] in [',',' ',#9]) do
     inc(i);
    Delete(fn,1,i);
  end;

  function GetName(var fn:string):string;
  var
    i : longint;
  begin
    i:=0;
    while (i<length(fn)) and (fn[i+1] in ['a'..'z','A'..'Z','0'..'9','_','-']) do
     inc(i);
    GetName:=Copy(fn,1,i);
    Delete(fn,1,i);
  end;

const
  maxlevel=16;
var
  f     : text;
  s,
  opts  : string;
  skip  : array[0..maxlevel-1] of boolean;
  level : byte;
begin
{ avoid infinite loop }
  Inc(FileLevel);
  If FileLevel>MaxLevel then
   Message(option_too_many_cfg_files);
{ open file }
  assign(f,filename);
  {$I-}
   reset(f);
  {$I+}
  if ioresult<>0 then
   begin
     Message1(option_unable_open_file,filename);
     exit;
   end;
  fillchar(skip,sizeof(skip),0);
  level:=0;
  while not eof(f) do
   begin
     readln(f,opts);
     RemoveSep(opts);
     if (opts<>'') then
      begin
        if opts[1]='#' then
         begin
           Delete(opts,1,1);
           s:=upper(GetName(opts));
           if (s='SECTION') then
            begin
              RemoveSep(opts);
              s:=upper(GetName(opts));
              if level=0 then
               skip[level]:=not (check_symbol(s) or (s='COMMON'));
            end
           else
            if (s='IFDEF') then
             begin
               RemoveSep(opts);
               if Level>=maxlevel then
                begin
                  Message(option_too_many_ifdef);
                  stop;
                end;
               inc(Level);
               skip[level]:=(skip[level-1] or (not check_symbol(upper(GetName(opts)))));
             end
           else
            if (s='IFNDEF') then
             begin
               RemoveSep(opts);
               if Level>=maxlevel then
                begin
                  Message(option_too_many_ifdef);
                  stop;
                end;
               inc(Level);
               skip[level]:=(skip[level-1] or (check_symbol(upper(GetName(opts)))));
             end
           else
            if (s='ELSE') then
             skip[level]:=skip[level-1] or (not skip[level])
           else
            if (s='ENDIF') then
             begin
               skip[level]:=false;
               if Level=0 then
                begin
                  Message(option_too_many_endif);
                  stop;
                end;
               dec(level);
             end
           else
            if (not skip[level]) then
             begin
               if (s='DEFINE') then
                begin
                  RemoveSep(opts);
                  def_symbol(upper(GetName(opts)));
                end
              else
               if (s='UNDEF') then
                begin
                  RemoveSep(opts);
                  undef_symbol(upper(GetName(opts)));
                end
              else
               if (s='WRITE') then
                begin
                  Delete(opts,1,1);
                  WriteLn(opts);
                end
              else
               if (s='INCLUDE') then
                begin
                  Delete(opts,1,1);
                  Interpret_file(opts);
                end;
            end;
         end
        else
         begin
           if (not skip[level]) and (opts[1]='-') then
            interpret_option(opts)
         end;
      end;
   end;
  if Level>0 then
   Message(option_too_less_endif);
  Close(f);
  Dec(FileLevel);
end;


procedure toption.read_parameters;
var
  opts       : string;
  paramindex : longint;
begin
  paramindex:=0;
  while paramindex<paramcount do
   begin
     inc(paramindex);
     opts:=paramstr(paramindex);
     if firstpass then
      begin
      { only parse define,undef,target,verbosity and link options }
        if (opts[1]='-') and (opts[2] in ['d','v','T','u','n','X']) then
         interpret_option(opts);
      end
     else
      begin
        if opts[1]='@' then
         begin
           Delete(opts,1,1);
           Message1(option_reading_further_from,opts);
           interpret_file(opts);
         end
        else
         interpret_option(opts);
      end;
   end;
end;


procedure toption.parsecmd(cmd:string);
var
  i    : longint;
  opts : string;
begin
  while (cmd<>'') do
   begin
     while cmd[1]=' ' do
      delete(cmd,1,1);
     i:=pos(' ',cmd);
     if i=0 then
      i:=255;
     opts:=Copy(cmd,1,i-1);
     Delete(cmd,1,i);
     if opts[1]='@' then
      begin
        Delete(opts,1,1);
        Message1(option_reading_further_from,opts);
        interpret_file(opts);
      end
     else
      interpret_option(opts);
   end;
end;


constructor TOption.Init;
begin
  LogoWritten:=false;
  NoPressEnter:=false;
  FirstPass:=false;
  FileLevel:=0;
end;


destructor TOption.Done;
begin
end;


{****************************************************************************
                              Callable Routines
****************************************************************************}

procedure read_arguments(const cmd:string);
var
  configpath : pathstr;
  option     : poption;
begin
{$ifdef i386}
  option:=new(poption386,Init);
{$else}
  {$ifdef m68k}
    option:=new(poption68k,Init);
  {$else}
    option:=new(poption,Init);
  {$endif}
{$endif}
{ Load messages }
  if (cmd='') and (paramcount=0) then
   Option^.WriteHelpPages;

{ default defines }
  def_symbol(target_info.short_name);
  def_symbol('FPK');
  def_symbol('FPC');
  def_symbol('VER'+version_nr);
  def_symbol('VER'+version_nr+'_'+release_nr);
  def_symbol('VER'+version_nr+'_'+release_nr+'_'+patch_nr);

{ Temporary defines, until things settle down }

{ some stuff for TP compatibility }
{$ifdef i386}
  def_symbol('CPU86');
  def_symbol('CPU87');
  if (target_info.target in [target_GO32V1,target_GO32V2]) then
   def_symbol('DPMI'); { MSDOS is not defined in BP when target is DPMI }
{$endif}
{$ifdef m68k}
  def_symbol('CPU68');
{$endif}

{ get default messagefile }
  msgfilename:=dos.getenv('PPC_ERROR_FILE');

{ Order to read ppc386.cfg:
   1 - current dir
   2 - configpath
   3 - compiler path }
  configpath:=FixPath(dos.getenv('PPC_CONFIG_PATH'));
{$ifdef linux}
  if configpath='' then
   configpath:='/etc/';
{$endif}
  read_configfile:=true;
  if not FileExists(ppccfg) then
   begin
{$ifdef linux}
     if (dos.getenv('HOME')<>'') and FileExists(FixPath(dos.getenv('HOME'))+'.'+ppccfg) then
      ppccfg:=FixPath(dos.getenv('HOME'))+'.'+ppccfg
     else
{$endif}
      if FileExists(configpath+ppccfg) then
       ppccfg:=configpath+ppccfg
     else
{$ifndef linux}
      if FileExists(exepath+ppccfg) then
       ppccfg:=exepath+ppccfg
     else
{$endif}
      read_configfile:=false;
   end;

{ Read commandline and configfile }
  target_is_set:=false;
  param_file:='';

  if cmd='' then
   begin
     if read_configfile then
      begin
      { read the parameters quick, only -v -T }
        option^.firstpass:=true;
        option^.read_parameters;
        if read_configfile then
         begin
{$ifdef EXTDEBUG}
           Comment(V_Debug,'read config file  #'+ppccfg+'#');
{$endif EXTDEBUG}
           option^.interpret_file(ppccfg);
         end;
      { Reread parameters to overwrite the options }
        option^.firstpass:=false;
        option^.read_parameters;
      end
     else
      begin
      { read full parameters }
        option^.firstpass:=false;
        option^.read_parameters;
      end;
   end
  else
   begin
     option^.firstpass:=false;
     option^.parsecmd(cmd);
   end;

{ Check file to compile }
  if param_file='' then
   begin
     Message(option_no_source_found);
     Stop;
   end;
{$ifndef linux}
  param_file:=FixFileName(param_file);
{$endif}
  fsplit(param_file,inputdir,inputfile,inputextension);
  if inputextension='' then
   begin
     if FileExists(inputdir+inputfile+target_os.sourceext) then
      inputextension:=target_os.sourceext
     else
      if FileExists(inputdir+inputfile+target_os.pasext) then
       inputextension:=target_os.pasext;
   end;

{ add unit environment and exepath to the unit search path }
  if inputdir<>'' then
   AddPathToList(Unitsearchpath,inputdir,true);
  AddPathToList(UnitSearchPath,dos.getenv(target_info.unit_env),false);
  AddPathToList(UnitSearchPath,ExePath,false);
{ Add Current Directory as the first path to search }
  AddPathToList(includesearchpath,'.',true);
  AddPathToList(unitsearchpath,'.',true);
  AddPathToList(objectsearchpath,unitsearchpath,false);
  AddPathToList(objectsearchpath,'.',true);
  AddPathToList(Linker.librarysearchpath,unitsearchpath,false);
  AddPathToList(Linker.librarysearchpath,'.',true);

  if msgfilename<>'' then
   LoadMsgFile(msgfilename);

  if (cs_link_deffile in aktglobalswitches) then
    deffile.init(inputdir+inputfile+'.def');

  dispose(option,Done);
end;


end.
{
  $Log: options.pas,v $
  Revision 1.41  1998/09/03 11:21:51  peter
    * -al sets cs_asm_source

  Revision 1.40  1998/08/31 08:50:32  peter
    * fixed default msgfile loading which is now in verbose.pas

  Revision 1.39  1998/08/29 13:52:38  peter
    + new messagefile
    * merged optione.msg into errore.msg

  Revision 1.38  1998/08/25 12:42:38  pierre
    * CDECL changed to CVAR for variables
      specifications are read in structures also
    + started adding GPC compatibility mode ( option  -Sp)
    * names changed to lowercase

  Revision 1.37  1998/08/20 16:10:52  pierre
    Q
    * Changed the -E switch to get better use of RHIDE v1.4.5

  Revision 1.36  1998/08/18 09:05:59  peter
    * new library options
    * smartlink is now -Cx

  Revision 1.35  1998/08/17 09:17:48  peter
    * static/shared linking updates

  Revision 1.34  1998/08/14 21:56:35  peter
    * setting the outputfile using -o works now to create static libs

  Revision 1.33  1998/08/10 23:53:47  peter
    * released all temporary defines

  Revision 1.32  1998/08/10 14:50:03  peter
    + localswitches, moduleswitches, globalswitches splitting

  Revision 1.30  1998/08/10 08:33:17  michael
  -d was destroyed by last comit

  Revision 1.29  1998/08/08 15:31:04  michael
  + Reinstated -e option for linux

  Revision 1.28  1998/07/17 10:06:18  michael
  + under linux, looking for ppc38.cfg in bindir removed.

  Revision 1.27  1998/07/07 11:19:58  peter
    + NEWINPUT for a better inputfile and scanner object

  Revision 1.26  1998/07/06 15:51:17  michael
  Added length checking for string reading

  Revision 1.25  1998/07/04 10:00:22  peter
    + define HAS_PROPERTY

  Revision 1.24  1998/07/01 15:28:49  peter
    + better writeln/readln handling, now 100% like tp7

  Revision 1.22  1998/06/13 00:10:07  peter
    * working browser and newppu
    * some small fixes against crashes which occured in bp7 (but not in
      fpc?!)

  Revision 1.21  1998/06/12 16:15:32  pierre
    * external name 'C_var';
      export name 'intern_C_var';
      cdecl;
      cdecl;external;
      are now supported only with -Sv switch

  Revision 1.20  1998/06/08 22:59:47  peter
    * smartlinking works for win32
    * some defines to exclude some compiler parts

  Revision 1.19  1998/06/04 23:51:46  peter
    * m68k compiles
    + .def file creation moved to gendef.pas so it could also be used
      for win32

  Revision 1.17  1998/05/25 17:11:40  pierre
    * firstpasscount bug fixed
      now all is already set correctly the first time
      under EXTDEBUG try -gp to skip all other firstpasses
      it works !!
    * small bug fixes
      - for smallsets with -dTESTSMALLSET
      - some warnings removed (by correcting code !)

  Revision 1.16  1998/05/23 01:21:12  peter
    + aktasmmode, aktoptprocessor, aktoutputformat
    + smartlink per module $SMARTLINK-/+ (like MMX) and moved to aktswitches
    + $LIBNAME to set the library name where the unit will be put in
    * splitted cgi386 a bit (codeseg to large for bp7)
    * nasm, tasm works again. nasm moved to ag386nsm.pas

  Revision 1.15  1998/05/20 09:42:34  pierre
    + UseTokenInfo now default
    * unit in interface uses and implementation uses gives error now
    * only one error for unknown symbol (uses lastsymknown boolean)
      the problem came from the label code !
    + first inlined procedures and function work
      (warning there might be allowed cases were the result is still wrong !!)
    * UseBrower updated gives a global list of all position of all used symbols
      with switch -gb

  Revision 1.14  1998/05/12 10:46:59  peter
    * moved printstatus to verb_def
    + V_Normal which is between V_Error and V_Warning and doesn't have a
      prefix like error: warning: and is included in V_Default
    * fixed some messages
    * first time parameter scan is only for -v and -T
    - removed old style messages

  Revision 1.13  1998/05/08 09:21:20  michael
  * Added missing -Fl message to messages file.
  * Corrected mangling of file names when doing Linklib
  * -Fl now actually WORKS.
  * Librarysearchpath is now a field in linker object.

  Revision 1.12  1998/05/06 08:38:41  pierre
    * better position info with UseTokenInfo
      UseTokenInfo greatly simplified
    + added check for changed tree after first time firstpass
      (if we could remove all the cases were it happen
      we could skip all firstpass if firstpasscount > 1)
      Only with ExtDebug

  Revision 1.11  1998/05/04 17:54:27  peter
    + smartlinking works (only case jumptable left todo)
    * redesign of systems.pas to support assemblers and linkers
    + Unitname is now also in the PPU-file, increased version to 14

  Revision 1.10  1998/05/01 16:38:44  florian
    * handling of private and protected fixed
    + change_keywords_to_tp implemented to remove
      keywords which aren't supported by tp
    * break and continue are now symbols of the system unit
    + widestring, longstring and ansistring type released

  Revision 1.9  1998/04/30 15:59:40  pierre
    * GDB works again better :
      correct type info in one pass
    + UseTokenInfo for better source position
    * fixed one remaining bug in scanner for line counts
    * several little fixes

  Revision 1.8  1998/04/27 15:45:20  peter
    + -Xl for smartlink
    + target_info.arext = .a

  Revision 1.7  1998/04/23 12:07:25  peter
    * fixed -i

  Revision 1.6  1998/04/08 16:58:03  pierre
    * several bugfixes
      ADD ADC and AND are also sign extended
      nasm output OK (program still crashes at end
      and creates wrong assembler files !!)
      procsym types sym in tdef removed !!

  Revision 1.5  1998/04/08 12:31:00  peter
    + .ppc386.cfg and #INCLUDE support

  Revision 1.4  1998/04/07 13:19:46  pierre
    * bugfixes for reset_gdb_info
      in MEM parsing for go32v2
      better external symbol creation
      support for rhgdb.exe (lowercase file names)
}
