{
    $Id: globals.pas,v 1.64 1998/09/10 15:25:29 daniel Exp $
    Copyright (C) 1993-98 by Florian Klaempfl

    This unit implements some support functions and global variables

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************
}

{$ifdef tp}
  {$E+,N+}
{$endif}

unit globals;

  interface

    uses
{$ifdef TP}
      objects,
{$endif}
      cobjects,systems,dos,strings
{$ifdef linux}
      ,linux
{$endif}
      ;

{$I version.inc}

    const
       { version string }
       wordversion = (0 shl 8)+99;

       version_nr = '0';
       release_nr = '99';
       patch_nr   = '8';
       version_string = version_nr+'.'+release_nr+'.'+patch_nr;
{$ifdef i386}
       target_string = 'i386';
{$endif}
{$ifdef m68k}
       target_string = 'M680x0';
{$endif}
{$ifdef alpha}
       target_string = 'Alpha';
{$endif}

{$ifdef FPC}
  {$ifndef VER0_99_5}
    {$ifndef VER0_99_6}
       date_string = {$I %DATE%};
    {$else}
       date_string = '';
    {$endif}
  {$else}
    date_string = '';
  {$endif}
{$else}
  date_string = '';
{$endif}

{$ifdef linux}
  DirSep = '/';
{$else}
  {$ifdef amiga}
    DirSep = '/';
  {$else}

    DirSep = '\';
  {$endif}
{$endif}

{$ifdef Splitheap}
       testsplit : boolean = false;
{$endif Splitheap}

       { max. significant length of strings }
       maxidlen = 64;

    type
       { I had to change the order for overloading
         can this be a problem ? (PM)

         It will be no problem, if you change also the array to convert
         tokens to strings (in PARSER.PAS) (FK)
       }

{***IMPLIBGEN}
       ttoken = (PLUS,MINUS,STAR,SLASH,EQUAL,GT,LT,GTE,LTE,_IS,_AS,_IN,
                 SYMDIF,STARSTAR,
                 ASSIGNMENT,CARET,UNEQUAL,LECKKLAMMER,RECKKLAMMER,
                 POINT,COMMA,LKLAMMER,RKLAMMER,COLON,SEMICOLON,
                 KLAMMERAFFE,POINTPOINT,
                 ID,REALNUMBER,_EOF,INTCONST,CSTRING,CCHAR,DOUBLEADDR,

{                _ABSOLUTE,}
                 _AND,_ARRAY,_ASM,_BEGIN,
                 _BREAK,_CASE,_CONST,_CONSTRUCTOR,_CONTINUE,
                 _DESTRUCTOR,_DISPOSE,_DIV,_DO,_DOWNTO,_ELSE,_END,
                 _EXIT,
{                _EXPORT,}
                 _EXTERNAL,_FAIL,_FALSE,
{                _FAR,}
                 _FILE,_FOR,
{                _FORWARD,}
                 _FUNCTION,_GOTO,_IF,_IMPLEMENTATION,
                 _INHERITED,
{                _INLINE,}
                 _INTERFACE,
{                _INTERRUPT,}
                 _LABEL,_MOD,
{                _NEAR,}
                 _NEW,_NIL,_NOT,_OBJECT,
                 _OF,_OTHERWISE,_OR,_PACKED,
                 _PROCEDURE,_PROGRAM,
                 _RECORD,_REPEAT,_SELF,
                 _SET,_SHL,_SHR,_STRING,_THEN,_TO,
                 _TRUE,_TYPE,_UNIT,_UNTIL,
                 _USES,_VAR,_WHILE,_WITH,_XOR,
                 { since Delphi 2 }
                 _CLASS,_EXCEPT,_TRY,_ON,
{                _ABSTRACT,}
                 _LIBRARY,_INITIALIZATION,_FINALIZATION,_FINALLY,
                 _EXPORTS,_PROPERTY,
                 _RAISE,
                 { for operator overloading }
                 _OPERATOR,

                 { C like operators }
                 _PLUSASN,_MINUSASN,_ANDASN,_ORASN,_STARASN,_SLASHASN,
                 _MODASN,_DIVASN,_NOTASN,_XORASN
                 );

       tblock_type = (bt_general,bt_type,bt_const);

       { Switches which can be changed locally }
       tlocalswitch = (cs_localnone,
         { codegen }
         cs_check_overflow,cs_check_range,cs_check_io,cs_check_stack,
         cs_omitstackframe,cs_do_assertion,cs_generate_rtti,
         { mmx }
         cs_mmx,cs_mmx_saturation,
         { parser }
         cs_typed_addresses,cs_strict_var_strings,cs_ansistrings
       );
       tlocalswitches=set of tlocalswitch;

       { Switches which can be changed only at the beginning of a new module }
       tmoduleswitch = (cs_modulenone,
         { parser }
         cs_fp_emulation,cs_extsyntax,
         cs_delphi2_compatible,cs_tp_compatible,
         cs_gpc_compatible,
         { support }
         cs_support_inline,cs_support_goto,cs_support_macro,
         cs_support_c_operators,cs_support_c_var,
         { generation }
         cs_profile,cs_debuginfo,cs_browser,cs_compilesystem,
         { linking }
         cs_smartlink,cs_create_sharedlib,cs_create_staticlib
       );
       tmoduleswitches=set of tmoduleswitch;

       { Switches which can be changed only for a whole program/compilation,
         mostly set with commandline }
       tglobalswitch = (cs_globalnone,
         { parameter switches }
         cs_check_unit_name,cs_constructor_name,cs_static_keyword,
         { units }
         cs_load_objpas_unit,
         cs_load_gpc_unit,
         { optimizer }
         cs_regalloc,cs_uncertainopts,cs_littlesize,cs_optimize,
         cs_fastoptimize, cs_slowoptimize,
         { assembling }
         cs_asm_leave,cs_asm_extern,cs_asm_pipe,cs_asm_source,
         { linking }
         cs_link_extern,cs_link_shared,cs_link_static,cs_link_deffile
       );
       tglobalswitches=set of tglobalswitch;

       stringid = string[maxidlen];

       tnormalset = set of byte; { 256 elements set }
       pnormalset = ^tnormalset;
       pdouble  = ^double;
       pbyte    = ^byte;
       pword    = ^word;
       plongint = ^longint;


    var
       { specified inputfile }
       inputdir       : dirstr;
       inputfile      : namestr;
       inputextension : extstr;
       { specified outputfile with -o parameter }
       outputfile     : namestr;
       { some flags for global compiler switches }
       do_build,
       do_make       : boolean;
       not_unit_proc : boolean;
       { path for searching units, different paths can be seperated by ; }
       exepath            : dirstr;  { Path to ppc }
       unitsearchpath,
       objectsearchpath,
       includesearchpath  : string;

       { deffile }
       usewindowapi  : boolean;
       description   : string;

       { current position }
       tokenpos,                     { last postion of the read token }
       aktfilepos : tfileposinfo;    { current position }

       { type of currently parsed block }
       { isn't full implemented (FK)    }
       block_type : tblock_type;

       in_args : boolean;                { arguments must be checked especially }
       parsing_para_level : longint;     { parameter level, used to convert
                                             proc calls to proc loads in firstcalln }
       Must_be_valid : boolean;          { should the variable already have a value }
       compile_level : word;
       make_ref : boolean;
       use_esp_stackframe : boolean;     { to test for call with ESP as stack frame }

{$ifdef TP}
       use_big      : boolean;
{$endif}

     { commandline values }
       initdefines        : tlinkedlist;
       initglobalswitches : tglobalswitches;
       initmoduleswitches : tmoduleswitches;
       initlocalswitches  : tlocalswitches;
       initpackenum,
       initpackrecords    : longint;
       initoutputformat   : tasm;
       initoptprocessor   : tprocessors;
       initasmmode        : tasmmode;
     { current state values }
       aktglobalswitches : tglobalswitches;
       aktmoduleswitches : tmoduleswitches;
       aktlocalswitches  : tlocalswitches;
       aktpackenum,
       aktpackrecords    : longint;
       aktoutputformat   : tasm;
       aktoptprocessor   : tprocessors;
       aktasmmode        : tasmmode;

     { Memory sizes }
	   heapsize,maxheapsize,
       stacksize : longint;

{$Ifdef EXTDEBUG}
       total_of_firstpass,
       firstpass_several : longint;
{$EndIf EXTDEBUG}
     { parameter switches }
{$Ifdef EXTDEBUG}
       debugstop,
       only_one_pass,
{$EndIf EXTDEBUG}
       use_gsym,
       use_dbx,
       dispose_asm_lists : boolean;

    function getspeedvalue(const s : string) : longint;

{$ifdef debug}
    { if the pointer don't point to the heap then write an error }
    function assigned(p : pointer) : boolean;
{$endif}
    function min(a,b : longint) : longint;
    function max(a,b : longint) : longint;
    procedure Replace(var s:string;const s1,s2:string);
    function upper(const s : string) : string;
    function lower(const s : string) : string;
    procedure uppervar(var s : string);
    function tostr(i : longint) : string;
    function tostr_with_plus(i : longint) : string;
    procedure valint(S : string;var V : longint;var code : word);
    function is_number(const s : string) : boolean;
    function ispowerof2(value : longint;var power : longint) : boolean;
    { enable ansistring comparison }
    function compareansistrings(p1,p2 : pchar;length1,length2 : longint) : longint;
    function concatansistrings(p1,p2 : pchar;length1,length2 : longint) : pchar;
    function bstoslash(const s : string) : string;

    function getdatestr:string;
    function gettimestr:string;
    function filetimestring( t : longint) : string;

    function path_absolute(const s : string) : boolean;
    Function FileExists ( Const F : String) : Boolean;
    Procedure RemoveFile(const f:string);
    Procedure RemoveDir(d:string);
    Function GetFileTime ( Var F : File) : Longint;
    Function GetNamedFileTime ( Const F : String) : Longint;
    Function SplitName(const s:string):string;
    Function FixPath(s:string):string;
    function FixFileName(const s:string):string;
    procedure AddPathToList(var list:string;s:string;first:boolean);
    function search(const f : string;path : string;var b : boolean) : string;
    function FindExe(bin:string;var found:boolean):string;

   procedure InitGlobals;


  implementation


{$ifdef FPC}
    function getspeedvalue(const s : string) : longint;
      var
        p1,p2:^byte;
      begin
        p1:=@s;
        longint(p2):=longint(p1)+p1^+1;
        inc(longint(p1));
        getspeedvalue:=0;
        while p1<>p2 do
         begin
           inc(getspeedvalue,p1^);
           inc(longint(p1));
         end;
      end;
{$else}
    function getspeedvalue(const s : string) : longint;
      type
        ptrrec=record
          ofs,seg:word;
        end;
      var
        l,w   : longint;
        p1,p2 : ^byte;
      begin
        p1:=@s;
        ptrrec(p2).seg:=ptrrec(p1).seg;
        ptrrec(p2).ofs:=ptrrec(p1).ofs+p1^+1;
        inc(p1);
        l:=0;
        while p1<>p2 do
         begin
           l:=l+p1^;
           inc(p1);
         end;
        getspeedvalue:=l;
      end;
{$endif}


    function ngraphsearchvalue(const s1,s2 : string) : double;
      const
         n = 3;
      var
         equals,i,j : longint;
         hs : string;
      begin
         equals:=0;
         { is the string long enough ? }
         if min(length(s1),length(s2))-n+1<1 then
           begin
              ngraphsearchvalue:=0.0;
              exit;
           end;
         for i:=1 to length(s1)-n+1 do
           begin
              hs:=copy(s1,i,n);
              for j:=1 to length(s2)-n+1 do
                if hs=copy(s2,j,n) then
                  inc(equals);
           end;
{$ifdef fpc}
         ngraphsearchvalue:=equals/double(max(length(s1),length(s2))-n+1);
{$else}
         ngraphsearchvalue:=equals/(max(length(s1),length(s2))-n+1);
{$endif}
      end;



    function bstoslash(const s : string) : string;
      var
         i : longint;
      begin
        for i:=1to length(s) do
         if s[i]='\' then
          bstoslash[i]:='/'
         else
          bstoslash[i]:=s[i];
        bstoslash[0]:=s[0];
      end;

{$ifdef debug}

    function assigned(p : pointer) : boolean;
      var
         lp : longint;
      begin
{$ifdef FPC}
         lp:=longint(p);
{$else}
    {$ifdef DPMI}
         assigned:=(p<>nil);
         exit;
    {$else DPMI}
         if p=nil then
           lp:=0
         else
           lp:=longint(ptrrec(p).seg)*16+longint(ptrrec(p).ofs);
         if (lp<>0) and
            ((lp<longint(seg(heaporg^))*16+longint(ofs(heaporg^))) or
            (lp>longint(seg(heapptr^))*16+longint(ofs(heapptr^)))) then
           runerror(230);
    {$endif DPMI}
{$endif FPC}
         assigned:=lp<>0;
      end;
{$endif}


    function min(a,b : longint) : longint;
      begin
         if a>b then
           min:=b
         else
           min:=a;
      end;


    function max(a,b : longint) : longint;
      begin
         if a<b then
           max:=b
         else
           max:=a;
      end;


    procedure Replace(var s:string;const s1,s2:string);
      var
         i  : longint;
      begin
        repeat
          i:=pos(s1,s);
          if i>0 then
           begin
             Delete(s,i,length(s1));
             Insert(s2,s,i);
           end;
        until i=0;
      end;


    function upper(const s : string) : string;
      var
         i  : longint;
      begin
         for i:=1 to length(s) do
          if s[i] in ['a'..'z'] then
           upper[i]:=char(byte(s[i])-32)
          else
           upper[i]:=s[i];
         upper[0]:=s[0];
      end;


    function lower(const s : string) : string;
      var
         i : longint;
      begin
         for i:=1 to length(s) do
          if s[i] in ['A'..'Z'] then
           lower[i]:=char(byte(s[i])+32)
          else
           lower[i]:=s[i];
         lower[0]:=s[0];
      end;


    procedure uppervar(var s : string);
      var
         i : longint;
      begin
         for i:=1 to length(s) do
          if s[i] in ['a'..'z'] then
           s[i]:=char(byte(s[i])-32);
      end;


   function tostr(i : longint) : string;
     var
        hs : string;
     begin
        str(i,hs);
        tostr:=hs;
     end;


   function tostr_with_plus(i : longint) : string;
     var
        hs : string;
     begin
        str(i,hs);
        if i>=0 then
          tostr_with_plus:='+'+hs
        else
          tostr_with_plus:=hs;
     end;


    procedure valint(S : string;var V : longint;var code : word);
{$ifndef FPC}
      var
        vs : longint;
        c  : byte;
      begin
        if s[1]='%' then
          begin
             vs:=0;
             longint(v):=0;
             for c:=2 to length(s) do
               begin
                  if s[c]='0' then
                    vs:=vs*2
                  else
                  if s[c]='1' then
                    vs:=vs*2+1
                  else
                    begin
                      code:=c;
                      exit;
                    end;
               end;
             code:=0;
             longint(v):=vs;
          end
        else
         system.val(S,V,code);
      end;
{$else not FPC}
      begin
         system.val(S,V,code);
      end;
{$endif not FPC}


    function is_number(const s : string) : boolean;
      var
         w : word;
         l : longint;
      begin
         valint(s,l,w);
         is_number:=(w=0);
      end;


    function ispowerof2(value : longint;var power : longint) : boolean;
      var
         hl : longint;
         i : longint;
      begin
         hl:=1;
         ispowerof2:=true;
         for i:=0 to 31 do
           begin
              if hl=value then
                begin
                   power:=i;
                   exit;
                end;
              hl:=hl shl 1;
           end;
         ispowerof2:=false;
      end;


    { enable ansistring comparison }
    { 0 means equal }
    { 1 means p1 > p2 }
    { -1 means p1 < p2 }
    function compareansistrings(p1,p2 : pchar;length1,length2 : longint) : longint;

      var
         i,j : longint;
      begin
         compareansistrings:=0;
         j:=min(length1,length2);
         for i:=1  to j do
           begin
              if p1[i]>p2[i] then
                begin
                   compareansistrings:=1;
                   exit;
                end
              else if p1[i]<p2[i] then
                begin
                   compareansistrings:=-1;
                   exit;
                end;
           end;
         if length1>length2 then
           begin
              compareansistrings:=1;
              exit;
           end
         else
           begin
              compareansistrings:=-1;
              exit;
           end;
      end;


    function concatansistrings(p1,p2 : pchar;length1,length2 : longint) : pchar;
      var
         p : pchar;
      begin
         getmem(p,length1+length2+1);
        { if p=nil then
           Message(general_f_no_memory_left);}
         move(p1[0],p[0],length1);
         move(p2[0],p[length1],length2+1);
         concatansistrings:=p;
      end;


 {****************************************************************************
                               Time Handling
 ****************************************************************************}

    Function L0(l:longint):string;
      var
        s : string;
      begin
        Str(l,s);
        if l<10 then
         s:='0'+s;
        L0:=s;
      end;


   function gettimestr:string;
      var
        hour,min,sec,hsec : word;
      begin
        dos.gettime(hour,min,sec,hsec);
        gettimestr:=L0(Hour)+':'+L0(min)+':'+L0(sec);
      end;


   function getdatestr:string;
      var
        Year,Month,Day,Wday : Word;
      begin
        dos.getdate(year,month,day,wday);
        getdatestr:=L0(Year)+'/'+L0(Month)+'/'+L0(Day);
      end;


   function  filetimestring( t : longint) : string;
     var
     {$ifndef linux}
       DT : DateTime;
     {$endif}
       Year,Month,Day,Hour,Min,Sec : Word;
     begin
     {$ifndef linux}
       unpacktime(t,DT);
       Year:=dT.year;month:=dt.month;day:=dt.day;
       Hour:=dt.hour;min:=dt.min;sec:=dt.sec;
     {$else}
       EpochToLocal (t,year,month,day,hour,min,sec);
     {$endif}
       filetimestring:=L0(Year)+'/'+L0(Month)+'/'+L0(Day)+' '+L0(Hour)+':'+L0(min)+':'+L0(sec);
     end;


 {****************************************************************************
                               File Handling
 ****************************************************************************}

   function path_absolute(const s : string) : boolean;
     begin
        path_absolute:=false;
{$ifdef linux}
        if (length(s)>0) and (s[1]='/') then
          path_absolute:=true;
{$else linux}
  {$ifdef amiga}
        if ((length(s)>0) and ((s[1]='\') or (s[1]='/'))) or (Pos(':',s) = length(s)) then
          path_absolute:=true;
  {$else}
        if ((length(s)>0) and ((s[1]='\') or (s[1]='/'))) or
           ((length(s)>2) and (s[2]=':') and ((s[3]='\') or (s[3]='/'))) then
          path_absolute:=true;
  {$endif amiga}
{$endif linux}
     end;


    Function FileExists ( Const F : String) : Boolean;
      Var
      {$ifdef linux}
         Info : Stat;
      {$else}
         Info : SearchRec;
      {$endif}

          begin
      {$ifdef linux}
           FileExists:=FStat(F,info);
      {$else}
           findfirst(F,anyfile,info);
           FileExists:=doserror=0 ;
      {$endif}
          end;


    Procedure RemoveFile(const f:string);
      var
        i : longint;
        g : file;
      begin
        assign(g,f);
        {$I-}
         erase(g);
        {$I+}
        i:=ioresult;
      end;


    Procedure RemoveDir(d:string);
      var
        i : longint;
      begin
        if d[length(d)]=DirSep then
         Delete(d,length(d),1);
        {$I-}
         rmdir(d);
        {$I+}
        i:=ioresult;
      end;


    Function SplitName(const s:string):string;
      var p:dirstr;
          n:namestr;
          e:extstr;
      begin
        FSplit(s,p,n,e);
        SplitName:=n;
      end;

    Function FixPath(s:string):string;
      var
        i : longint;
      begin
        for i:=1to length(s) do
         if s[i] in ['/','\'] then
          s[i]:=DirSep;
        if (length(s)>0) and (s[length(s)]<>DirSep) then
         s:=s+DirSep;
        if s='.'+DirSep then
         s:='';
        FixPath:=s;
      end;


   function FixFileName(const s:string):string;
     var
       i      : longint;
       NoPath : boolean;
     begin
       NoPath:=true;
       for i:=length(s) downto 1 do
        begin
          case s[i] of
      {$ifdef Linux}
       '/','\' : begin
                   FixFileName[i]:='/';
                   NoPath:=false; {Skip lowercasing path: 'X11'<>'x11' }
                 end;
      'A'..'Z' : if NoPath then
                  FixFileName[i]:=char(byte(s[i])+32)
                 else
                  FixFileName[i]:=s[i];
      {$else}
           '/' : FixFileName[i]:='\';
      'A'..'Z' : FixFileName[i]:=char(byte(s[i])+32);
      {$endif}
          else
           FixFileName[i]:=s[i];
          end;
        end;
       FixFileName[0]:=s[0];
     end;


   procedure AddPathToList(var list:string;s:string;first:boolean);
     var
       LastAdd,
       starti,i,j : longint;
       Found    : boolean;
       CurrentDir,
       CurrPath,
       AddList  : string;
     begin
       if s='' then
        exit;
     {Fix List}
       if (length(list)>0) and (list[length(list)]<>';') then
        begin
          inc(byte(list[0]));
          list[length(list)]:=';'
        end;
       GetDir(0,CurrentDir);
       CurrentDir:=FixPath(CurrentDir);
       AddList:='';
       LastAdd:=1;
       repeat
         j:=Pos(';',s);
         if j=0 then
          j:=255;
       {Get Pathname}
         CurrPath:=FixPath(Copy(s,1,j-1));
         if CurrPath='' then
          CurrPath:='.'+DirSep+';'
         else
          begin
            CurrPath:=FixPath(FExpand(CurrPath))+';';
            if (Copy(CurrPath,1,length(CurrentDir))=CurrentDir) then
             CurrPath:='.'+DirSep+Copy(CurrPath,length(CurrentDir)+1,255);
          end;
         Delete(s,1,j);
       {Check if already in path}
         found:=false;
         i:=0;
         starti:=1;
         while (not found) and (i<length(list)) do
          begin
            inc(i);
            if (list[i]=';') then
             begin
               found:=(CurrPath=Copy(List,starti,i-starti+1));
               if Found then
                begin
                  if First then
                   Delete(List,Starti,i-starti+1); {The new entry is placed first}
                end
               else
                starti:=i+1;
             end;
          end;
         if First then
          begin
            Insert(CurrPath,List,LastAdd);
            inc(LastAdd,Length(CurrPath));
          end
         else
          if not Found then
           List:=List+CurrPath
       until (s='');
     end;


   function search(const f : string;path : string;var b : boolean) : string;
      Var
        singlepathstring : string;
        i : longint;
     begin
     {$ifdef linux}
       for i:=1 to length(path) do
        if path[i]=':' then
       path[i]:=';';
     {$endif}
       b:=false;
       search:='';
       repeat
         i:=pos(';',path);
         if i=0 then
           i:=255;
         singlepathstring:=FixPath(copy(path,1,i-1));
         delete(path,1,i);
         If FileExists (singlepathstring+f) then
           begin
             Search:=singlepathstring;
             b:=true;
             exit;
           end;
       until path='';
     end;


   Function GetFileTime ( Var F : File) : Longint;
   Var
{$ifdef linux}
      Info : Stat;
{$endif}
      L : longint;
   begin
     {$ifdef linux}
     FStat (F,Info);
     L:=Info.Mtime;
     {$else}
     GetFTime(f,l);
     {$endif}
     GetFileTime:=L;
   end;


   Function GetNamedFileTime (Const F : String) : Longint;
   var
     L : Longint;
   {$ifndef linux}
     info : SearchRec;
   {$else}
     info : stat;
   {$endif}
   begin
     l:=-1;
     {$ifdef linux}
     if FStat (F,Info) then L:=info.mtime;
     {$else}
     FindFirst (F,anyfile,info);
     if DosError=0 then l:=info.time;
     {$endif}
     GetNamedFileTime:=l;
   end;


   function FindExe(bin:string;var found:boolean):string;
   begin
     bin:=FixFileName(bin)+source_os.exeext;
     FindExe:=Search(bin,'.;'+exepath+';'+dos.getenv('PATH'),found)+bin;
   end;


 {****************************************************************************
                                    Init
 ****************************************************************************}

   procedure get_exepath;
     var
       hs1 : namestr;
       hs2 : extstr;
     begin
       exepath:=dos.getenv('PPC_EXEC_PATH');
       if exepath='' then
        fsplit(FixFileName(paramstr(0)),exepath,hs1,hs2);
     {$ifdef linux}
       if exepath='' then
        fsearch(hs1,dos.getenv('PATH'));
     {$endif}
       exepath:=FixPath(exepath);
     end;



   procedure InitGlobals;
     begin
      { set global switches }
        do_build:=false;
        do_make:=true;
{$ifdef tp}
        use_big:=false;
{$endif tp}

      { Def file }
        usewindowapi:=false;
        description:='Compiled by FPC '+version_string+' - '+target_string;

      { Init values }
{$ifdef i386}
        initoptprocessor:=Class386;
        initlocalswitches:=[];
        initmoduleswitches:=[cs_extsyntax];
        initglobalswitches:=[cs_check_unit_name];
        initpackenum:=4;
        initpackrecords:=2;
        initoutputformat:=as_o;
        initasmmode:=I386_DIRECT;
        initdefines.init;
{$endif}
{$ifdef m68k}
        initoptprocessor:=MC68000;
        initlocalswitches:=[];
        initmoduleswitches:=[cs_extsyntax,cs_fp_emulation];
        initglobalswitches:=[cs_check_unit_name];
        initpackenum:=4;
        initpackrecords:=2;
        initoutputformat:=as_o;
        initasmmode:=M68K_MOT;
        initdefines.init;
{$endif}

      { memory sizes, will be overriden by parameter or default for target
        in options or init_parser }
        stacksize:=0;
        heapsize:=0;
		maxheapsize:=0;

      { compile state }
        in_args:=false;
        must_be_valid:=true;
        not_unit_proc:=true;
     end;

begin
  get_exepath;
end.
{
  $Log: globals.pas,v $
  Revision 1.64  1998/09/10 15:25:29  daniel
  + Added maxheapsize.
  * Corrected semi-bug in calling the assembler and the linker

  Revision 1.63  1998/09/09 18:17:13  florian
    * version number changed to 0.99.8

  Revision 1.62  1998/09/07 17:36:59  florian
    * first fixes for published properties

  Revision 1.61  1998/09/03 11:21:52  peter
    * -al sets cs_asm_source

  Revision 1.60  1998/09/01 12:53:20  peter
    + aktpackenum

  Revision 1.59  1998/09/01 07:54:18  pierre
    * UseBrowser a little updated (might still be buggy !!)
    * bug in psub.pas in function specifier removed
    * stdcall allowed in interface and in implementation
      (FPC will not yet complain if it is missing in either part
      because stdcall is only a dummy !!)

  Revision 1.58  1998/08/31 12:26:25  peter
    * m68k and palmos updates from surebugfixes

  Revision 1.57  1998/08/29 13:51:09  peter
    * moved get_exepath to globals
    + date_string const with the current date for 0.99.7+

  Revision 1.56  1998/08/26 15:35:31  peter
    * fixed scannerfiles for macros
    + $I %<environment>%

  Revision 1.55  1998/08/25 12:42:35  pierre
    * CDECL changed to CVAR for variables
      specifications are read in structures also
    + started adding GPC compatibility mode ( option  -Sp)
    * names changed to lowercase

  Revision 1.54  1998/08/19 18:04:53  peter
    * fixed current_module^.in_implementation flag

  Revision 1.53  1998/08/19 16:07:45  jonas
    * changed optimizer switches + cleanup of DestroyRefs in daopt386.pas

  Revision 1.52  1998/08/19 10:06:13  peter
    * fixed filenames and removedir which supports slash at the end

  Revision 1.51  1998/08/17 09:17:46  peter
    * static/shared linking updates

  Revision 1.50  1998/08/14 21:56:33  peter
    * setting the outputfile using -o works now to create static libs

  Revision 1.49  1998/08/13 10:57:31  peter
    * constant sets are now written correctly to the ppufile

  Revision 1.48  1998/08/11 15:31:37  peter
    * write extended to ppu file
    * new version 0.99.7

  Revision 1.47  1998/08/10 14:49:59  peter
    + localswitches, moduleswitches, globalswitches splitting

  Revision 1.46  1998/08/10 10:18:25  peter
    + Compiler,Comphook unit which are the new interface units to the
      compiler

  Revision 1.45  1998/07/24 22:16:56  florian
    * internal error 10 together with array access fixed. I hope
      that's the final fix.

  Revision 1.44  1998/07/18 17:11:08  florian
    + ansi string constants fixed
    + switch $H partial implemented

  Revision 1.43  1998/07/14 21:46:42  peter
    * updated messages file

  Revision 1.42  1998/07/08 14:28:35  daniel
  * Fixed small TP incompatibility: Fsplit requires use of dirstr, namestr and
  extstr

  Revision 1.41  1998/07/07 11:19:56  peter
    + NEWINPUT for a better inputfile and scanner object

  Revision 1.40  1998/06/25 08:48:13  florian
    * first version of rtti support

  Revision 1.39  1998/06/17 14:10:12  peter
    * small os2 fixes
    * fixed interdependent units with newppu (remake3 under linux works now)

  Revision 1.38  1998/06/16 08:56:21  peter
    + targetcpu
    * cleaner pmodules for newppu

  Revision 1.37  1998/06/13 00:10:06  peter
    * working browser and newppu
    * some small fixes against crashes which occured in bp7 (but not in
      fpc?!)

  Revision 1.36  1998/06/12 16:15:31  pierre
    * external name 'C_var';
      export name 'intern_C_var';
      cdecl;
      cdecl;external;
      are now supported only with -Sv switch

  Revision 1.34  1998/06/04 23:51:39  peter
    * m68k compiles
    + .def file creation moved to gendef.pas so it could also be used
      for win32

  Revision 1.33  1998/06/03 22:48:54  peter
    + wordbool,longbool
    * rename bis,von -> high,low
    * moved some systemunit loading/creating to psystem.pas

  Revision 1.32  1998/05/30 14:31:04  peter
    + $ASMMODE

  Revision 1.31  1998/05/28 14:40:24  peter
    * fixes for newppu, remake3 works now with it

  Revision 1.30  1998/05/27 19:45:03  peter
    * symtable.pas splitted into includefiles
    * symtable adapted for $ifdef NEWPPU

  Revision 1.29  1998/05/25 17:11:39  pierre
    * firstpasscount bug fixed
      now all is already set correctly the first time
      under EXTDEBUG try -gp to skip all other firstpasses
      it works !!
    * small bug fixes
      - for smallsets with -dTESTSMALLSET
      - some warnings removed (by correcting code !)

  Revision 1.28  1998/05/23 01:21:07  peter
    + aktasmmode, aktoptprocessor, aktoutputformat
    + smartlink per module $SMARTLINK-/+ (like MMX) and moved to aktswitches
    + $LIBNAME to set the library name where the unit will be put in
    * splitted cgi386 a bit (codeseg to large for bp7)
    * nasm, tasm works again. nasm moved to ag386nsm.pas

  Revision 1.27  1998/05/20 09:42:33  pierre
    + UseTokenInfo now default
    * unit in interface uses and implementation uses gives error now
    * only one error for unknown symbol (uses lastsymknown boolean)
      the problem came from the label code !
    + first inlined procedures and function work
      (warning there might be allowed cases were the result is still wrong !!)
    * UseBrower updated gives a global list of all position of all used symbols
      with switch -gb

  Revision 1.26  1998/05/12 10:46:59  peter
    * moved printstatus to verb_def
    + V_Normal which is between V_Error and V_Warning and doesn't have a
      prefix like error: warning: and is included in V_Default
    * fixed some messages
    * first time parameter scan is only for -v and -T
    - removed old style messages

  Revision 1.25  1998/05/11 13:07:54  peter
    + $ifdef NEWPPU for the new ppuformat
    + $define GDB not longer required
    * removed all warnings and stripped some log comments
    * no findfirst/findnext anymore to remove smartlink *.o files

  Revision 1.24  1998/05/08 09:21:20  michael
  * Added missing -Fl message to messages file.
  * Corrected mangling of file names when doing Linklib
  * -Fl now actually WORKS.
  * Librarysearchpath is now a field in linker object.

  Revision 1.23  1998/05/06 15:04:20  pierre
    + when trying to find source files of a ppufile
      check the includepathlist for included files
      the main file must still be in the same directory

  Revision 1.22  1998/05/06 08:38:39  pierre
    * better position info with UseTokenInfo
      UseTokenInfo greatly simplified
    + added check for changed tree after first time firstpass
      (if we could remove all the cases were it happen
      we could skip all firstpass if firstpasscount > 1)
      Only with ExtDebug

  Revision 1.21  1998/05/04 17:54:25  peter
    + smartlinking works (only case jumptable left todo)
    * redesign of systems.pas to support assemblers and linkers
    + Unitname is now also in the PPU-file, increased version to 14

  Revision 1.20  1998/05/01 07:43:53  florian
    + basics for rtti implemented
    + switch $m (generate rtti for published sections)

  Revision 1.19  1998/04/30 15:59:40  pierre
    * GDB works again better :
      correct type info in one pass
    + UseTokenInfo for better source position
    * fixed one remaining bug in scanner for line counts
    * several little fixes

  Revision 1.18  1998/04/29 10:33:52  pierre
    + added some code for ansistring (not complete nor working yet)
    * corrected operator overloading
    * corrected nasm output
    + started inline procedures
    + added starstarn : use ** for exponentiation (^ gave problems)
    + started UseTokenInfo cond to get accurate positions

  Revision 1.17  1998/04/27 23:10:28  peter
    + new scanner
    * $makelib -> if smartlink
    * small filename fixes pmodule.setfilename
    * moved import from files.pas -> import.pas

  Revision 1.16  1998/04/27 15:45:20  peter
    + -Xl for smartlink
    + target_info.arext = .a

  Revision 1.15  1998/04/22 21:06:50  florian
    * last fixes before the release:
      - veryyyy slow firstcall fixed

  Revision 1.14  1998/04/21 13:48:09  michael
  + Updated patch number

  Revision 1.13  1998/04/21 10:16:47  peter
    * patches from strasbourg
    * objects is not used anymore in the fpc compiled version

  Revision 1.12  1998/04/09 14:28:06  jonas
    + basic k6 and 6x86 optimizing support (-O7 and -O8)

  Revision 1.11  1998/04/08 16:58:02  pierre
    * several bugfixes
      ADD ADC and AND are also sign extended
      nasm output OK (program still crashes at end
      and creates wrong assembler files !!)
      procsym types sym in tdef removed !!

  Revision 1.10  1998/04/08 11:34:22  peter
    * nasm works (linux only tested)

  Revision 1.9  1998/04/07 21:37:30  peter
    * fixed fixpath to also change / and \ slashes and better addpathtolist

  Revision 1.8  1998/04/07 13:19:44  pierre
    * bugfixes for reset_gdb_info
      in MEM parsing for go32v2
      better external symbol creation
      support for rhgdb.exe (lowercase file names)

  Revision 1.7  1998/04/06 16:19:46  peter
    * fixed the -Up.. bug

}

