{
    $Id: ag386att.pas,v 1.38.2.1 1998/09/11 10:49:09 pierre Exp $
    Copyright (c) 1996-98 by the FPC development team

    This unit implements an asmoutput class for i386 AT&T syntax

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************
}
{ R- Necessary for the in [] }
{$ifdef TP}
  {$N+,E+,R-}
{$endif}
unit ag386att;

    interface

    uses cobjects,aasm,assemble;

    type
      pi386attasmlist=^ti386attasmlist;
      ti386attasmlist=object(tasmlist)
        procedure WriteTree(p:paasmoutput);virtual;
        procedure WriteAsmList;virtual;
{$ifdef GDB}
        procedure WriteFileLineInfo(var fileinfo : tfileposinfo);
{$endif}
      end;

  implementation

    uses
      dos,globals,systems,i386,
      strings,files,verbose
{$ifdef GDB}
      ,gdb
{$endif GDB}
      ;

    const
      line_length = 70;

    var
{$ifdef GDB}
      n_line       : byte;     { different types of source lines }
      linecount,
      includecount : longint;
      funcname     : pchar;
      stabslastfileinfo : tfileposinfo;
{$endif}
      lastsec    : tsection; { last section type written }
      lastsecidx : longint;
      lastfileinfo : tfileposinfo;
      infile,
      lastinfile   : pinputfile;


    function double2str(d : double) : string;
      var
         hs : string;
      begin
         str(d,hs);
      { replace space with + }
         if hs[1]=' ' then
          hs[1]:='+';
         double2str:='0d'+hs
      end;

    function extended2str(e : extended) : string;
      var
         hs : string;
      begin
{$ifdef VER0_99_5}
         str(double(e),hs);
{$else}
         str(e,hs);
{$endif}
      { replace space with + }
         if hs[1]=' ' then
          hs[1]:='+';
         extended2str:='0d'+hs
      end;

    function comp2str(d : bestreal) : string;
      type
        pdouble = ^double;
      var
        c  : comp;
        dd : pdouble;
      begin
      {$ifdef TP}
         c:=d;
      {$else}
         c:=comp(d);
      {$endif}
         dd:=pdouble(@c); { this makes a bitwise copy of c into a double }
         comp2str:=double2str(dd^);
      end;


    function getreferencestring(const ref : treference) : string;
    var
      s : string;
    begin
      if ref.isintvalue then
       s:='$'+tostr(ref.offset)
      else
       begin
         with ref do
          begin
          { have we a segment prefix ? }
          { These are probably not correctly handled under GAS }
          { should be replaced by coding the segment override  }
          { directly! - DJGPP FAQ                              }
            if segment<>R_DEFAULT_SEG then
             s:=att_reg2str[segment]+':'
            else
             s:='';
            if assigned(symbol) then
             s:=s+symbol^;
            if offset<0 then
             s:=s+tostr(offset)
            else
             if (offset>0) then
              begin
                if assigned(symbol) then
                 s:=s+'+'+tostr(offset)
                else
                 s:=s+tostr(offset);
              end;
            if (index<>R_NO) and (base=R_NO) then
             Begin
               s:=s+'(,'+att_reg2str[index];
               if scalefactor<>0 then
                s:=s+','+tostr(scalefactor)+')'
               else
                s:=s+')';
             end
            else
             if (index=R_NO) and (base<>R_NO) then
              s:=s+'('+att_reg2str[base]+')'
             else
              if (index<>R_NO) and (base<>R_NO) then
               Begin
                 s:=s+'('+att_reg2str[base]+','+att_reg2str[index];
                 if scalefactor<>0 then
                  s:=s+','+tostr(scalefactor)+')'
                 else
                  s := s+')';
               end;
          end;
       end;
      getreferencestring:=s;
    end;

    function getopstr(t : byte;o : pointer) : string;
    var
      hs : string;
    begin
      case t of
        top_reg : getopstr:=att_reg2str[tregister(o)];
        top_ref : getopstr:=getreferencestring(preference(o)^);
      top_const : getopstr:='$'+tostr(longint(o));
     top_symbol : begin
                    hs[0]:=chr(strlen(pchar(pcsymbol(o)^.symbol)));
                    move(pchar(pcsymbol(o)^.symbol)^,hs[2],byte(hs[0]));
                    inc(byte(hs[0]));
                    hs[1]:='$';
                    if pcsymbol(o)^.offset>0 then
                     hs:=hs+'+'+tostr(pcsymbol(o)^.offset)
                    else
                     if pcsymbol(o)^.offset<0 then
                      hs:=hs+tostr(pcsymbol(o)^.offset);
                    getopstr:=hs;
                  end;
      else
       internalerror(10001);
      end;
    end;


    function getopstr_jmp(t : byte;o : pointer) : string;
    var
      hs : string;
    begin
      case t of
       top_reg : getopstr_jmp:=att_reg2str[tregister(o)];
       top_ref : getopstr_jmp:='*'+getreferencestring(preference(o)^);
     top_const : getopstr_jmp:=tostr(longint(o));
    top_symbol : begin
                    hs[0]:=chr(strlen(pchar(pcsymbol(o)^.symbol)));
                    move(pchar(pcsymbol(o)^.symbol)^,hs[1],byte(hs[0]));
                    if pcsymbol(o)^.offset>0 then
                     hs:=hs+'+'+tostr(pcsymbol(o)^.offset)
                    else
                     if pcsymbol(o)^.offset<0 then
                      hs:=hs+tostr(pcsymbol(o)^.offset);
                    getopstr_jmp:=hs;
                 end;
      else
       internalerror(10001);
      end;
    end;

    var
      MMXWarn : boolean;
    procedure MMXWarning;
    begin
      if not MMXWarn then
       begin
         Message(assem_w_mmxwarning_as_281);
         MMXWarn:=true;
       end;
    end;


{****************************************************************************
                            TI386ATTASMOUTPUT
 ****************************************************************************}

    const
      ait_const2str : array[ait_const_32bit..ait_const_8bit] of string[8]=
       (#9'.long'#9,'',#9'.short'#9,#9'.byte'#9);

    function ait_section2str(s:tsection;idx:longint):string;
    begin
      case s of
        sec_code : ait_section2str:='.text';
        sec_data : ait_section2str:='.data';
         sec_bss : if target_info.target=target_Win32 then
                    ait_section2str:='.section .bss'
                   else
                    ait_section2str:='.bss';
       sec_idata : ait_section2str:='.section .idata$'+tostr(idx);
      else
       ait_section2str:='';
      end;
      LastSec:=s;
      LastSecIdx:=idx;
    end;


{$ifdef GDB}
      procedure ti386attasmlist.WriteFileLineInfo(var fileinfo : tfileposinfo);
        var
          curr_n : byte;
        begin
          if not (cs_debuginfo in aktmoduleswitches) then
           exit;
        { file changed ? (must be before line info) }
          if stabslastfileinfo.fileindex<>fileinfo.fileindex then
           begin
             infile:=current_module^.sourcefiles.get_file(fileinfo.fileindex);
             if includecount=0 then
              curr_n:=n_sourcefile
             else
              curr_n:=n_includefile;
             if (infile^.path^<>'') then
              begin
                AsmWriteLn(#9'.stabs "'+lower(BsToSlash(FixPath(infile^.path^)))+'",'+
                  tostr(curr_n)+',0,0,'+'Ltext'+ToStr(IncludeCount));
              end;
             AsmWriteLn(#9'.stabs "'+lower(FixFileName(infile^.name^))+'",'+
               tostr(curr_n)+',0,0,'+'Ltext'+ToStr(IncludeCount));
             AsmWriteLn('Ltext'+ToStr(IncludeCount)+':');
             inc(includecount);
           end;
        { line changed ? }
          if (stabslastfileinfo.line<>fileinfo.line) and (fileinfo.line<>0) then
           begin
             if (n_line=n_textline) and assigned(funcname) and
                (target_os.use_function_relative_addresses) then
              begin
                AsmWriteLn(target_asm.labelprefix+'l'+tostr(linecount)+':');
                AsmWrite(#9'.stabn '+tostr(n_line)+',0,'+tostr(fileinfo.line)+','+
                           target_asm.labelprefix+'l'+tostr(linecount)+' - ');
                AsmWritePChar(FuncName);
                AsmLn;
                inc(linecount);
              end
             else
              AsmWriteLn(#9'.stabd'#9+tostr(n_line)+',0,'+tostr(fileinfo.line));
           end;
          stabslastfileinfo:=fileinfo;
        end;
{$endif GDB}


    procedure ti386attasmlist.WriteTree(p:paasmoutput);
    type
      twowords=record
        word1,word2:word;
      end;
      textendedarray = array[0..9] of byte; { last longint will be and $ffff }
    var
      ch       : char;
      hp       : pai;
      consttyp : tait;
      s        : string;
      found    : boolean;
      i,pos,l  : longint;
      e        : extended;
      do_line  : boolean;
    begin
      if not assigned(p) then
       exit;
      do_line:=(cs_debuginfo in aktmoduleswitches) or (cs_asm_source in aktglobalswitches);
      hp:=pai(p^.first);
      while assigned(hp) do
       begin
         if do_line then
          begin
          { I think it is better to write stabs before source line PM }
{$ifdef GDB}
          { write stabs }
            if cs_debuginfo in aktmoduleswitches then
             begin
               if not (hp^.typ in  [ait_external,ait_stabn,ait_stabs,
                      ait_label,ait_cut,ait_align,ait_stab_function_name]) then
                 begin
                    WriteFileLineInfo(hp^.fileinfo);
                 end;
             end;
{$endif GDB}
          { load infile }
            if lastfileinfo.fileindex<>hp^.fileinfo.fileindex then
             infile:=current_module^.sourcefiles.get_file(hp^.fileinfo.fileindex);
          { write source }
            if (cs_asm_source in aktglobalswitches) and
                not (hp^.typ in  [ait_external,ait_stabn,ait_stabs,
                      ait_label,ait_cut,ait_align,ait_stab_function_name]) then
             begin
               if (infile<>lastinfile) and assigned(lastinfile) then
                lastinfile^.close;
               if (hp^.fileinfo.line<>lastfileinfo.line) and
                  (hp^.fileinfo.line<infile^.maxlinebuf) then
                 begin
                   if infile^.linebuf^[hp^.fileinfo.line]>=0 then
                     AsmWriteLn(target_asm.comment+infile^.GetLineStr(hp^.fileinfo.line));
                   { set it to a negative value !
                   to make that is has been read already !! PM }
                   infile^.linebuf^[hp^.fileinfo.line]:=-infile^.linebuf^[hp^.fileinfo.line]-1;
                end;
               lastfileinfo:=hp^.fileinfo;
               lastinfile:=infile;
             end;
          end;

         case hp^.typ of
      ait_external : ; { external is ignored }
       ait_comment : Begin
                       AsmWrite(target_asm.comment);
                       AsmWritePChar(pai_asm_comment(hp)^.str);
                       AsmLn;
                     End;
{$ifdef DREGALLOC}
      ait_regalloc : AsmWriteLn(target_asm.comment+'Register '+att_reg2str[pairegalloc(hp)^.reg]+' allocated');
    ait_regdealloc : AsmWriteLn(target_asm.comment+'Register '+att_reg2str[pairegalloc(hp)^.reg]+' released');
{$endif DREGALLOC}
         ait_align : begin
                        { Fix Align bytes for Go32 which uses empty bits }
                        l:=pai_align(hp)^.aligntype;
                        if (target_info.target in [target_GO32V1,target_GO32V2]) then
                         begin
                           i:=0;
                           while l>1 do
                            begin
                              l:=l shr 1;
                              inc(i);
                            end;
                           l:=i;
                         end;
                        { use correct align opcode }
                        AsmWrite(#9'.align '+tostr(l));
                        if pai_align(hp)^.op<>0 then
                         AsmWrite(','+tostr(pai_align(hp)^.op));
                        AsmLn;
                     end;
       ait_section : begin
                       if pai_section(hp)^.sec<>sec_none then
                        begin
                          AsmLn;
                          AsmWriteLn(ait_section2str(pai_section(hp)^.sec,pai_section(hp)^.idataidx));
{$ifdef GDB}
                          case pai_section(hp)^.sec of
                           sec_code : n_line:=n_textline;
                           sec_data : n_line:=n_dataline;
                            sec_bss : n_line:=n_bssline;
                          end;
{$endif GDB}
                        end;
                     end;
     ait_datablock : begin
                       if pai_datablock(hp)^.is_global then
                        AsmWrite(#9'.comm'#9)
                       else
                        AsmWrite(#9'.lcomm'#9);
                       AsmWritePChar(pai_datablock(hp)^.name);
                       AsmWriteLn(','+tostr(pai_datablock(hp)^.size));
                     end;
   ait_const_32bit,
   ait_const_16bit,
    ait_const_8bit : begin
                       AsmWrite(ait_const2str[hp^.typ]+tostr(pai_const(hp)^.value));
                       consttyp:=hp^.typ;
                       l:=0;
                       repeat
                         found:=(not (Pai(hp^.next)=nil)) and (Pai(hp^.next)^.typ=consttyp);
                         if found then
                          begin
                            hp:=Pai(hp^.next);
                            s:=','+tostr(pai_const(hp)^.value);
                            AsmWrite(s);
                            inc(l,length(s));
                          end;
                       until (not found) or (l>line_length);
                       AsmLn;
                     end;
  ait_const_symbol : begin
                       AsmWrite(#9'.long'#9);
                       AsmWritePChar(pchar(pai_const(hp)^.value));
                       AsmLn;
                     end;
     ait_const_rva : begin
                       AsmWrite(#9'.rva'#9);
                       AsmWritePChar(pchar(pai_const(hp)^.value));
                       AsmLn;
                     end;
    ait_real_64bit : AsmWriteLn(#9'.double'#9+double2str(pai_double(hp)^.value));
    ait_real_32bit : AsmWriteLn(#9'.single'#9+double2str(pai_single(hp)^.value));
 ait_real_extended : begin
{$ifdef EXTDEBUG}
                       AsmWriteLn('# workaround for Extended '+extended2str(pai_extended(hp)^.value));
{$endif}
                     { Make sure e is a extended type, bestreal could be
                       a different type (bestreal) !! (PFV) }
                       e:=pai_extended(hp)^.value;
                       AsmWrite(#9'.byte'#9);
                       for i:=0 to 9 do
                        begin
                          if i<>0 then
                           AsmWrite(',');
                          AsmWrite(tostr(textendedarray(e)[i]));
                        end;
                       AsmLn;
                     end;
          ait_comp : begin
                     { comp type is difficult to write so use double }
                       AsmWriteLn(#9'.double'#9+comp2str(pai_comp(hp)^.value));
                     end;
        ait_direct : begin
                       AsmWritePChar(pai_direct(hp)^.str);
                       AsmLn;
{$IfDef GDB}
                       if strpos(pai_direct(hp)^.str,'.data')<>nil then
                         n_line:=n_dataline
                       else if strpos(pai_direct(hp)^.str,'.text')<>nil then
                         n_line:=n_textline
                       else if strpos(pai_direct(hp)^.str,'.bss')<>nil then
                         n_line:=n_bssline;
{$endif GDB}
                     end;
        ait_string : begin
                       pos:=0;
                       for i:=1 to pai_string(hp)^.len do
                        begin
                          if pos=0 then
                           begin
                             AsmWrite(#9'.ascii'#9'"');
                             pos:=20;
                           end;
                          ch:=pai_string(hp)^.str[i-1];
                          case ch of
                             #0, {This can't be done by range, because a bug in FPC}
                        #1..#31,
                     #128..#255 : s:='\'+tostr(ord(ch) shr 6)+tostr((ord(ch) and 63) shr 3)+tostr(ord(ch) and 7);
                            '"' : s:='\"';
                            '\' : s:='\\';
                          else
                           s:=ch;
                          end;
                          AsmWrite(s);
                          inc(pos,length(s));
                          if (pos>line_length) or (i=pai_string(hp)^.len) then
                           begin
                             AsmWriteLn('"');
                             pos:=0;
                           end;
                        end;
                     end;
         ait_label : begin
                       if (pai_label(hp)^.l^.is_used) then
                        begin
                          if pai_label(hp)^.l^.is_data and (cs_smartlink in aktmoduleswitches) then
                            AsmWriteLn('.globl'#9+lab2str(pai_label(hp)^.l));
                          AsmWriteLn(lab2str(pai_label(hp)^.l)+':');
                        end;
                     end;
 ait_labeled_instruction : begin
                       if (pai_labeled(hp)^._operator>A_POPFD) then
                        MMXWarning;
                       AsmWriteLn(#9+att_op2str[pai_labeled(hp)^._operator]+#9+lab2str(pai_labeled(hp)^.lab));
                     end;
        ait_symbol : begin
                       if pai_symbol(hp)^.is_global then
                        begin
                          AsmWrite('.globl'#9);
                          AsmWritePChar(pai_symbol(hp)^.name);
                          AsmLn;
                        end;
                       if target_info.target=target_LINUX then
                        begin
                           AsmWrite(#9'.type'#9);
                           AsmWritePChar(pai_symbol(hp)^.name);
                           if assigned(pai(hp^.next)) and
                              (pai(hp^.next)^.typ in [ait_const_symbol,ait_const_32bit,
                                 ait_const_16bit,ait_const_8bit,ait_datablock,
                                 ait_real_64bit,ait_real_32bit,ait_real_extended,ait_comp]) then
                            AsmWriteLn(',@object')
                           else
                            AsmWriteLn(',@function');
                        end;
                       AsmWritePChar(pai_symbol(hp)^.name);
                       AsmWriteLn(':');
                     end;
   ait_instruction : begin { writes an instruction, highly table driven }
                       if (pai386(hp)^._operator>A_POPFD) then
                        MMXWarning;
                       if (pai386(hp)^._operator=A_PUSH) and
                          (pai386(hp)^.size=S_W) and
                          (pai386(hp)^.op1t=top_const) then
                        begin
{$ifdef EXTDEBUG}
                          AsmWriteLn('# workaround for pushw'#9+tostr(longint(pai386(hp)^.op1)));
{$endif}
                          AsmWriteLn(#9'.byte 0x66,0x68');
                          AsmWriteLn(#9'.word '+tostr(longint(pai386(hp)^.op1)));
                        end
                       else
                        begin
                        { call maybe not translated to calll }
                          if pai386(hp)^._operator in [A_CALL,A_JMP] then
                           s:=#9+att_op2str[pai386(hp)^._operator]
                          else
                           s:=#9+att_op2str[pai386(hp)^._operator]+att_opsize2str[pai386(hp)^.size];
                        { process operands }
                          if pai386(hp)^.op1t<>top_none then
                           begin
                           { call and jmp need an extra handling                          }
                           { this code is only called if jmp isn't a labeled instruction }
                             if pai386(hp)^._operator in [A_CALL,A_JMP] then
                              s:=s+#9+getopstr_jmp(pai386(hp)^.op1t,pai386(hp)^.op1)
                             else
                              begin
                                s:=s+#9+getopstr(pai386(hp)^.op1t,pai386(hp)^.op1);
                                if pai386(hp)^.op3t<>top_none then
                                 begin
                                   if pai386(hp)^.op2t<>top_none then
                                    s:=s+','+getopstr(pai386(hp)^.op2t,
                                      pointer(longint(twowords(pai386(hp)^.op2).word1)));
                                    s:=s+','+getopstr(pai386(hp)^.op3t,
                                    pointer(longint(twowords(pai386(hp)^.op2).word2)));
                                 end
                                else
                                 if pai386(hp)^.op2t<>top_none then
                                  s:=s+','+getopstr(pai386(hp)^.op2t,pai386(hp)^.op2);
                              end;
                           end;
                          AsmWriteLn(s);
                        end;
                     end;
{$ifdef GDB}
         ait_stabs : begin
                       AsmWrite(#9'.stabs ');
                       AsmWritePChar(pai_stabs(hp)^.str);
                       AsmLn;
                     end;
         ait_stabn : begin
                       AsmWrite(#9'.stabn ');
                       AsmWritePChar(pai_stabn(hp)^.str);
                       AsmLn;
                     end;
ait_stab_function_name:
                     funcname:=pai_stab_function_name(hp)^.str;
{$endif GDB}
           ait_cut : begin
                     { only reset buffer if nothing has changed }
                       if AsmSize=AsmStartSize then
                        AsmClear
                       else
                        begin
                          AsmClose;
                          DoAssemble;
                          if pai_cut(hp)^.EndName then
                           IsEndFile:=true;
                          AsmCreate;
                        end;
                     { avoid empty files }
                       while assigned(hp^.next) and (pai(hp^.next)^.typ in [ait_cut,ait_section,ait_comment]) do
                        begin
                          if pai(hp^.next)^.typ=ait_section then
                           begin
                             lastsec:=pai_section(hp^.next)^.sec;
                             lastsecidx:=pai_section(hp^.next)^.idataidx;
{$ifdef GDB}
                             { this is needed for line info in data }
                             case pai_section(hp^.next)^.sec of
                              sec_code : n_line:=n_textline;
                              sec_data : n_line:=n_dataline;
                               sec_bss : n_line:=n_bssline;
                             end;
{$endif GDB}
                           end;
                          hp:=pai(hp^.next);
                        end;
{$ifdef GDB}
                       { force write of filename }
                       FillChar(stabslastfileinfo,sizeof(stabslastfileinfo),0);
                       includecount:=0;
                       funcname:=nil;
                       WriteFileLineInfo(hp^.fileinfo);
{$endif GDB}
                       if lastsec<>sec_none then
                         AsmWriteLn(ait_section2str(lastsec,lastsecidx));
                       AsmStartSize:=AsmSize;
                     end;
           else
             internalerror(10000);
           end;
           hp:=pai(hp^.next);
        end;
      end;


    procedure ti386attasmlist.WriteAsmList;
    var
      p:dirstr;
      n:namestr;
      e:extstr;
{$ifdef GDB}
      fileinfo : tfileposinfo;
{$endif GDB}

    begin
{$ifdef EXTDEBUG}
      if assigned(current_module^.mainsource) then
       Comment(v_info,'Start writing att-styled assembler output for '+current_module^.mainsource^);
{$endif}

      LastSec:=sec_none;
{$ifdef GDB}
      FillChar(stabslastfileinfo,sizeof(stabslastfileinfo),0);
{$endif GDB}
      FillChar(lastfileinfo,sizeof(lastfileinfo),0);
      LastInfile:=nil;
      MMXWarn:=false;

      if assigned(current_module^.mainsource) then
       fsplit(current_module^.mainsource^,p,n,e)
      else
       begin
         p:=inputdir;
         n:=inputfile;
         e:=inputextension;
       end;
    { to get symify to work }
      AsmWriteLn(#9'.file "'+FixFileName(n+e)+'"');

{$ifdef GDB}
      n_line:=n_bssline;
      funcname:=nil;
      linecount:=1;
      includecount:=0;
      fileinfo.fileindex:=1;
      fileinfo.line:=1;
      { Write main file }
      WriteFileLineInfo(fileinfo);
{$endif GDB}
      AsmStartSize:=AsmSize;

      { there should be nothing but externals so we don't need to process
      WriteTree(externals); }

      WriteTree(debuglist);
      WriteTree(codesegment);
      WriteTree(datasegment);
      WriteTree(consts);
      WriteTree(rttilist);
      WriteTree(bsssegment);
      Writetree(importssection);
      Writetree(exportssection);
      Writetree(resourcesection);

      AsmLn;
{$ifdef EXTDEBUG}
      if assigned(current_module^.mainsource) then
       comment(v_info,'Done writing att-styled assembler output for '+current_module^.mainsource^);
{$endif EXTDEBUG}
    end;


end.
{
  $Log: ag386att.pas,v $
  Revision 1.38.2.1  1998/09/11 10:49:09  pierre
    * bug with -g -al option removed

  Revision 1.38  1998/09/07 22:23:35  peter
    * fixed for no gdb compiler

  Revision 1.37  1998/09/07 18:33:34  peter
    + smartlinking for win95 imports

  Revision 1.36  1998/09/04 17:34:19  pierre
    * bug with datalabel corrected
    + assembler errors better commented
    * one nested record crash removed

  Revision 1.35  1998/09/03 17:08:38  pierre
    * better lines for stabs
      (no scroll back to if before else part
      no return to case line at jump outside case)
    + source lines also if not in order

  Revision 1.34  1998/09/03 11:22:41  peter
    + support for cs_asm_source

  Revision 1.33  1998/08/26 10:06:33  peter
    * reduce amount of asmfiles generated
    * no stabs are written in writefilelineinfo when debuginfo is off

  Revision 1.32  1998/08/20 09:26:35  pierre
    + funcret setting in underproc testing
      compile with _dTEST_FUNCRET

  Revision 1.31  1998/08/11 14:01:16  peter
    * @object type also for extended and comp

  Revision 1.30  1998/08/10 23:56:02  peter
    * fixed extended writing

  Revision 1.29  1998/08/10 14:49:35  peter
    + localswitches, moduleswitches, globalswitches splitting

  Revision 1.27  1998/08/08 12:30:07  florian
    * extended writing improved

  Revision 1.26  1998/08/08 10:19:16  florian
    * small fixes to write the extended type correct

  Revision 1.28  1998/08/10 10:01:33  peter
    * Fixed with GDB undefined

  Revision 1.25  1998/08/06 16:53:25  pierre
    * debugging info corrected

  Revision 1.24  1998/07/14 14:46:37  peter
    * released NEWINPUT

  Revision 1.23  1998/07/07 11:19:51  peter
    + NEWINPUT for a better inputfile and scanner object

  Revision 1.22  1998/06/08 22:59:42  peter
    * smartlinking works for win32
    * some defines to exclude some compiler parts

  Revision 1.21  1998/06/05 17:46:01  peter
    * tp doesn't like comp() typecast

  Revision 1.20  1998/06/04 23:51:27  peter
    * m68k compiles
    + .def file creation moved to gendef.pas so it could also be used
      for win32

  Revision 1.19  1998/05/31 14:13:29  peter
    * fixed call bugs with assembler readers
    + OPR_SYMBOL to hold a symbol in the asm parser
    * fixed staticsymtable vars which were acessed through %ebp instead of
      name

  Revision 1.18  1998/05/28 17:24:25  peter
    - $R- for tp to solve range errors with in[]

  Revision 1.17  1998/05/25 17:11:34  pierre
    * firstpasscount bug fixed
      now all is already set correctly the first time
      under EXTDEBUG try -gp to skip all other firstpasses
      it works !!
    * small bug fixes
      - for smallsets with -dTESTSMALLSET
      - some warnings removed (by correcting code !)

  Revision 1.16  1998/05/23 01:20:54  peter
    + aktasmmode, aktoptprocessor, aktoutputformat
    + smartlink per module $SMARTLINK-/+ (like MMX) and moved to aktswitches
    + $LIBNAME to set the library name where the unit will be put in
    * splitted cgi386 a bit (codeseg to large for bp7)
    * nasm, tasm works again. nasm moved to ag386nsm.pas

  Revision 1.15  1998/05/11 13:07:53  peter
    + $ifdef NEWPPU for the new ppuformat
    + $define GDB not longer required
    * removed all warnings and stripped some log comments
    * no findfirst/findnext anymore to remove smartlink *.o files

  Revision 1.14  1998/05/06 18:36:53  peter
    * tai_section extended with code,data,bss sections and enumerated type
    * ident 'compiled by FPC' moved to pmodules
    * small fix for smartlink

  Revision 1.13  1998/05/06 08:38:32  pierre
    * better position info with UseTokenInfo
      UseTokenInfo greatly simplified
    + added check for changed tree after first time firstpass
      (if we could remove all the cases were it happen
      we could skip all firstpass if firstpasscount > 1)
      Only with ExtDebug

  Revision 1.12  1998/05/04 17:54:24  peter
    + smartlinking works (only case jumptable left todo)
    * redesign of systems.pas to support assemblers and linkers
    + Unitname is now also in the PPU-file, increased version to 14

  Revision 1.11  1998/05/01 07:43:52  florian
    + basics for rtti implemented
    + switch $m (generate rtti for published sections)

  Revision 1.10  1998/04/30 15:59:39  pierre
    * GDB works again better :
      correct type info in one pass
    + UseTokenInfo for better source position
    * fixed one remaining bug in scanner for line counts
    * several little fixes

  Revision 1.9  1998/04/29 10:33:41  pierre
    + added some code for ansistring (not complete nor working yet)
    * corrected operator overloading
    * corrected nasm output
    + started inline procedures
    + added starstarn : use ** for exponentiation (^ gave problems)
    + started UseTokenInfo cond to get accurate positions

  Revision 1.8  1998/04/28 08:23:58  pierre
    * bug in stabn generation fixed

  Revision 1.7  1998/04/27 23:10:27  peter
    + new scanner
    * $makelib -> if smartlink
    * small filename fixes pmodule.setfilename
    * moved import from files.pas -> import.pas

  Revision 1.6  1998/04/21 11:30:13  peter
    * fixed $ifdef regalloc

  Revision 1.5  1998/04/16 16:53:24  jonas
    * changed $ifdef regalloc to $ifdef dregalloc (= debugging info)

  Revision 1.4  1998/04/09 15:46:38  florian
    + register allocation tracing stuff added

  Revision 1.3  1998/04/08 16:58:00  pierre
    * several bugfixes
      ADD ADC and AND are also sign extended
      nasm output OK (program still crashes at end
      and creates wrong assembler files !!)
      procsym types sym in tdef removed !!

}
