#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/examples/hello-world/RCS/client.py,v $
# Version:      @(#)$RCSfile: client.py,v $ $Revision: 1.5 $
#
#############################################################################
""" Client for the "Hello World" example. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import CORBA

# Stubs generated by 'fnidl'.
import HelloWorld


def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Read the server's stringified IOR from a file (this is just a 'cheap and
    # cheerful' way of locating the server - in practise the client would use
    # the naming or trader services).
    stringified_ior = open('server.ref').read()

    # Convert the stringified IOR into an active object reference.
    server = orb.string_to_object(stringified_ior)

    # Make sure that the server is not a 'nil object reference' (represented
    # in Python by the value 'None').
    if server is None:
	raise 'Nil object reference!'

    # Make sure that the object implements the expected interface!
    if not server._is_a('IDL:dstc.edu.au/HelloWorld/HelloWorldIF:1.0'):
	raise 'This is not a "HelloWorldIF" server!'

    # Call the server!
    print server.hello_world()

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
