#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <pmerr.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

HPS hps;
HAB hab;
RECTL rcl;
LONG lcid = 0;
char *str = "abcdABCD";
FONTMETRICS fm;

void fl_arc(int x,int y,int w,int h,double a1,double a2)
{
  if (w <= 0 || h <= 0) return;
  if (a1 == a2) return;
  if (a1 < 0) a1 = a1 + 360;
  if (a2 < 0) a2 = a2 + 360;
  a2 = a2 - a1;
  if (a2 < 0)
  {
    a2 = a2 + 360;
    if (a2 == 0)
      a2 = 360;
  }
  ARCPARAMS arcp = { w/2, h/2, 0, 0};
  int parentHeight = rcl.yTop - 1;
  POINTL center = { w/2 + x, parentHeight - y - (h / 2)};
  GpiSetLineType(hps,LINETYPE_INVISIBLE);
  GpiSetArcParams(hps,&arcp);
  GpiPartialArc(hps,&center,MAKEFIXED(1,0),(LONG)a1*65536,0);
  GpiSetLineType(hps,LINETYPE_SOLID);
  GpiPartialArc(hps,&center,MAKEFIXED(1,0),(LONG)a1*65536,(LONG)a2*65536);
}

void fl_pie(int x,int y,int w,int h,double a1,double a2)
{
  if (w <= 0 || h <= 0) return;
  if (a1 < 0) a1 = a1 + 360;
  if (a2 < 0) a2 = a2 + 360;
  a2 = a2 - a1;
  if (a2 < 0)
  {
    a2 = a2 + 360;
    if (a2 == 0)
      a2 = 360;
  }
  int parentHeight = rcl.yTop - 1;
  POINTL center = { w/2 + x, parentHeight - y - (h / 2)};
  GpiMove(hps,&center);
  ARCPARAMS arcp = { w/2, h/2, 0, 0};
  GpiSetArcParams(hps,&arcp);
  GpiBeginPath(hps,1L);
  // Need to take int of a1 and a2, then their decimal parts
  // and do the MAKEFIXED macro on them as input to the GpiPartialArc fn
  GpiPartialArc(hps,&center,MAKEFIXED(1,0),(LONG)a1*65536,(LONG)a2*65536);
  GpiEndPath(hps);
  GpiFillPath(hps,1L,FPATH_ALTERNATE);
}

MRESULT EXPENTRY WinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  APIRET rc;
  POINTL center = { 150, 100};
  ARCPARAMS arcp = { 30, 30, 0, 0};
  LONG 
    a1 = 270,
    a2 = 180;

  switch (msg)
  {
    case WM_PAINT:
      hps = WinGetPS(hwnd);
      char *strs = (char*)malloc(256);
      PSTR8 p = (PSTR8) strs;
      char *cids = (char*)malloc(256);
      PLONG l = (PLONG)cids;
      char *types = (char*)malloc(256);
      PLONG t = (PLONG)types;
      rc = GpiQuerySetIds(hps,GpiQueryNumberSetIds(hps),(PLONG)types,(PSTR8)strs,(PLONG)cids);

      rc = GpiSetCharSet(hps,lcid);
      if (rc != 1)
      {
        ERRORID eid = 0;
        eid = WinGetLastError(hab);
        printf("eid: 0x%08X\n",eid);
      }
      rc = GpiQueryFontMetrics(hps,sizeof(FONTMETRICS),&fm);
      WinBeginPaint(hwnd, hps, &rcl);
      WinFillRect(hps,&rcl,CLR_PALEGRAY);
      GpiSetColor(hps,CLR_BLUE);
      fl_pie(20,20,50,50,0,360);
      GpiSetColor(hps,CLR_BLACK);
      fl_arc(20,20,50,50,0,360);
      POINTL aptl[TXTBOX_COUNT];
      RECTL textRect;
      GpiQueryTextBox(hps,strlen(str),(PCH)str,TXTBOX_COUNT,aptl);
      int height = aptl[TXTBOX_TOPRIGHT].y - aptl[TXTBOX_BOTTOMLEFT].y;
      textRect.xLeft = aptl[TXTBOX_BOTTOMLEFT].x;
      textRect.yBottom = 10;
      textRect.xRight = aptl[TXTBOX_TOPRIGHT].x + 10;
      textRect.yTop = 10 + height;
      rc = GpiCharStringAt(hps,&aptl[0],strlen(str),(PCH)str);
      //WinDrawText(hps,strlen(str),(PCH)str,&textRect,CLR_BLACK,BM_LEAVEALONE,0L);
      WinEndPaint(hwnd);
      return 0;
      break;
  }
  return WinDefWindowProc(hwnd, msg, mp1, mp2);
}


int main()
{
  int haveMessage = 1;
  QMSG msg;
  HMQ hmq;
  ULONG flFrameFlags = FCF_SIZEBORDER | FCF_MAXBUTTON | FCF_TITLEBAR | FCF_SYSMENU | FCF_TASKLIST;
  APIRET rc;
  HWND hwndFrame, hwndClient;

  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue(hab, 0);
  rc = WinRegisterClass(hab,
                        (PSZ)"Fred",
                        WinProc,
                        WS_VISIBLE,
                        NULL);
  hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                 0,
                                 &flFrameFlags,
                                 (PSZ)"Fred",
                                 (PSZ)"Fred",
                                 0,
                                 NULLHANDLE,
                                 0,
                                 &hwndClient);
  rc = WinSetWindowPos(hwndFrame,
                       NULLHANDLE,
                       300, 500,
                       300, 200, 
                       SWP_SIZE|SWP_ACTIVATE|SWP_MOVE|SWP_SHOW);

  hps = WinGetPS(hwndClient);
  FATTRS fat;
  memset(&fat,0x00,sizeof(FATTRS));
  fat.usRecordLength = sizeof(FATTRS);
  fat.lMaxBaselineExt = 24;
  fat.lAveCharWidth = 24;
  fat.fsFontUse = FATTR_FONTUSE_TRANSFORMABLE;
  strcpy(fat.szFacename,"Arial\0");
  lcid = 1;
  rc = GpiCreateLogFont(hps,NULL,lcid,&fat);
  rc = GpiSetCharSet(hps,lcid);
  rc = GpiQueryFontMetrics(hps,sizeof(FONTMETRICS),&fm);

  while (haveMessage)
  {
    haveMessage = WinGetMsg(hab, &msg, NULLHANDLE, 0, 0);
    WinDispatchMsg(hab, &msg);
  }

  return 0;
}
