#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <pmerr.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "cat.h"

HDC hdc, hdcBuffer;
HPS hps, hpsBuffer;
HAB hab;
RECTL rcl;
char str[256];
static LONG pitch = 14;
FONTMETRICS fm;
static beenHere = 0;

void SetFontSize(HPS hps, LONG lHeight, LONG lWidth);
LONG CreateOutlineFont (HPS hps, LONG lLcid, USHORT usCodepage, PSZ pszFacename);
BOOL SetCharPoint(HPS hps, LONG lOutlineLcid, LONG lPitch);
LONG CreateImageFont (HPS hps, LONG lLcid, SHORT sPointSize,
                      USHORT usCodepage, PSZ pszFacename);

MRESULT EXPENTRY WinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  APIRET rc;
  SIZEL pagesize = {0,0};
  static HBITMAP hbm;
  BITMAPINFO2 *pbmi;
  BITMAPINFOHEADER2 bmp;
  POINTL aptl[4];

  switch (msg)
  {
    case WM_CREATE:
      hdc = WinOpenWindowDC(hwnd);
      hps = GpiCreatePS(hab,hdc,&pagesize,PU_PELS | GPIA_ASSOC | GPIT_MICRO);
      /*
       * create memory device context - our double buffer
       */
      hdcBuffer = DevOpenDC((HAB)0L, OD_MEMORY, "*", 0L, (PDEVOPENDATA)NULL, NULL);
      /* 
       * Create the presentation space and associate the memory device context.
       */
      hpsBuffer = GpiCreatePS(hab, hdcBuffer, &pagesize, PU_PELS | GPIT_MICRO | GPIA_ASSOC | GPIF_DEFAULT );
      return 0;
      break;
    case WM_CHAR:
      if ((CHARMSG(&msg)->fs & KC_KEYUP) == 0)
      {
        if (CHARMSG(&msg)->vkey == VK_BACKSPACE)
        {
          WinInvalidateRect(hwnd,NULL,TRUE);
          pitch --;
        }
        if (CHARMSG(&msg)->vkey == VK_NEWLINE)
        {
          WinInvalidateRect(hwnd,NULL,TRUE);
          pitch ++;
        }
      }
      return 0;
      break;
    case WM_PAINT:
      WinBeginPaint(hwnd, hps, &rcl);

      RECTL rclWindow;
      LONG cyHeight;
      LONG cxWidth;
      HBITMAP hbm;
      BITMAPINFOHEADER bmp;
      LONG cColorPlanes, cColorBitcount;

      SIZEL pagesize = {0,0};
      if (!beenHere)
      {
        /* rc = CreateImageFont(hps,2,9,0,"WarpSans"); */
        rc = CreateOutlineFont(hpsBuffer,1,0,"Photina");
        rc = CreateOutlineFont(hpsBuffer,2,0,"Comic Sans MS");
        beenHere = 1;
      }
      DevQueryCaps (hdc, CAPS_COLOR_PLANES, 1L, &cColorPlanes);
      DevQueryCaps (hdc, CAPS_COLOR_BITCOUNT, 1L, &cColorBitcount);
      /*
       * Get the width and height of the window rectangle.
       */
      WinQueryWindowRect (hwnd, &rclWindow);
      cxWidth = rclWindow.xRight - rclWindow.xLeft;
      cyHeight = rclWindow.yTop - rclWindow.yBottom;
      /*
       * Now create a bitmap the size of the window.
       */
      bmp.cbFix = sizeof(BITMAPINFOHEADER);
      bmp.cx = (SHORT)cxWidth;
      bmp.cy = (SHORT)cyHeight;
      bmp.cPlanes = (SHORT)cColorPlanes;
      bmp.cBitCount = (SHORT)cColorBitcount;
      hbm = GpiCreateBitmap(hpsBuffer, (PBITMAPINFOHEADER2)&bmp,
                            0x0000, (PBYTE)NULL, (PBITMAPINFO2)NULL);
      /*
       * Set the bitmap into the memory presentation space.
       */
      GpiSetBitmap (hpsBuffer, hbm);

      /*
       * Draw, draw, draw!
       */
      rc = GpiSetCharSet(hpsBuffer,2);
      SetFontSize(hpsBuffer,pitch,pitch);
      sprintf(str,"Hello, world!\0");

      rc = WinFillRect(hpsBuffer,&rcl,CLR_PALEGRAY);
      rc = GpiSetColor(hpsBuffer,CLR_BLACK);

      POINTL aptl[TXTBOX_COUNT];
      RECTL textRect;
      rc = GpiQueryTextBox(hpsBuffer,strlen(str),(PCH)str,TXTBOX_COUNT,aptl);
      int height = aptl[TXTBOX_TOPRIGHT].y - aptl[TXTBOX_BOTTOMLEFT].y;
      textRect.xLeft = 0;
      textRect.yBottom = 0;
      textRect.xRight = aptl[TXTBOX_BOTTOMLEFT].x + aptl[TXTBOX_CONCAT].x;
      textRect.yTop = aptl[TXTBOX_TOPRIGHT].y - aptl[TXTBOX_BOTTOMLEFT].y;;
      rc = WinDrawText(hpsBuffer,strlen(str),(PCH)str,&textRect,CLR_BLACK,BM_LEAVEALONE,0L);

      /*
       * Ok, the show's over.  Blit the memory presentation space back out
       * to the visible PS.
       */
      POINTL ptl[3];
      ptl[0].x = 0;
      ptl[0].y = 0;
      ptl[1].x = cxWidth;
      ptl[1].y = cyHeight;
      ptl[2].x = 0;
      ptl[2].y = 0;

      rc = GpiBitBlt(hps,hpsBuffer,3L,ptl,ROP_SRCCOPY,BBO_IGNORE);
      WinEndPaint(hps);
      return 0;
  }
  return WinDefWindowProc(hwnd, msg, mp1, mp2);
}


int main()
{
  int haveMessage = 1;
  QMSG msg;
  HMQ hmq;
  ULONG flFrameFlags = FCF_SIZEBORDER | FCF_MAXBUTTON | FCF_TITLEBAR | FCF_SYSMENU | FCF_TASKLIST | FCF_SHELLPOSITION;
  APIRET rc;
  HWND hwndFrame, hwndClient;

  hab = WinInitialize(0);
  rc = WinGetLastError(hab);
  printf("WinGetLastError after WinInitialize: 0x%08x\n",rc);
  hmq = WinCreateMsgQueue(hab, 0);
  rc = WinGetLastError(hab);
  printf("WinGetLastError after WinGetLastError: 0x%08x\n",rc);
  rc = WinRegisterClass(hab,
                        (PSZ)"Fred",
                        WinProc,
                        WS_VISIBLE,
                        NULL);
  rc = WinGetLastError(hab);
  printf("WinGetLastError after WinRegisterClass: 0x%08x\n",rc);

  hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                 0,
                                 &flFrameFlags,
                                 (PSZ)"Fred",
                                 (PSZ)"Fred",
                                 0,
                                 NULLHANDLE,
                                 0,
                                 &hwndClient);
  rc = WinGetLastError(hab);
  printf("WinGetLastError after WinCreateStdWindow: 0x%08x\n",rc);
  rc = WinSetWindowPos(hwndFrame,
                       NULLHANDLE,
                       0, 0,
                       300, 200, 
                       SWP_SIZE|
                       SWP_ACTIVATE|
                       //SWP_MOVE|
                       SWP_SHOW);

  WinSetActiveWindow(HWND_DESKTOP,hwndFrame);

  rc = WinGetLastError(hab);
  printf("WinGetLastError after WinSetWindowPos: 0x%08x\n",rc);
  while (haveMessage)
  {
    haveMessage = WinGetMsg(hab, &msg, NULLHANDLE, 0, 0);
    WinDispatchMsg(hab, &msg);
  }

  return 0;
}

/******************************************************************************/
/*                                                                            */
/*   CROLNFNT.C           CreateOutlineFont                                   */
/*                                                                            */
/*   Create a logical outline font with the specified Facename, set id, and   */
/*   codepage.                                                                */
/*                                                                            */
/*   An explicit codepage should normally be specified. However, if zero is   */
/*   specified then the codepage defined in the font metrics will be used.    */
/*   If this too is zero then it is a universal (i.e., multi-codepage) font   */
/*   current PS codepage will be used.                                        */
/*                                                                            */
/*   Note that this function uses its own 8 character font name rather than   */
/*   requiring this as a parameter, and this name will thus be the same for   */
/*   each created font. This name is not used for font selection and is       */
/*   normally of little interest.                                             */
/*                                                                            */
/*   Inputs:  hps           PS handle                                         */
/*            lLcid         set id                                            */
/*            usCodepage    codepage                                          */
/*            pszFacename   font Facename                                     */
/*                                                                            */
/*   Returns: FONT_MATCH    Font match successful                             */
/*            FONT_DEFAULT  Font match unsuccessful; default font returned    */
/*            GPI_ERROR     Error                                             */
/*                                                                            */
/******************************************************************************/

LONG CreateOutlineFont (HPS hps, LONG lLcid, USHORT usCodepage, PSZ pszFacename)
{
  PFONTMETRICS  afmMetrics = NULL        ;    /* pointer to FONTMETRICS array */
  LONG          lNumFonts                ;    /* number of fonts              */
  LONG          lReqFonts                ;    /* number fonts requested       */
  LONG          lRemFonts = GPI_ALTERROR ;    /* number fonts not returned    */
  LONG          lMatch    = GPI_ERROR    ;    /* font match return code       */
  INT           i                        ;    /* array index                  */
  FATTRS        fatAttrs                 ;    /* font attributes              */

  /****************************************************************************/
  /* Query the number of fonts to determine how much memory to allocate for   */
  /* font metrics, allocate the memory and query the metrics for all public   */
  /* fonts with the required facename.                                        */
  /****************************************************************************/

  lReqFonts = 0L;
  lNumFonts = GpiQueryFonts(hps, QF_PUBLIC, pszFacename, &lReqFonts, 0L, NULL );

  if ((lNumFonts!=GPI_ALTERROR) && (lNumFonts!= 0L))
    afmMetrics = (FONTMETRICS*)malloc((USHORT)(lNumFonts*sizeof(FONTMETRICS)));

  if (afmMetrics != NULL)
    lRemFonts = GpiQueryFonts(hps, QF_PUBLIC, pszFacename, &lNumFonts,
                              (LONG)sizeof(FONTMETRICS), afmMetrics);

  /****************************************************************************/
  /* Search the font metrics for a font that satisfies the following          */
  /* conditions and create a logical font for it without using lMatch:        */
  /*     font is outline                                                      */
  /*     facename matches required facename                                   */
  /* If specified codepage is default (i.e., zero) and font is non-universal  */
  /* (i.e., codepage non-zero) then use font codepage, otherwise use          */
  /* codepage.                                                                */
  /****************************************************************************/

  if (lRemFonts != GPI_ALTERROR)
  {
    for (i = 0; i < (INT)lNumFonts; i++)
    {
      if ((afmMetrics[i].fsDefn & FM_DEFN_OUTLINE)     /*  check for outline  */
          && !(strcmp(afmMetrics[i].szFacename, pszFacename)))/* compare facename */
      {
        fatAttrs.usRecordLength  = sizeof(FATTRS);
        fatAttrs.fsSelection     = 0;
        fatAttrs.lMatch          = 0L;
        strcpy(fatAttrs.szFacename, afmMetrics[i].szFacename);
        fatAttrs.idRegistry      = afmMetrics[i].idRegistry;
        if (usCodepage == 0 && afmMetrics[i].usCodePage != 0)
          fatAttrs.usCodePage = afmMetrics[i].usCodePage;
        else
          fatAttrs.usCodePage = usCodepage;
        fatAttrs.lMaxBaselineExt = 0L;
        fatAttrs.lAveCharWidth   = 0L;
        fatAttrs.fsType          = 0;
        fatAttrs.fsFontUse       = (FATTR_FONTUSE_OUTLINE |
                                    FATTR_FONTUSE_TRANSFORMABLE);
        lMatch = GpiCreateLogFont(hps, (PSTR8)NULL, lLcid, &fatAttrs);
        break;
      }
    }
  }
  /****************************************************************************/
  /* free the memory and return                                               */
  /****************************************************************************/

  free(afmMetrics);
  return(lMatch);
}

/******************************************************************************/
/*                                                                            */
/*   CRIMGFNT.C           CreateImageFont                                     */
/*                                                                            */
/*   Create a logical raster font with the specified Facename, set id,        */
/*   point size and codepage.                                                 */
/*                                                                            */
/*   An explicit codepage should normally be specified. However, if zero is   */
/*   specified then the codepage defined in the font metrics will be used.    */
/*   If this too is zero then it is a universal (i.e., multi-codepage) font   */
/*   and the current PS codepage will be used.                                */
/*                                                                            */
/*   Note that this function uses its own 8 character font name rather than   */
/*   requiring this as a parameter, and this name will thus be the same for   */
/*   each created font. This name is not used for font selection and is       */
/*   normally of little interest.                                             */
/*                                                                            */
/*   Inputs:  hps             PS handle                                       */
/*            lLcid           set id                                          */
/*            sPointSize  point size in decipoints                        */
/*            usCodepage      codepage (can be specified as zero)             */
/*            pszFacename     font Facename                                   */
/*                                                                            */
/*   Returns: FONT_MATCH    Font match successful                             */
/*            FONT_DEFAULT  Font match unsuccessful; default font returned    */
/*            GPI_ERROR     Error                                             */
/*                                                                            */
/******************************************************************************/

LONG CreateImageFont (HPS hps, LONG lLcid, SHORT sPointSize,
                      USHORT usCodepage, PSZ pszFacename)
{
  PFONTMETRICS  afmMetrics = NULL        ;    /* pointer to FONTMETRICS array */
  LONG          lNumFonts                ;    /* number of fonts              */
  LONG          lReqFonts                ;    /* number fonts requested       */
  LONG          lRemFonts = GPI_ALTERROR ;    /* number fonts not returned    */
  LONG          lMatch    = GPI_ERROR    ;    /* font match return code       */
  LONG          lXDevRes                 ;    /* actual X device resolution   */
  LONG          lYDevRes                 ;    /* actual Y device resolution   */
  BOOL          fRet = FALSE             ;    /* BOOL return code             */
  INT           i                        ;    /* array index                  */
  FATTRS        fatAttrs                 ;    /* font attributes              */
  HDC           hdc   = NULLHANDLE       ;    /* DC handle                    */

  /****************************************************************************/
  /* Query the number of fonts to determine how much memory to allocate for   */
  /* font metrics, allocate the memory and query the metrics for all public   */
  /* fonts with the required facename.                                        */
  /****************************************************************************/

  lReqFonts = 0L;
  lNumFonts = GpiQueryFonts(hps, QF_PUBLIC, pszFacename, &lReqFonts, 0L, NULL );

  if ((lNumFonts!=GPI_ALTERROR) && (lNumFonts!= 0L))
    afmMetrics = (FONTMETRICS*)malloc((USHORT)(lNumFonts*sizeof(FONTMETRICS)));

  if (afmMetrics != NULL)
    lRemFonts = GpiQueryFonts(hps, QF_PUBLIC, pszFacename, &lNumFonts,
                              (LONG)sizeof(FONTMETRICS), afmMetrics);

  /****************************************************************************/
  /* Query the actual horizontal and vertical resolution for the device.      */
  /****************************************************************************/

  if (lRemFonts != GPI_ALTERROR)
    hdc = GpiQueryDevice(hps);                  /* query associated DC handle */

  if ((hdc!=NULLHANDLE)&&(hdc!=HDC_ERROR))       /* query actual device X res */
    fRet = DevQueryCaps( hdc                     /* -DC handle                */
                         , CAPS_HORIZONTAL_FONT_RES /* -first item requested    */
                         , 1L                      /* -number of caps requested */
                         , &lXDevRes               /* -returned caps            */
                       );

  if (fRet)                                      /* query actual device Y res */
    fRet = DevQueryCaps( hdc                     /* -DC handle                */
                         , CAPS_VERTICAL_FONT_RES  /* -first item requested     */
                         , 1L                      /* -number of caps requested */
                         , &lYDevRes               /* -returned caps            */
                       );


  /****************************************************************************/
  /* Search the font metrics for a font that satisfies the following          */
  /* conditions and create a logical font for it without using lMatch:        */
  /*     font is not outline                                                  */
  /*     facename matches required facename                                   */
  /*     point size matches required point size                               */
  /*     resolution matches target device                                     */
  /* If specified codepage is default (i.e., zero) and font is non-universal  */
  /* (i.e., codepage non-zero) then use font codepage, otherwise use          */
  /* codepage.                                                                */
  /****************************************************************************/

  if (fRet)
  {
    for (i = 0; i < (INT)lNumFonts; i++)
    {
//    if (!(afmMetrics[i].fsDefn & FM_DEFN_OUTLINE)     /* check for raster   */
//    && !(strcmp(afmMetrics[i].szFacename, pszFacename)) /* compare facename */

      if (
         !(strcmp(afmMetrics[i].szFacename, pszFacename)) /* compare facename */
         && (afmMetrics[i].sNominalPointSize == sPointSize * 10) /*compare pt size*/
         && ((LONG)afmMetrics[i].sXDeviceRes == lXDevRes)  /* compare X & Y Res  */
         && ((LONG)afmMetrics[i].sYDeviceRes == lYDevRes)) /* for this device    */
      {
        fatAttrs.usRecordLength  = sizeof(FATTRS);
        fatAttrs.fsSelection     = 0;
        fatAttrs.lMatch          = 0L;
        strcpy(fatAttrs.szFacename, afmMetrics[i].szFacename);
        fatAttrs.idRegistry      = afmMetrics[i].idRegistry;
        if (usCodepage == 0 && afmMetrics[i].usCodePage != 0)
          fatAttrs.usCodePage = afmMetrics[i].usCodePage;
        else
          fatAttrs.usCodePage = usCodepage;
        fatAttrs.lMaxBaselineExt = afmMetrics[i].lMaxBaselineExt;
        fatAttrs.lAveCharWidth   = afmMetrics[i].lAveCharWidth;
        fatAttrs.fsType          = 0;
        fatAttrs.fsFontUse       = 0;

        lMatch = GpiCreateLogFont(hps, (PSTR8)NULL, lLcid, &fatAttrs);
        break;
      }
    }
  }
  /****************************************************************************/
  /* free the memory and return                                               */
  /****************************************************************************/

  free(afmMetrics);
  return(lMatch);
}


void SetFontSize(HPS hps, LONG lHeight, LONG lWidth)
{
  HDC   hDC;
  LONG  lxFontResolution,lyFontResolution;         // in pels per inch
  double dPointSizeH, dPointSizeV;
  SIZEF fSize;
  dPointSizeV = (double)lHeight;
  dPointSizeH = (double)lWidth;

  hDC = GpiQueryDevice(hps);
  DevQueryCaps( hDC, CAPS_HORIZONTAL_FONT_RES, (LONG)1,&lxFontResolution);
  DevQueryCaps( hDC, CAPS_VERTICAL_FONT_RES, (LONG)1,&lyFontResolution);

  dPointSizeH = (dPointSizeH * lxFontResolution * 9661) / (72 * 10000);
  dPointSizeV = (dPointSizeV * lyFontResolution * 9661) / (72 * 10000);

  fSize.cx = (FIXED)((ULONG) (dPointSizeH * 65536.0));
  fSize.cy = (FIXED)((ULONG) (dPointSizeV * 65536.0));

  GpiSetCharBox (hps,&fSize);

}
