//
// "$Id: Fl_get_key_win32.cxx,v 1.4.2.5 2001/01/22 15:13:40 easysw Exp $"
//
// WIN32 keyboard state routines for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2001 by Bill Spitzak and others.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
// Please report all bugs and problems to "fltk-bugs@fltk.org".
//

// Return the current state of a key.  Keys are named by fltk symbols,
// which are actually X keysyms.  So this has to translate to MSWindows
// VK_x symbols.

#include <FL/Fl.H>
#include <FL/os2.H>

// convert an Fltk (X) keysym to an OS/2 VK symbol:
// See also the inverse converter in Fl_win32.C
// This table is in numeric order by Fltk symbol order for binary search:

static const struct {unsigned short vk, fltk;} vktab[] = {
  {VK_SPACE,	' '},
  {'1',		'!'},
  {0xde,	'\"'},
  {'3',		'#'},
  {'4',		'$'},
  {'5',		'%'},
  {'7',		'&'},
  {0xde,	'\''},
  {'9',		'('},
  {'0',		')'},
  {'8',		'*'},
  {0xbb,	'+'},
  {0xbc,	','},
  {0xbd,	'-'},
  {0xbe,	'.'},
  {0xbf,	'/'},
  {0xba,	':'},
  {0xba,	';'},
  {0xbc,	'<'},
  {0xbb,	'='},
  {0xbe,	'>'},
  {0xbf,	'?'},
  {'2',		'@'},
  {0xdb,	'['},
  {0xdc,	'\\'},
  {0xdd,	']'},
  {'6',		'^'},
  {0xbd,	'_'},
  {0xc0,	'`'},
  {0xdb,	'{'},
  {0xdc,	'|'},
  {0xdd,	'}'},
  {0xc0,	'~'},
  {VK_BACKSPACE,FL_BackSpace},
  {VK_TAB,	FL_Tab},
  {VK_CLEAR,	0xff0b/*XK_Clear*/},
  {VK_ENTER,	FL_Enter},
  {VK_PAUSE,	FL_Pause},
  {VK_SCRLLOCK,	FL_Scroll_Lock},
  {VK_ESC,	FL_Escape},
  {VK_HOME,	FL_Home},
  {VK_LEFT,	FL_Left},
  {VK_UP,	FL_Up},
  {VK_RIGHT,	FL_Right},
  {VK_DOWN,	FL_Down},
  {VK_PAGEUP,	FL_Page_Up},
  {VK_PAGEDOWN,	FL_Page_Down},
  {VK_END,	FL_End},
  {VK_PRINTSCRN,FL_Print},
  {VK_INSERT,	FL_Insert},
  {VK_MENU,	FL_Menu},
  {VK_NUMLOCK,	FL_Num_Lock},
//  {VK_???,	FL_KP_Enter},
//  {VK_MULTIPLY,	FL_KP+'*'},
//  {VK_ADD,	FL_KP+'+'},
//  {VK_SUBTRACT,	FL_KP+'-'},
//  {VK_DECIMAL,	FL_KP+'.'},
//  {VK_DIVIDE,	FL_KP+'/'},
  {VK_SHIFT,	FL_Shift_L},
  {VK_SHIFT,	FL_Shift_R},
  {VK_CTRL,	FL_Control_L},
  {VK_CTRL,	FL_Control_R},
  {VK_CAPSLOCK,	FL_Caps_Lock},
//  {VK_LWIN,	FL_Meta_L},
//  {VK_RWIN,	FL_Meta_R},
  {VK_ALT,	FL_Alt_L},
  {VK_ALT,	FL_Alt_R},
  {VK_DELETE,	FL_Delete}
};

static int fltk2ms(int fltk) {
  if (fltk >= '0' && fltk <= '9') return fltk;
  if (fltk >= 'A' && fltk <= 'Z') return fltk;
  if (fltk >= 'a' && fltk <= 'z') return fltk-('a'-'A');
  if (fltk > FL_F && fltk <= FL_F+16) return fltk-(FL_F-(VK_F1-1));
//  if (fltk >= FL_KP+'0' && fltk<=FL_KP+'9') return fltk-(FL_KP+'0'-VK_NUMPAD0);
  int a = 0;
  int b = sizeof(vktab)/sizeof(*vktab);
  int vk= 0, fk = 0;
  while (a < b)
  {
    int c = (a+b)/2;
    fk = vktab[c].fltk;
    vk = vktab[c].vk;
    if (vktab[c].fltk == fltk)
      return vktab[c].vk;
    if (vktab[c].fltk < fltk) a = c+1; else b = c;
  }
  return 0;
}

int Fl::event_key(int k) {
  int nk = fltk2ms(k);
  return WinGetKeyState(HWND_DESKTOP,nk)&~1;
}

int Fl::get_key(int k) {
  uchar foo[256];
  WinSetKeyboardStateTable(HWND_DESKTOP,(PBYTE)foo,FALSE);
  return foo[fltk2ms(k)]&~1;
}

//
// End of "$Id: Fl_get_key_win32.cxx,v 1.4.2.5 2001/01/22 15:13:40 easysw Exp $".
//
