//
// "$Id: os2.H,v 1.15.2.3 2001/01/22 15:13:38 easysw Exp $"
//
// OS/2 header file for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2001 by Bill Spitzak and others.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
// Please report all bugs and problems to "fltk-bugs@fltk.org".
//

// Do not directly include this file, instead use <FL/x.H>.  It will
// include this file if OS/2 is defined.  This is to encourage
// portability of even the system-specific code...

#define INCL_WIN
#define INCL_GPI
#define INCL_BASE
#include <os2.h>
#include <sys/time.h>
#include <sys/select.h>
#include <fl/Fl_Window.H>
#include <string.h>

extern FL_EXPORT HPS fl_gc;
extern FL_EXPORT HAB fl_pm_hab;
extern FL_EXPORT HDC fl_pm_hdc;

#ifdef __DEBUG__
  #include <stdio.h>
  #define WINGETLASTERROR(__X__) printf("%08X		%s:%s:%s\n",WinGetLastError(fl_pm_hab),__FILE__,__FUNCTION__,__X__)
  #define WINGETLASTERROR2(__X__,__Y__) printf("%08X %08X	%s:%s:%s\n",WinGetLastError(fl_pm_hab),__Y__,__FILE__,__FUNCTION__,__X__)
#else
  #define WINGETLASTERROR(__X__)
  #define WINGETLASTERROR2(__X__,__Y__)
#endif

static int winId = 1;

/*****************************************************************************/
/* Smaller of two values.                                                    */
/*****************************************************************************/
#if !defined(MIN)
#define MIN( M, N ) ( ( ( M ) < ( N ) ) ? ( M ) : ( N ) )
#endif
 
/*****************************************************************************/
/* Larger of two values                                                     */
/*****************************************************************************/
#if !defined(MAX)
#define MAX( M, N ) ( ( ( M ) > ( N ) ) ? ( M ) : ( N ) )
#endif

// Some random Win32 equivalents

#define RGB(b, g ,r)  ((LONG) (((BYTE) (r) | ((INT) (g) << 8)) | (((LONG) (BYTE) (b)) << 16))) 

typedef struct _tagMINMAXINFO {
   POINTL ptReserved;
   POINTL ptMaxSize;
   POINTL ptMaxPosition;
   POINTL ptMinTrackSize;
   POINTL ptMaxTrackSize;
} MINMAXINFO, *PMINMAXINFO, *LPMINMAXINFO;

#define CALLBACK _System

// some random X equivalents
typedef HWND Window;
typedef POINTL XPoint;
struct XRectangle {int x, y, width, height;};
typedef HRGN Region;
FL_EXPORT void fl_clip_region(Region);

inline Region XRectangleRegion(int x, int y, int w, int h) {
  RECTL rect0 = { 0, 0, 0, 0 };
  if ((x ==0) && (y == 0) && (w == 0) && (h == 0))
    return GpiCreateRegion(fl_gc,1,&rect0);
  else
  {
    if (Fl_Window::current())
    {
      int parentHeight = Fl_Window::current()->h();
      RECTL rect1 = { x, parentHeight - y - h, x + w, parentHeight - y};
      return GpiCreateRegion(fl_gc,1,&rect1);
    }
    else
      return GpiCreateRegion(fl_gc,1,&rect0);
  }
}

inline void XDestroyRegion(Region r)
{
  Region tempr = r;
  GpiDestroyRegion(fl_gc,r);
  WINGETLASTERROR2("GpiDestroyRegion",tempr);
}

inline void XClipBox(Region r,XRectangle* rect)
{
  // Not used, evidently...
}
#define XDestroyWindow(a,b) WinDestroyWindow(b)
#define XMapWindow(a,b) WinSendMsg(b,WM_SETFOCUS,(MPARAM)b,(MPARAM)TRUE)

#define XUnmapWindow(a,b) WinShowWindow(b, FALSE)

#include "Fl_Window.H"
// This object contains all OS/2-specific stuff about a window.
// Stand back... I dunno how big this thing's gonna get!
class Fl_X
{
public:
  Window xid;
  Window frame;
  HPS other_xid; // for double-buffered windows
  Fl_Window* w;
  Region region;
  Fl_X *next;
  int wait_for_expose;
  HDC private_dc; // used for OpenGL
  HWND cursor;
  static FL_EXPORT Fl_X* first;
  static FL_EXPORT Fl_X* i(const Fl_Window* w) {return w->i;}
  static FL_EXPORT int fake_X_wm(const Fl_Window* w,int &X, int &Y,
		                 int &bt,int &bx,int &by);
  FL_EXPORT void setwindow(Fl_Window* wi) {w=wi; wi->i=this;}
  FL_EXPORT void flush() {w->flush();}
  FL_EXPORT void set_minmax(LPMINMAXINFO minmax);
  FL_EXPORT void mapraise();
  static FL_EXPORT Fl_X* make(Fl_Window*);
};

extern FL_EXPORT HWND fl_default_cursor;
inline Window fl_xid(const Fl_Window*w) {return Fl_X::i(w)->xid;}
FL_EXPORT Fl_Window* fl_find(Window xid);
extern FL_EXPORT char fl_override_redirect; // hack into Fl_Window::make_xid()
extern FL_EXPORT int fl_background_pixel;  // hack into Fl_Window::make_xid()

// most recent fl_color() or fl_rgbcolor() points at one of these:
extern FL_EXPORT struct Fl_XMap {
  LONG rgb;	// this should be the type the RGB() macro returns
  int pen;	// pen, 0 if none created yet
  LONG brush;	// ref to solid brush, 0 if none created yet
} *fl_current_xmap;
inline long fl_RGB() {return fl_current_xmap->rgb;}
inline int fl_pen() {return fl_current_xmap->pen;}
FL_EXPORT int fl_brush(); // allocates a brush if necessary

extern FL_EXPORT HWND fl_display;
extern FL_EXPORT Window fl_window;
extern FL_EXPORT HWND fl_palette; // non-zero only on 8-bit displays!
extern FL_EXPORT HDC fl_GetDC(Window);
extern FL_EXPORT QMSG fl_msg;

// off-screen pixmaps: create, destroy, draw into, copy to window
#define Fl_Offscreen HBITMAP
#define fl_create_offscreen(w, h) GpiCreateBitmap(NULL,NULL,0L,NULL,NULL); \
  WINGETLASTERROR("GpiCreateBitmap")

extern FL_EXPORT HDC fl_makeDC(HBITMAP);
#define fl_begin_offscreen(b) \
  HDC _sgc=fl_gc; Window _sw=fl_window; \
  fl_gc=fl_makeDC(b); fl_window=(HWND)b; fl_push_no_clip()

#define fl_end_offscreen() \
  fl_pop_clip(); GpiDestroyPS(fl_gc); fl_window=_sw; fl_gc = _sgc; \
  WINGETLASTERROR("GpiDestoryPS")


FL_EXPORT void fl_copy_offscreen(int x,int y,int w,int h,HBITMAP pixmap,int srcx,int srcy);
#define fl_delete_offscreen(bitmap) //DeleteObject(bitmap);

//
// End of "$Id: os2.H,v 1.15.2.3 2001/01/22 15:13:38 easysw Exp $".
//
