#include <fstream>
#include <sstream>
#include <hash_map>
#include <vector>

#include "fbutton.h"
#include "fbase.h"
#include "fshape.h"
#include "fdisplay.h"
#include "fcontrol.h"
#include "fsprite.h"
#include "fsound.h"
#include "flashmp3encoder.h"
#include "ffont.h"
#include "flashfontobj.h"
#include "fmorph.h"

#include "ftarga.h"
#include "fbitmap.h"

#include "FImport.h"
#include "Magick++/Magick++.h"

using namespace Magick; 

UWORD ReadImage(char *fname, std::ostringstream &f, int &width, int &height) 
{
	UWORD return_val = 0;
	try
	{
		Image image(fname);
		width = image.baseColumns();
		height = image.baseRows();
		
		//Encode Image with 24 bit color
		int format = 5;
		
		unsigned char *imagedata = (unsigned char *)malloc(height*width*3);
		unsigned char *tgadata = (unsigned char *)malloc(height*width*4);

		image.write(0,0,width,height,"RGB",CharPixel,imagedata);	
		{
			for(UWORD y = 0; y < height; y++)
			{
				for(UWORD x = 0; x < width; x++)
				{
					UDWORD base = (y*width+x)*4;

					UDWORD base2 = (y*width+x)*3;
				
					unsigned char r = imagedata[base2];
					unsigned char g = imagedata[base2+1];
					unsigned char b = imagedata[base2+2];
					
					((unsigned char*)tgadata)[base+0]   =  0xff;
					((unsigned char*)tgadata)[base+1]   =  r;
					((unsigned char*)tgadata)[base+2]   =  g;
					((unsigned char*)tgadata)[base+3]   =  b;
					
				}
			}
		}
		FlashZLibBitmapData d((unsigned char *)tgadata,(width*height*4));
		FlashTagDefineBitsLossless2 db(format,width, height, d);
		f << db;

		free (imagedata);
		free (tgadata);

		FlashMatrix m;
		m.SetScale(20,20);
		
		FlashShapeWithStyle s;
		FlashFillStyleArray ffa;
		FlashFillStyleBitmap sf(db.GetID(),m); 

		ffa.AddFillStyle(&sf);
		s.SetFillStyleArray(ffa);
			
		FlashShapeRecordChange c(0,0);
		c.ChangeFillStyle1(1);
		s.AddRecord(c);
		s.AddRecord(FlashShapeRecordStraight(width*20, 0));
		s.AddRecord(FlashShapeRecordStraight(0, height*20));
		s.AddRecord(FlashShapeRecordStraight(-width*20, 0));
		s.AddRecord(FlashShapeRecordStraight(0, -height*20)); 
			
		
		FlashTagDefineShape3 ftds(s);
		
		f << ftds;
		return_val =  ftds.GetID();
	}
	catch(Exception &error_)
	{
		std::cout << "Caught exception: " << error_.what() << "\n"; 
		throw (error_);
	}
	return return_val;
}
UWORD ReadImage2(char *fname, std::ostringstream &f, int &width, int &height) 
{
	UWORD return_val = 0;
	try
	{
		Image image(fname);
		width = image.baseColumns();
		height = image.baseRows();
		
		Blob blob; 
		image.magick( "JPEG" ); // Set JPEG output format 
		image.write( &blob ); 
		
		unsigned char *data = (unsigned char*)malloc(blob.length());
		memcpy(data,blob.data(),blob.length());
		FlashTagDefineBitsJPEG2 db(data, blob.length());
		f << db;
		free(data);

		FlashMatrix m;
		m.SetScale(20,20);
		
		FlashShapeWithStyle s;
		FlashFillStyleArray ffa;
		FlashFillStyleBitmap sf(db.GetID(),m); 

		ffa.AddFillStyle(&sf);
		s.SetFillStyleArray(ffa);
			
		FlashShapeRecordChange c(0,0);
		c.ChangeFillStyle1(1);
		s.AddRecord(c);
		s.AddRecord(FlashShapeRecordStraight(width*20, 0));
		s.AddRecord(FlashShapeRecordStraight(0, height*20));
		s.AddRecord(FlashShapeRecordStraight(-width*20, 0));
		s.AddRecord(FlashShapeRecordStraight(0, -height*20)); 
			
		
		FlashTagDefineShape3 ftds(s);
		
		f << ftds;
		return_val =  ftds.GetID();
	}
	catch(Exception &error_)
	{
		std::cout << "Caught exception: " << error_.what() << "\n"; 
		throw (error_);
	}
	return return_val;
}

int main( int argc , char *argv[ ])
{

	if(argc < 3) 
	{
		std::cout << "Usage: imagecnv inputfilename outputfilename [1 | 2]\n1 = Lossless Compression\n2 = JPEG compression";
		return -1;
	}
	std::ostringstream f(std::ios::binary);
	std::ofstream fileout(argv[2],std::ios::binary);
	if(fileout.fail())
	{
		std::cout << "ERROR: Could not open output file.\n";
		return -1;
	}
	bool lossless = true;

	if(argc > 3)
	{
		if(strcmp(argv[3], "1") == 0)
		{
			lossless = true;
		}
		else if(strcmp(argv[3], "2") == 0)
		{
			lossless = false;
		}
	}
    f << FlashTagBackgroundColor(0xff,0xff,0xff);
		
	int width;
	int height;
	UWORD id;
	try
	{
		if(lossless) 
			id = ReadImage(argv[1],f,width,height);
		else
			id = ReadImage2(argv[1],f,width,height);
	}
	catch(...)
	{
		return -1;
	}

	f << FlashTagPlaceObject2 (1,id);

	f << FlashTagShowFrame();

	f << FlashTagEnd();
	
	fileout << FlashHeader(5,f.str().size(),width*20,height*20,15.0,1);
	fileout << f.str();
	return 0;
}
