#include <fstream>
#include <sstream>
#include <vector>

#include "FButton.h"
#include "FBase.h"
#include "FShape.h"
#include "FDisplay.h"
#include "FControl.h"
#include "FSprite.h"
#include "FSound.h"
#include "FlashMP3Encoder.h"
#include "FFont.h"
#if defined(__WIN32__)
#include "FlashFontObj.h"
#endif
#include "FMorph.h"

#include "FTarga.h"
#include "FBitmap.h"

#include "FImport.h"
#include "magick++/Magick++.h"

using namespace Magick; 

UWORD ReadImage(char *fname, std::ostringstream &f)
{
	UWORD return_val = 0;
	try
	{
		Image image(fname);
		int width = image.baseColumns();
		int height = image.baseRows();
		
		//Encode Image with 24 bit color
		int format = 5;
		
		unsigned char *imagedata = (unsigned char *)malloc(height*width*3);
		unsigned char *tgadata = (unsigned char *)malloc(height*width*4);

		image.write(0,0,width,height,"RGB",CharPixel,imagedata);	
		{
			for(UWORD y = 0; y < height; y++)
			{
				for(UWORD x = 0; x < width; x++)
				{
					UDWORD base = (y*width+x)*4;

					UDWORD base2 = (y*width+x)*3;
				
					unsigned char r = imagedata[base2];
					unsigned char g = imagedata[base2+1];
					unsigned char b = imagedata[base2+2];
					
					((unsigned char*)tgadata)[base+0]   =  0xff;
					((unsigned char*)tgadata)[base+1]   =  r;
					((unsigned char*)tgadata)[base+2]   =  g;
					((unsigned char*)tgadata)[base+3]   =  b;
					
				}
			}
		}
		FlashZLibBitmapData d((unsigned char *)tgadata,(width*height*4));
		FlashTagDefineBitsLossless2 db(format,width, height, d);
		f << db;

		free (imagedata);
		free (tgadata);

		FlashMatrix m;
		m.SetScale(20,20);
		
		FlashShapeWithStyle s;
		FlashFillStyleArray ffa;
		FlashFillStyleBitmap sf(db.GetID(),m); 

		ffa.AddFillStyle(&sf);
		s.SetFillStyleArray(ffa);
			
		FlashShapeRecordChange c(0,0);
		c.ChangeFillStyle1(1);
		s.AddRecord(c);
		s.AddRecord(FlashShapeRecordStraight(width*20, 0));
		s.AddRecord(FlashShapeRecordStraight(0, height*20));
		s.AddRecord(FlashShapeRecordStraight(-width*20, 0));
		s.AddRecord(FlashShapeRecordStraight(0, -height*20)); 
			
		
		FlashTagDefineShape3 ftds(s);
		
		f << ftds;
		return_val =  ftds.GetID();
	}
	catch(Exception &error_)
	{
		std::cout << "Caught exception: " << error_.what() << "\n"; 
	}
	return return_val;
}

void SetBackground(std::ostringstream &f)
{
	f << FlashTagPlaceObject2 (1,ReadImage("c:\\windows\\desktop\\background.tga",f));
}
#if defined(__WIN32__)
void WriteText(std::ostringstream &f)
{
	FlashFontFactory fff;
	fff.WriteText(f,"Arial Black","Virtuascape", 530*20, 505*20, FlashRGB(0x34,0x34,0x34),18,100,220);
	fff.WriteText(f,"Arial Black","Virtuascape", 650*20, 520*20, FlashRGB(0xff,0xff,0xff),10,101,100);
	
}
#endif
void Write3DBox(std::ostringstream &f, int x1, int y1, int x2, int y2, FlashRGB &c1, UWORD depth)
{
    FlashShapeWithStyle shape;
	
	FlashRGB c2((unsigned short)(1.50 * c1.GetR()), (unsigned short)(1.50 * c1.GetG()), (unsigned short)(1.50 * c1.GetB()));
	FlashRGB c3((unsigned short)(0.50 * c1.GetR()), (unsigned short)(0.50 * c1.GetG()), (unsigned short)(0.50 * c1.GetB()));
	
	FlashFillStyleArray fsa;
	FlashFillStyleSolid s1(c1);
	fsa.AddFillStyle(&s1);
		
	FlashLineStyleArray fla;
	FlashLineStyle ls1(20,c2);
	FlashLineStyle ls2(20,c3);
	
	fla.AddLineStyle(&ls1);
	fla.AddLineStyle(&ls2);

	shape.SetFillStyleArray(fsa);
	shape.SetLineStyleArray(fla);

	FlashShapeRecordChange line0(x1,y1);
	line0.ChangeFillStyle1(1);
	line0.ChangeLineStyle(1);

	FlashShapeRecordChange line1;
	line1.ChangeLineStyle(1);

	FlashShapeRecordChange line2;
	line2.ChangeLineStyle(2);

	shape.AddRecord(line0);
	shape.AddRecord(FlashShapeRecordStraight(x2-x1,0));
	shape.AddRecord(line2);
	shape.AddRecord(FlashShapeRecordStraight(0,y2-y1));
	shape.AddRecord(FlashShapeRecordStraight(-(x2-x1),0));
	shape.AddRecord(line1);
	shape.AddRecord(FlashShapeRecordStraight(0,-(y2-y1)));

	FlashTagDefineShape3 tshape(shape);
	f << tshape;
	f << FlashTagPlaceObject2(depth, tshape.GetID());
	
}
void WriteSprite(std::ostringstream &f)
{
	UWORD id = ReadImage("c:\\windows\\desktop\\v.tga",f);
	FlashTagSprite ftds;
	FlashMatrix m;
	m.SetTranslate(300*20,230*20);
	FlashColorTransform cfx;
	
	FlashTagPlaceObject2 f1(2,id,m);

	int r;
	
	r = 128+rand()%128;
	cfx.SetAddRGB(FlashRGB(0,0,0,-r));
	FlashTagPlaceObject2 f2(2,id,m,cfx);
	f2.SetMove(true);
	r = 128+rand()%128;
	cfx.SetAddRGB(FlashRGB(0,0,0,-r));
	FlashTagPlaceObject2 f3(2,id,m,cfx);
	f3.SetMove(true);
	r = 128+rand()%128;
	cfx.SetAddRGB(FlashRGB(0,0,0,-r));
	FlashTagPlaceObject2 f4(2,id,m,cfx);
	f4.SetMove(true);
	r = 128+rand()%128;
	cfx.SetAddRGB(FlashRGB(0,0,0,-r));
	FlashTagPlaceObject2 f5(2,id,m,cfx);
	f5.SetMove(true);
	r = 128+rand()%128;
	cfx.SetAddRGB(FlashRGB(0,0,0,-r));
	FlashTagPlaceObject2 f6(2,id,m,cfx);
	f6.SetMove(true);
	r = 128+rand()%128;
	cfx.SetAddRGB(FlashRGB(0,0,0,-r));
	FlashTagPlaceObject2 f7(2,id,m,cfx);
	f7.SetMove(true);
	r = 128+rand()%128;
	cfx.SetAddRGB(FlashRGB(0,0,0,-r));
	FlashTagPlaceObject2 f8(2,id,m,cfx);
	f8.SetMove(true);

	FlashTagShowFrame s;

	ftds.Add(&f1);
	ftds.Add(&s);
	ftds.Add(&f2);
	ftds.Add(&s);
	ftds.Add(&f3);
	ftds.Add(&s);
	ftds.Add(&f4);
	ftds.Add(&s);
	ftds.Add(&f5);
	ftds.Add(&s);
	ftds.Add(&f6);
	ftds.Add(&s);
	ftds.Add(&f7);
	ftds.Add(&s);
	ftds.Add(&f8);
	ftds.Add(&s);

	f << ftds;
	f << FlashTagPlaceObject2(2,ftds.GetID());

}
void TestRotatingText(void)
{	
#if defined(__WIN32__)
	std::ofstream fileout("testing2.swf",std::ios::binary);
	std::ostringstream f(std::ios::binary);

	f << FlashTagBackgroundColor(0xff,0xee,0xff);
	FlashRect bounds;
	UWORD depth = 0;

	FlashFontFactory fff;
	fff.WriteText(f,"Arial","Hello,SWFSource", 25*20, 10*20, FlashRGB(0xff,0x00,0x00),10,depth,bounds);
	depth = 1;
	fff.WriteText(f,"Arial","Support Double-byte Char Set", 25*20, 50*20, FlashRGB(0x00,0x00,0x50),10,depth,bounds);
	depth = 1;
	fff.WriteText(f,"Arial","CJK(China,Japan,Korea)", 25*20, 75*20, FlashRGB(0x00,0x50,0x00),10,depth,bounds);
	depth = 2;
	//Test DBCS 
	//WriteText(f,"Arial","ѱ", 20*20, 100*20, FlashRGB(0x00,0x00,0x00),20,depth,0,bounds);
	fff.WriteText(f,"Arial","Test ChnJpnKor Characters", 20*20, 100*20, FlashRGB(0x00,0x00,0x00),20,depth,bounds);
	depth = 3;
	UWORD id = fff.WriteText(f,"Arial","SWFSource SDK", 25*20, 75*20, FlashRGB(0x00,0x00,0xff),34,depth,bounds, 0, false, true, false);

	f << FlashTagShowFrame();

	int nFrames = 25;
    for (int ii = 1 ; ii < nFrames;ii++) {
		f << FlashTagRemoveObject2(depth);//then vv.RemoveObject(txt);
        FlashMatrix m2;
		m2 = CreateMatrix(bounds,(nFrames-ii),(nFrames-ii),(nFrames+1-ii)*128,0,0,true,true);
		f << FlashTagPlaceObject2(depth,id,m2);
		f << FlashTagShowFrame();
    }

	f << FlashTagEnd();
	
	//fileout << FlashHeader(5,f.str().size(),800*20,600*20,8.0,1);
	fileout << FlashHeader(5,f.str().size(),400*20,200*20,8.0,1);
	fileout << f.str();
#endif
}
void main2(void)
{
	TestRotatingText();

	std::ofstream fileout("testing.swf",std::ios::binary);
	std::ostringstream f(std::ios::binary);
	
	f << FlashTagBackgroundColor(0xff,0xff,0xff);
	SetBackground(f);
	//Write3DBox(f,10,10,799*20,20*20,FlashRGB(0xff,0xaa,0x00), 5);
	//Write3DBox(f,10*20,30*20,250*20,500*20,FlashRGB(0xaa,0xaa,0xaa), 4);
	//Write3DBox(f,12*20,32*20,248*20,42*20, FlashRGB(0xff,0xaa,0x00), 5);

	//WriteText(f);
	//WriteSprite(f);

	//FlashActionGetURL url("http://www.google.com","");
	//FlashActionStop s;

	//FlashTagDoAction ftd;
	//ftd.AddAction(&s);
	//ftd.AddAction(&url);
 
	//f << ftd;
	//f << FlashTagShowFrame();
    
	// Shape Morph Example
	
	/*FlashShape s;
	FlashShapeRecordChange changerec;
	changerec.ChangeFillStyle0(1);
	
	s.AddRecord(changerec);
	s.AddRecord(FlashShapeRecordChange(100,100));
	s.AddRecord(FlashShapeRecordStraight(100,0));
	s.AddRecord(FlashShapeRecordStraight(0,100));
	s.AddRecord(FlashShapeRecordStraight(-100,0));
	s.AddRecord(FlashShapeRecordStraight(0,-100));
	
	FlashShape s2;
	s2.AddRecord(FlashShapeRecordChange(100,100));
	s2.AddRecord(FlashShapeRecordStraight(200,0));
	s2.AddRecord(FlashShapeRecordStraight(0,200));
	s2.AddRecord(FlashShapeRecordStraight(-200,0));
	s2.AddRecord(FlashShapeRecordStraight(0,-200));

	FlashMorphFillStyleSolid fss(FlashRGB(0xff,0xff,0xff), FlashRGB(0x00,0x00,0x00));
	
	FlashMorphFillStyles fmfs;
	fmfs.AddFillStyle(&fss);
	
	FlashTagDefineMorphShape ms(s,s2);
	ms.SetMorphFillStyles(fmfs);

	f << ms;
	FlashTagPlaceObject2 po(1, ms.GetID());
	f << po;
	
	FlashTagPlaceObject2 po2(1, ms.GetID());
	po2.SetMove(true);*/
	
	/*for(UWORD ratio = 0; ratio < 0xffff; ratio+=0xff)
	{
		po2.SetRatio(ratio);
		f << po2;
		f << FlashTagShowFrame();
	}*/
	/*	UWORD ratio = i2*(0xffff/100);
		
		po2.SetRatio(ratio);
		f << po2;
	*/	
	// SAMPLE FONT OUTPUT...see FlashFontObj.cpp
	
	/*FlashFontFactory fff;
	fff.WriteText(f,"Arial Bold","SWF Source", 100*20, 135*20, FlashRGB(0xff,0xff,0xff),8,1,105);
	fff.WriteText(f,"Impact","WWW", 100*20, 150*20, FlashRGB(0xff,0xcc,0x00),34,0);*/
	
	// SAMPLE MP3 OUTPUT
	
	FlashMP3Encoder MP3("c:\\windows\\desktop\\test.mp3",15);
	MP3.WriteDefineTag(f);
	//MP3.WriteHeader(f);
	//for(int i2=0; i2 < 45; i2++)
	//{
	//	MP3.WriteStream(f);
		//f << FlashTagShowFrame();
	//}

	//UWORD MP3_id = MP3.WriteDefineTag(f);
	//f << FlashTagStartSound(MP3_id, FlashSoundInfo(0x01 << 4));
	
	// SAMPLE IMAGE OUTPUT
	
	
	f << FlashTagShowFrame();
	
	FlashTagDoAction theButton;
	
	theButton.AddAction(new FlashActionPush(0,"Jump3",strlen("Jump3")+1));
    theButton.AddAction(new FlashActionGotoFrame2(true));

	f << theButton;

	FlashActionWaitForFrame2 fw(1);
    FlashTagDoAction ftd;
    ftd.AddAction(&fw); 
    f << ftd;

	f << FlashTagEnd();
	
	fileout << FlashHeader(5,f.str().size(),800*20,600*20,15.8,1);
	fileout << f.str();

}


void main3(int argc, char **argv)
{
//	TEST FLASH IMPORT
#if defined(__WIN32__)
	std::ifstream filein("c:\\test.swf",std::ios::binary);
#else
	std::ifstream filein(argv[1],std::ios::binary);
#endif
	if(filein.fail()) std::cout << "ERROR: Could not open input file";
	{
		FlashImporter fi;
		FlashMyImporter i;
		FlashHeader fh = fi.ImportHeader(filein,i);
		while(fi.ImportTag(filein,i));
	}
}

int main4()
{
	
	FlashMorphFillStyles fills;
	
	double xScale = 10000 / 0x00008000L;
	double yScale = 10000 / 0x00008000L;

	int xCenter = 10000 / 2;
	int yCenter = 10000 / 2;
	

	FlashMatrix matrix1(true, FlashFixed(xScale), FlashFixed(yScale),
					    false, FlashFixed(0), FlashFixed(0),	// no rotate
					    xCenter, yCenter);
			
	FlashMatrix matrix2(false, FlashFixed(xScale), FlashFixed(yScale),
						false, FlashFixed(0), FlashFixed(0),	// no rotate
					    0, 0);

	
	FlashMorphGradient gradient;

	FlashMorphGradientRecord record1(0, FlashRGB(255,0,0), 0, FlashRGB(255,255,255));
	gradient.AddRecord(record1);

	FlashMorphGradientRecord record2(255, FlashRGB(0,0,0), 255, FlashRGB(255,255,255));
	gradient.AddRecord(record2);
			
	// build fill style
	
	FlashMorphFillStyleLinear *fill= new FlashMorphFillStyleLinear(matrix1, matrix2, gradient);
		
	fills.AddFillStyle(fill);

	std::ofstream fileout("testing.swf",std::ios::binary);
	std::ostringstream f(std::ios::binary);
	
	f << FlashTagBackgroundColor(0x88,0x88,0x88);
	
	FlashShape s;
	FlashShapeRecordChange changerec;
	changerec.ChangeFillStyle0(1);
	
	s.AddRecord(changerec);
	s.AddRecord(FlashShapeRecordChange(0,0));
	s.AddRecord(FlashShapeRecordStraight(10000,0));
	s.AddRecord(FlashShapeRecordStraight(0,10000));
	s.AddRecord(FlashShapeRecordStraight(-10000,0));
	s.AddRecord(FlashShapeRecordStraight(0,-10000));
	
	FlashShape s2;
	s2.AddRecord(FlashShapeRecordChange(1000,1000));
	s2.AddRecord(FlashShapeRecordStraight(2000,0));
	s2.AddRecord(FlashShapeRecordStraight(0,2000));
	s2.AddRecord(FlashShapeRecordStraight(-2000,0));
	s2.AddRecord(FlashShapeRecordStraight(0,-2000));

        FlashRGB C1(0xff,0xff,0xff);
        FlashRGB C2(0xff,0xff,0xff);

        FlashMorphFillStyleSolid fss(C1, C2);
	
	FlashMorphFillStyles &fmfs = fills;
	//fmfs.AddFillStyle(&fss);
	
	FlashTagDefineMorphShape ms(s,s2);
	ms.SetMorphFillStyles(fmfs);

	f << ms;
	FlashTagPlaceObject2 po(1, ms.GetID());
	f << po;
	
	FlashTagPlaceObject2 po2(1, ms.GetID());
	po2.SetMove(true);
	
	for(UWORD ratio = 0; ratio < 0xffff; ratio+=0xff)
	{
		po2.SetRatio(ratio);
		f << po2;
		f << FlashTagShowFrame();
	}
	


	fileout << FlashHeader(5,f.str().size(),800*20,600*20,15.8,1);
	fileout << f.str();

	delete fill;
	
	return 0;
}

