/* MP3 Encoding Extension Class
   Author: Jesse Ezell <JesseEzell@netscape.net>
   Last Updated: Oct. 12, 2000
*/

#ifndef H_FLASHMP3_JE
#define H_FLASHMP3_JE

#include "FBase.h"
#include <stdio.h>
#include <vector>

class FlashMP3Encoder
{
public:
	FlashMP3Encoder(const char *filename, int FrameRate);
	~FlashMP3Encoder();

	UWORD WriteDefineTag(std::ostream &out);
	
	void WriteHeader(std::ostream &out);
	void WriteStream(std::ostream &out);

private:
	int GetMp3FrameSize (char *szMp3File, long *pnFrameSize, long *pnPCMFrameSize);    
	int ReadMp3Frame (FILE *fp, char *lpData, long *pnSize);
	int SeekToNextValidHeader (FILE *fp, int &layer, int &ver, int &freq, int &stereo, int &rate);

	std::vector<char *> m_frameData;	
	std::vector<UDWORD>	m_sizes;
	
        long m_delay;
        int m_frameRate;
        unsigned long m_pos;
        bool m_done;
        long m_frame;

	int m_layer;
	int m_ver;
	int m_freq;
	int m_stereo;
	int m_rate;
	long pcmFrameSize;
};

#endif
