#ifndef FSPRITE_H_FILE
#define FSPRITE_H_FILE
#include "FBase.h"

class FlashTagSprite : public FlashIDEnabled, public FlashTag
{
	DEFINE_RW_INTERFACE
public:
	FlashTagSprite() : frames(0) {}
	~FlashTagSprite() {}

	void Add(FlashSpriteEnabled *tag); 

	friend std::ostream &operator << (std::ostream &out, FlashTagSprite &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagSprite &data);

private:

	std::vector<FlashSpriteEnabled *> tags;
	
	FlashIDFactory idFactory;

	gc_vector<FlashSpriteEnabled *> gc;
	UWORD frames;
};

class FlashTagDefineMovie : public FlashIDEnabled, public FlashTag
{
	DEFINE_RW_INTERFACE
public:
	FlashTagDefineMovie(char *url) : str(url) {}

	friend std::ostream &operator << (std::ostream &out, FlashTagDefineMovie &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagDefineMovie &data);

private:
	gc_vector<char *> gc;
	char *str;
};

#endif
