#include <strstream>
#include "FControl.h"
#include "FSprite.h"
#include "FDisplay.h"

void FlashTagSprite::Add(FlashSpriteEnabled *tag)
{ 
	tags.push_back(tag);
	if(tag->isFrame()) frames++;
}

std::ostream &operator << (std::ostream &out, FlashTagSprite &data)
{
	std::ostrstream tmp;
	for(std::vector<FlashSpriteEnabled *>::iterator i=data.tags.begin(); i != data.tags.end(); i++)
	{
		(*i)->Write(tmp);
	}
	tmp << FlashTagEnd();
	out << FlashTagHeader(39, 4+tmp.pcount());
	WRITE_UWORD(data.GetID());
	WRITE_UWORD(data.frames);
	out.write(tmp.rdbuf()->str(),tmp.pcount());
	return out;
}

std::istream &operator >> (std::istream &in,  FlashTagSprite &data)
{
	/*UWORD id;
	READ_UWORD(id);
	data.SetID(id);
	READ_UWORD(data.frames);*/

	//ADD IMPORT CODE
	
	return in;
}

std::ostream &operator << (std::ostream &out, FlashTagDefineMovie &data)
{
	out << FlashTagHeader(38, strlen(data.str)+3);
	WRITE_UWORD(data.GetID());
	out << data.str;
	out.put((char)0);
	return out;
}
	
std::istream &operator >> (std::istream &in,  FlashTagDefineMovie &data)
{
	UWORD id;
	READ_UWORD(id);
	data.SetID(id);
	data.str = (char *)malloc(data.importsize - 2);	
	in.read(data.str, data.importsize - 2);
	data.gc.push_back(data.str);
	return in;
}
