#ifndef FSHAPE_H_FILE
#define FSHAPE_H_FILE

#include <vector>
#include "FBase.h"

class FlashShapeCommon
{
public:
        FlashShapeCommon() : NBitsFillStyle(0), NBitsLineStyle(0), DefineTagVersion(1), flags(0) {}

        int NBitsFillStyle;
	int NBitsLineStyle;
	int DefineTagVersion;
        int flags;
};
class FlashFillStyle : public FlashVersionEnabled
{
public:	
	FlashFillStyle() : type(0) {}
	FlashFillStyle(UBYTE _type) : type(_type){}
	
        virtual ~FlashFillStyle() {}

	virtual void Write(std::ostream &out) {}
	virtual void Read(std::istream &in) {}
	
protected:
	UBYTE type;
	
	friend std::ostream &operator<< (std::ostream &out, FlashFillStyle &data);
	friend std::istream &operator>> (std::istream &in,  FlashFillStyle &data);

};
	/* FILL TYPES
		0x00 - solid
		0x10 - linear gradient
		0x12 - radial gradient
		0x40 - tiled bitmap
		0x41 - clipped bitmap
	*/
class FlashFillStyleArray;
class FlashFillStyleSolid : public FlashFillStyle 
{
public:	
	FlashFillStyleSolid(FlashRGB  &color) : FlashFillStyle(0), r1(color) { type = 0; }
        virtual ~FlashFillStyleSolid() {}

	virtual void Write(std::ostream &out);
	virtual void Read(std::istream &in);
	
	FlashRGB GetRGB() { return r1; }
	void SetRGB(FlashRGB &r) { r1=r; }
private:
	friend std::istream &operator>> (std::istream &in,  FlashFillStyleArray &data);
	FlashFillStyleSolid() {}

	FlashRGB r1;
};

class FlashGradientRecord : public FlashVersionEnabled
{
public:	
        FlashGradientRecord() {}
        virtual ~FlashGradientRecord() {}
	void AddGradient(UBYTE ratio, FlashRGB &r) { colors.push_back(r); ratios.push_back(ratio); }

	
private:

	std::vector<UBYTE> ratios;
	std::vector<FlashRGB> colors;
	
	friend std::ostream &operator<< (std::ostream &out, FlashGradientRecord &data);
	friend std::istream &operator>> (std::istream &in,  FlashGradientRecord &data);

};

class FlashFillStyleGradient : public FlashFillStyle
{
public:	
	FlashFillStyleGradient(FlashMatrix &m, FlashGradientRecord &g) : FlashFillStyle(0x10), matrix(m), gradient(g){	type = 0x10; }
        virtual ~FlashFillStyleGradient() {}
	void SetLinear() { type = 0x10; }
	void SetRadial() { type = 0x12; }


	virtual void Write(std::ostream &out);
	virtual void Read(std::istream &in);

private:
	friend std::istream &operator>> (std::istream &in,  FlashFillStyleArray &data);
        FlashFillStyleGradient() {}

	FlashMatrix matrix;
	FlashGradientRecord gradient;	
};

class FlashFillStyleBitmap : public FlashFillStyle
{

public:
        FlashFillStyleBitmap(UWORD _bitmapID, FlashMatrix &m, bool _tiled=false) : bitmapID(_bitmapID), matrix(m), tiled(_tiled) { type = tiled ? 0x40 : 0x41;}
        virtual ~FlashFillStyleBitmap() {}
	virtual void Write(std::ostream &out);
	virtual void Read(std::istream &in);

private:
	friend std::istream &operator>> (std::istream &in,  FlashFillStyleArray &data);
	FlashFillStyleBitmap() {}
        
        UWORD bitmapID;
        FlashMatrix matrix;
        bool tiled;
};
class FlashFillStyleArray : public FlashVersionEnabled
{
public:
	FlashFillStyleArray() {}
        virtual ~FlashFillStyleArray() {}
	size_t AddFillStyle(FlashFillStyle *s)
	{
		styles.push_back(s);
		return styles.size();
	}
	
	int GetNBits();
	
private:
	std::vector<FlashFillStyle*> styles;
	gc_vector<FlashFillStyle*> gc;
	friend std::ostream &operator<< (std::ostream &out, FlashFillStyleArray &data);
	friend std::istream &operator>> (std::istream &in,  FlashFillStyleArray &data);
	
};
class FlashLineStyleArray;
class FlashLineStyle : public FlashVersionEnabled
{
public:
        FlashLineStyle(UWORD _width, FlashRGB &_color) : width(_width), color(_color) {}
	
	friend std::ostream &operator<< (std::ostream &out, FlashLineStyle &data);
	friend std::istream &operator>> (std::istream &in,  FlashLineStyle &data);

private:
	friend std::istream &operator>> (std::istream &in,  FlashLineStyleArray &data);
	FlashLineStyle() {}

        UWORD width;
	FlashRGB color;	

};

class FlashLineStyleArray : public FlashVersionEnabled
{
public:
	FlashLineStyleArray() {}
        virtual ~FlashLineStyleArray() {}

	size_t AddLineStyle(FlashLineStyle *s)
	{
		styles.push_back(s);
		return styles.size();
	}
	int GetNBits();
private:
	std::vector<FlashLineStyle*> styles;
	gc_vector<FlashLineStyle*> gc;
	friend std::ostream &operator<< (std::ostream &out, FlashLineStyleArray &data);
	friend std::istream &operator>> (std::istream &in,  FlashLineStyleArray &data);
};

class FlashShapeRecord : public FlashVersionEnabled
{
public:
        FlashShapeRecord() {};
        virtual ~FlashShapeRecord() {};
	virtual void Write(BitBuffer &out, FlashShapeCommon &c)=0;
	virtual void Read(BitStreamIn &in, FlashShapeCommon &data)=0;
};
class FlashShape;
class FlashShapeWithStyle;
class FlashShapeRecordStraight : public FlashShapeRecord
{
public:	
        FlashShapeRecordStraight(SWORD _dx, SWORD _dy) : dx(_dx), dy(_dy) {}
        virtual ~FlashShapeRecordStraight() {}
	virtual void Write(BitBuffer &out, FlashShapeCommon &data);
	virtual void Read(BitStreamIn &in, FlashShapeCommon &data);
private:
	FlashShapeRecordStraight() {}
	SWORD dx;
	SWORD dy;
	friend class FlashShape;
	friend std::istream &operator>> (std::istream &in,   FlashShape &data);
	friend std::istream &operator>> (std::istream &in,   FlashShapeWithStyle &data);

};
class FlashShapeRecordEnd : public FlashShapeRecord
{
public:
        FlashShapeRecordEnd() {}
        virtual ~FlashShapeRecordEnd() {}
	virtual void Write(BitBuffer &out, FlashShapeCommon &data);
	virtual void Read(BitStreamIn &in, FlashShapeCommon &data);
};

class FlashShapeRecordCurved : public FlashShapeRecord
{
public:	
        FlashShapeRecordCurved(SWORD _dxc, SWORD _dyc, SWORD _dxa, SWORD _dya) : 
	  dxa(_dxa), dya(_dya), dxc(_dxc), dyc(_dyc)  {}
        virtual ~FlashShapeRecordCurved() {};
	virtual void Write(BitBuffer &out, FlashShapeCommon &data);
	virtual void Read(BitStreamIn &in, FlashShapeCommon &data);
private:
	FlashShapeRecordCurved() {}
	SWORD dxa;
	SWORD dya;
	SWORD dxc;
	SWORD dyc;
	friend class FlashShape;
	friend std::istream &operator>> (std::istream &in,   FlashShape &data);
	friend std::istream &operator>> (std::istream &in,   FlashShapeWithStyle &data);
};

class FlashShapeRecordChange : public FlashShapeRecord
{
public:
    FlashShapeRecordChange();
	FlashShapeRecordChange(SDWORD dx, SDWORD dy);
    virtual ~FlashShapeRecordChange() {}
	
	void NewFillStyles(FlashFillStyleArray &a, FlashLineStyleArray &c);

	void ChangeMoveDelta(SDWORD _dx, SDWORD _dy)
	{
		moveto=true;
		
		dx=_dx;
		dy=_dy;
	}
	void ChangeFillStyle0(UWORD style);
	void ChangeFillStyle1(UWORD style);
	void ChangeLineStyle(UWORD style);

	virtual void Write(BitBuffer &out, FlashShapeCommon &data);
	virtual void Read(BitStreamIn &in, FlashShapeCommon &data);
private:
	bool newstyles;
	bool linestyle;
	bool fillstyle1;
	bool fillstyle0;
	bool moveto;

	UWORD stylefill0;
	UWORD stylefill1;
	UWORD styleline;
	SDWORD dx;
	SDWORD dy;

	FlashFillStyleArray fillstyles;
	FlashLineStyleArray linestyles;
	
	friend class FlashShape;
	friend std::istream &operator>> (std::istream &in,   FlashShape &data);
	friend std::istream &operator>> (std::istream &in,   FlashShapeWithStyle &data);
};
class FlashShape
{
public:
	FlashShape() {}
	~FlashShape() {}

	FlashRect GetBounds();
	void AddRecord(const FlashShapeRecordChange &r)
	{
		record_change.push_back(r);
		record_sequencer.push_back(flash_pair<int,long>(0,record_change.size()-1));
	}
	void AddRecord(const FlashShapeRecordStraight &r)
	{
		record_straight.push_back(r);
		record_sequencer.push_back(flash_pair<int,long>(1,record_straight.size()-1));
	}
	void AddRecord(const FlashShapeRecordCurved &r)
	{
		record_curved.push_back(r);
		record_sequencer.push_back(flash_pair<int,long>(2,record_curved.size()-1));
	}
protected:
	std::vector<FlashShapeRecordChange> record_change;
	std::vector<FlashShapeRecordStraight> record_straight;
	std::vector<FlashShapeRecordCurved> record_curved;

	std::vector<flash_pair<int,long> > record_sequencer;

	friend std::ostream &operator<< (std::ostream &out,  FlashShape &data);
	friend std::istream &operator>> (std::istream &in,   FlashShape &data);

};
class FlashShapeWithStyle : public FlashVersionEnabled, public FlashShape
{
public:
	FlashShapeWithStyle(){}
        virtual ~FlashShapeWithStyle(){}
	void SetFillStyleArray(FlashFillStyleArray &_fillstyles)
	{
		fillstyles=_fillstyles;
	}
	void SetLineStyleArray(FlashLineStyleArray &_linestyles)
	{
		linestyles=_linestyles;
	}
private:
	FlashFillStyleArray fillstyles;
	FlashLineStyleArray linestyles;

	friend std::ostream &operator<< (std::ostream &out,  FlashShapeWithStyle &data);
	friend std::istream &operator>> (std::istream &in,   FlashShapeWithStyle &data);
};
class FlashTagDefineShapeBase : public FlashTag, public FlashIDEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashTagDefineShapeBase(FlashShapeWithStyle &s) : shapes(s) { }
	~FlashTagDefineShapeBase() {}
	
	FlashShapeWithStyle &GetShapes() { return shapes; }
	FlashRect rimport;
private:
    friend std::ostream &operator<< (std::ostream &out, FlashTagDefineShapeBase &data);
	friend std::istream &operator>> (std::istream &in,  FlashTagDefineShapeBase &data);

	FlashShapeWithStyle shapes;
	
	
	friend class FlashImporter;

protected:
	FlashTagDefineShapeBase() {}
	int version;
	int header;
};
class FlashTagDefineShape1 : public FlashTagDefineShapeBase
{
	DEFINE_RW_INTERFACE
public:
	FlashTagDefineShape1(FlashShapeWithStyle &s) : FlashTagDefineShapeBase(s) { header=2;  version=1; }
    friend class FlashImporter;
private:
	FlashTagDefineShape1() { header=2;  version=1; }
};

class FlashTagDefineShape2 : public FlashTagDefineShapeBase
{
	DEFINE_RW_INTERFACE
public:
	FlashTagDefineShape2(FlashShapeWithStyle &s) : FlashTagDefineShapeBase(s) { header=22; version=2; }
    friend class FlashImporter;
private:
	FlashTagDefineShape2() { header=22; version=2; }
};
class FlashTagDefineShape3 : public FlashTagDefineShapeBase
{
	DEFINE_RW_INTERFACE
public:	
	FlashTagDefineShape3(FlashShapeWithStyle &s) : FlashTagDefineShapeBase(s) { header=32; version=3; }
    friend class FlashImporter;
private:
	FlashTagDefineShape3() { header=32; version=3; }

};
#endif
