#include "FBase.h"
#include "FMorph.h"
#include <strstream>
#include <iostream>

void FlashMorphGradientRecord::Write(std::ostream &out)
{
	c1.SetAlphaWriteMode(true);
	c2.SetAlphaWriteMode(true);
	out.put(r1);
	out << c1;
	out.put(r2);
	out << c2;
}

void FlashMorphGradient::Write(std::ostream &out)
{
	out.put(records.size());
	for(std::vector<FlashMorphGradientRecord>::iterator i=records.begin();
		i != records.end(); i++)
		{
			(*i).Write(out);
		}
}

void FlashMorphFillStyleSolid::Write(std::ostream &out)
{
	out.put(0x00);
	c1.SetAlphaWriteMode(true);
	c2.SetAlphaWriteMode(true);
	out << c1;
	out << c2;
}

void FlashMorphFillStyleLinear::Write(std::ostream &out)
{
	out.put(0x10);
	out << fm1;
	out << fm2;
	fmg.Write(out);
}

void FlashMorphFillStyleRadial::Write(std::ostream &out)
{
	out.put(0x12);
	out << fm1;
	out << fm2;
	fmg.Write(out);
}

void FlashMorphFillStyles::Write(std::ostream &out)
{
	if(fillStyles.size() >= 0xff)
	{
		out.put((char)0xff);
		WRITE_UWORD(fillStyles.size());
	}
	else 
	{
		out.put(fillStyles.size());
	}
	for(std::vector<FlashMorphFillStyle *>::iterator i=fillStyles.begin();
		i != fillStyles.end(); i++)
		{
			(*i)->Write(out);
		}
}

void FlashMorphLineStyle::Write(std::ostream &out)
{
	WRITE_UWORD(w1);
	WRITE_UWORD(w2);
	c1.SetAlphaWriteMode(true);
	c2.SetAlphaWriteMode(true);
	out << c1;
	out << c2;
}

void FlashMorphLineStyles::Write(std::ostream &out)
{
	if(lineStyles.size() >= 0xff)
	{
		out.put((char)0xff);
		WRITE_UWORD(lineStyles.size());
	}
	else 
	{
		out.put(lineStyles.size());
	}
	for(std::vector<FlashMorphLineStyle>::iterator i=lineStyles.begin();
		i != lineStyles.end(); i++)
		{
			(*i).Write(out);
		}
}
void FlashMorphFillStyleBitmap::Write(std::ostream &out)
{
	out.put((char)(tiled ? 0x40  : 0x41));
	WRITE_UWORD(bitmapID);
	out << mstart;
	out << mend;
}

std::ostream &operator<< (std::ostream &out, FlashTagDefineMorphShape &data)
{
	std::ostrstream tmp;
	std::ostrstream tmp2;
	WRITE_UWORD2(data.GetID(),tmp);
	tmp << data.s1.GetBounds();
	tmp << data.s2.GetBounds();

	data.fs1.Write(tmp2);
	data.fs2.Write(tmp2);
	tmp2 << data.s1;
	WRITE_UDWORD2(tmp2.pcount(),tmp);
	
	tmp.write(tmp2.rdbuf()->str(), tmp2.pcount());	
	tmp << data.s2;
	
	out << FlashTagHeader(46, tmp.pcount());
	out.write(tmp.rdbuf()->str(), tmp.pcount());
	return out;
}

std::istream &operator>> (std::istream &in,  FlashTagDefineMorphShape &data)
{
	return in;
}
	
