#ifndef FLASH_IMPORT_H_FILE
#define FLASH_IMPORT_H_FILE

#include "FBase.h"
#include "FDisplay.h"
#include "FControl.h"
#include "FAction.h"
#include "FBitmap.h"
#include "FSound.h"

#include <iostream>

class FlashImportHandler
{
public:
	FlashImportHandler() {}

	virtual void Import(FlashHeader &data) {}
	virtual void Import(FlashTagHeader &data) {}
	
	virtual void Import(FlashTagRemoveObject &data) {}
	virtual void Import(FlashTagRemoveObject2 &data) {}
	virtual void Import(FlashTagPlaceObject &data) {}
	virtual void Import(FlashTagPlaceObject2 &data) {}
	virtual void Import(FlashTagShowFrame &data) {}

	virtual void Import(FlashTagBackgroundColor &data) {}
	virtual void Import(FlashTagLabelFrame &data) {}
	virtual void Import(FlashTagProtect &data) {}
	virtual void Import(FlashTagEnd &data) {}
	virtual void Import(FlashTagExportAssets &data) {}
	virtual void Import(FlashTagImportAssets &data) {}
	virtual void Import(FlashTagDefineBitsPtr &data) {}
	virtual void Import(FlashTagEnableDebugger &data) {}
	virtual void Import(FlashTagFreeCharacter &data) {}
	
	virtual void Import(FlashTagDefineBitsJPEG1 &data) {}
	virtual void Import(FlashTagJPEGTables &data) {}
	virtual void Import(FlashTagDefineBitsJPEG2 &data) {}
	virtual void Import(FlashTagDefineBitsJPEG3 &data) {}
	virtual void Import(FlashTagDefineBitsLossless &data) {}
	virtual void Import(FlashTagDefineBitsLossless2 &data) {}

	virtual void Import(FlashTagDefineShape1 &data) {}
	virtual void Import(FlashTagDefineShape2 &data) {}
	virtual void Import(FlashTagDefineShape3 &data) {}
	
	virtual void Import(FlashTagDefineSound &data) {}
	virtual void Import(FlashTagDefineSoundMP3 &data) {}
	virtual void Import(FlashTagStartSound &data) {}
	virtual void Import(FlashTagSoundStreamHead &data) {}
	virtual void Import(FlashTagSoundStreamHead2 &data) {}
	virtual void Import(FlashTagSoundStreamBlock &data) {}

	virtual void Import(FlashTagDoAction &data) {}

};



class FlashMyImporter : public FlashImportHandler
{
public:
	FlashMyImporter() {}

	void PrintMatrix(const FlashMatrix &m);
	void PrintCFX(const FlashColorTransform &cfx);
	void PrintRect(const FlashRect &r);

	virtual void Import(FlashHeader &data);
	virtual void Import(FlashTagHeader &data);
	
	virtual void Import(FlashTagRemoveObject &data);
	virtual void Import(FlashTagRemoveObject2 &data);
	virtual void Import(FlashTagPlaceObject &data);
	virtual void Import(FlashTagPlaceObject2 &data);
	virtual void Import(FlashTagShowFrame &data);

	virtual void Import(FlashTagBackgroundColor &data);
	virtual void Import(FlashTagLabelFrame &data);
	virtual void Import(FlashTagProtect &data);
	virtual void Import(FlashTagEnd &data);
	virtual void Import(FlashTagExportAssets &data);
	virtual void Import(FlashTagImportAssets &data);
	virtual void Import(FlashTagDefineBitsPtr &data);
	virtual void Import(FlashTagEnableDebugger &data);
	virtual void Import(FlashTagFreeCharacter &data);
	
	virtual void Import(FlashTagDefineBitsJPEG1 &data);
	virtual void Import(FlashTagJPEGTables &data);
	virtual void Import(FlashTagDefineBitsJPEG2 &data);
	virtual void Import(FlashTagDefineBitsJPEG3 &data);
	virtual void Import(FlashTagDefineBitsLossless &data);
	virtual void Import(FlashTagDefineBitsLossless2 &data);

	virtual void Import(FlashTagDefineShape1 &data);
	virtual void Import(FlashTagDefineShape2 &data);
	virtual void Import(FlashTagDefineShape3 &data);
	
	virtual void Import(FlashTagDefineSound &data);
	virtual void Import(FlashTagDefineSoundMP3 &data);
	virtual void Import(FlashTagStartSound &data);
	virtual void Import(FlashTagSoundStreamHead &data);
	virtual void Import(FlashTagSoundStreamHead2 &data);
	virtual void Import(FlashTagSoundStreamBlock &data);

	virtual void Import(FlashTagDoAction &data);
};

class FlashImporter
{
public:
	FlashImporter() {}
	
	FlashHeader ImportHeader(std::istream &in, FlashImportHandler &i);
	bool ImportTag(std::istream &in, FlashImportHandler &i);
private:
	
};


#endif
