#include "FBase.h"
#include "FImport.h"
#include "FBitmap.h"
#include "FSound.h"
#include "FControl.h"

#include <iostream>

// NOT COMPLETE

void FlashMyImporter::PrintMatrix(const FlashMatrix &m)
{
	if(m.HasRotate()) std::cout << "  Rotate:    " << (double)m.GetRotateX().lowerval/0xffff + m.GetRotateX().upperval << ", " << (double)m.GetRotateY().lowerval/0xffff + m.GetRotateY().upperval << "\n";
	if(m.HasScale())  std::cout << "  Scale:     " << (double)m.GetScaleX().lowerval/0xffff + m.GetScaleX().upperval << ", " << (double)m.GetScaleY().lowerval/0xffff + m.GetScaleY().upperval << "\n";
	std::cout					<< "  Translate: " << (double)m.GetTranslateX().lowerval/0xffff + m.GetTranslateX().upperval << ", " << (double)m.GetTranslateY().lowerval/0xffff + m.GetTranslateY().upperval << "\n";
}

void FlashMyImporter::PrintCFX(const FlashColorTransform &cfx)
{
	
	if(cfx.HasAdd())
	{
		if(cfx.GetAddRGB().GetAlphaWriteMode())
		{
			std::cout   << "  AddRGBA:  " << cfx.GetAddRGB().GetR() << ", " << cfx.GetAddRGB().GetG() << ", " << cfx.GetAddRGB().GetB() << ", " << cfx.GetAddRGB().GetA() << "\n";
		}
		else std::cout  << "  AddRGB:   " << cfx.GetAddRGB().GetR() << ", " << cfx.GetAddRGB().GetG() << ", " << cfx.GetAddRGB().GetB() << "\n";
	}
	if(cfx.HasMult())
	{
		if(cfx.GetMultRGB().GetAlphaWriteMode())
		{
			std::cout   << "  MultRGBA:  " << cfx.GetMultRGB().GetR() << ", " << cfx.GetMultRGB().GetG() << ", " << cfx.GetMultRGB().GetB() << ", " << cfx.GetMultRGB().GetA() << "\n";
		}
		else std::cout   <<"  MultRGB:   " << cfx.GetMultRGB().GetR() << ", " << cfx.GetMultRGB().GetG() << ", " << cfx.GetMultRGB().GetB() << "\n";
	}
}


void FlashMyImporter::PrintRect(const FlashRect &r)
{
	std::cout << " [RECT] (" << r.GetX1() << ", " << r.GetY1() << ", " << r.GetX2() << ", " << r.GetY2() << ")\n";
}

void FlashMyImporter::Import(FlashHeader &data)
{
	std::cout << "\n<FLASH FILE HEADER>\n";
	std::cout << "File Version: "<< (int)data.GetVersion() << "\n";
	std::cout << "Frame Size (x): "  << (data.GetScreenSize().GetX2()) << "\n";
	std::cout << "Frame Size (y): "  << (data.GetScreenSize().GetY2()) << "\n";
	std::cout << "Frame Rate: "  << data.GetFrameRate().ConvertToDouble() << "\n";
	std::cout << "Frame Count: " << data.GetFrameCount() << "\n";
	std::cout << "File Length: " << data.GetFilesize() << "\n";
}

void FlashMyImporter::Import(FlashTagHeader &data)
{
	std::cout << "\n<UNKNOWN TAG>\n";
	std::cout << "ID: "		<< data.GetTagID() << "\n";
	std::cout << "Length: " << data.GetTagLength() << "\n";
}
void FlashMyImporter::Import(FlashTagRemoveObject &data)
{
	std::cout << "\n<RemoveObject>\n";
	std::cout << "Character ID: " << data.GetCharID() << "\n";
	std::cout << "Depth: "        << data.GetDepth() << "\n";
}
void FlashMyImporter::Import(FlashTagRemoveObject2 &data)
{
	std::cout << "\n<RemoveObject2>\n";
	std::cout << "Depth: "        << data.GetDepth() << "\n";
}
void FlashMyImporter::Import(FlashTagPlaceObject &data)
{
	std::cout << "\n<PlaceObject>\n";
	std::cout << "Character ID: " << data.GetCharID() << "\n";
	std::cout << "Depth: "		  << data.GetDepth() << "\n";
	std::cout << "Matrix: "		  << "\n";
	PrintMatrix(data.GetMatrix());
	if(data.HasColorTransform())  std::cout << "HasColorTransform: true"  << "\n"; 
	else						std::cout << "HasColorTransform: false" << "\n"; 
}
void FlashMyImporter::Import(FlashTagPlaceObject2 &data)
{
	std::cout << "\n<PlaceObject2>\n";
	std::cout << "Depth: "		  << data.GetDepth() << "\n";
	
	if(data.HasCharID())		std::cout << "HasCharID: true [" << data.GetCharID() << "]\n"; 
	else						std::cout << "HasCharID: false" << "\n"; 
	if(data.HasMatrix())
	{
		std::cout << "HasMatrix: true"  << "\n"; 
		PrintMatrix(data.GetMatrix());
	}
	else						std::cout << "HasMatrix: false" << "\n"; 
	
	if(data.HasColorTransform())
	{
		std::cout << "HasColorTransform: true"  << "\n"; 
		PrintCFX(data.GetColorTransform());
	}
	else						std::cout << "HasColorTransform: false" << "\n"; 
	if(data.HasMove())			std::cout << "HasMove: true"  << "\n"; 
	else						std::cout << "HasMove: false" << "\n"; 
	if(data.HasRatio())			std::cout << "HasRatio: true ["  << data.GetRatio() << "]\n"; 
	else						std::cout << "HasRatio: false" << "\n"; 
	if(data.HasName())			std::cout << "HasName: true ["  << data.GetName() << "]\n"; 
	else						std::cout << "HasName: false" << "\n"; 


}
void FlashMyImporter::Import(FlashTagShowFrame &data) 
{
	std::cout << "\n<FlashTagShowFrame>\n";
}

void FlashMyImporter::Import(FlashTagBackgroundColor &data)
{
	std::cout << "\n<FlashTagBackgroundColor>\n";
	std::cout << "RGB: " << data.GetRGB().GetR() << ", " << data.GetRGB().GetG() << ", " << data.GetRGB().GetB() << "\n";
}
void FlashMyImporter::Import(FlashTagLabelFrame &data)
{
	std::cout << "\n<FlashTagLabelFrame>\n";
	std::cout << "Label: " << data.GetLabel() << "\n";
}
void FlashMyImporter::Import(FlashTagProtect &data)
{
	std::cout << "\n<FlashTagProtect>\n";
	if(data.HasPassword())
	{
		std::cout << "Password (Encrypted): " << data.GetEncryptedPassword() << "\n";
	}
}
void FlashMyImporter::Import(FlashTagEnableDebugger &data)
{
	std::cout << "\n<FlashTagEnableDebugger>\n";
	
	if(data.HasPassword())
	{
		std::cout << "Password: " << data.GetEncryptedPassword() << "\n";
	}
}

void FlashMyImporter::Import(FlashTagDefineBitsPtr &data)
{
	std::cout << "\n<FlashTagDefineBitsPtr>\n";
	std::cout << "Ptr: " << data.GetPtr() << "\n";
	
}

void FlashMyImporter::Import(FlashTagEnd &data)
{
	std::cout << "\n<FlashTagEnd>\n";
}
void FlashMyImporter::Import(FlashTagExportAssets &data)
{
	std::cout << "\n<FlashTagExportAssets>\n";
	int num = data.GetAssetNum();
	for(int i=0; i < num; i++)
	{
		std::cout << "Asset " << i << " (name): " << data.GetAsset(i).first << "\n"; 
		std::cout << "Asset " << i << " (id):   " << data.GetAsset(i).second << "\n"; 
	}
	
}
void FlashMyImporter::Import(FlashTagImportAssets &data)
{
	std::cout << "\n<FlashTagImportAssets>\n";
	std::cout << "SWF Url: " << data.GetSwfUrl() << "\n";
	int num = data.GetAssetNum();
	for(int i=0; i < num; i++)
	{
		std::cout << "Asset " << i << " (name): " << data.GetAsset(i).first << "\n"; 
		std::cout << "Asset " << i << " (id):   " << data.GetAsset(i).second << "\n"; 
	}
}
void FlashMyImporter::Import(FlashTagDoAction &data)
{
	std::cout << "\n<FlashTagDoAction>\n";
	std::cout << "Num Actions: " << data.GetNumActions() << "\n";

}

void FlashMyImporter::Import(FlashTagDefineBitsJPEG1 &data)
{
	std::cout << "\n<FlashTagDefineBitsJPEG1>\n";
	std::cout << "ID:" << data.GetID() << "\n";
}
void FlashMyImporter::Import(FlashTagJPEGTables &data)
{
	std::cout << "\n<FlashTagJPEGTables>\n";
}
void FlashMyImporter::Import(FlashTagDefineBitsJPEG2 &data) 
{
	std::cout << "\n<FlashTagDefineBitsJPEG2>\n";
	std::cout << "ID:" << data.GetID() << "\n";

}
void FlashMyImporter::Import(FlashTagDefineBitsJPEG3 &data) 
{
	std::cout << "\n<FlashTagDefineBitsJPEG3>\n";
	std::cout << "ID:" << data.GetID() << "\n";

}
void FlashMyImporter::Import(FlashTagDefineBitsLossless &data) 
{
	std::cout << "\n<FlashTagDefineBitsLossless>\n";
	std::cout << "ID:" << data.GetID() << "\n";
	std::cout << "Format: " << data.GetFormat() << "\n";
	std::cout << "Width: " << data.GetWidth() << " Height: " << data.GetHeight() << "\n";

}
void FlashMyImporter::Import(FlashTagDefineBitsLossless2 &data) 
{
	std::cout << "\n<FlashTagDefineBitsLossless2>\n";
	std::cout << "ID:" << data.GetID() << "\n";
	std::cout << "Format: " << data.GetFormat() << "\n";
	std::cout << "Width: " << data.GetWidth() << " Height: " << data.GetHeight() << "\n";

}

void FlashMyImporter::Import(FlashTagDefineShape1 &data)
{
	std::cout << "\n<FlashTagDefineShape1>\n";
	std::cout << "ID:" << data.GetID() << "\n";
	PrintRect(data.GetShapes().GetBounds());
	PrintRect(data.rimport);
}
void FlashMyImporter::Import(FlashTagDefineShape2 &data)
{
	std::cout << "\n<FlashTagDefineShape2>\n";
	std::cout << "ID:" << data.GetID() << "\n";
	PrintRect(data.GetShapes().GetBounds());
	PrintRect(data.rimport);
}
void FlashMyImporter::Import(FlashTagDefineShape3 &data)
{
	std::cout << "\n<FlashTagDefineShape3>\n";
	std::cout << "ID:" << data.GetID() << "\n";
	PrintRect(data.GetShapes().GetBounds());
	PrintRect(data.rimport);
}
void FlashMyImporter::Import(FlashTagFreeCharacter &data)
{
	std::cout << "\n<FreeCharacter>\n";
	std::cout << "ID:" << data.GetID() << "\n";
}

void FlashMyImporter::Import(FlashTagDefineSound &data)
{
	std::cout << "\n<FlashTagDefineSound>\n";
	std::cout << "ID:" << data.GetID() << "\n";
	std::cout << "Flags:" << (int)data.GetFlags() << "\n";
	std::cout << "Sample Count:" << data.GetSampleCount() << "\n";
	std::cout << "Sample Length:" << data.GetSampleLength() << "\n";
}

void FlashMyImporter::Import(FlashTagDefineSoundMP3 &data)
{
	std::cout << "\n<FlashTagDefineSoundMP3>\n";
	std::cout << "ID:" << data.GetID() << "\n";
	std::cout << "Flags:" << (int)data.GetFlags() << "\n";
	std::cout << "Sample Count:" << data.GetSampleCount() << "\n";
	std::cout << "Sample Length:" << data.GetSampleLength() << "\n";
}

void FlashMyImporter::Import(FlashTagStartSound &data)
{
	std::cout << "\n<FlashTagStartSound>\n";
	std::cout << "ID:" << data.GetID() << "\n";
	std::cout << "Sound Info:\n";
	std::cout << "  Flags: "  << (int)data.GetSoundInfo().GetFlags()   << "\n";
	
	if(data.GetSoundInfo().GetFlags() & FSI_HAS_IN != 0) std::cout << "  In Point: "  << data.GetSoundInfo().GetInPoint()   << "\n";
	if(data.GetSoundInfo().GetFlags() & FSI_HAS_OUT != 0) std::cout << "  Out Point: " << data.GetSoundInfo().GetOutPoint()  << "\n";
	if(data.GetSoundInfo().GetFlags() & FSI_HAS_LOOP != 0) std::cout << "  Loop Count: " << data.GetSoundInfo().GetLoopCount() <<  "\n";
	if(data.GetSoundInfo().GetFlags() & FSI_HAS_ENVELOPE != 0) std::cout << "  Sound Envelopes Found\n";
}
void FlashMyImporter::Import(FlashTagSoundStreamHead &data)
{
	std::cout << "\n<FlashTagSoundStreamHead>\n";
	std::cout << "Play Rate: " <<  (int)data.GetPlayRate() << "\n";
	std::cout << "Play 16 Bit: " << data.GetPlay16bit() << "\n";
	std::cout << "Play Stereo: " << data.GetPlayStereo() << "\n";
	std::cout << "Compression: " << (int)data.GetCompression() << "\n";
	std::cout << "Stream Rate: " << (int)data.GetStreamRate() << "\n";
	std::cout << "Stream 16 Bit: " << data.GetStream16bit() << "\n";
	std::cout << "Stream Stereo: " << data.GetStreamStereo() << "\n";
	std::cout << "Sample Count Avg.: " << data.GetSampleCountAvg() << "\n";

	
}
void FlashMyImporter::Import(FlashTagSoundStreamHead2 &data)
{
	std::cout << "\n<FlashTagSoundStreamHead2>\n";
	std::cout << "Play Rate: " << (int)data.GetPlayRate() << "\n";
	std::cout << "Play 16 Bit: " << data.GetPlay16bit() << "\n";
	std::cout << "Play Stereo: " << data.GetPlayStereo()<< "\n";
	std::cout << "Compression: " << (int)data.GetCompression() << "\n";
	std::cout << "Stream Rate: " << (int)data.GetStreamRate() << "\n";
	std::cout << "Stream 16 Bit: " << data.GetStream16bit() << "\n";
	std::cout << "Stream Stereo: " << data.GetStreamStereo() << "\n";
	std::cout << "Sample Count Avg.: " << data.GetSampleCountAvg() << "\n";

}
void FlashMyImporter::Import(FlashTagSoundStreamBlock &data)
{
	std::cout << "\n<FlashTagSoundStreamBlock>\n";
	std::cout << "Length:" << data.GetSampleLength() << "\n";
}



FlashHeader FlashImporter::ImportHeader(std::istream &in, FlashImportHandler &i)
{
	FlashHeader h;
	in >> h;
	i.Import(h);
	return h;
}
 

#define IMPORT_MACRO(id, name)                              \
	if(tagHeader.GetTagID() == id)                           \
	{                                                        \
		name tmp;                                            \
		tmp.SetImportSize(tagHeader.GetTagLength());         \
		in >> tmp;                                           \
		i.Import(tmp);                                       \
} 

bool FlashImporter::ImportTag(std::istream &in, FlashImportHandler &i)
{
	FlashTagHeader tagHeader;
	in >> tagHeader;
	
	std::streampos start = in.tellg();

	if(tagHeader.GetTagID() == 4)
	{
		FlashTagPlaceObject tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp); // PlaceObject
	}
	else if(tagHeader.GetTagID() == 26)
	{
		FlashTagPlaceObject2 tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp); // PlaceObject2
	}
	else if(tagHeader.GetTagID() ==  5)
	{
		FlashTagRemoveObject tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp); // RemoveObject
	}
	else if(tagHeader.GetTagID() == 28)
	{
		FlashTagRemoveObject2 tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp); // RemoveObject2
	}
	else if(tagHeader.GetTagID() == 1)
	{
		FlashTagShowFrame tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp); // ShowFrame
	}
	else if(tagHeader.GetTagID() == 9)
	{
		FlashTagBackgroundColor tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp);
	}
	else if(tagHeader.GetTagID() == 43)
	{
		FlashTagLabelFrame tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp);
	}
	else if(tagHeader.GetTagID() == 24)
	{
		FlashTagProtect tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp);
	}
	else if(tagHeader.GetTagID() == 0)
	{
		FlashTagEnd tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp);
	}
	else if(tagHeader.GetTagID() == 56)
	{
		FlashTagExportAssets tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp);
	}
	else if(tagHeader.GetTagID() == 57)
	{
		FlashTagImportAssets tmp;
		tmp.SetImportSize(tagHeader.GetTagLength());
		in >> tmp;
		i.Import(tmp);
	}
	else IMPORT_MACRO(8, FlashTagJPEGTables)
	else IMPORT_MACRO(6,  FlashTagDefineBitsJPEG1)
	else IMPORT_MACRO(21, FlashTagDefineBitsJPEG2)
	else IMPORT_MACRO(35, FlashTagDefineBitsJPEG3)
	else IMPORT_MACRO(20, FlashTagDefineBitsLossless)
	else IMPORT_MACRO(36, FlashTagDefineBitsLossless2)

	else IMPORT_MACRO(2,  FlashTagDefineShape1)
	else IMPORT_MACRO(22, FlashTagDefineShape2)
	else IMPORT_MACRO(32, FlashTagDefineShape3)
	else IMPORT_MACRO(3,  FlashTagFreeCharacter)

	else if(tagHeader.GetTagID() == 14)
	{
		
		int c = in.get();
		if(c == EOF)
		{ 
			//throw
		}
		else
		{
			if(c & FTDS_COMPRESS_MP3 != 0) 
			{
				in.putback(c);
				FlashTagDefineSoundMP3 tmp;
				tmp.SetImportSize(tagHeader.GetTagLength());
				in >> tmp;
				i.Import(tmp);
			}
			else
			{
				in.putback(c);
				FlashTagDefineSound tmp;
				tmp.SetImportSize(tagHeader.GetTagLength());
				in >> tmp;
				i.Import(tmp);
			}
		}	
	}

	else IMPORT_MACRO(15, FlashTagStartSound)
	else IMPORT_MACRO(18, FlashTagSoundStreamHead)
	else IMPORT_MACRO(45, FlashTagSoundStreamHead2)
	else IMPORT_MACRO(19, FlashTagSoundStreamBlock)
	
	else
	{
		for(UDWORD index=0; index < tagHeader.GetTagLength(); index++)
		{
			in.get();
		}
		i.Import(tagHeader);
	}
	
	if(tagHeader.GetTagLength() + start != (UDWORD)in.tellg())
	{
		if(tagHeader.GetTagLength() + start > (UDWORD)in.tellg())
		{
			UDWORD difference = (tagHeader.GetTagLength() + start) - (UDWORD)in.tellg();
			
			std::cout << "Extra Tag Data Encountered: " <<  difference;
			

			for(UDWORD index=0; index < difference; index++)
			{
				in.get();
			}
		}
		else
		{
			//ADD HANDLER???
			
			UDWORD difference = (UDWORD)in.tellg() - (UDWORD)(tagHeader.GetTagLength() + start);
			std::cout << "Tag Size Discrepancy: -" << difference;
			return false;
		}
	}
	if(tagHeader.GetTagID() == 0)
	{
		return false;
	}
	return true;
}

