#ifndef FFONT_H_FILE
#define FFONT_H_FILE

#include "FBase.h"
#include "FShape.h"

#include <vector>

typedef FlashIDFactory FlashFontIDFactory;
typedef FlashIDEnabled FlashFontIDEnabled;

#define FTDFI_UNICODE		(1 << 5)
#define FTDFI_SHIFTJIS		(1 << 4)
#define FTDFI_ANSI			(1 << 3)
#define FTDFI_ITALIC		(1 << 2)
#define FTDFI_BOLD			(1 << 1)
#define FTDFI_WIDECODES		(1)

class FlashTagDefineFontInfo : public FlashTag, public FlashFontIDEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashTagDefineFontInfo(char *_str, unsigned char _flags) : str(_str), flags(_flags) {}

	void AddCode(UWORD code) { codes.push_back(code); }

	friend std::istream &operator >> (std::istream &in,  FlashTagDefineFontInfo &data);
	friend std::ostream &operator << (std::ostream &out, FlashTagDefineFontInfo &data);

private:
	std::vector<UWORD> codes;
	gc_vector<char *> strings;
	char *str;
	unsigned char flags;
};


class FlashTagDefineFont : public FlashTag, public FlashFontIDEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashTagDefineFont() {}
	
	void AddShape(FlashShape& shape);
	friend std::istream &operator >> (std::istream &in,  FlashTagDefineFont &data);
	friend std::ostream &operator << (std::ostream &out, FlashTagDefineFont &data);
private:
	std::vector<FlashShape> shapes;
};

class FlashTextRecord : public FlashVersionEnabled
{
public:	
	FlashTextRecord() {};
	virtual void Write(std::ostream &out, unsigned char bitsGlyph=0, unsigned char bitsAdvance=0) = 0;
	virtual bool isGlyph(void) = 0;
	virtual int returnGlyphBits(void) { return -1; }
	virtual int returnAdvBits(void) { return -1; }
};

class FlashTextRecordStyle : public FlashTextRecord
{
public:
	FlashTextRecordStyle(bool hasFont, bool hasFlashRGB, bool hasOffsetx, bool hasOffsety, 
		UWORD FontID, UWORD FontHeight, FlashRGB color, SWORD offsetx, SWORD offsety) :		
			mhasFont(hasFont), mhasFlashRGB(hasFlashRGB), mhasOffsetx(hasOffsetx), mhasOffsety(hasOffsety), 
			mFontID(FontID), mFontHeight(FontHeight), mcolor(color), moffsetx(offsetx), moffsety(offsety) {}
	
	virtual void Write(std::ostream &out, unsigned char bitsGlyph=0, unsigned char bitsAdvance=0);
	virtual bool isGlyph(void);
	

private:
	bool mhasFont;
	bool mhasFlashRGB;
	bool mhasOffsetx;
	bool mhasOffsety;
	UWORD mFontID;
	UWORD mFontHeight;
	FlashRGB mcolor;
	SWORD moffsetx;
	SWORD moffsety;
};
typedef flash_pair<UWORD, SWORD> FlashGlyphEntry;

class FlashTextRecordGlyph : public FlashTextRecord
{
	
public:
        FlashTextRecordGlyph() {}
        virtual ~FlashTextRecordGlyph() {}
	virtual void Write(std::ostream &out, unsigned char bitsGlyph=0, unsigned char bitsAdvance=0);
	virtual bool isGlyph(void) { return true; }
	virtual int returnGlyphBits(void);
	virtual int returnAdvBits(void);

	void AddGlyph(FlashGlyphEntry &e) { v.push_back(e); }
private:
	std::vector<FlashGlyphEntry> v;
};

class FlashTagDefineText : public FlashTag, public FlashIDEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashTagDefineText(FlashRect &r, FlashMatrix &m) : rect(r), matrix(m) {}

	void AddTextRecord(FlashTextRecord *r);

	friend std::istream &operator >> (std::istream &in,  FlashTagDefineText &data);
	friend std::ostream &operator << (std::ostream &out, FlashTagDefineText &data);

private:
	FlashRect rect;
	FlashMatrix matrix;
	std::vector<FlashTextRecord *> records;

};

class FlashTagDefineText2 : public FlashTag, public FlashIDEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashTagDefineText2(FlashRect &r, FlashMatrix &m) : rect(r), matrix(m) {}

	void AddTextRecord(FlashTextRecord *r);

	friend std::istream &operator >> (std::istream &in,  FlashTagDefineText2 &data);
	friend std::ostream &operator << (std::ostream &out, FlashTagDefineText2 &data);

private:
	FlashRect rect;
	FlashMatrix matrix;
	std::vector<FlashTextRecord *> records;

};


class FlashKerningRecord : public FlashVersionEnabled
{
public:
	FlashKerningRecord(UWORD _code1, UWORD _code2, SWORD _adjustment) : code1(_code1), code2(_code2), adjustment(_adjustment) {}
private:
	friend std::istream &operator >> (std::istream &in,  FlashKerningRecord &data);
	friend std::ostream &operator << (std::ostream &out, FlashKerningRecord &data);

	UWORD code1;
	UWORD code2;
	SWORD adjustment;

};

#define FTDF2_HASLAYOUT			(1 << 7)
#define FTDF2_SHIFTJIS			(1 << 6)
#define FTDF2_UNICODE			(1 << 5)
#define FTDF2_ANSI				(1 << 4)
#define FTDF2_WIDEOFFSETS		(1 << 3)
#define FTDF2_WIDECODES			(1 << 2)
#define FTDF2_ITALIC			(1 << 1)
#define FTDF2_BOLD				(1)

class FlashTagDefineFont2 : public FlashTag, public FlashFontIDEnabled
{
	DEFINE_RW_INTERFACE
public:
	FlashTagDefineFont2(char fontflags,	const char *_fontname) : flags(fontflags), fontname(_fontname) {}
	
	class FlashFontLayout
	{		
	public:
		FlashFontLayout() {}
		FlashFontLayout(SWORD ascent, SWORD descent, SWORD leading,
			std::vector<SWORD> &advance) : fontAscent(ascent), fontDescent(descent),
			fontLeading(leading), fontAdvanceTable(advance) {}
		FlashFontLayout(SWORD ascent, SWORD descent, SWORD leading,
			std::vector<SWORD> &advance, std::vector<FlashRect> &bounds,
			std::vector<FlashKerningRecord> &kerning) 
			: fontAscent(ascent), fontDescent(descent),
			fontLeading(leading), fontAdvanceTable(advance),
			fontBoundsTable(bounds), fontKerningTable(kerning){}
		
		void Write(std::ostream &out);
	private:
		SWORD fontAscent;
		SWORD fontDescent;
		SWORD fontLeading;

		std::vector<SWORD>fontAdvanceTable;
		
		std::vector<FlashRect> fontBoundsTable;
		std::vector<FlashKerningRecord> fontKerningTable;
	};

	void SetLayout(FlashFontLayout &l) {layout = true; layout_data = l; }
	void AddShape(FlashShape &shape) { shapes.push_back(shape); }
	void AddCode(UWORD code) { codes.push_back(code); }

private:

	std::vector<UWORD> codes;
	std::vector<FlashShape> shapes;
	bool layout;
        char flags;
	const char *fontname;
	FlashFontLayout layout_data;

	
	friend std::ostream &operator << (std::ostream &out, FlashTagDefineFont2 &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagDefineFont2 &data);

};

#define FTDEB_HASTEXT			(1 << 15)
#define FTDEB_WORDWRAP			(1 << 14)
#define FTDEB_MULTILINE			(1 << 13)
#define FTDEB_PASSWORD			(1 << 12)
#define FTDEB_READONLY			(1 << 11)
#define FTDEB_HASTEXTCOLOR		(1 << 10)
#define FTDEB_HASMAXLENGTH		(1 << 9)
#define FTDEB_HASFONT			(1 << 8)
//reserved 2 bits
#define FTDEB_HASLAYOUT			(1 << 5)
#define FTDEB_NOSELECT			(1 << 4)
#define FTDEB_BORDER			(1 << 3)
//reserved 1 bit
#define FTDEB_HTML   			(1 << 1)
#define FTDEB_USEOUTLINES		(1)

class FlashTagDefineEditBox : public FlashTag, public FlashIDEnabled
{
DEFINE_RW_INTERFACE
public:	
	FlashTagDefineEditBox(FlashRect &r, UWORD flags, UWORD fontID, UWORD fontHeight, 
						  FlashRGB color /*WITH ALPHA*/, UWORD maxLength, unsigned char align, 
						  UWORD leftmargin, UWORD rightmargin, UWORD indent, UWORD leading, 
						  char *variable, char *initialtext) :
						mr(r), mflags(flags), mfontID(fontID),mfontHeight(fontHeight),mcolor(color),
						mmaxLength(maxLength), malign(align), mleftmargin(leftmargin), mrightmargin(rightmargin),
						mindent(indent), mleading(leading), mvariable(variable), 
						minitialtext(initialtext) {}
private:

	friend std::ostream &operator << (std::ostream &out, FlashTagDefineEditBox &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagDefineEditBox &data);

	gc_vector<char *> gc;
	FlashRect &mr;
	UWORD mflags; 
	UWORD mfontID; 
	UWORD mfontHeight;
	FlashRGB mcolor /*WITH ALPHA*/; 
	UWORD mmaxLength; 
	unsigned char malign;
	UWORD mleftmargin; 
	UWORD mrightmargin; 
	UWORD mindent; 
	UWORD mleading;
	char *mvariable; 
	char *minitialtext;
};
#endif
