#include "FFont.h"
#include <strstream>


std::ostream &operator << (std::ostream &out, FlashTagDefineFontInfo &data)
{
	out << FlashTagHeader(13, strlen(data.str)+2+2+data.codes.size()*((data.flags & 1) ? 2:1));
	WRITE_UWORD(data.GetID());
	out.put((char)strlen(data.str));
	out << data.str;
	out.put(data.flags);
	if(data.flags & 1)
	{
		for(std::vector<UWORD>::iterator i = data.codes.begin(); i != data.codes.end(); i++)
		{
			WRITE_UWORD(*i);		
		}
	}
	else
	{
		for(std::vector<UWORD>::iterator i = data.codes.begin(); i != data.codes.end(); i++)
		{
			out.put((char)*i);
		}
	}
	return out;
}

std::istream &operator >> (std::istream &in,  FlashTagDefineFontInfo &data)
{
	UWORD id;
	READ_UWORD(id);
	data.SetID(id);
	int len = in.get();
	//if(i == EOF) throw;
	
	data.str = (char *)malloc(len+1);
	data.strings.push_back(data.str);
	data.str[len] = 0;
	
	unsigned char * tmp = (unsigned char *)data.str;
	
	for(int i=0; (i < len); i++)
	{
		int c = in.get();
		//if(c == EOF) throw;
		tmp[i] = c;
	}
	int flags = in.get();
	//if(flags == EOF) throw;
	
	data.flags = flags;
	
	UWORD size = data.importsize - (len+2+2);
	
	if(data.flags & 1)
	{
		for(UWORD i = 0; i < size; i+=2)
		{
			UWORD tmp;
			READ_UWORD(tmp);
			data.codes.push_back(tmp);		
		}
	}
	else
	{
		for(UWORD i = 0; i < size; i++)
		{
			int c = in.get();
			//if(c == EOF) throw;
			data.codes.push_back(c);
		}
		
	}
	return in;
}


void FlashTagDefineFont::AddShape(FlashShape &shape)
{
	shapes.push_back(shape);
}

std::ostream &operator << (std::ostream &out, FlashTagDefineFont &data)
{
	
	std::ostrstream tmp;
		
	std::vector<UWORD> offsets;

	for(std::vector<FlashShape>::iterator i = data.shapes.begin(); i < data.shapes.end(); i++)
	{
		offsets.push_back(tmp.pcount());
		tmp << *i;
	}
	
	out << FlashTagHeader(10, 2+offsets.size()*2+tmp.pcount());
	WRITE_UWORD(data.GetID());
	
	for(std::vector<UWORD>::iterator i2 = offsets.begin(); i2 < offsets.end(); i2++)
	{
		WRITE_UWORD(*i2+offsets.size()*2);
	}
	
	out.write(tmp.rdbuf()->str(), tmp.pcount());

	return out;
}

std::istream &operator >> (std::istream &in,  FlashTagDefineFont &data)
{
	return in;
}

void FlashTextRecordStyle::Write(std::ostream &out, unsigned char bitsGlyph, unsigned char bitsAdvance)
{
	out.put((char)((char)(1 << 7)  | (char)(mhasFont << 3) | (char)(mhasFlashRGB << 2) | (char)(mhasOffsetx << 1) | (char)(mhasOffsety)));
	if(mhasFont)
	{
		WRITE_UWORD(mFontID);
	}
	if(mhasFlashRGB)
	{		
		mcolor.SetAlphaWriteMode(GetTagVersion() > 1);
		out << mcolor;
	}
	if(mhasOffsetx)
	{
		WRITE_SWORD(moffsetx);
	}
	if(mhasOffsety)
	{
		WRITE_SWORD(moffsety);
	}
	if(mhasFont)
	{
		WRITE_UWORD(mFontHeight);
	}
}

bool FlashTextRecordStyle::isGlyph(void)
{
	return false;
}

void FlashTextRecordGlyph::Write(std::ostream &out, unsigned char bitsGlyph, unsigned char bitsAdvance)
{
	out.put((char)v.size());
	BitStreamOut b(&out);
	for(std::vector<FlashGlyphEntry>::iterator i=v.begin(); i != v.end(); i++)
	{
		b.Write((*i).first, bitsGlyph);
		b.Write(PackBitsSigned((*i).second), bitsAdvance);
	}
	b.Align();
}

int FlashTextRecordGlyph::returnGlyphBits(void)
{
	int ret=0;
	for(std::vector<FlashGlyphEntry>::iterator i=v.begin(); i != v.end(); i++)
	{
		if(GetBitSize((*i).first) > ret) ret = GetBitSize((*i).first);
	}
	return ret;
}

int FlashTextRecordGlyph::returnAdvBits(void)
{
		int ret=0;
	for(std::vector<FlashGlyphEntry>::iterator i=v.begin(); i != v.end(); i++)
	{
		if(GetBitSizeSigned((*i).second) > ret) ret = GetBitSizeSigned((*i).second);
	}
	return ret;
}


void FlashTagDefineText::AddTextRecord(FlashTextRecord *r)
{
	records.push_back(r);
}

std::ostream &operator << (std::ostream &out, FlashTagDefineText &data)
{
	std::ostrstream tmp;
	int gbits=0;
	int abits=0;
	for(std::vector<FlashTextRecord *>::iterator i = data.records.begin(); i != data.records.end(); i++)
	{
		if((*i)->isGlyph())
		{
			if((*i)->returnGlyphBits() > gbits) { gbits=(*i)->returnGlyphBits(); }
			if((*i)->returnAdvBits()   > abits) { abits=(*i)->returnAdvBits(); }
		}
	}
	

	WRITE_UWORD2(data.GetID(), tmp);
	tmp << data.rect;
	tmp << data.matrix;
	tmp << (char)gbits;
	tmp << (char)abits;
	
	for(std::vector<FlashTextRecord *>::iterator i2 = data.records.begin(); i2 != data.records.end(); i2++)
	{
		(*i2)->SetTagVersion(1);
		(*i2)->Write(tmp,gbits,abits);
	}
	
	tmp << (char)0;

	out << FlashTagHeader(11, tmp.pcount());
	out.write(tmp.rdbuf()->str(), tmp.pcount());

	return out;
}

std::istream &operator >> (std::istream &in,  FlashTagDefineText &data)
{
	return in;
}

void FlashTagDefineText2::AddTextRecord(FlashTextRecord *r)
{
	records.push_back(r);
}

std::ostream &operator << (std::ostream &out, FlashTagDefineText2 &data)
{
	std::ostrstream tmp;
	int gbits=0;
	int abits=0;
	for(std::vector<FlashTextRecord *>::iterator i = data.records.begin(); i != data.records.end(); i++)
	{
		if((*i)->isGlyph())
		{
			if((*i)->returnGlyphBits() > gbits) { gbits=(*i)->returnGlyphBits(); }
			if((*i)->returnAdvBits()   > abits) { abits=(*i)->returnAdvBits(); }
		}
	}
	

	WRITE_UWORD2(data.GetID(), tmp);
	tmp << data.rect;
	tmp << data.matrix;
	tmp << (char)gbits;
	tmp << (char)abits;
	
	for(std::vector<FlashTextRecord *>::iterator i2 = data.records.begin(); i2 != data.records.end(); i2++)
	{
		(*i2)->SetTagVersion(2);
		(*i2)->Write(tmp,gbits,abits);
	}
	
	tmp << (char)0;

	out << FlashTagHeader(33, tmp.pcount());
	out.write(tmp.rdbuf()->str(), tmp.pcount());

	return out;
}

std::istream &operator >> (std::istream &in,  FlashTagDefineText2 &data)
{
	return in;
}

std::ostream &operator << (std::ostream &out, FlashKerningRecord &data)
{
	if(data.GetTagVersion() > 1)
	{
		WRITE_UWORD(data.code1);
		WRITE_UWORD(data.code2);
		WRITE_SWORD(data.adjustment);
	}
	else
	{
		out.put((char)data.code1);
		out.put((char)data.code2);
		WRITE_SWORD(data.adjustment);
	}
	return out;
}
std::istream &operator >> (std::istream &in,  FlashKerningRecord &data)
{
	return in;
}


// TODO: Error checking nGlyph?!
void FlashTagDefineFont2::FlashFontLayout::Write(std::ostream &out)
{
	WRITE_SWORD(fontAscent);
	WRITE_SWORD(fontDescent);
	WRITE_SWORD(fontLeading);
	for(std::vector<SWORD>::iterator i=fontAdvanceTable.begin(); i != fontAdvanceTable.end(); i++)
	{
		WRITE_SWORD(*i);
	}
	for(std::vector<FlashRect>::iterator i2=fontBoundsTable.begin(); i2 != fontBoundsTable.end(); i2++)
	{
		out << *i2;
	}
	WRITE_UWORD(fontKerningTable.size());
	for(std::vector<FlashKerningRecord>::iterator i3=fontKerningTable.begin(); i3 != fontKerningTable.end(); i3++)
	{
		out << *i3;
	}
}

std::ostream &operator << (std::ostream &out, FlashTagDefineFont2 &data)
{
	
	std::ostrstream tmp;
	
	tmp << (char)strlen(data.fontname);
	tmp << data.fontname;
	WRITE_UWORD2(data.shapes.size(),tmp);

	std::ostrstream tmp2;
	
	std::vector<UDWORD> offsets;

	for(std::vector<FlashShape>::iterator i = data.shapes.begin(); i < data.shapes.end(); i++)
	{
		offsets.push_back(tmp.pcount());
		tmp << *i;
	}	
	bool longoffsets;
	
	if(offsets.size() > 0) longoffsets = offsets[offsets.size()-1] > (64*1024);
	else longoffsets = false;

	for(std::vector<UDWORD>::iterator i2 = offsets.begin(); i2 < offsets.end(); i2++)
	{
		if(longoffsets)
		{
			WRITE_UDWORD2(*i2+offsets.size()*4,tmp);
		}
		else
		{
			WRITE_UWORD2(*i2+offsets.size()*2,tmp);
		}		
	}
	
	if(longoffsets)
	{
		WRITE_UDWORD2(tmp2.pcount(),tmp);
	}
	else
	{
		WRITE_UWORD2(tmp2.pcount(),tmp);	
	}			
	
	tmp.write(tmp2.rdbuf()->str(), tmp2.pcount());
	
	bool longcodes = data.shapes.size() > (64*1024);
	if(longcodes)
	{
		for(std::vector<UWORD>::iterator i = data.codes.begin(); i != data.codes.end(); i++)
		{
			WRITE_UWORD(*i);		
		}
	}
	else
	{
		for(std::vector<UWORD>::iterator i = data.codes.begin(); i != data.codes.end(); i++)
		{
			out.put((char)*i);
		}
	}

	if(data.layout)
	{
		data.layout_data.Write(tmp);
	}
	
	out << FlashTagHeader(48,tmp.pcount()+4);
	
	WRITE_UWORD(data.GetID());
	
	out.put((char)((data.layout << 7) | (longoffsets << 3) | (longcodes << 2) | (data.flags)));
	out.put(0);
	out.write(tmp.rdbuf()->str(), tmp.pcount());
	
	return out;
}

std::istream &operator >> (std::istream &in,  FlashTagDefineFont2 &data)
{
	return in;
}


std::ostream &operator << (std::ostream &out, FlashTagDefineEditBox &data)
{
	std::ostrstream tmp;
	WRITE_UWORD2(data.GetID(), tmp);
	tmp << data.mr;
	tmp.put((unsigned char)(data.mflags >> 8));
	tmp.put((unsigned char)(data.mflags & 0xff));
	if(data.mflags & FTDEB_HASFONT)
	{
		WRITE_UWORD2(data.mfontID,tmp); 
		WRITE_UWORD2(data.mfontHeight,tmp);
	}
	if(data.mflags & FTDEB_HASTEXTCOLOR)
	{
		data.mcolor.SetAlphaWriteMode(true);
		tmp << data.mcolor;
	}
	if(data.mflags & FTDEB_HASMAXLENGTH)
	{
		WRITE_UWORD2(data.mmaxLength, tmp); 
	}
	if(data.mflags & FTDEB_HASLAYOUT)
	{
		tmp.put(data.malign);
		WRITE_UWORD2(data.mleftmargin, tmp); 
		WRITE_UWORD2(data.mrightmargin, tmp); 
		WRITE_UWORD2(data.mindent, tmp); 
		WRITE_UWORD2(data.mleading, tmp);	
	}
	tmp << data.mvariable; 
	tmp.put((char)0);
	if(data.mflags & FTDEB_HASTEXT)
	{
		tmp << data.minitialtext;
		tmp.put((char)0);
	}
	out << FlashTagHeader(37, tmp.pcount());
	out.write(tmp.rdbuf()->str(),tmp.pcount());
	return out;
}
std::istream &operator >> (std::istream &in,  FlashTagDefineEditBox &data)
{
	UWORD id;
	READ_UWORD(id);
	data.SetID(id);
	
	in >> data.mr;
	
	int c = in.get();
	//if c == EOF throw
	int c2 = in.get();
	//if c2 == EOF throw

	data.mflags = ((unsigned char)c);
	data.mflags = (data.mflags << 8) | (c2 & 0xff);

	
	if(data.mflags & FTDEB_HASFONT)
	{
		READ_UWORD(data.mfontID); 
		READ_UWORD(data.mfontHeight);
	}
	if(data.mflags & FTDEB_HASTEXTCOLOR)
	{
		data.mcolor.SetAlphaWriteMode(true);
		in >> data.mcolor;
	}
	if(data.mflags & FTDEB_HASMAXLENGTH)
	{
		READ_UWORD(data.mmaxLength); 
	}
	if(data.mflags & FTDEB_HASLAYOUT)
	{
		data.malign = in.get();
		// if(data.malign == EOF) throw
		READ_UWORD(data.mleftmargin);
		READ_UWORD(data.mrightmargin);
		READ_UWORD(data.mindent);
		READ_UWORD(data.mleading);
	}
	{
		std::vector<int> text;
		for(;;)
		{
			int i = in.get();
			//if(i == EOF) throw;
			text.push_back(i);
			if(i==0) break;
		}
		data.mvariable = (char *)malloc(text.size());
		data.gc.push_back(data.mvariable);
		{
			for(unsigned int i = 0; i < text.size(); i++)
			{
				unsigned char *c = (unsigned char *)data.mvariable;
				c[i] = text[i];
			}		
		}
	}

	if(data.mflags & FTDEB_HASTEXT)
	{
		std::vector<int> text;
		for(;;)
		{
			int i = in.get();
			//if(i == EOF) throw;
			text.push_back(i);
			if(i==0) break;
		}
		data.minitialtext = (char *)malloc(text.size());
		data.gc.push_back(data.minitialtext);
		{
			for(unsigned int i = 0; i < text.size(); i++)
			{
				unsigned char *c = (unsigned char *)data.minitialtext;
				c[i] = text[i];
			}		
		}	
	}
	return in;
}

