#ifndef FDISPLAY_H_FILE
#define FDISPLAY_H_FILE

#include <string>
#include "FBase.h"
#include "FShape.h"

class FlashTagPlaceObject : public FlashSpriteEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashTagPlaceObject(UWORD _depth, UWORD _charID, FlashMatrix &m);
	FlashTagPlaceObject(UWORD _depth, UWORD _charID, FlashMatrix &m, FlashColorTransform &c);

	bool HasColorTransform() { return (hascfx); }

	UWORD GetCharID() { return characterID; }
	UWORD GetDepth()  { return depth; }
	FlashMatrix GetMatrix() { return matrix; } 
	FlashColorTransform GetColorTransform() { return cfx; }

protected:
	friend class FlashImporter;
	FlashTagPlaceObject() {}
private:
	friend std::ostream& operator<<(std::ostream& out, FlashTagPlaceObject &data);
	friend std::istream& operator>>(std::istream& in, FlashTagPlaceObject &data);

        UWORD characterID;
        UWORD depth;
	FlashMatrix matrix;
        bool hascfx;
	FlashColorTransform cfx;

};

//TODO: Find out Clip Actions Data Format
class FlashTagPlaceObject2 : public FlashSpriteEnabled
{
DEFINE_RW_INTERFACE
protected:
	friend class FlashImporter;
public:
	FlashTagPlaceObject2(UWORD _depth) : hasName(false), hasCharID(false), hasMove(false), hasMatrix(false), hasColorTransform(false), hasRatio(false), hasClipDepth(false), depth(_depth){}
	FlashTagPlaceObject2(UWORD _depth, UWORD _charID) : hasName(false), hasCharID(true), hasMove(false), hasMatrix(false), hasColorTransform(false), hasRatio(false), hasClipDepth(false), depth(_depth), charID(_charID)
	{
	}
	FlashTagPlaceObject2(UWORD _depth, UWORD _charID, FlashMatrix& _matrix) : hasName(false), hasCharID(true), hasMove(false), hasMatrix(true), hasColorTransform(false), hasRatio(false), hasClipDepth(false), depth(_depth)
	{
		charID = _charID;
		matrix = _matrix;
	}
	FlashTagPlaceObject2(UWORD _depth, UWORD _charID, FlashMatrix& _matrix, FlashColorTransform& _cfx) : hasName(false), hasCharID(true), hasMove(false), hasMatrix(true), hasColorTransform(true), hasRatio(false), hasClipDepth(false), depth(_depth)
	{
		charID = _charID;
		matrix = _matrix;
		cfx = _cfx;
	}
	FlashTagPlaceObject2(UWORD _depth, FlashMatrix& _matrix, FlashColorTransform& _cfx) : hasName(false), hasCharID(false), hasMove(false), hasMatrix(true), hasColorTransform(true), hasRatio(false), hasClipDepth(false), depth(_depth)
	{	
		matrix = _matrix;
		cfx = _cfx;
	}
	~FlashTagPlaceObject2(){}
	
	void SetName(std::string& _name)
	{
		hasName = true;
		name = _name;
	}

	void SetCharID(UWORD _charID)
	{
		hasCharID = true;
		charID = _charID;
	}

	void SetMove(bool _move)
	{
		hasMove = _move;
	}

	void SetMatrix(FlashMatrix& _matrix)
	{
		hasMatrix = true;
		matrix = _matrix;
	}

	void SetColorTransform(FlashColorTransform& _cfx)
	{
		hasColorTransform = true;
		cfx = _cfx;
	}

	void SetRatio(UWORD _ratio) 
	{ 
		hasRatio = true;
		ratio=_ratio; 
	}

	void SetClipDepth(UWORD _clipDepth) 
	{
		hasClipDepth = true;
		clipDepth = _clipDepth;
	}

	bool HasName() { return hasName; }
	bool HasCharID() { return hasCharID; }
	bool HasMove() { return hasMove; }
	bool HasMatrix() { return hasMatrix; }
	bool HasColorTransform() { return hasColorTransform; }
	bool HasRatio() { return hasRatio; }
	bool HasClipDepth() { return hasClipDepth; }

	UWORD GetDepth()  { return depth; }
	const char* GetName() { return name.c_str(); }
	UWORD GetCharID() { return charID; }	
	FlashMatrix GetMatrix() { return matrix; } 
	FlashColorTransform GetColorTransform() { return cfx; }
	UWORD GetRatio() { return ((UWORD)ratio); }
	UWORD GetClipDepth(){ return clipDepth; }
	

private:

	friend std::ostream& operator<<(std::ostream& out, FlashTagPlaceObject2 &data);
	friend std::istream& operator>>(std::istream& in, FlashTagPlaceObject2 &data);
	
	FlashTagPlaceObject2(){}

	bool hasName;
	bool hasCharID;
	bool hasMove;
	bool hasMatrix;
	bool hasColorTransform;
	bool hasRatio;
	bool hasClipDepth;
	
	UWORD depth;
	std::string name;
	UWORD charID;
	FlashMatrix matrix;
	FlashColorTransform cfx;	
	UWORD ratio;
	UWORD clipDepth;
};

class FlashTagRemoveObject : public FlashSpriteEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashTagRemoveObject(UWORD _charID, UWORD _depth) : charID(_charID), depth(_depth){};
	~FlashTagRemoveObject() {}

	UWORD GetCharID() { return charID; }
	UWORD GetDepth()  { return depth; }

protected:
	friend class FlashImporter;
	FlashTagRemoveObject() {}
private:
	friend std::ostream& operator<<(std::ostream& out, FlashTagRemoveObject &data);
	friend std::istream& operator>>(std::istream& in, FlashTagRemoveObject &data);

	UWORD charID;
	UWORD depth;
};
class FlashTagRemoveObject2 : public FlashSpriteEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashTagRemoveObject2(UWORD _depth) : depth(_depth){};
	~FlashTagRemoveObject2() {}

	UWORD GetDepth()  { return depth; }

protected:
	friend class FlashImporter;
	FlashTagRemoveObject2() {}
private:
	friend std::ostream& operator<<(std::ostream& out, FlashTagRemoveObject2 &data);
	friend std::istream& operator>>(std::istream& in, FlashTagRemoveObject2 &data);

	UWORD depth;
};
DECLARE_SIMPLE_TAG3(FlashTagShowFrame)
#endif 
