#include "FBase.h"
#include "FDisplay.h"
#include <iostream>
#include <strstream>


FlashTagPlaceObject::FlashTagPlaceObject(UWORD _charID,UWORD _depth, FlashMatrix &m)
: characterID(_charID), depth(_depth), matrix(m), hascfx(false)
{
}

FlashTagPlaceObject::FlashTagPlaceObject(UWORD _charID,UWORD _depth, FlashMatrix &m, FlashColorTransform &c)
: characterID(_charID), depth(_depth), matrix(m), hascfx(true)
{
  cfx = c;
}

std::ostream& operator<<(std::ostream& out, FlashTagPlaceObject &data)
{
	std::ostrstream s;
	s.write((const char*)&data.characterID,2);
	s.write((const char*)&data.depth,2);
	s << data.matrix;
	if(data.hascfx) { s << data.cfx; }
	
	out << FlashTagHeader(4, s.pcount());
	out.write(s.rdbuf()->str(), s.pcount());
	return out;
}
std::istream& operator>>(std::istream& in, FlashTagPlaceObject &data)
{
	std::streampos start = in.tellg();
	in.read((char*)&data.characterID,2);
	in.read((char*)&data.depth,2);
	in >> data.matrix;
	
	if(data.importsize + start != (UDWORD)in.tellg())
	{
		data.hascfx = true;
		in >> data.cfx;
	}
	return in;
}

std::ostream& operator<<(std::ostream& out, FlashTagRemoveObject &data)
{
	out << FlashTagHeader(5,4);
	WRITE_UWORD(data.charID);
	WRITE_UWORD(data.depth);
	return out;
}

std::istream& operator>>(std::istream& in, FlashTagRemoveObject &data)
{
	READ_UWORD(data.charID);
	READ_UWORD(data.depth);
	return in;
}
std::ostream& operator<<(std::ostream& out, FlashTagPlaceObject2 &data)
{
	std::strstream o;
	BitBuffer b;
	b.Write(0,1); // CLIP ACTIONS
	b.Write(data.hasClipDepth,1); 
	b.Write(data.hasName,1);
	b.Write(data.hasRatio,1);
	b.Write(data.hasColorTransform,1);
	b.Write(data.hasMatrix,1);
	b.Write(data.hasCharID,1);
	b.Write(data.hasMove,1);
	if(data.hasColorTransform) data.cfx.SetTagVersion(2);
	o << b;
	o.write((char*)&data.depth,2);
	if(data.hasCharID) o.write((char*)&data.charID,2);
	if(data.hasMatrix) o << data.matrix;
	if(data.hasColorTransform) o << data.cfx;
	if(data.hasRatio) o.write((char*)&data.ratio,2);
	if(data.hasName) { o.write(data.name.c_str(),data.name.size()); o << (char)0; }
	if(data.hasClipDepth) o.write((char*)&data.clipDepth,2);

	out << FlashTagHeader(26,o.rdbuf()->pcount());
	out.write((char*)o.rdbuf()->str(),o.rdbuf()->pcount());
	
	return out;
}
std::istream& operator>>(std::istream& in, FlashTagPlaceObject2 &data)
{
	BitStreamIn b(&in);
	unsigned char hasclipdepth;
	b.Read(hasclipdepth,1); // CLIP ACTIONS
	unsigned char tmp;
	b.Read(tmp,1); // RESERVED FOR FUTURE USE
	unsigned  hasname;
	b.Read(hasname,1);
	unsigned char hasratio;
	b.Read(hasratio,1);
	unsigned char hascfx;
	b.Read(hascfx,1);
	unsigned char hasmatrix;
	b.Read(hasmatrix,1);
	unsigned char hasid;
	b.Read(hasid,1);
	unsigned char move;
	b.Read(move,1);

	data.hasName = (hasname == 1);
	data.hasCharID = (hasid == 1);
	data.hasMove = (move == 1);
	data.hasMatrix = (hasmatrix == 1);
	data.hasColorTransform = (hascfx == 1);
	data.hasRatio = (hasratio == 1);
	data.hasClipDepth = (hasclipdepth == 1);
	
	b.Align();

	in.read((char*)&data.depth,2);
	if(hasid)
	{
		in.read((char*)&data.charID,2);
	}
	if(hasmatrix)
	{
		in >> data.matrix;
	}
	if(hascfx)
	{
		data.cfx.SetTagVersion(2);
		in >> data.cfx;
	}
	if(hasratio)
	{
		in.read((char*)&data.ratio,2);
	}
	if(hasname) 
	{ 
		unsigned int i;
		while((i = in.get()) != 0)
		{
			data.name+=(char)i;
		}				
	}
	return in;
}


std::ostream& operator<<(std::ostream& out, FlashTagRemoveObject2 &data)
{
	out << FlashTagHeader(28,2);
	WRITE_UWORD(data.depth);
	return out;
}
std::istream& operator>>(std::istream& in, FlashTagRemoveObject2 &data)
{
	READ_UWORD(data.depth);
	return in;
}
DEFINE_SIMPLE_TAG(FlashTagShowFrame,0x01)
