#ifndef FCONTROL_H_FILE
#define FCONTROL_H_FILE

#include "FBase.h"
#include "./md5/md5.h"
#include <vector>
#include <string>


class FlashImportHandler;

class FlashTagDefineBitsPtr : public FlashTag
{
DEFINE_RW_INTERFACE
public:
	FlashTagDefineBitsPtr(UDWORD ptr) : ref(ptr){}
	UDWORD GetPtr() { return ref; }
	void SetPtr(UDWORD ptr) { ref = ptr; }

private:
	friend class FlashImportHandler;
	FlashTagDefineBitsPtr(){};
	UDWORD ref;
	friend std::ostream &operator << (std::ostream &out, FlashTagDefineBitsPtr &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagDefineBitsPtr &data);
};

class FlashTagProtect : public FlashTag
{
DEFINE_RW_INTERFACE
public:	
	friend class FlashImportHandler;
	FlashTagProtect() : hasPass(false){}
	FlashTagProtect(std::string& password) : hasPass(false)
	{
		hasPass = true;		
		md5Pass = crypt_md5(password.c_str(), "Aa");
	}
	
	std::string GetEncryptedPassword(){return md5Pass;}
	
	void SetEncryptedPassword(std::string& encPassword){
		hasPass = true;
		md5Pass = encPassword;
	}
	void SetPassword(std::string& password)
	{		
		hasPass = true;				
		md5Pass = crypt_md5(password.c_str(), "Aa");;
	}
	bool HasPassword() { return hasPass; }
private:
	bool hasPass;
	std::string md5Pass;

	friend class FlashImporter;	
	
	friend std::ostream &operator << (std::ostream &out, FlashTagProtect &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagProtect &data);
};

class FlashTagEnableDebugger : public FlashTag
{
DEFINE_RW_INTERFACE
public:	
	friend class FlashImportHandler;
	FlashTagEnableDebugger() : hasPass(false){}
	FlashTagEnableDebugger(std::string& password) : hasPass(false)
	{
		hasPass = true;		
		md5Pass = crypt_md5(password.c_str(), "Aa");
	}
	
	std::string GetEncryptedPassword(){return md5Pass;}
	
	void SetEncryptedPassword(std::string& encPassword){
		hasPass = true;
		md5Pass = encPassword;
	}
	void SetPassword(std::string& password)
	{		
		hasPass = true;				
		md5Pass = crypt_md5(password.c_str(), "Aa");;
	}
	bool HasPassword() { return hasPass; }
private:
	bool hasPass;
	

	std::string md5Pass;
	
	friend class FlashImporter;	
	
	friend std::ostream &operator << (std::ostream &out, FlashTagEnableDebugger &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagEnableDebugger &data);
};

class FlashTagBackgroundColor : public FlashTag
{
DEFINE_RW_INTERFACE
public:	
	friend class FlashImportHandler;
	FlashTagBackgroundColor(UBYTE _r, UBYTE _g, UBYTE _b) : r(_r), g(_g), b(_b) {}
	FlashTagBackgroundColor(FlashRGB &c) { r = (UBYTE)c.GetR(); g= (UBYTE)c.GetG(); b = (UBYTE)c.GetB(); }
	~FlashTagBackgroundColor() {}

	FlashRGB GetRGB() { return FlashRGB(r,g,b); }
	
	UBYTE r;
	UBYTE g;
	UBYTE b;
private:
	friend class FlashImporter;
	FlashTagBackgroundColor() {}

	friend std::ostream &operator << (std::ostream &out, FlashTagBackgroundColor &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagBackgroundColor &data);
};

class FlashTagLabelFrame : public FlashSpriteEnabled
{
DEFINE_RW_INTERFACE
public:
	friend class FlashImportHandler;
	FlashTagLabelFrame(char *_str) : str(_str) {}
	~FlashTagLabelFrame() { free(str); }

	const char *GetLabel() { return str; }
private:
	FlashTagLabelFrame() {}
	friend class FlashImporter;

	friend std::ostream &operator << (std::ostream &out, FlashTagLabelFrame &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagLabelFrame &data);
	
	char *str;

	gc_vector<char *> gc;
};

DECLARE_SIMPLE_TAG2(FlashTagEnd)

class FlashTagExportAssets : public FlashTag
{
DEFINE_RW_INTERFACE
public:
	friend class FlashImportHandler;
	FlashTagExportAssets() {}
	~FlashTagExportAssets() {}

	void AddAsset(char *str, UWORD id);

	unsigned int GetAssetNum() { return assets_str.size(); }
	flash_pair<char*, UWORD> GetAsset(long num) { return(flash_pair<char*,UWORD>(assets_str[num],assets_id[num])); }
private:
	friend class FlashImporter;
private:
	friend std::ostream &operator << (std::ostream &out, FlashTagExportAssets &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagExportAssets &data);

	std::vector <char*> assets_str;
	std::vector <UWORD> assets_id;
	gc_vector<char *> gc;
};
class FlashTagImportAssets : public FlashTag
{
DEFINE_RW_INTERFACE
FlashTagImportAssets() {}
public:
	friend class FlashImportHandler;
	FlashTagImportAssets(char *_swfurl) : swfurl(_swfurl) {}
	~FlashTagImportAssets() { }

	void AddAsset(char *str, UWORD id);

	const char *GetSwfUrl() { return swfurl; }
	unsigned int GetAssetNum() { return assets_str.size(); }
	flash_pair<char*, UWORD> GetAsset(long num) { return(flash_pair<char*,UWORD>(assets_str[num],assets_id[num])); }
private:
	friend class FlashImporter;


private:
	friend std::ostream &operator << (std::ostream &out, FlashTagImportAssets &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagImportAssets &data);

	char *swfurl;
	std::vector <char*> assets_str;
	std::vector <UWORD> assets_id;
    gc_vector<char *> gc;
};


class FlashTagFreeCharacter : public FlashTag
{
DEFINE_RW_INTERFACE
FlashTagFreeCharacter() {}
public:
	FlashTagFreeCharacter(UWORD _id) { _id = id; }
	UWORD GetID(void) const { return id; }
private:
	friend class FlashImporter;
	friend std::ostream &operator << (std::ostream &out, FlashTagFreeCharacter &data);
	friend std::istream &operator >> (std::istream &in,  FlashTagFreeCharacter &data);

	UWORD id;
};

#endif
