#ifndef FBUTTON_H_FILE
#define FBUTTON_H_FILE


#include <vector>

#include "FBase.h"
#include "FShape.h"
#include "FAction.h"

#define FBR_HIT_TEST (1<<3)
#define FBR_DOWN     (1<<2)
#define FBR_OVER     (1<<1)
#define FBR_UP       (1)


class FlashTagDefineButton;
class FlashTagDefineButton2;

class FlashButtonRecord : public FlashVersionEnabled
{
DEFINE_RW_INTERFACE
public:
	FlashButtonRecord(UWORD _charID, UWORD _depth, char _validstates, FlashMatrix &_matrix,
		FlashColorTransform &_cfx);
	
    friend std::ostream &operator<< (std::ostream &out, FlashButtonRecord &data);
	friend std::istream &operator>> (std::istream &in,  FlashButtonRecord &data);

private:
	FlashButtonRecord()  {}	
	
	friend std::istream &operator>> (std::istream &in,  FlashTagDefineButton &data);
	friend std::istream &operator>> (std::istream &in,  FlashTagDefineButton2 &data);

	UWORD charID;
	UWORD depth;
	char validstates;
	FlashMatrix matrix;
	FlashColorTransform cfx;
};

class FlashTagDefineButton : public FlashTag, public FlashIDEnabled
{
DEFINE_RW_INTERFACE
public:
    FlashTagDefineButton() {}
	~FlashTagDefineButton() { }
	
	void AddButtonRecord(FlashButtonRecord *r);
	void AddActionRecord(FlashActionRecord *r);
private:
    friend std::ostream &operator<< (std::ostream &out, FlashTagDefineButton &data);
	friend std::istream &operator>> (std::istream &in,  FlashTagDefineButton &data);

	std::vector<FlashButtonRecord*> buttonrecords;
	std::vector<FlashActionRecord*> actionrecords;

	gc_vector<FlashButtonRecord*> gcbuttonrecords;
	gc_vector<FlashActionRecord*> gcactionrecords;


};

class FlashTagDefineButton2 : public FlashTag, public FlashIDEnabled
{	
DEFINE_RW_INTERFACE
public:
	FlashTagDefineButton2(bool _menu) : menu(_menu) {}
	~FlashTagDefineButton2();
	void AddButtonRecord(FlashButtonRecord *r);
	void AddActionRecords(std::vector<FlashActionRecord *> &r, UWORD conditionflags);	
private:
    friend std::ostream &operator<< (std::ostream &out, FlashTagDefineButton2 &data);
	friend std::istream &operator>> (std::istream &in,  FlashTagDefineButton2 &data);

	bool menu;
	std::vector<FlashButtonRecord *> buttonrecords;
	
	std::vector<flash_pair<std::vector<FlashActionRecord*>, UWORD> > actionrecords;

	gc_vector<FlashButtonRecord*> gcbuttonrecords;
	gc_vector<FlashActionRecord*> gcactionrecords;

};
#endif
