#include <strstream>
#include "FButton.h"

FlashButtonRecord::FlashButtonRecord(UWORD _charID, UWORD _depth, char _validstates, 
									 FlashMatrix &_matrix, FlashColorTransform &_cfx) :
									 charID(_charID), depth(_depth), validstates(_validstates),
										 matrix(_matrix), cfx(_cfx)
{

}

std::ostream &operator<< (std::ostream &out, FlashButtonRecord &data)
{
	out.put(data.validstates);
	WRITE_UWORD(data.charID);
	WRITE_UWORD(data.depth);
	out << data.matrix;
	if(data.GetTagVersion() > 1) out << data.cfx;
	data.cfx.SetTagVersion(data.GetTagVersion());
	return out;
}
std::istream &operator>> (std::istream &in,  FlashButtonRecord &data)
{
	data.validstates = in.get();
	READ_UWORD(data.charID);
	READ_UWORD(data.depth);
	in >> data.matrix;
	data.cfx.SetTagVersion(data.GetTagVersion());
	if(data.GetTagVersion() > 1) in >> data.cfx;
	return in;
}

void FlashTagDefineButton::AddButtonRecord(FlashButtonRecord *r)
{
	buttonrecords.push_back(r);
}
void FlashTagDefineButton::AddActionRecord(FlashActionRecord *r)
{
	actionrecords.push_back(r);
}

std::ostream &operator<< (std::ostream &out, FlashTagDefineButton &data)
{
	
	std::ostrstream tmp;
	
	for(std::vector<FlashButtonRecord*>::iterator ib=data.buttonrecords.begin();
		ib != data.buttonrecords.end(); ib++)
		{
			(*ib)->SetTagVersion(0);
			tmp << *(*ib);
		}
		tmp.put( (char) 0);
	
	for(std::vector<FlashActionRecord*>::iterator ir=data.actionrecords.begin();
		ir != data.actionrecords.end(); ir++)
		{
			(*ir)->Write(tmp);
		}
		tmp.put( (char) 0);
	
		
	out << FlashTagHeader(7,tmp.pcount()+2);
	WRITE_UWORD(data.GetID());
	
	out.write(tmp.rdbuf()->str(), tmp.pcount());
	
	return out;
}

std::istream &operator>> (std::istream &in,  FlashTagDefineButton &data)
{
	
	UWORD d;
	READ_UWORD(d);
	data.SetID(d);
	
	int i;
	int count = 0;
	for(i = in.get(); i != 0; i=in.get())
	{
		in.putback(i);
		data.buttonrecords.push_back(new FlashButtonRecord());
		data.gcbuttonrecords.push_back(data.buttonrecords[count]);
		data.buttonrecords[i]->SetTagVersion(0);
		in >> *data.buttonrecords[i];
		count ++;
	}
	count = 0;

	FlashActionVectorImporter import;
	import.Import(in, data.actionrecords, data.gcactionrecords);
	
	return in;
}

FlashTagDefineButton2::~FlashTagDefineButton2() 
{ 	
}
void FlashTagDefineButton2::AddButtonRecord(FlashButtonRecord *r)
{
	buttonrecords.push_back(r);
}
void FlashTagDefineButton2::AddActionRecords(std::vector<FlashActionRecord *> &r, UWORD conditionflags)
{
	actionrecords.push_back(flash_pair<std::vector<FlashActionRecord *>, UWORD>(r,conditionflags));
}
std::ostream &operator<< (std::ostream &out, FlashTagDefineButton2 &data)
{
	std::ostrstream tmp;
	for(std::vector<FlashButtonRecord*>::iterator ib=data.buttonrecords.begin();
		ib != data.buttonrecords.end(); ib++)
		{
			(*ib)->SetTagVersion(2);
			tmp << *(*ib);
		}
		tmp.put((char)0);
	
	UWORD offset = tmp.pcount();
		
	for(std::vector<flash_pair<std::vector<FlashActionRecord *>,UWORD> >::iterator ir
			= data.actionrecords.begin();
		ir != data.actionrecords.end(); ir++)
		{
			std::ostrstream tmp2;
			WRITE_UWORD2((*ir).second,tmp2);
			
			for(std::vector<FlashActionRecord *>::iterator i = (*ir).first.begin(); 
				i != (*ir).first.end();
				i++)
				{
					(*i)->Write(tmp2);			
				}
			tmp2.put((char)0);

			std::vector<flash_pair<std::vector<FlashActionRecord *>,UWORD> >::iterator irt = ir;
			irt++;
			if(irt != (data.actionrecords.end()))
			{
				WRITE_UWORD2(tmp2.pcount(), tmp);
			}
			else 
			{
				WRITE_UWORD2(0, tmp);
			}
			tmp.write(tmp2.rdbuf()->str(), tmp2.pcount());
		}		
	out << FlashTagHeader(34,tmp.pcount()+5);	
	WRITE_UWORD(data.GetID());
	out.put((char)data.menu);
	WRITE_UWORD(offset+2);
	out.write(tmp.rdbuf()->str(), tmp.pcount());
	return out;
}

std::istream &operator>> (std::istream &in,  FlashTagDefineButton2 &data)
{
	std::ostrstream tmp;
		
	UWORD d;
	READ_UWORD(d);
	data.SetID(d);
	data.menu = (in.get()==1);
	int i;
	int count = 0;
	for(i = in.get(); i != 0; i=in.get())
	{
		in.putback(i);
		data.buttonrecords.push_back(new FlashButtonRecord());
		data.gcbuttonrecords.push_back(data.buttonrecords[count]);
		data.buttonrecords[count]->SetTagVersion(2);
		in >> *data.buttonrecords[count];
		count ++;
	}

	
	int count2 = 0;
	do
	{
		READ_UWORD(d);
		UWORD d2;
		READ_UWORD(d2);
		
		std::vector<FlashActionRecord *> x;
		flash_pair<std::vector<FlashActionRecord *>,UWORD> tmp(x,d2);
		data.actionrecords.push_back(tmp);
		
		FlashActionVectorImporter import;
		import.Import(in, data.actionrecords[count2].first, data.gcactionrecords);
		
		count2++;

	} while (d != 0);

	return in;
}
