/**********************************************/
/* fftpak.h                                   */
/* Copyright (C) 1995 Precision Plus Software */
/* All rights reserved.                       */
/**********************************************/

#define twopi 6.283185307179586

/* uncomment the line below for IBM CSet++ */
/*
#define pascal _Pascal
*/

struct LONGCOMPLEX {
  double r;
  double i;
  };

struct COMPLEX {
  float r;
  float i;
  };

void pascal fft2( struct LONGCOMPLEX *x );
void pascal fft4( struct LONGCOMPLEX *x );
void pascal fft8( struct LONGCOMPLEX *x );
void pascal fft16( struct LONGCOMPLEX *x );
void pascal fft32( struct LONGCOMPLEX *x );
void pascal fft64( struct LONGCOMPLEX *x );
void pascal fft128( struct LONGCOMPLEX *x );
void pascal fft256( struct LONGCOMPLEX *x );
void pascal fft512( struct LONGCOMPLEX *x );
void pascal fft1024( struct LONGCOMPLEX *x );
void pascal fft( struct LONGCOMPLEX *x, int m );

void pascal fftinv2( struct LONGCOMPLEX *x );
void pascal fftinv4( struct LONGCOMPLEX *x );
void pascal fftinv8( struct LONGCOMPLEX *x );
void pascal fftinv16( struct LONGCOMPLEX *x );
void pascal fftinv32( struct LONGCOMPLEX *x );
void pascal fftinv64( struct LONGCOMPLEX *x );
void pascal fftinv128( struct LONGCOMPLEX *x );
void pascal fftinv256( struct LONGCOMPLEX *x );
void pascal fftinv512( struct LONGCOMPLEX *x );
void pascal fftinv1024( struct LONGCOMPLEX *x );
void pascal fftinv( struct LONGCOMPLEX *x, int m );

void pascal fftsort( struct LONGCOMPLEX *x, int m );
void pascal scalecv( struct LONGCOMPLEX *x, int m, int N );
void pascal scalev( double *x, int m, int N );
void pascal conjcv( struct LONGCOMPLEX *x, int N );

void pascal fft2_s( struct COMPLEX *x );
void pascal fft4_s( struct COMPLEX *x );
void pascal fft8_s( struct COMPLEX *x );
void pascal fft16_s( struct COMPLEX *x );
void pascal fft32_s( struct COMPLEX *x );
void pascal fft64_s( struct COMPLEX *x );
void pascal fft128_s( struct COMPLEX *x );
void pascal fft256_s( struct COMPLEX *x );
void pascal fft512_s( struct COMPLEX *x );
void pascal fft1024_s( struct COMPLEX *x );
void pascal fft_s( struct COMPLEX *x, int m );

void pascal fftinv2_s( struct COMPLEX *x );
void pascal fftinv4_s( struct COMPLEX *x );
void pascal fftinv8_s( struct COMPLEX *x );
void pascal fftinv16_s( struct COMPLEX *x );
void pascal fftinv32_s( struct COMPLEX *x );
void pascal fftinv64_s( struct COMPLEX *x );
void pascal fftinv128_s( struct COMPLEX *x );
void pascal fftinv256_s( struct COMPLEX *x );
void pascal fftinv512_s( struct COMPLEX *x );
void pascal fftinv1024_s( struct COMPLEX *x );
void pascal fftinv_s( struct COMPLEX *x, int m );

void pascal fftsort_s( struct COMPLEX *x, int m );
void pascal scalecv_s( struct COMPLEX *x, int m, int N );
void pascal scalev_s( float *x, int m, int N );
void pascal conjcv_s( struct COMPLEX *x, int N );

