/**********************************************************************/
/*                           IBM Internal Use Only                    */
/**********************************************************************/
/*                                                                    */
/*  SAMPLE                                                            */
/*                                                                    */
/* SAMPLE 32 bit program to access EXCEPTQ.DLL exception handler      */
/* SAMPLE generates a TRAP to demonstrate information gathering       */
/* C-SET/2 compiler complies that code                                */
/**********************************************************************/
/* Version: 2.2             |   Marc Fiammante (FIAMMANT at LGEVM2)   */
/*                          |   La Gaude FRANCE                       */
/**********************************************************************/
/*                                                                    */
/**********************************************************************/
/* History:                                                           */
/* --------                                                           */
/*                                                                    */
/* created: Marc Fiammante December 1992                              */
/**********************************************************************/

/* Following line to tell C-Set compiler to install an exception handler */
/* for main                                                              */
#pragma handler(main)
/* Following line to tell C-Set compiler to use MYHANDLER instead of     */
/* default _Exception handler                                            */
#pragma map (_Exception,"MYHANDLER")

#include <stdio.h>
#include <stdlib.h>

void TrapFunc(void);

typedef unsigned char BYTE;
typedef unsigned short USHORT;


struct some_struct {
   BYTE   bByte;
   USHORT uUshort;
   char   *pTest;
};

void main(void)
{
    struct some_struct TestStruct;
    USHORT test = 4567;
    USHORT *pUshort;
    struct some_struct *pTestStruct;

    printf("Exception handler has been set by compiler\n");
    printf("Generating the TRAP from function\n");

    TestStruct.bByte = 123;
    TestStruct.uUshort = 1234;
    TestStruct.pTest = (void *)0;

    TrapFunc();
}

void TrapFunc() {
    BYTE * Test;
    char * Test1 = "1234";

    Test=0;
    *Test=0;
}
