#define INCL_DOSEXCEPTIONS
#define INCL_DOSFILEMGR
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

/****************************************************************************/
/* This is a simple example on how to register and use an OS/2 exception    */
/* handler.  The main routine registers the handler and forces a protection */
/* exception by attempting to store at address 0.                           */
/*                                                                          */
/* The exception handler gets control and checks for an addressing          */
/* exception.  This is important because the exception handler will also get*/
/* control for other exceptions, i.e. when a page needs to be swapped in    */
/* from the swap file.  If another exception has been found, the exception  */
/* handler returns with XCPT_CONTINUE_SEARCH, which tells OS/2 to pass the  */
/* exception on to the next handler in the list.
/*                                                                          */
/* The exception handler opens a log file.  If this fails, the file pointer */
/* is redirected to stderr.  The registers are then written to the log file */
/* and the process is terminated with DosExit.                              */
/*                                                                          */
/* This is not meant to be production level code, but since several people  */
/* have asked for a simple example. I came up with this.                    */
/*                                                                          */
/* Jerry Stuckle, JDS & Associates [70363,407]                              */
/*                                                                          */
/****************************************************************************/







ULONG _System ExceptionHandler (PEXCEPTIONREPORTRECORD pERepRec,
                      PEXCEPTIONREGISTRATIONRECORD pERegRec,
                      PCONTEXTRECORD pCtxRec,
                      PVOID p);
int main(void);

int main(void)
{
   EXCEPTIONREGISTRATIONRECORD er = { NULL, ExceptionHandler }; /* To register the handler */
   PCHAR pc = NULL;                                   /* Used to create an addressing exception */
   
   DosSetExceptionHandler (&er);                      /* Add our routine to the chain */
   *pc = '\0';                                        /* This should cause an error */
   return 0;
}

ULONG _System ExceptionHandler (PEXCEPTIONREPORTRECORD pERepRec, /* Main exception handler */
                      PEXCEPTIONREGISTRATIONRECORD pERegRec,
                      PCONTEXTRECORD pCtxRec, PVOID p)
{
   FILE * fp;

   if (pERepRec->ExceptionNum == XCPT_ACCESS_VIOLATION)     /* If this is the exception we want */
   {
      if ((fp = fopen ("except.log", "a+")) == 0)           /* Open the log file                */
      {
         fprintf (stderr, "Return code %ud from fopen for log file\n", errno);
         fp = stderr;                                       /* On error, reset log to stderr */
      }

/* The following fprintf statements log the error message to the file */
      fprintf (fp, "Access violation occurred at location 0X%8.8X\r\nRegisters in hex:\n",
               pERepRec -> ExceptionAddress);
      fprintf (fp, "EAX = %8.8X, EBX = %8.8X, ECX = %8.8X, EDX = %8.8X\r\n",
               pCtxRec->ctx_RegEax, pCtxRec->ctx_RegEbx,
               pCtxRec->ctx_RegEcx, pCtxRec->ctx_RegEdx);
      fprintf (fp, "ESI = %8.8X, EDI = %8.8X\n\n",
               pCtxRec->ctx_RegEsi, pCtxRec->ctx_RegEdi);
      if (pCtxRec->ContextFlags & CONTEXT_CONTROL)             /* If control registers are listed */
      {
         fprintf (fp, "Current instruction pointer:\nCS = %8.8X, EIP = %8.8X Flags = %8.8X\r\n\n",
                  pCtxRec->ctx_SegCs, pCtxRec->ctx_RegEip, pCtxRec->ctx_EFlags);
         fprintf (fp, "Current stack: SS = %8.8X, ESP = %8.8X, EBP = %8.8X\r\n",
                  pCtxRec->ctx_SegSs, pCtxRec->ctx_RegEsp, pCtxRec->ctx_RegEbp);
      }
      else
         fprintf (fp, "Control registers not available\n\n");
      if (pCtxRec->ContextFlags & CONTEXT_SEGMENTS)            /* If segment registers are listed */
         fprintf (fp, "DS = %8.8X, ES = %8.8X, FS = %8.8X, GS = %8.8X\r\n\n\n",
                  pCtxRec->ctx_SegDs, pCtxRec->ctx_SegEs,
                  pCtxRec->ctx_SegFs, pCtxRec->ctx_SegGs);
      else
         fprintf (fp, "Segment registers not available\n\n\n");
         
      if (fp != stdout)                      /* If pointing to stdout         */
         fclose (fp);                        /* Otherwise close the log file  */
      DosExit (EXIT_PROCESS, (ULONG) -1);    /* Terminate the process         */
   }
   return XCPT_CONTINUE_SEARCH;
}
