#include "Xlib.h"
#include "Xlib_private.h" 

/*

Copyright 1986, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/


Status XGetTextProperty (Display *display, Window window, XTextProperty *tp, Atom property)
{
    Atom actual_type;
    int actual_format = 0;
    unsigned long nitems = 0L, leftover = 0L;
    unsigned char *prop = NULL;

    DBUG_ENTER("XGetTextProperty")

    if (XGetWindowProperty (display, window, property, 0L, 1000000L, False,
			    AnyPropertyType, &actual_type, &actual_format,
			    &nitems, &leftover, &prop) == Success &&
	actual_type != None) {
	/* okay, fill it in */
	tp->value = prop;
	tp->encoding = actual_type;
	tp->format = actual_format;
	tp->nitems = nitems;
	DBUG_RETURN(True);
    }

    tp->value = NULL;
    tp->encoding = None;
    tp->format = 0;
    tp->nitems = 0;
    DBUG_RETURN(False);
}

Status XGetWMName(Display *display, Window w, XTextProperty *tp)
{
    DBUG_ENTER("XGetWMName")
    DBUG_RETURN(XGetTextProperty (display, w, tp, XA_WM_NAME));
}

Status XGetWMIconName(Display *display, Window w, XTextProperty *tp)
{
    DBUG_ENTER("XGetWMIconName")
    DBUG_RETURN(XGetTextProperty (display, w, tp, XA_WM_ICON_NAME));
}

Status XGetWMClientMachine(Display *display, Window w, XTextProperty *tp)
{
    DBUG_ENTER("XGetWMClientMachine")
    DBUG_RETURN(XGetTextProperty (display, w, tp, XA_WM_CLIENT_MACHINE));
}

