#include "Xlib.h"
#include "Xlib_private.h"
#include "GetReq.h"

/*

Copyright 1986, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/


/*
 * Arguments
 * 
 *  display  Specifies the connection to the X server. 
 *  cursor   Specifies the cursor. 
 * 
 * 
 * Description
 * 
 * The XFreeCursor() function deletes the association between the cursor resource ID and the specified cursor. The cursor storage is
 * freed when no other resource references it. The specified cursor ID should not be referred to again. 
 * 
 * XFreeCursor() can generate a BadCursor error. 
 * 
 * Diagnostics
 * 
 *  BadCursor   A value for a Cursor argument does not name a defined Cursor.
 */

int XFreeCursor(register Display *dpy, Cursor cursor)
{
    register xResourceReq *req;

    DBUG_ENTER("XFreeCursor");
    LockDisplay(dpy);
    GetResReq(FreeCursor, cursor, req);
    UnlockDisplay(dpy);
    SyncHandle();
    DBUG_RETURN(1);
}

