
#include "Xlib.h"
#define INCL_BASE
#define INCL_WIN
#define INCL_GPI
#define INCL_WINATOM
#include <os2.h>
#include "X11pmhk.h"
#include <process.h>

#include "x11pmvk.h"

#define CLIENTHWND(wnd) WinWindowFromID(FID_CLIENT, wnd)

static Xlib_Grab *Grab = NULL;
static Xlib_Grab GrabList[1024], *FreeList[1024];
static int LastGrab = 0, GrabAvail = 0;
static HMTX hkmutex = NULLHANDLE;

static char *AtomTbl[1024] = {"", NULL};
static char AtomBuf[65536], *AtomTail = AtomBuf;
static int LastAtom = 1;

#ifndef NO_RTE
int _CRT_init(void);
void _CRT_term(void);
void __ctordtorInit(void);
void __ctordtorTerm(void);
#endif

unsigned long _DLL_InitTerm(unsigned long mod_handle, unsigned long flag)
{
	APIRET rc;
	switch (flag) {
	case 0:
#ifndef NO_RTE
		if (_CRT_init() != 0) return 0;
		__ctordtorInit();
#endif
		if (hkmutex == NULLHANDLE)
			rc = DosCreateMutexSem(NULL, &hkmutex, DC_SEM_SHARED, FALSE);
		else
			rc = DosOpenMutexSem(NULL, &hkmutex);
		if (rc != NO_ERROR) return 0;
		return 1;
	case 1:
		rc = DosCloseMutexSem(hkmutex);
#ifndef NO_RTE
		__ctordtorTerm();
		_CRT_term();
#endif
		return 1;
	default:
		return 0;
	}
	return 1;
}

#ifdef NO_RTE
int getpid(void) {
	PPIB pib;
	DosGetInfoBlocks(NULL, &pib);
	return pib->pib_ulpid;
}
#endif

Xlib_Grab *Xlib_NewGrab(void)
{
	Xlib_Grab *newg;

	/* Add event to the bottom of the list */
	DosRequestMutexSem(hkmutex, SEM_INDEFINITE_WAIT);

	if (GrabAvail)
		newg = FreeList[--GrabAvail];
	else
		newg = &GrabList[LastGrab++];

        newg->special = 0;
	newg->pid = getpid();
	newg->next = NULL;

	if(Grab == NULL)
		Grab = newg;
	else
	{
		Xlib_Grab *tmp;

		tmp = Grab;
		while(tmp->next != NULL)
			tmp = tmp->next;
		tmp->next = newg;
	}
	DosReleaseMutexSem(hkmutex);
	return newg;
}

void Xlib_RemoveGrab(int type)
{
	Xlib_Grab *prev = NULL, *tmp;
	int pid = getpid();

	DosRequestMutexSem(hkmutex, SEM_INDEFINITE_WAIT);

	tmp = Grab;
	while(tmp != NULL)
	{
		if(tmp->pid == pid && (tmp->type == type || type == GrabAny))
		{
			if(prev) 
				prev->next = tmp->next;
			else
				Grab = tmp->next;
			tmp->pid = tmp->type = 0;
			FreeList[GrabAvail++] = tmp;
			DosReleaseMutexSem(hkmutex);
			return;
		}
		prev = tmp;
		tmp=tmp->next;
	}
	DosReleaseMutexSem(hkmutex);
}

void Xlib_RemoveGrabAny(int type)
{
	Xlib_Grab *prev = NULL, *tmp;
        int pid = getpid();
        HFILE hfile = 0L;
        ULONG action = 0L, wrote;

        DosRequestMutexSem(hkmutex, SEM_INDEFINITE_WAIT);
        tmp = Grab;
	while(tmp != NULL)
	{
		if(tmp->type == type || type == GrabAny)
                {
			if(prev) 
				prev->next = tmp->next;
			else
				Grab = tmp->next;
			tmp->pid = tmp->type = 0;
                        FreeList[GrabAvail++] = tmp;
                        if(prev)
                            tmp = prev;
                        else
                            tmp = Grab;
		}
                prev = tmp;
                if(tmp)
                    tmp=tmp->next;
        }
	DosReleaseMutexSem(hkmutex);
}

Xlib_Grab *__FindGrab(int pid, int type)
{
    Xlib_Grab *tmp;

    DosRequestMutexSem(hkmutex, SEM_INDEFINITE_WAIT);
    tmp = Grab;
    while(tmp != NULL)
    {
        if((!pid || tmp->pid == pid) && (tmp->type == type || type == GrabAny))
        {
	    DosReleaseMutexSem(hkmutex);
            return tmp;
        }
        
        tmp = tmp->next;
    }
    DosReleaseMutexSem(hkmutex);
    return NULL;
}

Xlib_Grab *Xlib_FindGrab(int type)
{
	return __FindGrab(getpid(), type);
}

BOOL EXPENTRY Xlib_InputQueueHook (HAB hab, PQMSG pQmsg, USHORT fs)

{
    Xlib_Grab *current;
    HWND client;

    if(!Grab)
        return FALSE;

    switch(pQmsg->msg)
    {
    case WM_CHAR:
        if ((current = __FindGrab(0,GrabKeyboard)) && 
		CLIENTHWND(pQmsg->hwnd) != (client = CLIENTHWND(current->window)))
        {
            if(current->special == SyncKeyboard)
            {
                current->special = 0;
                return FALSE;
            }
            WinPostMsg(client, pQmsg->msg, pQmsg->mp1, pQmsg->mp2);
            if(current->keyboard_mode == GrabModeAsync)
                return FALSE;
            else
                return TRUE;
        }
        if ((current = __FindGrab(0,GrabKey)) && 
		CLIENTHWND(pQmsg->hwnd) != (client = CLIENTHWND(current->window)))
        {
	    int keycode;
            /* TODO: Antony, there probably needs to be keycode
             translation done here, want to do it or should I
             try and figure it out? :) Brian */
	    /* RPLY: Brian, how's this code? %^) */
	    if (SHORT1FROMMP(pQmsg->mp1) & KC_CHAR)
		keycode = vk(SHORT1FROMMP(pQmsg->mp2), \
			SHORT1FROMMP(pQmsg->mp1)&~(KC_SCANCODE|KC_VIRTUALKEY)); else
	    if (SHORT1FROMMP(pQmsg->mp1) & KC_VIRTUALKEY)
		keycode = vk(SHORT2FROMMP(pQmsg->mp2), \
			SHORT1FROMMP(pQmsg->mp1)&~(KC_CHAR|KC_SCANCODE)); else
	    if (SHORT1FROMMP(pQmsg->mp1) & KC_SCANCODE)
		keycode = vk(CHAR4FROMMP(pQmsg->mp1), \
			SHORT1FROMMP(pQmsg->mp1)&~(KC_CHAR|KC_VIRTUALKEY)); 
	    else return TRUE;
            if (vkmatch(current->keycode, keycode))
            {
                WinPostMsg(client, pQmsg->msg, pQmsg->mp1, pQmsg->mp2);
                if(current->keyboard_mode == GrabModeAsync)
                    return FALSE;
                else
                    return TRUE;
            }
        }
        if((current = __FindGrab(0,GrabServer)) && 
		CLIENTHWND(pQmsg->hwnd) != (client = CLIENTHWND(current->window)))
        {
            WinPostMsg(client, pQmsg->msg, pQmsg->mp1, pQmsg->mp2);
            return TRUE;
        }
        break;
    case WM_BUTTON1UP:
    case WM_BUTTON2UP:
    case WM_BUTTON3UP:
    case WM_BUTTON1DOWN:
    case WM_BUTTON2DOWN:
    case WM_BUTTON3DOWN:
    case WM_MOUSEMOVE:
        if((current = __FindGrab(0,GrabPointer)) && 
		CLIENTHWND(pQmsg->hwnd) != (client = CLIENTHWND(current->window)))
        {
            if(current->special == SyncPointer)
            {
                current->special = 0;
                return FALSE;
            }
            WinPostMsg(client, pQmsg->msg, pQmsg->mp1, pQmsg->mp2);
            if(current->pointer_mode == GrabModeAsync)
                return FALSE;
            else
                return TRUE;
        }
        if((current = __FindGrab(0,GrabButton)) && 
		CLIENTHWND(pQmsg->hwnd) != (client = CLIENTHWND(current->window)))
        {
            if((current->button == 1 && (pQmsg->msg == WM_BUTTON1UP || pQmsg->msg == WM_BUTTON1DOWN)) ||
               (current->button == 2 && (pQmsg->msg == WM_BUTTON3UP || pQmsg->msg == WM_BUTTON3DOWN)) ||
               (current->button == 3 && (pQmsg->msg == WM_BUTTON2UP || pQmsg->msg == WM_BUTTON2DOWN)))
            {
                WinPostMsg(client, pQmsg->msg, pQmsg->mp1, pQmsg->mp2);
                if(current->pointer_mode == GrabModeAsync)
                    return FALSE;
                else
                    return TRUE;
            }
        }
        if((current = __FindGrab(0,GrabServer)) && 
		CLIENTHWND(pQmsg->hwnd) != (client = CLIENTHWND(current->window)))
        {
            WinPostMsg(client, pQmsg->msg, pQmsg->mp1, pQmsg->mp2);
            return TRUE;
        }
        break;
    }
        
    return FALSE;
}

Atom Xlib_XInternAtom(char* atom_name, Bool only_if_exists)
{
	char **tbl = AtomTbl;
	int i = 0;
	if (atom_name) {
		DosRequestMutexSem(hkmutex, SEM_INDEFINITE_WAIT);

		while (i<LastAtom) {
			if (!strcmp(*tbl, atom_name)) {
				DosReleaseMutexSem(hkmutex);
				return (Atom) i;
			}
			i++; tbl++;
		}
		if (!only_if_exists) {
			strcpy(AtomTbl[i = LastAtom++] = AtomTail, atom_name);
			AtomTail += strlen(atom_name)+1;
			DosReleaseMutexSem(hkmutex);
			return (Atom) i;
		}
		DosReleaseMutexSem(hkmutex);
	}
	return (Atom) 0;
}

char *Xlib_GetAtomName(Atom atom)
{
	if (atom > 0 && atom < LastAtom) {
		return AtomTbl[atom];
	} else 
		return NULL;
}

