#include <stdio.h>
#include "X.h"
#include "Xlib.h"
#include <X11/Xutil.h>

#define MAX_MAPPED_STRING_LENGTH 10

int main(void)
{
	Display *display;
	int screen;
	Window window;
	XSetWindowAttributes attributes;
	XEvent xevent;
	KeySym keysym;
	XComposeStatus compose;
	int exitprog = 0;
	GC gc;
	Visual *visual;
	int depth;
	Cursor cursor;
	Font font;

	display = XOpenDisplay("localhost");
	screen = DefaultScreen(display);
	visual = DefaultVisual(display, screen);
	depth = DefaultDepth(display, screen);

	attributes.background_pixel = WhitePixel(display, screen);

	if (!(font = XLoadFont(display, "fixed")))
	printf("Unable to load font!\n");

	window = XCreateWindow(display, DefaultRootWindow(display), 
		300, 300, 300, 300, 5, depth, InputOutput, 
		visual, CWBackPixel, &attributes);

	XSelectInput(display, window, -1);

	XMapWindow(display, window);

	gc = XCreateGC(display, window, 0, NULL);

	XSetForeground(display, gc, BlackPixel(display, screen));
	XSetBackground(display, gc, WhitePixel(display, screen));
	XSetLineAttributes(display, gc, 15, LineSolid, CapNotLast, JoinBevel);
	if (font) XSetFont(display, gc, font);

	cursor = XCreateFontCursor (display, 0);
	XDefineCursor(display, window, cursor);

	while (exitprog == 0) {
      XPeekEvent(display, &xevent);
      switch(xevent.type)
      {
      case CreateNotify:
         printf("Peeked CreateNotify event.\n");
         break;
      case DestroyNotify:
         printf("Peeked DestroyNotify event.\n");
         break;
      case FocusIn:
         printf("Peeked FocusIn event.\n");
         break;
      case FocusOut:
         printf("Peeked FocusOut event.\n");
         break;
      case EnterNotify:
         printf("Peeked EnterNotify event.\n");
         break;
      case LeaveNotify:
         printf("Peeked LeaveNotify event.\n");
         break;
      }
		XNextEvent(display, &xevent);
		if (xevent.type == Expose && xevent.xany.window == window) {
			char st[80];
			XClearWindow(display, xevent.xany.window);
			XDrawLine(display, xevent.xexpose.window, gc,
				xevent.xexpose.x, xevent.xexpose.x + xevent.xexpose.width,
				xevent.xexpose.y, xevent.xexpose.y + xevent.xexpose.height);
			XDrawLine(display, xevent.xexpose.window, gc,
				xevent.xexpose.x + xevent.xexpose.width, xevent.xexpose.x,
				xevent.xexpose.y, xevent.xexpose.y + xevent.xexpose.height);
			sprintf(st,"Expose (x=%d,y=%d,width=%d,height=%d)",
				xevent.xexpose.x, xevent.xexpose.y,
				xevent.xexpose.width, xevent.xexpose.height);
			XDrawString(display, xevent.xexpose.window, gc, 0, 20,
				st, strlen(st) );
		} else
		if (xevent.type == DestroyNotify) exitprog++;
		else
		if (xevent.type == KeyPress) {
			char buffer[MAX_MAPPED_STRING_LENGTH];
			int bufsize = MAX_MAPPED_STRING_LENGTH;
			int count = XLookupString(&xevent.xkey, buffer, bufsize, &keysym, &compose);
			buffer[count] = 0;
			if (count) 
				printf("Keypressed: '%s'  (keycode = 0x%x)\n",
					buffer, xevent.xkey.keycode);
			else {
				char *tmp = XKeysymToString(keysym);
				if (tmp) printf("Graykey: [%s] (keycode = 0x%x)\n", 
					tmp, xevent.xkey.keycode); 
				else printf("Unknown keycode! 0x%x\n", xevent.xkey.keycode);
			}
		}
	}

	XDestroyWindow(display, window);
	XCloseDisplay(display);

	return 0;
}
