##################################################################
#
# Xlib for Presentation Manager
#
##################################################################

CC=gcc
AS=as
MKLIB=ar r
MAKE=make
CP=cp
RM=rm -f
RC=rc

XDEFS=-DXLIB_ILLEGAL_ACCESS -DXKB
CDEFS=-DHAVE_SETSYSERRNO -DPTHREAD_RTL -DOS2I18N -DX_LOCALE
CFLAGS=-Zmt -O3 -mpentium -Wall $(CDEFS) $(XDEFS)
DLLFLAGS=-Zdll -Zcrtdll=pthrdrtl -Zbsd-signals $(CFLAGS) -s
EXEFLAGS=-Zexe -Zcrtdll=pthrdrtl -Zbsd-signals $(CFLAGS) -s

# Uncomment the following lines to build a debug version.
# Will require ICSDEBUG or SD386 to debug in OMF mode

CDEFS=-DHAVE_SETSYSERRNO -DPTHREAD_RTL -DDEBUG -DOS2I18N -DX_LOCALE
CFLAGS=-Zmt -O -g -Wall $(CDEFS) $(XDEFS)
DLLFLAGS=-Zdll -Zcrtdll=pthrdrtl -Zbsd-signals $(CFLAGS)
EXEFLAGS=-Zexe -Zcrtdll=pthrdrtl -Zbsd-signals $(CFLAGS)

##################################################################

HEADER=Xlib.h Xlib_private.h

LIB_RES=X11.res
LIB_DEF=X11.def
EXELIBS=-L. -lX11 -lbsd
EXESLIB=-L. -lX11_s -lbsd

HK_DLL=X11pmhk.dll
HK_DEF=X11pmhk.def

SLIB_OUT=X11_s.a

XLIB_SRC=\
	Xlib_OpenDisplay.c Xlib_CreateWindow.c Xlib_CreateGC.c \
	Xlib_pmctls.c Xlib_Protocol.c Xlib_NextEvent.c Xlib_Atom.c \
	Xlib_ResizeWindow.c Xlib_DrawLine.c Xlib_misc.c Xlib_simple.c \
	Xlib_Text.c Xlib_Free.c Xlib_evtomask.c Xlib_Keyboard.c \
	Xlib_TextExt.c Xlib_PropAlloc.c Xlib_DrawPoly.c Xlib_PutImage.c \
	Xlib_CrBFData.c Xlib_CrPFBData.c Xlib_WrBitF.c Xlib_RegstFlt.c \
	Xlib_Region.c Xlib_PolyReg.c Xlib_SetCRects.c Xlib_FilterEv.c \
	Xlib_CrPixmap.c Xlib_InitExt.c Xlib_Context.c Xlib_ErrHndlr.c \
	Xlib_GetGCVals.c Xlib_WMProps.c Xlib_WMGeom.c Xlib_SetTxtProp.c \
	Xlib_SetWMProto.c Xlib_SetHints.c Xlib_SetNrmHint.c Xlib_Cursor.c \
	Xlib_LookupCol.c Xlib_GetColor.c Xlib_Pointer.c Xlib_FontNames.c \
	Xlib_Property.c Xlib_StrToText.c Xlib_ImUtil.c Xlib_Grab.c \
	Xlib_GetImage.c Xlib_Geom.c Xlib_ParseGeom.c Xlib_GetHints.c \
	Xlib_Synchro.c Xlib_TextToStr.c Xlib_FontAlias.c Xlib_SetFont.c \
	Xlib_LoadFont.c Xlib_FSWrap.c Xlib_ReconfWin.c Xlib_QuColors.c \
	Xlib_QuColor.c Xlib_GetFProp.c Xlib_ChangeGC.c Xlib_ChWAttrs.c \
	Xlib_Depths.c Xlib_CopyArea.c Xlib_CopyPlane.c Xlib_CopyGC.c \
	Xlib_KeyBind.c Xlib_ModMap.c Xlib_QuExt.c Xlib_PMWM.c \
	Xlib_Border.c Xlib_BorderWidth.c Xlib_uconv.c Xlib_TrCoords.c \
	Xlib_Colormap.c Xlib_QuTree.c Xlib_VisUtil.c Xlib_GetWAttrs.c \
	Xlib_StBytes.c Xlib_RotProp.c Xlib_RdBitF.c Xlib_Focus.c \
	Xlib_PixFormats.c Xlib_ScrnSav.c Xlib_ListExt.c Xlib_QryBest.c \
	Xlib_ParseCol.c Xlib_StName.c Xlib_GCMisc.c Xlib_pmatms.c \
	Xlib_SetStip.c Xlib_GetWMCMapW.c Xlib_Geometry.c Xlib_mbWMProps.c \
        Xlib_imLcGIc.c Xlib_FetchName.c Xlib_GContextFromGC.c \
	Xlib_GetTextProperty.c Xlib_GetMotionEvents.c Xlib_GetIconName.c \
	Xlib_LockDisplay.c Xlib_RecolorCursor.c Xlib_FreeCursor.c \
	Xlib_FreeFontInfo.c Xlib_FreeFontPath.c Xlib_WarpPointer.c \
	Xlib_UninstallColormap.c \
	Xlib_Stubs.c

XRM_SRC=\
	Xrm_Core.c Xrm_Quarks.c Xrm_Defaults.c Xrm_ParseCmd.c

XLC_SRC=\
	Xlc_Init.c Xlc_Wrap.c Xlc_GenConv.c Xlc_DefConv.c Xlc_CT.c \
	Xlc_SetLocale.c Xlc_CharSet.c Xlc_Std.c Xlc_PubWrap.c \
	Xlc_Conv.c Xlc_Public.c Xlc_File.c Xlc_DB.c Xlc_Generic.c \
	Xlc_PrTxt.c Xlc_TxtPr.c Xlc_Util.c Xlc_RM.c Xlc_UTF.c \
	Xom_Default.c Xom_Generic.c Xom_ImText.c Xom_Text.c Xom_Wrap.c \
	Xom_TextEsc.c Xom_TextExt.c Xom_TextPer.c Xom_XChar.c \
	Xoc_Wrap.c Xic_Wrap.c Xmb_Wrap.c Xwc_Wrap.c \
	Xim_Wrap.c Xim_Core.c Xim_Conv.c Xim_ImSw.c Xim_TransR.c Xim_Rm.c \
	Xim_LcIm.c Xim_ThaiIm.c Xim_DefIm.c Xim_LcLkup.c Xim_LcPrs.c \
	Xim_LcIc.c Xim_LcFlt.c

XCMS_SRC=\
	Xcms_ColNm.c Xcms_QRed.c Xcms_QGreen.c Xcms_QBlue.c Xcms_Int.c \
	Xcms_Globals.c Xcms_LRGB.c Xcms_UNDEF.c Xcms_XYZ.c Xcms_uvY.c \
	Xcms_xyY.c Xcms_Lab.c Xcms_Luv.c Xcms_HVC.c Xcms_XRGB.c \
	Xcms_CvCols.c Xcms_Cmap.c Xcms_QuCols.c Xcms_SetGetCols.c \
	Xcms_CCC.c Xcms_SetCCC.c Xcms_Trig.c Xcms_Math.c

XKBD_SRC=\
	XKB.c XKBAlloc.c XKBBell.c XKBCompat.c XKBCtrls.c XKBCvt.c \
	XKBExtDev.c XKBGAlloc.c XKBGeom.c XKBGetByName.c XKBGetMap.c \
	XKBleds.c XKBList.c XKBMAlloc.c XKBMisc.c XKBNames.c XKBRdBuf.c \
	XKBSetGeom.c XKBSetMap.c XKBUse.c XKBBind.c

XLIB_DEP=xlib_s.a
XLIB_OBJ=\
	Xlib_OpenDisplay.o Xlib_CreateWindow.o Xlib_CreateGC.o \
	Xlib_pmctls.o Xlib_Protocol.o Xlib_NextEvent.o Xlib_Atom.o \
	Xlib_ResizeWindow.o Xlib_DrawLine.o Xlib_misc.o Xlib_simple.o \
	Xlib_Text.o Xlib_Free.o Xlib_evtomask.o Xlib_Keyboard.o \
	Xlib_TextExt.o Xlib_PropAlloc.o Xlib_DrawPoly.o Xlib_PutImage.o \
	Xlib_CrBFData.o Xlib_CrPFBData.o Xlib_WrBitF.o Xlib_RegstFlt.o \
	Xlib_Region.o Xlib_PolyReg.o Xlib_SetCRects.o Xlib_FilterEv.o \
	Xlib_CrPixmap.o Xlib_InitExt.o Xlib_Context.o Xlib_ErrHndlr.o \
	Xlib_GetGCVals.o Xlib_WMProps.o Xlib_WMGeom.o Xlib_SetTxtProp.o \
	Xlib_SetWMProto.o Xlib_SetHints.o Xlib_SetNrmHint.o Xlib_Cursor.o \
	Xlib_LookupCol.o Xlib_GetColor.o Xlib_Pointer.o Xlib_FontNames.o \
	Xlib_Property.o Xlib_StrToText.o Xlib_ImUtil.o Xlib_Grab.o \
	Xlib_GetImage.o Xlib_Geom.o Xlib_ParseGeom.o Xlib_GetHints.o \
	Xlib_Synchro.o Xlib_TextToStr.o Xlib_FontAlias.o Xlib_SetFont.o \
	Xlib_LoadFont.o Xlib_FSWrap.o Xlib_ReconfWin.o Xlib_QuColors.o \
	Xlib_QuColor.o Xlib_GetFProp.o Xlib_ChangeGC.o Xlib_ChWAttrs.o \
	Xlib_Depths.o Xlib_CopyArea.o Xlib_CopyPlane.o Xlib_CopyGC.o \
	Xlib_KeyBind.o Xlib_ModMap.o Xlib_QuExt.o Xlib_PMWM.o \
	Xlib_Border.o Xlib_BorderWidth.o Xlib_uconv.o Xlib_TrCoords.o \
	Xlib_Colormap.o Xlib_QuTree.o Xlib_VisUtil.o Xlib_GetWAttrs.o \
	Xlib_StBytes.o Xlib_RotProp.o Xlib_RdBitF.o Xlib_Focus.o \
	Xlib_PixFormats.o Xlib_ScrnSav.o Xlib_ListExt.o Xlib_QryBest.o \
	Xlib_ParseCol.o Xlib_StName.o Xlib_GCMisc.o Xlib_pmatms.o \
	Xlib_SetStip.o Xlib_GetWMCMapW.o Xlib_Geometry.o Xlib_mbWMProps.o \
        Xlib_imLcGIc.o Xlib_FetchName.o Xlib_GContextFromGC.o \
	Xlib_GetTextProperty.o Xlib_GetMotionEvents.o Xlib_GetIconName.o \
	Xlib_LockDisplay.o Xlib_RecolorCursor.o Xlib_FreeCursor.o \
	Xlib_FreeFontInfo.o Xlib_FreeFontPath.o Xlib_WarpPointer.o \
	Xlib_UninstallColormap.o \
	Xlib_Stubs.o

XRM_DEP=xrm_s.a
XRM_OBJ=\
	Xrm_Core.o Xrm_Quarks.o Xrm_Defaults.o Xrm_ParseCmd.o

XLC_DEP=xlc_s.a
XLC_OBJ=\
	Xlc_Init.o Xlc_Wrap.o Xlc_GenConv.o Xlc_DefConv.o Xlc_CT.o \
	Xlc_SetLocale.o Xlc_CharSet.o Xlc_Std.o Xlc_PubWrap.o \
	Xlc_Conv.o Xlc_Public.o Xlc_File.o Xlc_DB.o Xlc_Generic.o \
	Xlc_PrTxt.o Xlc_TxtPr.o Xlc_Util.o Xlc_RM.o Xlc_UTF.o \
	Xom_Default.o Xom_Generic.o Xom_ImText.o Xom_Text.o Xom_Wrap.o \
	Xom_TextEsc.o Xom_TextExt.o Xom_TextPer.o Xom_XChar.o \
	Xoc_Wrap.o Xic_Wrap.o Xmb_Wrap.o Xwc_Wrap.o \
	Xim_Wrap.o Xim_Core.o Xim_Conv.o Xim_ImSw.o Xim_TransR.o Xim_Rm.o \
	Xim_LcIm.o Xim_ThaiIm.o Xim_DefIm.o Xim_LcLkup.o Xim_LcPrs.o \
	Xim_LcIc.o Xim_LcFlt.o

XCMS_DEP=xcms_s.a
XCMS_OBJ=\
	Xcms_ColNm.o Xcms_QRed.o Xcms_QGreen.o Xcms_QBlue.o Xcms_Int.o \
	Xcms_Globals.o Xcms_LRGB.o Xcms_UNDEF.o Xcms_XYZ.o Xcms_uvY.o \
	Xcms_xyY.o Xcms_Lab.o Xcms_Luv.o Xcms_HVC.o Xcms_XRGB.o \
	Xcms_CvCols.o Xcms_Cmap.o Xcms_QuCols.o Xcms_SetGetCols.o \
	Xcms_CCC.o Xcms_SetCCC.o Xcms_Trig.o Xcms_Math.o

XKB_DEP=xkb_s.a
XKB_OBJ=\
	XKB.o XKBAlloc.o XKBBell.o XKBCompat.o XKBCtrls.o XKBCvt.o \
	XKBExtDev.o XKBGAlloc.o XKBGeom.o XKBGetByName.o XKBGetMap.o \
	XKBleds.o XKBList.o XKBMAlloc.o XKBMisc.o XKBNames.o XKBRdBuf.o \
	XKBSetGeom.o XKBSetMap.o XKBUse.o XKBBind.o

LIB_DEP=$(XLIB_DEP) $(XRM_DEP) $(XLC_DEP) $(XCMS_DEP) $(XKB_DEP)
LIB_OBJ=$(XLIB_OBJ) $(XRM_OBJ) $(XLC_OBJ) $(XCMS_OBJ) $(XKB_OBJ) \
	Xlib_private.o

##################################################################

CRTL_LIB=\
	crtl/bsd.lib crtl/c_alias.lib crtl/c_static.lib crtl/emx2.lib \
	crtl/os2.lib crtl/pthrdrtl.lib crtl/gcc.lib crtl/c.lib

CLEAN_FILES=$(LIB_DEP) $(HK_DLL) $(LIB_OBJ) $(SLIB_OUT)\
	$(CRTL_LIB) $(LIB_RES)

##################################################################

all: banner headers lib res dll example

banner:

headers: $(HEADER)

lib:	$(LIB_DEP) $(SLIB_OUT)

dll:	$(HK_DLL)

res:	$(LIB_RES)

example: test_s

clean:
	$(RM) test test.exe test_s test_s.exe $(CLEAN_FILES)

$(LIB_RES): X11.rc
	rc -r -p -x X11.rc $(LIB_RES)

$(XLIB_DEP): $(XLIB_OBJ) Makefile
	$(RM) $(XLIB_DEP)
	$(MKLIB) $(XLIB_DEP) $(XLIB_OBJ)

$(XRM_DEP): $(XRM_OBJ) Makefile
	$(RM) $(XRM_DEP)
	$(MKLIB) $(XRM_DEP) $(XRM_OBJ)

$(XLC_DEP): $(XLC_OBJ) Makefile
	$(RM) $(XLC_DEP)
	$(MKLIB) $(XLC_DEP) $(XLC_OBJ)

$(XCMS_DEP): $(XCMS_OBJ) Makefile
	$(RM) $(XCMS_DEP)
	$(MKLIB) $(XCMS_DEP) $(XCMS_OBJ)

$(XKB_DEP): $(XKB_OBJ) Makefile
	$(RM) $(XKB_DEP)
	$(MKLIB) $(XKB_DEP) $(XKB_OBJ)

$(SLIB_OUT): $(LIB_OBJ) Makefile
	$(RM) $(SLIB_OUT) $(SLIB_OMF)
	emximp -o $(SLIB_OUT) uconv.def
	$(MKLIB) $(SLIB_OUT) $(LIB_OBJ)

$(HK_DLL): $(HK_DEF) $(CRTL_LIB) X11pmhk.c X11pmhk.h
	$(RM) $(HK_DLL)
	$(CC) -Zdll -Zno-rte -Zomf -DNO_RTE -Lcrtl -o $(HK_DLL) X11pmhk.c $(HK_DEF)

# test program

test_s: test.c $(SLIB_OUT)
	$(CC) $(EXEFLAGS) -o test_s test.c $(EXESLIB)

# DEPENDANCY INFOMATION

$(LIB_OBJ): $(HEADER)

##################################################################

.c.o:
	$(CC) -c $(CFLAGS) $<

.s.o:
	$(CC) -c $(CFLAGS) $<

crtl/bsd.lib: $(EMX_LIBDIR)/bsd.a
	emxomf -o $@ $<
crtl/c_alias.lib: $(EMX_LIBDIR)/c_alias.a
	emxomf -o $@ $<
crtl/c_static.lib: $(EMX_LIBDIR)/c_static.a
	emxomf -o $@ $<
crtl/emx2.lib: $(EMX_LIBDIR)/emx2.a
	emxomf -o $@ $<
crtl/os2.lib: $(EMX_LIBDIR)/os2.a
	emxomf -o $@ $<
crtl/pthrdrtl.lib: pthrdrtl.a
	emxomf -o $@ $<
crtl/gcc.lib: $(EMX_LIBDIR)/gcc.a
	emxomf -o $@ $<
crtl/c.lib: $(EMX_LIBDIR)/st/c.a
	emxomf -o $@ $<

# END OF MAKEFILE