/* $XConsortium: OMWrap.c /main/3 1996/01/05 11:22:34 kaleb $ */
/*
 * Copyright 1992, 1993 by TOSHIBA Corp.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of TOSHIBA not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission. TOSHIBA make no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * TOSHIBA DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * TOSHIBA BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Author: Katsuhisa Yano	TOSHIBA Corp.
 *			   	mopi@osa.ilab.toshiba.co.jp
 */

#include "Xlib_private.h"
#include "Xlcint.h"

XOM
#if NeedFunctionPrototypes
XOpenOM(Display *dpy, XrmDatabase rdb, _Xconst char *res_name,
	_Xconst char *res_class)
#else
XOpenOM(dpy, rdb, res_name, res_class)
    Display *dpy;
    XrmDatabase rdb;
    char *res_name;
    char *res_class;
#endif
{
    DBUG_ENTER("XOpenOM")
    XLCd lcd = _XOpenLC((char *) NULL);

    if (lcd == NULL) {
#ifdef DEBUG
	fprintf(stderr,"XOpenOM: _XOpenLC failed!\n");
#endif
	DBUG_RETURN((XOM) NULL);
    }
    if (lcd->methods->open_om) {
	XOM result = (*lcd->methods->open_om)(lcd, dpy, rdb, res_name, res_class);
	DBUG_RETURN(result);
    }

#ifdef DEBUG
    fprintf(stderr,"XOpenOM: missing open_om method!\n");
#endif
    DBUG_RETURN((XOM) NULL);
}

Status
XCloseOM(om)
    XOM om;
{
    DBUG_ENTER("XCloseOM")
    XOC oc, next;
    XLCd lcd = om->core.lcd;
    Status result;

    next = om->core.oc_list;

    while (oc = next) {
	next = oc->core.next;
	(*oc->methods->destroy)(oc);
    }

    om->core.oc_list = NULL;

    _XCloseLC(lcd);

    result = (*om->methods->close)(om);
    DBUG_RETURN(result);
}

#if NeedVarargsPrototypes
char *
XSetOMValues(XOM om, ...)
#else
char *
XSetOMValues(om, va_alist)
    XOM om;
    va_dcl
#endif
{
    DBUG_ENTER("XSetOMValues")
    va_list var;
    XlcArgList args;
    char *ret;
    int num_args;

    Va_start(var, om);
    _XlcCountVaList(var, &num_args);
    va_end(var);

    Va_start(var, om);
    _XlcVaToArgList(var, num_args, &args);
    va_end(var);

    if (args == (XlcArgList) NULL)
	DBUG_RETURN((char *) NULL);

    ret = (*om->methods->set_values)(om, args, num_args);

    Xfree(args);

    DBUG_RETURN(ret);
}

#if NeedVarargsPrototypes
char *
XGetOMValues(XOM om, ...)
#else
char *
XGetOMValues(om, va_alist)
    XOM om;
    va_dcl
#endif
{
    DBUG_ENTER("XGetOMValues")
    va_list var;
    XlcArgList args;
    char *ret;
    int num_args;

    Va_start(var, om);
    _XlcCountVaList(var, &num_args);
    va_end(var);

    Va_start(var, om);
    _XlcVaToArgList(var, num_args, &args);
    va_end(var);

    if (args == (XlcArgList) NULL)
	DBUG_RETURN((char *) NULL);
    
    ret = (*om->methods->get_values)(om, args, num_args);

    Xfree(args);

    DBUG_RETURN(ret);
}

Display *
XDisplayOfOM(om)
    XOM om;
{
    DBUG_ENTER("XDisplayOfOM")
    Display *result = om->core.display;
    DBUG_RETURN(result);
}

char *
XLocaleOfOM(om)
    XOM om;
{
    DBUG_ENTER("XLocaleOfOM")
    char *result = om->core.lcd->core->name;
    DBUG_RETURN(result);
}
