
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#define INCL_BASE
#define INCL_WIN
#define INCL_GPI
#define INCL_WINATOM
#include <os2.h>

typedef void * UconvObject;
typedef unsigned short UniChar;

#define UCSCPSIZE 16
#define CALLCONV
#define ISO8859_1       (UniChar *)L"IBM-819"

static UniChar ucsCodepage[UCSCPSIZE];

int CALLCONV UniMapCpToUcsCp( 
             unsigned long ulCodePage, /* I  - A codepage as DosQueryCp    */
             UniChar *ucsCodePage,     /* O  - Unicode name of uconv table */
             size_t n );               /* I  - Output size (chars)         */

int CALLCONV UniCreateUconvObject(
             UniChar     * code_set,   /* I  - Unicode name of uconv table */
             UconvObject * uobj  );    /* O  - Uconv object handle         */

int CALLCONV UniFreeUconvObject(
             UconvObject   uobj   );   /* I  - Uconv object handle         */

int CALLCONV UniUconvToUcs(
             UconvObject uobj,         /* I  - Uconv object handle         */
             void    * * inbuf,        /* IO - Input buffer                */
             size_t    * inbytes,      /* IO - Input buffer size (bytes)   */
             UniChar * * outbuf,       /* IO - Output buffer size          */
             size_t    * outchars,     /* IO - Output size (chars)         */
             size_t    * subst  );     /* IO - Substitution count          */

int CALLCONV UniUconvFromUcs(
             UconvObject uobj,         /* I  - Uconv object handle         */
             UniChar * * inbuf,        /* IO - Input buffer                */
             size_t    * inchars,      /* IO - Input buffer size (bytes)   */
             void    * * outbuf,       /* IO - Output buffer size          */
             size_t    * outbytes,     /* IO - Output size (chars)         */
             size_t    * subst   );    /* IO - Substitution count          */


#ifdef OS2I18N

void Xlib_InitOS2I18N(void)
{
	ULONG cp[3], rc;
	/*DosQueryCp(3, cp, &rc);*/
	cp[0] = 1004;
	UniMapCpToUcsCp(cp[0], ucsCodepage, UCSCPSIZE);
}

int Xlib_XlatUCS_2(char *tgt, int tgt_size, void *src, int src_size)
{
	UconvObject xlat = NULL;
	int result = 0;
	size_t src_pos = src_size, tgt_pos = tgt_size, dup;
	if (UniCreateUconvObject( ucsCodepage, &xlat ))
	{
		src_size *= 2;
		result = (src_size>tgt_size)?tgt_size:src_size;
		strncpy(tgt, (char*)src, result);
	} else {
		UniUconvFromUcs(xlat, (UniChar **)&src, &src_pos, (void **)&tgt, &tgt_pos, &dup);
		UniFreeUconvObject(xlat);
		result = tgt_size - tgt_pos;
	}
	return result;
}

int Xlib_XlatISO8859_1(char *tgt, int tgt_size, char *src, int src_size)
{
	UconvObject xlat1 = NULL, xlat2 = NULL;
	int result = 0;
	size_t src_pos = src_size, tgt_pos = tgt_size, dup;
	size_t tmpsize = src_size + 1, tmppos = tmpsize;
	UniChar *tmpbuf = alloca(tmpsize * sizeof(UniChar)), *tmp = tmpbuf;
	if (UniCreateUconvObject( ISO8859_1, &xlat1 ) ||
	    UniCreateUconvObject( ucsCodepage, &xlat2 )) 
	{
		result = (tgt_size>src_size)?src_size:tgt_size;
		strncpy(tgt, src, result);
	} else {
		UniUconvToUcs(xlat1, (void **)&src, &src_pos, &tmp, &tmppos, &dup);
		tmp = tmpbuf; tmppos = tmpsize - tmppos;
		UniUconvFromUcs(xlat2, &tmp, &tmppos, (void **)&tgt, &tgt_pos, &dup);
		result = tgt_size - tgt_pos;
	}
	if (xlat1) UniFreeUconvObject(xlat1);
	if (xlat2) UniFreeUconvObject(xlat2);
	return result;
}

#endif